
{ TPrevInst: component to limit multiple instances of your program
  Target   : Delphi 2.x
  Version  : 1.0
  Date     : 25 August 1997
  Freeware
  
  NOTE     : I took almost all code here from The Unofficial Newsletter 
             of Delphi Users - Issue #16 - September 1996 and made this
             component for easy use.
             
             Article's title:
             Limiting Multiple Instances Of Your Program
             by Robert Vivrette - CIS: 76416,1373
                
	     See PrevInst.txt. All mr Vivrette's article included.

 USING TPrevInst
             1. Install PrevInst.pas as usual (menu Component|Install)
                There is no .dcr file
             2. Drop an instance of TPrevInst on your main form	
             3. Set property AllowedInst to how many allowed instances 
                you want (default:=1)
             4. On your main's form OnCreate add:
                PrevInst1.Execute
             5. Run your program.


Don't forget:Thanks to mr Vivrette




Theodoros Bebekis "Lathe Viosas", Salonica, Greece.
Hmmm....!



}


{************************* unit PrevInst ********************************}


unit PrevInst;

interface

uses
  Forms,Windows,SysUtils,Classes,Dialogs;


type

  TPrevInst = class(TComponent)
  private
    FAllowedInst: integer;

  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function Execute: boolean; virtual;

  published
    property AllowedInst: integer read FAllowedInst write FAllowedInst;

  end;

procedure Register;



implementation


var
  MyAppName   : array[0..255] of Char;
  MyClassName : array[0..255] of Char;
  NumFound    : Integer;
  LastFound   : HWnd;
  MyPopup     : HWnd;



{------------------------------Create-----------------------------------------}

constructor TPrevInst.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  AllowedInst:=1;
end;


{------------------------------Destroy-----------------------------------------}

destructor TPrevInst.Destroy;
begin
  inherited Destroy;
end;


{------------------------LookAtAllWindows-----------------------------------}

function LookAtAllWindows(Handle: HWND; Temp:LongInt): BOOL; stdcall;
var
  WindowName : array[0..255] of Char;
  ClassName  : array[0..255] of Char;
begin

  // Go get the windows class name
  if GetClassName(Handle,ClassName,SizeOf(ClassName)) > 0 then
    // Is the window class the same?
    if StrComp(ClassName,MyClassName) = 0 then
      // Get its window caption
      if GetWindowText(Handle,WindowName,SizeOf(WindowName)) > 0 then
        // Does this have the same window title?
        if StrComp(WindowName,MyAppName)=0 then
        begin
          Inc(NumFound);
          if Handle <> Application.Handle  // Are the handles different?
          then LastFound := Handle;  // Save it so we can bring it to the top later.
        end;

end;   { LookAtAllWindows }



{-------------------------------Execute----------------------------------------}

function TPrevInst.Execute: boolean;
begin

  Result:=False;
  NumFound := 0; LastFound := 0;
  // First, determine what this application's name is
  GetWindowText(Application.Handle,MyAppName,SizeOf(MyAppName));
  // Now determine the class name for this application
  GetClassName(Application.Handle,MyClassName,SizeOf(MyClassName));
  // Now count how many others out there are Delphi apps with this title
  EnumWindows(@LookAtAllWindows,0);
  if NumFound > AllowedInst then
  // There is another instance running, bring it to the front!
  begin
    ShowMessage('There are ' + IntToStr(AllowedInst) +' instance(s)' + #13 +
                'of '   + MyAppName                                  + #13 +
                'already running');
    MyPopup := GetLastActivePopup(LastFound);
    BringWindowToTop(LastFound);        // Bring it to the top in the ZOrder
    if IsIconic(MyPopup)                // Is the window iconized?
    then ShowWindow(MyPopup,SW_RESTORE) // Restore it to its original position
    else SetForegroundWindow(MyPopup);  // Bring it to the front

    Result:=True;   // ?
    Application.Terminate;
  end
  else Result:=False;

end;  { Execute }



{------------------------------------Register----------------------------------}

procedure Register;
begin
  RegisterComponents('Samples', [TPrevInst]);
end;

end.


{************************* End of unit PrevInst ****************************}



