unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl;

type
  TForm1 = class(TForm)
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    FileListBox1: TFileListBox;
    Button1: TButton;
    Button2: TButton;
    LogMemo: TMemo;
    StreamCheck: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FileListBox1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses PowerArc;

var iPowerLZW: integer = -1;

procedure TForm1.FormCreate(Sender: TObject);
begin
  iPowerLZW:=RegisterPowerArcModule('PowerLZW.dll');
  if iPowerLZW < 0 then begin
    Application.Terminate;
    raise Exception.Create('PowerArc LZW module not found.');
  end;
end;

procedure TForm1.FileListBox1Change(Sender: TObject);
begin
  Button1.Enabled:=FileExists(FileListBox1.FileName) and
    (ANSICompareText(ExtractFileExt(FileListBox1.FileName),'.pk') <> 0);
  Button2.Enabled:=FileExists(FileListBox1.FileName) and
    (ANSICompareText(ExtractFileExt(FileListBox1.FileName),'.pk') = 0);
end;

procedure TForm1.Button1Click(Sender: TObject);
var InStream,OutStream: TFileStream;
    CompressStream: TPowerArcCompressStream;
begin
  InStream:=TFileStream.Create(FileListBox1.FileName,fmOpenRead);
  OutStream:=TFileStream.Create(FileListBox1.FileName+'.pk',fmCreate);
  try
    if StreamCheck.Checked then begin
      CompressStream:=TPowerArcCompressStream.Create(OutStream,iPowerLZW,'');
      try
        CompressStream.CopyFrom(InStream,0);
      finally
        CompressStream.Free;
      end;
    end else
      Compress(iPowerLZW,InStream,OutStream,'');
    LogMemo.Lines.Add('Compress '+FileListBox1.FileName);
    LogMemo.Lines.Add('Size'#9+IntToStr(InStream.Size));
    LogMemo.Lines.Add('Destination '+FileListBox1.FileName+'.pk');
    LogMemo.Lines.Add('Size'#9+IntToStr(OutStream.Size));
    LogMemo.Lines.Add('Ratio'#9+FormatFloat('#0.00',OutStream.Size*100.0/InStream.Size)+'%');
    LogMemo.Lines.Add('BPC'#9+FormatFloat('#0.000',OutStream.Size*8.0/InStream.Size));
    LogMemo.Lines.Add('');
  finally
    InStream.Free;
    OutStream.Free;
  end;
  FileListBox1.Update;
end;

procedure TForm1.Button2Click(Sender: TObject);
var InStream,OutStream: TFileStream;
    DecompressStream: TPowerArcDecompressStream;
    Buff: array[0..4095] of byte;
    len: integer;
begin
  InStream:=TFileStream.Create(FileListBox1.FileName,fmOpenRead);
  OutStream:=TFileStream.Create(ChangeFileExt(FileListBox1.FileName,'.org'),fmCreate);
  try
    if StreamCheck.Checked then begin
      DecompressStream:=TPowerArcDecompressStream.Create(InStream);
      try
        len:=DecompressStream.Read(Buff[0],4096);
        while len > 0 do begin
          OutStream.Write(Buff[0],len);
          len:=DecompressStream.Read(Buff[0],4096);
        end;
      finally
        DecompressStream.Free;
      end;
    end else
      Decompress(InStream,OutStream);
    LogMemo.Lines.Add('Decompress '+FileListBox1.FileName);
    LogMemo.Lines.Add('');
  finally
    InStream.Free;
    OutStream.Free;
  end;
  FileListBox1.Update;
end;

end.
