unit PosSaver;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TPosSaverHKEY = (_CLASSES_ROOT, _CURRENT_USER, _LOCAL_MACHINE, _USERS,
    _PERFORMANCE_DATA, _CURRENT_CONFIG, _DYN_DATA);

  TPosSaver = class(TComponent)
  private
    { Private declarations }
    FIniName: string;
    FIniSection: string;
    FUseRegistry: boolean;
    FRegKey: string;
    FRegRootKey: HKEY;
    F_RegRootKey: TPosSaverHKEY;
  protected
    { Protected declarations }
    procedure SetRegRootKey(Value: TPosSaverHKEY);
  public
    { Public declarations }
    procedure Restore;
    procedure Save;
  published
    { Published declarations }
    property IniName: string read FIniName write FIniName;
    property IniSection: string read FIniSection write FIniSection;
    property UseRegistry: boolean read FUseRegistry write FUseRegistry;
    property RegKey: string read FRegKey write FRegKey;
    property RegRootKey: TPosSaverHKEY read F_RegRootKey write SetRegRootKey;
  end;

procedure Register;

implementation

Uses
   IniFiles, Registry;

procedure Register;
begin
  RegisterComponents('Misc', [TPosSaver]);
end;

procedure TPosSaver.SetRegRootKey(Value: TPosSaverHKEY);
begin
  F_RegRootKey:=Value;
  case Value of
    _CLASSES_ROOT: FRegRootKey:=HKEY_CLASSES_ROOT;
    _CURRENT_USER: FRegRootKey:=HKEY_CURRENT_USER;
    _LOCAL_MACHINE: FRegRootKey:=HKEY_LOCAL_MACHINE;
    _USERS: FRegRootKey:=HKEY_USERS;
    _PERFORMANCE_DATA: FRegRootKey:=HKEY_PERFORMANCE_DATA;
    _CURRENT_CONFIG: FRegRootKey:=HKEY_CURRENT_CONFIG;
    _DYN_DATA: FRegRootKey:=HKEY_DYN_DATA;
  end;
end;

Procedure TPosSaver.Restore;
Var
   Ini:TIniFile;
   r: TRegistry;
   s: string;
Begin
  if FUseRegistry then
    begin
      r:=TRegistry.Create;
      r.RootKey:=FRegRootKey;
      r.OpenKey(FRegKey,false);
      try (Owner as TForm).Top:=r.ReadInteger('Top');
      except on ERegistryException do ;  end;
      try (Owner as TForm).Left:=r.ReadInteger('Left');
      except on ERegistryException do ;  end;
      try (Owner as TForm).Width:=r.ReadInteger('Width');
      except on ERegistryException do ;  end;
      try (Owner as TForm).Height:=r.ReadInteger('Height');
      except on ERegistryException do ;  end;
      r.CloseKey;
      r.Free;
    end
  else
    begin
      Ini:=TIniFile.Create(FIniName);
      if FIniSection='' then s:='TPosSaver' else s:=FIniSection;
      (Owner as TForm).Top:=Ini.ReadInteger(s,'Top',(Owner as TForm).Top);
      (Owner as TForm).Left:=Ini.ReadInteger(s,'Left',(Owner as TForm).Left);
      (Owner as TForm).Width:=Ini.ReadInteger(s,'Width',(Owner as TForm).Width);
      (Owner as TForm).Height:=Ini.ReadInteger(s,'Height',(Owner as TForm).Height);
      Ini.Destroy;
    end;
End;

Procedure TPosSaver.Save;
Var
   Ini:TiniFile;
   r: TRegistry;
   s: string;
Begin
  if FUseRegistry then
    begin
      r:=TRegistry.Create;
      r.RootKey:=FRegRootKey;
      r.CreateKey(FRegKey);
      r.OpenKey(FRegKey,false);
      try r.WriteInteger('Top',(Owner as TForm).Top);
      except on ERegistryException do ;  end;
      try r.WriteInteger('Left',(Owner as TForm).Left);
      except on ERegistryException do ;  end;
      try r.WriteInteger('Width',(Owner as TForm).Width);
      except on ERegistryException do ;  end;
      try r.WriteInteger('Height',(Owner as TForm).Height);
      except on ERegistryException do ;  end;
      r.CloseKey;
      r.Free;
    end
  else
    begin
      Ini:=TIniFile.Create(FIniName);
      if FIniSection='' then s:='TPosSaver' else s:=FIniSection;
      Ini.WriteInteger(s,'Top',(Owner as TForm).Top);
      Ini.WriteInteger(s,'Left',(Owner as TForm).Left);
      Ini.WriteInteger(s,'Width',(Owner as TForm).Width);
      Ini.WriteInteger(s,'Height',(Owner as TForm).Height);
      Ini.Destroy;
    end;
End;


end.
