unit PortIO;

interface

uses
  Windows;
  
type
  PCardinal = ^Cardinal;

function DlPortReadPortByte(PortAdr:Cardinal):byte; stdcall;
function DlPortReadPortWord(PortAdr:Cardinal):word; stdcall;
function DlPortReadPortCardinal(PortAdr:Cardinal):Cardinal; stdcall;

procedure DlPortReadPortBufferByte(PortAdr:Cardinal;Buffer:PByte;Count:Cardinal); stdcall;
procedure DlPortReadPortBufferWord(PortAdr:Cardinal;Buffer:PWord;Count:Cardinal); stdcall;
procedure DlPortReadPortBufferCardinal(PortAdr:Cardinal;Buffer:PCardinal;Count:Cardinal); stdcall;

procedure DlPortWritePortByte(PortAdr:Cardinal;Value:byte); stdcall;
procedure DlPortWritePortWord(PortAdr:Cardinal;Value:word); stdcall;
procedure DlPortWritePortCardinal(PortAdr:Cardinal;Value:Cardinal); stdcall;

procedure DlPortWritePortBufferByte(PortAdr:Cardinal;Buffer:PByte;Count:Cardinal); stdcall;
procedure DlPortWritePortBufferWord(PortAdr:Cardinal;Buffer:PWord;Count:Cardinal); stdcall;
procedure DlPortWritePortBufferCardinal(PortAdr:Cardinal;Buffer:PCardinal;Count:Cardinal); stdcall;

implementation

const
  DLPortIO = 'DLPortIO.DLL';
  
function DlPortReadPortByte(PortAdr:Cardinal):byte; external DLPortIO name 'DlPortReadPortUchar';
function DlPortReadPortWord(PortAdr:Cardinal):word; external DLPortIO name 'DlPortReadPortUshort';
function DlPortReadPortCardinal(PortAdr:Cardinal):Cardinal; external DLPortIO name 'DlPortReadPortUlong';

procedure DlPortReadPortBufferByte(PortAdr:Cardinal;Buffer:PByte;Count:Cardinal); external DLPortIO name 'DlPortReadPortBufferUchar';
procedure DlPortReadPortBufferWord(PortAdr:Cardinal;Buffer:PWord;Count:Cardinal); external DLPortIO name 'DlPortReadPortBufferUshort';
procedure DlPortReadPortBufferCardinal(PortAdr:Cardinal;Buffer:PCardinal;Count:Cardinal); external DLPortIO name 'DlPortReadPortBufferUlong';

procedure DlPortWritePortByte(PortAdr:Cardinal;Value:byte); external DLPortIO name 'DlPortWritePortUchar';
procedure DlPortWritePortWord(PortAdr:Cardinal;Value:word); external DLPortIO name 'DlPortWritePortUshort';
procedure DlPortWritePortCardinal(PortAdr:Cardinal;Value:Cardinal); external DLPortIO name 'DlPortWritePortUlong';

procedure DlPortWritePortBufferByte(PortAdr:Cardinal;Buffer:PByte;Count:Cardinal); external DLPortIO name 'DlPortWritePortBufferUchar';
procedure DlPortWritePortBufferWord(PortAdr:Cardinal;Buffer:PWord;Count:Cardinal); external DLPortIO name 'DlPortWritePortBufferUshort';
procedure DlPortWritePortBufferCardinal(PortAdr:Cardinal;Buffer:PCardinal;Count:Cardinal); external DLPortIO name 'DlPortWritePortBufferUlong';

var
  IOPortDLLHandle : HMODULE;
initialization
  IOPortDLLHandle:=LoadLibrary(DLPortIO);
finalization
  FreeLibrary(IOPortDLLHandle);
end.
 