unit FmDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, PJSysInfo;

type
  TDemoForm = class(TForm)
    Memo1: TMemo;
    PJSysInfo1: TPJSysInfo;
    procedure FormCreate(Sender: TObject);
  private
  public
    { Public declarations }
  end;

var
  DemoForm: TDemoForm;

implementation

{$R *.DFM}

function Title(Str: string): string;
begin
  Result := Format('  %-20s: ', [Str]);
end;

procedure TDemoForm.FormCreate(Sender: TObject);
begin
  with Memo1.Lines do
  begin
    Add('COMPUTER & USER');
    Add(Title('Computer name') + PJSysInfo1.ComputerName);
    Add(Title('User name') + PJSysInfo1.UserName);
    Add('');
    Add('FOLDERS');
    Add(Title('Windows folder') + PJSysInfo1.WindowsFolder);
    Add(Title('System folder') + PJSysInfo1.SystemFolder);
    Add(Title('Temp folder') + PJSysInfo1.TempFolder);
    Add(Title('Program Files folder') + PJSysInfo1.ProgramFilesFolder);
    Add(Title('Common Files folder') + PJSysInfo1.CommonFilesFolder);
    Add('');
    Add('OPERATING SYSTEM');
    Add(Title('Description') + PJSysInfo1.OSDesc);
    case PJSysInfo1.OSPlatform of
      ospWinNT: Add(Title('Platform code') + 'ospWinNT');
      ospWin9X: Add(Title('Platform code')+ 'ospWin9X');
      ospWin32s: Add(Title('Platform code') + 'ospWin32s');
    end;
    Add(Title('Product name') + PJSysInfo1.OSProductName);
    case PJSysInfo1.OSProduct of
      osUnknownWinNT: Add(Title('Product code') + 'osUnknownWinNT');
      osUnknownWin9x: Add(Title('Product code') + 'osUnknownWin9x');
      osUnknownWin32s: Add(Title('Product code') + 'osUnknownWin32s');
      osWin95: Add(Title('Product code') + 'osWin95');
      osWin98: Add(Title('Product code') + 'osWin98');
      osWinMe: Add(Title('Product code') + 'osWinMe');
      osWinNT: Add(Title('Product code') + 'osWinNT');
      osWin2K: Add(Title('Product code') + 'osWin2K');
      osWinXP: Add(Title('Product code') + 'osWinXP');
      osWinSvr2003: Add(Title('Product code') + 'osWinSvr2003');
    end;
    Add(Title('Version')
      + Format('%d.%d',
        [PJSysInfo1.OSMajorVersion, PJSysInfo1.OSMinorVersion]));
    Add(Title('Service pack') + PJSysInfo1.OSServicePack);
    Add(Title('Product type') + PJSysInfo1.OSProductType);
    Add(Title('Build number') + IntToStr(PJSysInfo1.OSBuildNumber));
  end;
end;

end.
