unit LsPEPicRegD4;

interface

uses DsgnIntf, Forms;

type
 TLsPictureEditor = class(TClassProperty)
 public
  function GetAttributes: TPropertyAttributes; override;
  procedure Edit; override;
 end;

procedure Register;

implementation

uses SysUtils, Controls, Graphics, TypInfo, LsPEPicMainD4, LsPEPicViewD4;

function TLsPictureEditor.GetAttributes: TPropertyAttributes;
begin
 Result := [paDialog]
end;

procedure TLsPictureEditor.Edit;
begin
  Application.CreateForm(TPEPicMainForm, PEPicMainForm);
  Application.CreateForm(TPEPicViewForm, PEPicViewForm);
  with PEPicMainForm do
  try
    Image1.Picture := TPicture(GetOrdValue);
    Image2.Picture := Image1.Picture;
    
    if ShowModal = mrOk then
      if (GetPropType^.Name = 'TPicture') then
        SetOrdValue(LongInt(Image1.Picture))
      else
        SetOrdValue(LongInt(Image1.Picture.Bitmap));
  finally
		Close;
  end; { finally }
  PEPicViewForm.Close;
end;

procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(TPicture), nil, '', TLsPictureEditor);
  RegisterPropertyEditor(TypeInfo(TBitmap), nil, '', TLsPictureEditor);
end;

end.