{****************************************************************************
	Component   :  LsPEPicMainD4.pas is a part of the TLsPictureEditor, that
								 is a Picture and Bitmap property editor for Delphi.
	Version     :  0.80
	Author      :  Leo D. Shih  e-mail: <ldshih@ecn.ab.ca> or
																			<ldshih@freenet.edmonton.ab.ca>
	Copyright   :  (C)1998 SHIH's Research, all rights reserved.

	DISCLAIMER  :  Current version of TLsPictureEditor is distributed as
								 freeware, without warranties of any kind.  Use of this
								 software is at your own risk.
****************************************************************************}


unit LsPEPicMainD4;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls,
	FileCtrl, StdCtrls, ExtCtrls, Buttons, Dialogs, Menus,
	Clipbrd, ComCtrls, SysUtils, IniFiles, Spin;

type
	TPEPicMainForm = class(TForm)
		SaveDialog1: TSaveDialog;
		Panel3: TPanel;
		PopupMenu1: TPopupMenu;
		NumGlyph1: TMenuItem;
		N1: TMenuItem;
		CopyImage1: TMenuItem;
		SaveImage1: TMenuItem;
		Panel2: TPanel;
		DirectoryListBox1: TDirectoryListBox;
		FileListBox1: TFileListBox;
		Panel6: TPanel;
		StatusBar1: TStatusBar;
		PageControl1: TPageControl;
		TabSheet1: TTabSheet;
		TabSheet2: TTabSheet;
    Panel1: TPanel;
    Label1: TLabel;
    Label3: TLabel;
    StretchCheck: TCheckBox;
    Image1: TImage;
    Image2: TImage;
    Panel5: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    SpeedButton9: TSpeedButton;
    SpeedButton10: TSpeedButton;
    SpeedButton11: TSpeedButton;
    SpeedButton12: TSpeedButton;
    SpeedButton13: TSpeedButton;
    SpeedButton14: TSpeedButton;
    SpeedButton15: TSpeedButton;
		SpeedButton16: TSpeedButton;
    SpeedButton17: TSpeedButton;
    SpeedButton18: TSpeedButton;
    SpeedButton19: TSpeedButton;
    SpeedButton20: TSpeedButton;
    SpeedButton21: TSpeedButton;
    SpeedButton22: TSpeedButton;
    SpeedButton23: TSpeedButton;
    SpeedButton24: TSpeedButton;
    DriveTabSet: TTabControl;
    Panel7: TPanel;
    SpeedButton25: TSpeedButton;
    SpeedButton26: TSpeedButton;
    SpeedButton27: TSpeedButton;
    SpeedButton28: TSpeedButton;
    SpeedButton29: TSpeedButton;
    SpeedButton30: TSpeedButton;
    CancelBtn: TBitBtn;
    OKBtn: TBitBtn;
    ClearBtn: TBitBtn;
    SaveBtn: TBitBtn;
    CopyImageBtn: TBitBtn;
    AddBookMkBtn: TBitBtn;
    BookMkBtn: TBitBtn;
		PathEdit: TEdit;
    BitBtn1: TBitBtn;
    DisabledBtn: TBitBtn;
    NextPgBtn: TBitBtn;
    ViewBtn: TBitBtn;
    TabSheet3: TTabSheet;
    Panel4: TPanel;
    Image3: TImage;
    Panel8: TPanel;
    SEdtWidth: TSpinEdit;
    SEdtHeight: TSpinEdit;
    BtnConvert: TBitBtn;
    Label2: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Image4: TImage;
    Label7: TLabel;
    Label8: TLabel;
    BitBtn2: TBitBtn;
    TabSheet4: TTabSheet;
    Panel9: TPanel;
    Image5: TImage;
    Label9: TLabel;
		Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    DelBookMkBtn: TBitBtn;
    Image6: TImage;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    LbxBookMark: TListBox;
    Label19: TLabel;
    procedure FileListBox1Click(Sender: TObject);
    procedure ViewBtnClick(Sender: TObject);
    procedure ViewAsGlyph(const FileExt: string);
    procedure StretchCheckClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SaveBtnClick(Sender: TObject);
    procedure SpeedButtonMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure NextPgBtnClick(Sender: TObject);
    procedure DisabledBtnClick(Sender: TObject);
		procedure OKBtnClick(Sender: TObject);
    procedure DirectoryListBox1Change(Sender: TObject);
    procedure CopyImageBtnClick(Sender: TObject);
    procedure ClearBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure DriveTabSetChange(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure DisplayHint(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure BtnSaveClick(Sender: TObject);
    procedure BookMkBtnClick(Sender: TObject);
    procedure AddBookMkBtnClick(Sender: TObject);
    procedure DelBookMkBtnClick(Sender: TObject);
    procedure LbxBookMarkDblClick(Sender: TObject);
    procedure BtnConvertClick(Sender: TObject);
    procedure LbxBookMarkDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure LbxBookMarkDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure LbxBookMarkMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
  { Private declarations }
    DefaultDir: string;
    Icon1: TIcon;
		IniFile: TIniFile;
    LastDirIndex: integer;
    sSearchPath: string;
    sSbName: string;
    SynBtnList: Boolean; //Synchronize Glyphs in SpeedButtons with FileListBox1
    tsRec: TSearchRec;
    Title: string;
//	  function  DiskInDrive(Drv: Char): Boolean;
    procedure LoadBookMarks;
    procedure UpdateBookMarks;
    procedure AddBookMark(NewDir: string);
    procedure DrawGlyphs;
    procedure ClearGlyphs;
    procedure Draw;
    procedure ReleaseBtn;
  end;

var
  PEPicMainForm: TPEPicMainForm;

implementation

uses LsPEPicViewD4;

{$R *.DFM}


{
function  TPE_MainForm.DiskInDrive(Drv: Char): Boolean;
var
 ErrorMode: word;
begin
 if (Drv in ['a'..'z']) then
 Dec(Drv, $20);
 if not (Drv in ['A'..'Z']) then
 ShowMessage('Not a valid drive ID');
 ErrorMode := SetErrorMode(SEM_FailCriticalErrors);
 try
 if DiskSize(Ord(Drv) - $40) = -1 then
  Result := False
 else
  Result := True;
 finally
 SetErrorMode(ErrorMode);
 end;
end;
}


// Display applications Hints in StatusBar1
procedure TPEPicMainForm.DisplayHint(Sender: TObject);
begin
	StatusBar1.SimpleText := GetLongHint(Application.Hint);
end;


procedure TPEPicMainForm.FormCreate(Sender: TObject);
var
	Drive: Char;
	AddedIndex: Integer;
begin
	for Drive := 'A' to 'Z' do
		if GetDriveType(PChar(Drive + ':\')) > 1 then begin
			AddedIndex := DriveTabSet.Tabs.Add(Drive + ' :');
			if UpCase(Drive) = Upcase(DirectoryListBox1.Drive) then
				DriveTabSet.TabIndex := AddedIndex;
		end;
	with LbxBookMark do begin
		Left := 2;
		Top := 2;
		Height := 120;
		Width := 334;
		Visible := False;
	end;
	Icon1 := TIcon.Create;
  Application.OnHint := DisplayHint;
  Title := 'Property Editor (Bitmap and Picture)';
  GetDir(0, DefaultDir);
  LoadBookMarks;
  DirectoryListBox1.Directory := LbxBookMark.Items[LastDirIndex];
end;


procedure TPEPicMainForm.FormActivate(Sender: TObject);
begin
  PageControl1.ActivePage := TabSheet1;
  SynBtnList := False;
  PathEdit.Text := DirectoryListBox1.Directory;
end;


procedure TPEPicMainForm.FormDestroy(Sender: TObject);
begin
  ChDir(DefaultDir);
end;

// Select a file from FileListBox, and load picture into Image1
procedure TPEPicMainForm.FileListBox1Click(Sender: TObject);
var
  FileExt: string[4];
begin
  ClearBtnClick(Sender);
  FileExt := UpperCase(ExtractFileExt(FileListBox1.Filename));

  if (FileExt = '.BMP') or (FileExt = '.ICO') or
    (FileExt = '.WMF') then begin
    Image1.Picture.LoadFromFile(FileListBox1.Filename);
    Image2.Picture := Image1.Picture;
    Label1.Caption := ExtractFilename(FileListBox1.Filename);
    Caption := Title + '  -  ' + Label1.Caption;
    if (FileExt = '.BMP') then begin
      PageControl1.ActivePage := TabSheet1;
      Label3.Caption := Format('(%d x %d)', [Image1.Picture.Width,
        Image1.Picture.Height]);
      PEPicViewForm.VFrmImage1.Picture := Image1.Picture;
      ViewAsGlyph(FileExt);
    end { if FileExt = 'BMP'}
    else
      Label3.Caption := '(n/a)';

		if FileExt = '.ICO' then begin
			PageControl1.ActivePage := TabSheet3;
      Icon1 := Image1.Picture.Icon;
      Image3.Picture.Icon := Icon1;
      Image4.Picture := nil;
      BtnConvert.Enabled := True;
    end;

    if FileExt = '.WMF' then begin
      PageControl1.ActivePage := TabSheet1;
      PEPicViewForm.VFrmImage1.Picture.Metafile := Image1.Picture.Metafile;
    end;
  end;
  ReleaseBtn;
end;

// If it is a Bitmap, Load it to Image2 and BitBtn1 as Glyph
procedure TPEPicMainForm.ViewAsGlyph(const FileExt: string);
begin
	if (PageControl1.ActivePage = TabSheet2) and (FileExt = '.BMP') then begin
		Image2.Picture := Image1.Picture;
		BitBtn1.Glyph := Image1.Picture.Bitmap;
	end;
end;

// To view the picture at its fullsize
procedure TPEPicMainForm.ViewBtnClick(Sender: TObject);
begin
  if (Image1.Picture.Width < 620) and
    (Image1.Picture.Height < 440) then begin
    PEPicViewForm.Width := Image1.Picture.Width + 20;
    PEPicViewForm.Height := Image1.Picture.Height + 40;
  end
  else begin
    PEPicViewForm.Width := 640;
    PEPicViewForm.Height := 480;
    PEPicViewForm.HorzScrollBar.Range := Image1.Picture.Width;
    PEPicViewForm.VertScrollBar.Range := Image1.Picture.Height;
  end;
  PEPicViewForm.Caption := Label1.Caption;
  PEPicViewForm.VFrmImage1.Picture := Image1.Picture;
  if not PEPicViewForm.Visible then
    PEPicViewForm.Show
  else PEPicViewForm.Hide;
end;

// Stretch the picture size to fit Image1 if StretchCheckBox Checked
procedure TPEPicMainForm.StretchCheckClick(Sender: TObject);
begin
	Image1.Stretch := StretchCheck.Checked;
end;

// Save the selected Picture to a file
procedure TPEPicMainForm.SaveBtnClick(Sender: TObject);
begin
	if Image1.Picture.Graphic = nil then begin
    ShowMessage('No Image selected');
    exit;
  end;
  if Label1.Caption <> '' then
    SaveDialog1.Filename := Label1.Caption;
  if SaveDialog1.Execute then
    Image1.Picture.SaveToFile(SaveDialog1.Filename)
  else
    ModalResult := mrNone;
end;


// =========== Draw bitmaps in speedbuttons on TabSheet2 as glyphs =========

procedure TPEPicMainForm.Draw;
var
	i: integer;
	bEnd: Boolean;
begin
	bEnd := False;
	i := 0;
	while i < ComponentCount do begin
    if Components[i] is TSpeedButton then
      with Components[i] as TSpeedButton do
        if not bEnd then begin
          Glyph.loadFromFile(sSearchPath + tsRec.Name);
          NumGlyphs := Glyph.width div 16;
          Hint := tsRec.Name;
          Visible := True;
          Down := False;
          if FindNext(tsRec) <> 0 then begin
            FindFirst(sSearchPath + '*.bmp', faAnyFile, tsRec);
            bEnd := True;
          end;
        end
        else
          Visible := False;
    inc(i);
  end;
end;


procedure TPEPicMainForm.DrawGlyphs;
begin
  sSearchPath := FileListBox1.Directory;
  if sSearchPath[length(sSearchPath)] <> '\' then
    sSearchPath := sSearchPath + '\';
  if (FindFirst(sSearchPath + '*.bmp', faAnyFile, tsRec) = 0)
    and (PageControl1.ActivePage = TabSheet2) then begin
    DisabledBtn.Tag := 0;
    Draw;
  end;
end;

// Clear all Glyphs in SpeedButtons on TabSheet2
procedure TPEPicMainForm.ClearGlyphs;
var
	i: integer;
begin
	i := 0;
	while i < ComponentCount do begin
		if Components[i] is TSpeedButton then begin
			DeleteObject(TSpeedButton(Components[i]).Glyph.ReleaseHandle);
			TSpeedButton(Components[i]).Glyph := nil;
		end;
		inc(i);
	end;
end;

// Release all SpeedButtons on TabSheet2
procedure TPEPicMainForm.ReleaseBtn;
var
  i: integer;
begin
  i := 0;
  while i < ComponentCount do begin
    if Components[i] is TSpeedButton then begin
      TSpeedButton(Components[i]).Down := False;
    end;
    inc(i);
  end;
end;

// MouseDownEvent - LEFT-Button to select Glyph
//                  RIGHT-Button to activate PopupMenu1
procedure TPEPicMainForm.SpeedButtonMouseDown(Sender: TObject;
	Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
	PtPos: TPoint;
	SelPict: TBitmap;
	SelFile: string;
begin
	PtPos := Point(X, Y);
	PtPos := TSpeedButton(Sender).ClientToScreen(PtPos);
  sSBName := TSpeedButton(Sender).Name;
  if Button = mbLeft then begin
    SelPict := TSpeedButton(Sender).Glyph;
    SelFile := TSpeedButton(Sender).Hint;

    SynBtnList := True;
    FileListBox1.ApplyFilePath(DirectoryListBox1.Directory + '\' + SelFile);
    SynBtnList := False;

    Image1.Picture.Graphic := SelPict;
    Image2.Picture.Graphic := SelPict;
    Label1.Caption := SelFile;
    Label3.Caption := Format('(%d x %d)',
      [Image1.Picture.Width, Image1.Picture.Height]);
    PathEdit.Text := LowerCase(FileListBox1.Directory);
		Caption := Title + '  -  ' + SelFile;
		ViewAsGlyph('.BMP');
	end
	else if Button = mbRight then begin
		NumGlyph1.Caption := 'Num Glyphs = ' +
			IntToStr(TSpeedButton(Sender).NumGlyphs);
		PopupMenu1.Popup(PtPos.x + 10, PtPos.y + 6);
	end;
end;

// Display next page of Glyphs
procedure TPEPicMainForm.NextPgBtnClick(Sender: TObject);
begin
	Image1.Picture.graphic := nil;
  Label1.Caption := '';
  Label3.Caption := '';
  Caption := Title;
  BitBtn1.Enabled := True;
  BitBtn1.Glyph := nil;
  Image2.Picture := nil;
  DisabledBtn.Tag := 0;
  Draw;
end;

// Enable or Disable Glyphs in SpeedButtons.
procedure TPEPicMainForm.DisabledBtnClick(Sender: TObject);
var
	i: integer;
begin
	with DisabledBtn do begin
		if Tag = 0 then begin
			Font.Color := clBlue;
			Caption := 'Enable';
			Hint := '| Enable Glyphs in SpeedButtons';
			Tag := 1;
    end
    else begin
      Font.Color := clRed;
      Caption := 'Disable';
      Hint := '| Disable Glyphs in SpeedButtons';
      Tag := 0;
    end;
  end;
  i := 0;
  while i < ComponentCount do begin
    if Components[i] is TSpeedButton then
      TSpeedButton(Components[i]).Enabled := (DisabledBtn.Tag = 0);
    inc(i);
  end;
	BitBtn1.Enabled := (DisabledBtn.Tag = 0);
end;


procedure TPEPicMainForm.DirectoryListBox1Change(Sender: TObject);
var
  FileDir: string;
begin
  FileDir := FileListBox1.Directory;
  if FileDir[Length(FileDir)] <> '\' then
    FileDir := FileDir + '\';
  Image1.Picture.Graphic := nil;
  Image2.Picture.Graphic := nil;
  BitBtn1.Glyph := nil;
  Label1.Caption := '';
  Label3.Caption := '';
  Caption := Title;
  DriveTabSet.TabIndex := Ord(DirectoryListBox1.Drive) - $42;
  if SynBtnList = False then begin
    if FindFirst(FileDir + '*.bmp', faAnyFile, tsRec) = 0 then
      DrawGlyphs
    else
      ClearGlyphs;
  end;
	PathEdit.Text := DirectoryListBox1.Directory;
end;

// Copy the selected Bitmap/Glyph to Clipboard
procedure TPEPicMainForm.CopyImageBtnClick(Sender: TObject);
begin
  if (Image1.Picture.Graphic = nil) then begin
    ShowMessage('No Image selected');
    exit;
  end
  else if (UpperCase(ExtractFileExt(Label1.Caption)) = '.ICO') then begin
    ShowMessage('ClipBoard does not support Icons');
    exit;
  end else
    ClipBoard.Assign(Image1.Picture.Graphic);
end;

// Clear the displayed Bitmaps and/or Glyphs
procedure TPEPicMainForm.ClearBtnClick(Sender: TObject);
begin
	Image1.Picture := nil;
	Image2.Picture := nil;
	Image3.Picture := nil;
	Image4.Picture := nil;
	BitBtn1.Glyph := nil;
	BitBtn2.Glyph := nil;
	Label1.Caption := '';
	Label3.Caption := '';
	Label8.Caption := '';
	Caption := Title;
	ReleaseBtn;
end;

// Selected Bitmap/Glyph is Ok, and write current BookMark to IniFile
procedure TPEPicMainForm.OKBtnClick(Sender: TObject);
begin
  IniFile := TIniFile.Create('LsPEPicture.ini');
  with IniFile do
  try
    WriteInteger('General', 'LastDirIndex', LbxBookMark.ItemIndex);
  finally
    IniFile.Free;
  end; { finally }
  ChDir(DefaultDir);
  ModalResult := mrOK;
end;

// Cancel current operation
procedure TPEPicMainForm.CancelBtnClick(Sender: TObject);
begin
	ChDir(DefaultDir);
	ModalResult := mrCancel;
end;

// Change of Drive TabSet
procedure TPEPicMainForm.DriveTabSetChange(Sender: TObject);
begin
	with DriveTabSet do begin
		DirectoryListBox1.Drive := Tabs[TabIndex][1];
	end;
end;

// Draw Glyphs in SpeedButtons when change to TabSheet2
procedure TPEPicMainForm.PageControl1Change(Sender: TObject);
begin
	if PageControl1.ActivePage = TabSheet2 then begin
		ViewAsGlyph('.BMP');
		DrawGlyphs;
	end
	else begin
		DeleteObject(BitBtn1.Glyph.ReleaseHandle);
		BitBtn1.Glyph := nil;
		ClearGlyphs;
		BitBtn2.Enabled := False;
	end; { else }
end;

// Save currently selected Picture/Bitmap to a file
procedure TPEPicMainForm.BtnSaveClick(Sender: TObject);
begin
	if Image1.Picture.Graphic.Empty = True then begin
		ShowMessage('No Image selected');
		exit;
	end;
	if Label1.Caption <> '' then
		SaveDialog1.Filename := Label1.Caption;
	if SaveDialog1.Execute then
		Image1.Picture.SaveToFile(SaveDialog1.Filename)
	else
		ModalResult := mrNone;
end;

// Open or Close BookMark List (LbxBookMark)
procedure TPEPicMainForm.BookMkBtnClick(Sender: TObject);
begin
	if not LbxBookMark.Visible then
		LbxBookMark.Visible := True
	else
		LbxBookMark.Visible := False;
end;

// ===================== BookMarks =========================

// Load BookMarks from IniFile (IconEditor.ini) to BookMark List(LbxBookMark)
procedure TPEPicMainForm.LoadBookMarks;
var
	i,
    BookMarksCount: Integer;
begin
  IniFile := TIniFile.Create('LsPEPicture.ini');
  with IniFile do
  try
    LbxBookMark.Items.Clear;
    LbxBookMark.ItemIndex := 0;
    BookMarksCount := ReadInteger('General', 'BookMarksCount', 0);
    for i := 1 to BookMarksCount do begin
      LbxBookMark.ItemIndex := i - 1;
      LbxBookMark.Items.Add(ReadString('Path', 'Directory' +
        IntToStr(i), ''));
    end;
    LastDirIndex := ReadInteger('General', 'LastDirIndex', 0);
    LbxBookMark.ItemIndex := LastDirIndex;
	finally
    Free;
  end;
  LbxBookMark.ItemIndex := LastDirIndex;
end;

// Add current DirectoryListBox's directory to BookMark List
procedure TPEPicMainForm.AddBookMkBtnClick(Sender: TObject);
var
	CurDir: string;
begin
	if DirectoryListBox1.Directory = '' then begin
		ShowMessage('No Directory selected');
		exit;
	end;
	CurDir := DirectoryListBox1.Directory;
	if CurDir[Length(CurDir)] <> '\' then
		CurDir := CurDir + '\';
	if MessageDlg('Add the currently selected directory' + #13 +
		'      "' + UpperCase(CurDir) + '"' + #13 +
		'to the BookMarks List?' + #13, mtConfirmation,
		[mbYes, mbNo], 0) = mrNo then exit;
	AddBookMark(CurDir);
end;

// Add a Directory(NewDir) to BookMark List
procedure TPEPicMainForm.AddBookMark(NewDir: string);
begin
	NewDir := LowerCase(NewDir);
  LbxBookMark.Items.Add(NewDir);
  LbxBookMark.ItemIndex := Pred(LbxBookMark.Items.Count);
  IniFile := TIniFile.Create('LsPEPicture.ini');
  with IniFile do
  try
    WriteInteger('General', 'BookMarksCount', LbxBookMark.Items.Count);
    WriteString('Path', 'Directory' + IntToStr(LbxBookMark.Items.Count),
      NewDir);
  finally
    Free;
  end;
end;

// Delete selected BookMark from the BookMarks List
procedure TPEPicMainForm.DelBookMkBtnClick(Sender: TObject);
var
	OldIndex: integer;
begin
	if (LbxBookMark.Items.Count = 0) or (LbxBookMark.ItemIndex = -1) or
		(LbxBookMark.Visible = False) then
		exit;
  OldIndex := LbxBookMark.ItemIndex;
  if MessageDlg('Are you sure you want to delete' + #13 + '    "' +
    UpperCase(LbxBookMark.Items[OldIndex]) +
    '"' + #13 + 'from the BookMarks List ?', mtConfirmation,
    [mbYes, mbNo], 0) = mrYes then
  try
    LbxBookMark.Items.Delete(OldIndex);
    LbxBookMark.ItemIndex := 0;
    UpdateBookMarks;
  finally
    LbxBookMark.Visible := False;
    LoadBookMarks;
  end;
end;

// Select a BookMark as DirectoryListBox1's Directory
procedure TPEPicMainForm.LbxBookMarkDblClick(Sender: TObject);
var
  SelDir: string;
begin
  SelDir := LbxBookMark.Items[LbxBookMark.ItemIndex];
  if DirectoryExists(SelDir) then begin
		DirectoryListBox1.Directory := SelDir;
    DirectoryListBox1.Update;
    PathEdit.Text := DirectoryListBox1.Directory;
  end
  else ShowMessage('Selected Directory does not exist');
  LbxBookMark.Visible := False;
end;

// ============== Drag-n-Drop BookMarks in the BookMarks List ============

procedure TPEPicMainForm.LbxBookMarkDragOver(Sender, Source: TObject; X,
	Y: Integer; State: TDragState; var Accept: Boolean);
var
	DropPos: Integer;
begin
	if Source = LbxBookMark then begin
		DropPos := LbxBookMark.ItemAtPos(Point(X, Y), False);
		Accept := (DropPos > -1) and (DropPos < LbxBookMark.Items.Count);
	end
	else Accept := False;
end;

procedure TPEPicMainForm.LbxBookMarkDragDrop(Sender, Source: TObject; X,
	Y: Integer);
var
	OldPos: Integer;
	NewPos: Integer;
begin
	if Source = LbxBookMark then begin
		OldPos := LbxBookMark.ItemIndex;
    NewPos := LbxBookMark.ItemAtPos(Point(X, Y), False);
    if (NewPos > -1) and (NewPos <> OldPos) then
      LbxBookMark.Items.Move(OldPos, NewPos);
		UpdateBookMarks;
    LbxBookMark.ItemIndex := NewPos;
  end;
end;

procedure TPEPicMainForm.LbxBookMarkMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  DragItem: Integer;
begin
  if Button = mbLeft then begin
    DragItem := LbxBookMark.ItemAtPos(Point(X, Y), False);
    if (DragItem > -1) and (DragItem < LbxBookMark.Items.Count) then
      LbxBookMark.BeginDrag(False);
  end
	else if Button = mbRight then
    LbxBookMark.Visible := False;
end;

// Update IniFile (IconEditor.ini) after changing or deleting BookMarks

procedure TPEPicMainForm.UpdateBookMarks;
var
  i: integer;
begin
	IniFile := TIniFile.Create('LsPEPicture.ini');
	with IniFile do
	try
		WriteInteger('General', 'BookMarksCount', LbxBookMark.Items.Count);
		EraseSection('Path');
		LbxBookMark.ItemIndex := 0;
		for i := 1 to LbxBookMark.Items.Count do begin
			LbxBookMark.ItemIndex := i - 1;
			WriteString('Path', 'Directory' + IntToStr(i),
				LowerCase(LbxBookMark.Items[Pred(i)]));
		end; // for
	finally
		Free;
	end;
end;


// ==================== Convert Icons to Bitmaps ==================

procedure TPEPicMainForm.BtnConvertClick(Sender: TObject);
var
	Rect1: TRect;
	Bmp1: TBitmap;
const
	FExt = '.bmp';
begin
	Bmp1 := TBitmap.Create;
	Image4.Picture := nil;
	Label8.Caption := '';
	SEdtWidth.Update;
	SEdtHeight.Update;
	with Rect1 do begin
		Top := 0;
		Left := 0;
		Right := SEdtWidth.Value;
		Bottom := SEdtHeight.Value;
	end;
	try
		with Bmp1 do begin
			width := Icon1.Width;
			Height := Icon1.Height;
			Canvas.Draw(0, 0, Icon1);
		end;
		with Image4 do begin
			Width := SEdtWidth.Value;
			Height := SEdtHeight.Value;
			Canvas.StretchDraw(Rect1, Bmp1);
		end;
		Image1.Picture.Bitmap := Image4.Picture.Bitmap;
		Label1.Caption := ChangeFileExt(ExtractFileName(FileListBox1.FileName),
			FExt);
		Caption := Title + '  -  ' + Label1.Caption;
		Label3.Caption := Format('(%d x %d)', [Image1.Picture.Width,
			Image1.Picture.Height]);
		Label8.Caption := Label3.Caption;
		BitBtn2.Glyph := Image4.Picture.Bitmap;
		BtnConvert.Enabled := False;
	finally
		Bmp1.Free;
	end;
end;


end.

