unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Menus, PgSetup, Printers;

const
  FormExt = '.dfm';
  TextExt = '.txt';

type
  TDFMOrTXT = (ConvertToForm, ConvertToText) ;

  TForm1 = class(TForm)
    PageSetupDialog: TPageSetupDialog;
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Bevel1: TBevel;
    PaperSize: TLabel;
    Orientation: TLabel;
    MinMargins: TLabel;
    Margins: TLabel;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    function PageSetupDialogInitPaintPage(Sender: TObject;
      PaperSize: Smallint; PaperType: TPSPaperType;
      PaperOrientation: TPSPaperOrientation; PrinterType: TPSPrinterType;
      pSetupData: PPSDlgData): Boolean;
    function PageSetupDialogPaintPage(Sender: TObject;
      PaintWhat: TPSPaintWhat; Canvas: TCanvas; Rect: TRect): Boolean;
    procedure PageSetupDialogPrinter(Sender: TObject; Wnd: Integer);
  private
    { Private declarations }
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses ShlObj, ShellAPI;


procedure TForm1.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if PageSetupDialog.Execute then begin
    PaperSize.Caption := Format('Width = %-2.2f"   Height = %-2.2f"',
          [PageSetupDialog.PaperSize.X / 1000, PageSetupDialog.PaperSize.Y / 1000]);

    with PageSetupDialog.MinimumMargins do
      MinMargins.Caption := Format('Left = %-2.2f"  Right = %-2.2f"'#13+
                                   'Top = %-2.2f"  Bottom = %-2.2f"',
                                 [(Left / 1000), (Right / 1000), Top / 1000, Bottom / 1000]);

    with PageSetupDialog.Margins do
      Margins.Caption := Format('Left = %-2.2f"  Right = %-2.2f"'#13+
                                'Top = %-2.2f"  Bottom = %-2.2f"',
                                [Left / 1000, Right / 1000, Top / 1000, Bottom / 1000]);

    // Stuff that comes from the current printer
    if Printer.Orientation = poPortrait then
      Orientation.Caption := 'Portrait'
    else
      Orientation.Caption := 'Landscape'
  end;
end;

function TForm1.PageSetupDialogInitPaintPage(Sender: TObject;
  PaperSize: Smallint; PaperType: TPSPaperType;
  PaperOrientation: TPSPaperOrientation; PrinterType: TPSPrinterType;
  pSetupData: PPSDlgData): Boolean;
begin
  // All parameters contain data describing the paper.
  // Return true to tell the dialog that we want don't want to do any drawing, i.e.
  // the OnPaintPage event will not be called and you will only get a blank paper.
  // Return false to allow OnPaintPage to be called so you can draw it.
  Result := FALSE;
end;

function TForm1.PageSetupDialogPaintPage(Sender: TObject;
  PaintWhat: TPSPaintWhat; Canvas: TCanvas; Rect: TRect): Boolean;
begin
  Result := FALSE;
  case PaintWhat of
    // The entire paper.
    pwFullPage:
      begin

        Canvas.Brush.Color := clYellow;
        with Rect do
          Canvas.Rectangle(Left, Top, Right, Bottom);
      end;

    // Thre frame of the paper
    pwMinimumMargins:
      begin
        Canvas.Pen.Color := clGreen;
        Canvas.Brush.Color := clYellow;
        with Rect do
          Canvas.Rectangle(Left, Top, Right, Bottom);
      end;

    // The margin rectangle
    pwMargins:
      begin
        Canvas.Pen.Color := clRed;
        Canvas.Pen.Style := psDot;
        Canvas.Brush.Color := clWhite;
        with Rect do
          Canvas.Rectangle(Left, Top, Right, Bottom);
      end;

    // The rectangle where sample text is drawn.
    pwGreekText:
      begin
        Canvas.Pen.Color := clRed;
        Canvas.Pen.Style := psDot;
        Canvas.Brush.Color := clWhite;
        with Rect do
          Canvas.Rectangle(Left, Top, Right, Bottom);
      end;

    // Stamp rect for envelopes.
    pwEnvStamp:
      begin
        Canvas.Pen.Color := clBlue;
        Canvas.Pen.Style := psDot;
        Canvas.Brush.Style := bsSolid;
        Canvas.Brush.Color := clRed;
        with Rect do
          Canvas.Rectangle(Left, Top, Right, Bottom);
      end;
  end;
end;

procedure TForm1.PageSetupDialogPrinter(Sender: TObject; Wnd: Integer);
begin
  MessageDlg('This handler allows you to override what happens'#13 +
             'when the user presses the Printer button.  If you'#13 +
             'do not add a handler for it, the system will take'#13 +
             'take care of it, displaying the Printer Setup'#13 +
             'Dialog itself.  This is what you really want 99%'#13 +
             'of the time.', mtInformation, [mbOK], 0);
end;

end.


