{$J+,Z4}
unit pgpTLS;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the "Borland Delphi Runtime Library PGPsdk" released 10 Apr }
{ 2000, available at http://www.oz.net/~srheller/dpgp/sdk/.                        }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpTLS.pas based on pgpTLS.h                                }
{ from the PGP sources which are Copyright (C) PGP Corporation.                    }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ Types pPGPtlsContext, pPGPtlsConstContext, pPGPtlsSession, pPGPtlsConstSession   }
{ moved to pgpPubTypes.pas, all functions taking OptionLists modified according    }
{ to a suggestion by Steven R. Heller, for details see pgpOptionList.pas           }
{                                                                                  }
{**********************************************************************************}

interface

uses
  pgpBase,
  pgpPubTypes;

type
  PGPtlsFlags = PGPFlags;
const
  kPGPtlsFlags_ServerSide			= $01;
  kPGPtlsFlags_ClientSide			= $02;
  kPGPtlsFlags_RequestClientCert		= $04;
  kPGPtlsFlags_NonBlockingIO			= $08;

type
  PGPtlsCipherSuiteNum = PGPEnumType;
const
  kPGPtls_TLS_NULL_WITH_NULL_NULL		= 0;
  kPGPtls_TLS_PGP_DHE_DSS_WITH_CAST_CBC_SHA	= 1;
  kPGPtls_TLS_PGP_DHE_RSA_WITH_CAST_CBC_SHA	= 2;
  kPGPtls_TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA	= 3;
  kPGPtls_TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA	= 4;
  kPGPtls_TLS_RSA_WITH_3DES_EDE_CBC_SHA		= 5;
  kPGPtls_TLS_RSA_WITH_IDEA_CBC_SHA		= 6;
  kPGPtls_TLS_PGP_RSA_WITH_CAST_CBC_SHA		= 7;
  kPGPtls_TLS_PGP_DHE_DSS_WITH_NULL_SHA		= 8;
  kPGPtls_TLS_DHE_DSS_WITH_NULL_SHA		= 9;

type
  PGPtlsProtocolState = PGPEnumType;
const
  kPGPtls_IdleState				= 0;
  kPGPtls_FatalErrorState			= 1;
  kPGPtls_ClosedState				= 2;
  kPGPtls_HandshakeState			= 3;
  kPGPtls_ReadyState				= 4;

type
  PGPtlsPrime = PGPEnumType;
const
  kPGPtls_DHPrime1024				= 0;
  kPGPtls_DHPrime1536				= 1;
  kPGPtls_DHPrime2048				= 2;
  kPGPtls_DHPrime3072				= 3;
  kPGPtls_DHPrime4096				= 4;

type
  PGPtlsAlert = PGPEnumType;
const
  kPGPtls_AT_CloseNotify			= 000;
  kPGPtls_AT_UnexpectedMessage			= 010;	{ FATAL }
  kPGPtls_AT_BadRecordMAC			= 020;	{ FATAL }
  kPGPtls_AT_DecryptionFailed			= 021;	{ FATAL }
  kPGPtls_AT_RecordOverflow			= 022;	{ FATAL }
  kPGPtls_AT_DecompressionFailure		= 030;	{ FATAL }
  kPGPtls_AT_HandshakeFailure			= 040;	{ FATAL }
  kPGPtls_AT_NoCertificate			= 041;	{ SSL3  }
  kPGPtls_AT_BadCertificate			= 042;
  kPGPtls_AT_UnsupportedCert			= 043;
  kPGPtls_AT_CertRevoked			= 044;
  kPGPtls_AT_CertExpired			= 045;
  kPGPtls_AT_CertUnknown			= 046;
  kPGPtls_AT_IllegalParameter			= 047;	{ FATAL }
  kPGPtls_AT_UnknownCA				= 048;	{ FATAL }
  kPGPtls_AT_AccessDenied			= 049;	{ FATAL }
  kPGPtls_AT_DecodeError			= 050;	{ FATAL }
  kPGPtls_AT_DecryptError			= 051;
  kPGPtls_AT_ExportRestriction			= 060;	{ FATAL }
  kPGPtls_AT_ProtocolVersion			= 070;	{ FATAL }
  kPGPtls_AT_InsufficientSecurity		= 071;	{ FATAL }
  kPGPtls_AT_InternalError			= 080;	{ FATAL }
  kPGPtls_AT_UserCancelled			= 090;
  kPGPtls_AT_NoRenegotiation			= 100;

  kPGPtls_AT_None				= 255;

type
  TPGPtlsReceiveProcPtr = function(InData: Pointer; OutBuffer: Pointer; InBufferSize: PGPInt32): PGPInt32; cdecl;
  TPGPtlsSendProcPtr = function(InData: Pointer; const InBuffer: Pointer; InBufferLength: PGPInt32): PGPInt32; cdecl;

var	// added by idw from pgpUtilities.h
  PGPsdkNetworkLibInit: function(Options: PGPFlags): PGPError; cdecl;	// Options is ignored prior to 7.X
  PGPsdkNetworkLibCleanup: function: PGPError; cdecl;

{____________________________________________________________________________
  The Send and Receive function Pointers should return
  kPGPError_TLSWouldBlock when the socket is non-blocking and the
  call would block.  The Send and Receive functions passed in will
  need to translate the platform-specific socket error in appropriate
  cases by using calls such as WSAGetLastError() on Win32.  Remember
  to call PGPtlsSendQueueIdle for non-blocking sockets also if
  kPGPError_TLSWouldBlock is returned from a send on a non-blocking
  socket.
____________________________________________________________________________}

  PGPNewTLSContext: function(Context: pPGPContext; var OutRef: pPGPtlsContext): PGPError; cdecl;
  PGPFreeTLSContext: function(Ref: pPGPtlsContext): PGPError; cdecl;

{____________________________________________________________________________
  The following function activates or deactivates the session key cache
  for TLS sessions.  This defaults to on but can be deactivated with this
  function to force all connections to proceed through the entire
  handshake.
____________________________________________________________________________}

  PGPtlsSetCache: function(Ref: pPGPtlsContext; UseCache: PGPBoolean): PGPError; cdecl;
  PGPtlsClearCache: function(Ref: pPGPtlsContext): PGPError; cdecl;
  PGPNewTLSSession: function(Ref: pPGPtlsContext; var OutRef: pPGPtlsSession): PGPError; cdecl;
  PGPFreeTLSSession: function(Ref: pPGPtlsSession): PGPError; cdecl;
  PGPCopyTLSSession: function(Ref: pPGPtlsSession; var OutRef: pPGPtlsSession): PGPError; cdecl;

{____________________________________________________________________________
  Default options are client side and no client cert request
____________________________________________________________________________}

  PGPtlsSetProtocolOptions: function(Ref: pPGPtlsSession; Options: PGPtlsFlags): PGPError; cdecl;

{____________________________________________________________________________
  The following function must be called to cleanly close a TLS
  connection.  If it is not called, the session will not be able
  to be resumed from the session cache.

  In the event the application determines any problem with the
  connection such as the remote key not being valid, call this
  function with dontCache set to true in order to not cache the
  session keys.
____________________________________________________________________________}

  PGPtlsClose: function(Ref: pPGPtlsSession; DontCache: PGPBoolean): PGPError; cdecl;

{____________________________________________________________________________
  The following function must be called to initiate the PGPtls session.
  Once a TLS session has been assigned to a socket, no data can be sent
  over that socket by the application until the handshake is completed.
  Handshake completion is indicated by completion of this call without
  error or by checking the state of the PGPtlsSession.  It will be
  kPGPtls_ReadyState when the application layer may send and receive
  data securely.

  This function performs all negotiation of the TLS connection.
____________________________________________________________________________}

  PGPtlsHandshake: function(Ref: pPGPtlsSession): PGPError; cdecl;

{____________________________________________________________________________
  The following function should be called before PGPtlsHandshake.
  In the general case, the remoteID will be an IP address.  This
  is provided to PGPtls in order to allow it to cache the current
  session and be able to look it up later.  If the remoteID passed
  into a future session is the same as a previously cached session,
  PGPtls will attempt to resume the session.
____________________________________________________________________________}

  {// PGP 6.5.X
  PGPtlsSetRemoteUniqueID: function(Ref: pPGPtlsSession; RemoteID: PGPUInt32): PGPError; cdecl;}
  {// PGP 9.X
  PGPtlsSetRemoteUniqueID: function(Ref: pPGPtlsSession; RemoteID: PGPUInt64): PGPError; cdecl;}

{____________________________________________________________________________
  The following function sets the local private authenticating key.

  The passphrase and key are retained in memory.  By default, no
  key is specified and a client side session will return no key in the
  client key exchange message to the server.
  It is an error not to specify a key on a server side TLS session.
  This function must be passed either PGPOPassphrase or PGPOPasskeyBuffer.
  You may pass in just a PGP key, PGP w/ X.509 cert, or both -- and they
  must be the same -- the cert must be from the key.  For an X.509 cert,
  the inCertChain keyset must contain the keys of all keys in the
  certificate chain for that certificate up to the root.  [To disable X.509
  certs, simply pass nothing (ie. kPGPInvalidSigRef).]  The inCertChain
  keyset must remain valid for the lifetime of the TLS connection.
____________________________________________________________________________}

  {// PGP 6.5.X
  PGPtlsSetLocalPrivateKey: function(Ref: pPGPtlsSession; InKey: pPGPKey; InX509Cert: pPGPSig; InCertChain: pPGPKeySet;
				     Options: pPGPOptionList; LastOption: pPGPOptionList): PGPError; cdecl;}
  {// PGP 7.X
  PGPtlsSetLocalPrivateKey: function(Ref: pPGPtlsSession; InKey: pPGPKeyDBObj; InCertChain: pPGPKeySet;
				     Options: pPGPOptionList; LastOption: pPGPOptionList): PGPError; cdecl;}

{____________________________________________________________________________
  The following function sets the preferred cipher suite.

  There is no guarantee that cipher will actually be negotiated,
  but it will be attempted in preference to others.
____________________________________________________________________________}

  PGPtlsSetPreferredCipherSuite: function(Ref: pPGPtlsSession; Cipher: PGPtlsCipherSuiteNum): PGPError; cdecl;

{____________________________________________________________________________
  The following function sets the desired DH prime.

  The requested primes are drawn from a set of primes hard-coded
  into PGPtls.  New primes can be added in a fully compatible
  fashion since the server sends the prime to the client, but this
  version of the API does not support passing in a desired prime.  The
  default prime if this function is not called is kPGPtls_DHPrime2048.
____________________________________________________________________________}

  PGPtlsSetDHPrime: function(Ref: pPGPtlsSession; Prime: PGPtlsPrime): PGPError; cdecl;

{____________________________________________________________________________
  The following function gets the authenticated remote key after a
  successful handshake.  You must call this function after a successful
  handshake to verify that the remote key is authorized to make the
  connection.
____________________________________________________________________________}

  {// PGP 6.5.X
  PGPtlsGetRemoteAuthenticatedKey: function(Ref: pPGPtlsSession; var OutKey: pPGPKey;
  					    var OutKeySet: pPGPKeySet): PGPError; cdecl;}
  {// PGP 7.X
  PGPtlsGetRemoteAuthenticatedKey: function(Ref: pPGPtlsSession; var OutKey: pPGPKeyDBObj;
  					    var OutKeyDB: pPGPKeyDB): PGPError; cdecl;}

{____________________________________________________________________________
  The following function returns the negotiated symmetric cipher.

  This function will return an error if called before a successful
  handshake.
____________________________________________________________________________}

  PGPtlsGetNegotiatedCipherSuite: function(Ref: pPGPtlsSession; var OutCipher: PGPtlsCipherSuiteNum): PGPError; cdecl;
  PGPtlsGetState: function(Ref: pPGPtlsSession; var OutState: PGPtlsProtocolState): PGPError; cdecl;

{____________________________________________________________________________
  The following two functions process data through TLS.

  It is an error to call these functions without having set a
  Read function Pointer or Write function Pointer.  Most applications
  will never need to use these functions as the function Pointers
  are automatically configured by PGPsockets, and these functions
  are automatically called by the PGPsockets implementations of
  PGPWrite and PGPRead whenever a pPGPtlsSession has been set for
  a given socket.
____________________________________________________________________________}

  PGPtlsReceive: function(Ref: pPGPtlsSession; var OutBuffer: Pointer; var BufferSize: PGPSize): PGPError; cdecl;
  {// PGP 6.5.X
  PGPtlsSend: function(Ref: pPGPtlsSession; const InBuffer: Pointer; InBufferLength: PGPSize): PGPError; cdecl;}
  {// PGP 9.X
  PGPtlsSend: function(Ref: pPGPtlsSession; const InBuffer: Pointer; ; var BufferSize: PGPSize): PGPError; cdecl;}
  PGPtlsSetReceiveCallback: function(Ref: pPGPtlsSession; TLSReceiveProc: TPGPtlsReceiveProcPtr; InData: Pointer): PGPError; cdecl;
  PGPtlsSetSendCallback: function(Ref: pPGPtlsSession; TLSSendProc: TPGPtlsSendProcPtr; InData: Pointer): PGPError; cdecl;

{____________________________________________________________________________
  The following function is necessary *only* on a non-blocking socket.
  If a call to PGPtlsSend returns kPGPError_TLSWouldBlock, call
  the following function repeatedly until that error is no longer
  returned in order to make sure data is sent.  Another call to
  PGPtlsSend will also call this function automatically and queue
  any new data if necessary.
____________________________________________________________________________}

  PGPtlsSendQueueIdle: function(Ref: pPGPtlsSession): PGPError; cdecl;
  PGPtlsReceiveBufferSize: function(Ref: pPGPtlsSession): PGPSize; cdecl;

{____________________________________________________________________________
  The following function gets the ID of the fatal alert which caused
  the TLS session to abort and go into the kPGPtls_FatalErrorState.
____________________________________________________________________________}

  PGPtlsGetAlert: function(Ref: pPGPtlsSession; var OutAlert: PGPtlsAlert): PGPError; cdecl;

implementation	// code modified by idw

uses
  Windows;

initialization

  if PGPInitErrorCode = ieNone then begin
    PGPsdkNetworkLibInit := GetProcAddress(hPGPsdkNLLib, 'PGPsdkNetworkLibInit');
    PGPsdkNetworkLibCleanup := GetProcAddress(hPGPsdkNLLib, 'PGPsdkNetworkLibCleanup');
    PGPNewTLSContext := GetProcAddress(hPGPsdkNLLib, 'PGPNewTLSContext');
    PGPFreeTLSContext := GetProcAddress(hPGPsdkNLLib, 'PGPFreeTLSContext');
    PGPtlsSetCache := GetProcAddress(hPGPsdkNLLib, 'PGPtlsSetCache');
    PGPtlsClearCache := GetProcAddress(hPGPsdkNLLib, 'PGPtlsClearCache');
    PGPNewTLSSession := GetProcAddress(hPGPsdkNLLib, 'PGPNewTLSSession');
    PGPFreeTLSSession := GetProcAddress(hPGPsdkNLLib, 'PGPFreeTLSSession');
    PGPCopyTLSSession := GetProcAddress(hPGPsdkNLLib, 'PGPCopyTLSSession');
    PGPtlsSetProtocolOptions := GetProcAddress(hPGPsdkNLLib, 'PGPtlsSetProtocolOptions');
    PGPtlsClose := GetProcAddress(hPGPsdkNLLib, 'PGPtlsClose');
    PGPtlsHandshake := GetProcAddress(hPGPsdkNLLib, 'PGPtlsHandshake');
    {PGPtlsSetRemoteUniqueID := GetProcAddress(hPGPsdkNLLib, 'PGPtlsSetRemoteUniqueID');}
    {PGPtlsSetLocalPrivateKey := GetProcAddress(hPGPsdkNLLib, 'PGPtlsSetLocalPrivateKey');}
    PGPtlsSetPreferredCipherSuite := GetProcAddress(hPGPsdkNLLib, 'PGPtlsSetPreferredCipherSuite');
    PGPtlsSetDHPrime := GetProcAddress(hPGPsdkNLLib, 'PGPtlsSetDHPrime');
    {PGPtlsGetRemoteAuthenticatedKey := GetProcAddress(hPGPsdkNLLib, 'PGPtlsGetRemoteAuthenticatedKey');}
    PGPtlsGetNegotiatedCipherSuite := GetProcAddress(hPGPsdkNLLib, 'PGPtlsGetNegotiatedCipherSuite');
    PGPtlsGetState := GetProcAddress(hPGPsdkNLLib, 'PGPtlsGetState');
    PGPtlsReceive := GetProcAddress(hPGPsdkNLLib, 'PGPtlsReceive');
    {PGPtlsSend := GetProcAddress(hPGPsdkNLLib, 'PGPtlsSend');}
    PGPtlsSetReceiveCallback := GetProcAddress(hPGPsdkNLLib, 'PGPtlsSetReceiveCallback');
    PGPtlsSetSendCallback := GetProcAddress(hPGPsdkNLLib, 'PGPtlsSetSendCallback');
    PGPtlsSendQueueIdle := GetProcAddress(hPGPsdkNLLib, 'PGPtlsSendQueueIdle');
    PGPtlsReceiveBufferSize := GetProcAddress(hPGPsdkNLLib, 'PGPtlsReceiveBufferSize');
    PGPtlsGetAlert := GetProcAddress(hPGPsdkNLLib, 'PGPtlsGetAlert');

    PGPsdkNetworkLibInit(InitFlags);
  end;

finalization

  if Assigned(PGPsdkNetworkLibCleanup) then PGPsdkNetworkLibCleanup;

end.

