{$J+,Z4}
unit pgpSC;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the SPGP 2.5.6.0 sources,                                   }
{ available at http://www.oz.net/~srheller/spgp/.                                  }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpSC.pas based on pgpSC.h                                  }
{ from the PGP sources which are Copyright (C) PGP Corporation.                    }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ Some comments and declarations removed, some declarations activated              }
{                                                                                  }
{**********************************************************************************}

interface

uses
  Windows,
  pgpBase,
  pgpPubTypes;


type	// modified by idw
  pPGPsc = pPGPContext;
  pPGPtls = pPGPtlsContext;

type	// modified by idw
  TPath = Array[0..MAX_PATH*2] of Char;
  pFileList = ^TFileList;
  TFileList = Record case Longint of
    6: (FileList6: Record // PGP 6.5.X - 8.X
      Name: PAnsiChar;
      IsDirectory: Longbool;
      Next: pFileList;
    end);
    9: (FileList9: Record // PGP 9.X
      Name: PWideChar;
      IsDirectory: Longbool;
      Next: pFileList;
    end);
  end;

const	// 7.X & later
  WIPE_DEFAULT		=  0;
  WIPE_DONOTDELETE	=  1;
  WIPE_DONOTWARN	=  2;
  WIPE_DONOTPROGRESS	=  4;
  WIPE_DONOTERROR	=  8;
  WIPE_ADS		= 16;

// Library initialization routines
var InitPGPsc6: function(Parent: Longint; var P: pPGPsc; var TLS: pPGPtls): Longbool; cdecl;
var InitPGPsc7: function(Parent: Longint; var P: pPGPsc; var TLS: pPGPtls; Flags: Integer): Longbool; cdecl;
var UninitPGPsc: function(Parent: Longint; P: pPGPsc; TLS: pPGPtls): Longbool; cdecl;

// Clipboard routines
var EncryptClipboard6: function(Parent: Longint;
    App			: PAnsiChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    Encrypt		: Longbool;
    Sign		: Longbool): Longbool; cdecl;
var EncryptClipboard7: function(Parent: Longint;
    App			: PAnsiChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    Encrypt		: Longbool;
    Sign		: Longbool;
    StartingCR		: Longbool): Longbool; cdecl;
var EncryptClipboard9: function(Parent: Longint;
    App			: PWideChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    Encrypt		: Longbool;
    Sign		: Longbool;
    StartingCR		: Longbool): Longbool; cdecl;
var DecryptClipboard6: function(Parent: Longint;
    App			: PAnsiChar;
    P			: pPGPsc;
    TLS			: pPGPtls): Longbool; cdecl;
var DecryptClipboard7: function(Parent: Longint;
    App			: PAnsiChar;
    P			: pPGPsc;
    TLS			: pPGPtls): Longbool; cdecl;
var DecryptClipboard9: function(Parent: Longint;
    App			: PWideChar;
    P			: pPGPsc;
    TLS			: pPGPtls): Longbool; cdecl;
var AddKeyClipboard: function(Parent: Longint;
    P			: pPGPsc;
    TLS			: pPGPtls): Longbool; cdecl;
var ClipboardWipe: function(Parent: Longint; P: pPGPsc): Longbool; cdecl;

// Filelist routines
var EncryptFileList6: function(Parent: Longint;
    App			: PAnsiChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    ListHead		: pFileList;
    Encrypt		: Longbool;
    Sign		: Longbool): Longbool; cdecl;
var EncryptFileList7: function(Parent: Longint;
    App			: PAnsiChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    ListHead		: pFileList;
    Encrypt		: Longbool;
    Sign		: Longbool): Longbool; cdecl;
var EncryptFileList9: function(Parent: Longint;
    App			: PWideChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    ListHead		: pFileList;
    Encrypt		: Longbool;
    Sign		: Longbool;
    Tar			: Longbool): Longbool; cdecl;
var DecryptFileList6: function(Parent: Longint;
    App			: PAnsiChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    ListHead		: pFileList): Longbool; cdecl;
var DecryptFileList7: function(Parent: Longint;
    App			: PAnsiChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    ListHead		: pFileList): Longbool; cdecl;
var DecryptFileList9: function(Parent: Longint;
    App			: PWideChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    ListHead		: pFileList): Longbool; cdecl;
var AddKeyFileList: function(Parent: Longint;
    P			: pPGPsc;
    TLS			: pPGPtls;
    ListHead		: pFileList): Longbool; cdecl;
var WipeFileList6: function(Parent: Longint;
    P			: pPGPsc;
    ListHead		: pFileList;
    DelFilePostWipe	: Longbool): Longbool; cdecl;
var WipeFileList7: function(Parent: Longint;
    P			: pPGPsc;
    ListHead		: pFileList;
    dwWipeFlags		: DWord;
    dwPasses		: DWord): Longbool; cdecl;

var HDropToFileList: function(hDrop: Longint): pFileList; cdecl;
var CmdLineToFileList6: function(szCmdLine: PAnsiChar): pFileList; cdecl;
var CmdLineToFileList7: function(szCmdLine: PAnsiChar): pFileList; cdecl;
var CmdLineToFileList9: function(szCmdLine: PWideChar): pFileList; cdecl;

// Grabs preferences from pref file
var GetValidityDrawPrefs: function(P: pPGPsc; var InputBool: Longbool): Longbool; cdecl;
var GetMarginalInvalidPref: function(P: pPGPsc; var InputBool: Longbool): Longbool; cdecl;
var GetSecureViewerPref: function(P: pPGPsc): Longbool; cdecl;

// Use secure viewer and/or anti-tempest font (takes UTF8 input since PGP 9.X)
var TempestViewer: function(P: pPGPsc;
    Parent		: Longint;
    pInput		: PChar;
    InSize		: Longint;
    Warn		: Longbool): Cardinal; cdecl;

// Launches Keys/Tools (Net only in PGP 6.5.X - 8.X)
{var DoLaunchNet: function(Parent: Longint): Longbool; cdecl;}
var DoLaunchKeys: function(Parent: Longint): Longbool; cdecl;
var DoLaunchTools: function(Parent: Longint): Longbool; cdecl;
var DoLaunchDisk: function(Parent: Longint): Longbool; cdecl;

// Sends signature info to PGPlog (takes UTF8 input since PGP 9.X)
var SendPGPlogMsg6: function(Parent: Longint; Msg: PAnsiChar): Longbool; cdecl;
var SendPGPlogMsg7: function(Parent: Longint; Msg: PAnsiChar): Longbool; cdecl;
var SendPGPlogMsg9: function(Parent: Longint; Msg: PWideChar): Longbool; cdecl;

// Returns path for PGPkeys
var PGPpath6: procedure(Path: PAnsiChar); cdecl;
var PGPpath7: procedure(Path: PWideChar); cdecl;
var PGPpath9: procedure(Path: PAnsiChar); cdecl;

// Wrappers added by idw
function InitPGPsc(Parent: Longint; var P: pPGPsc; var TLS: pPGPtls; Flags: Integer): Longbool;
function EncryptClipboard(Parent: Longint; const App: String; P: pPGPsc; TLS: pPGPtls;
			  Encrypt, Sign, StartingCR: Longbool): Longbool;
function DecryptClipboard(Parent: Longint; const App: String; P: pPGPsc; TLS: pPGPtls): Longbool;
function EncryptFileList(Parent: Longint; const App: String; P: pPGPsc; TLS: pPGPtls; ListHead: pFileList;
			 Encrypt: Longbool; Sign: Longbool; Tar: Longbool): Longbool;
function DecryptFileList(Parent: Longint; const App: String; P: pPGPsc; TLS: pPGPtls; ListHead: pFileList): Longbool;
function WipeFileList(Parent: Longint; P: pPGPsc; ListHead: pFileList;
		      dwWipeFlags: DWord; dwPasses: DWord): Longbool;
function CmdLineToFileList(const CmdLine: String): pFileList;
function SendPGPlogMsg(Parent: Longint; const Msg: String): Longbool;
procedure PGPpath(var Path: String);

implementation	// code modified by idw

function WideCharFromString(const Str: String): PWideChar;
var
  dwSize: DWord;
begin
  dwSize := Length(Str) shl 1 + 2;
  Result := PWideChar(GlobalAlloc(GPTR, dwSize));
  if Result <> nil then StringToWideChar(Str, Result, dwSize);
end;

function InitPGPsc(Parent: Longint; var P: pPGPsc; var TLS: pPGPtls; Flags: Integer): Longbool;
begin
  if PGP7X then
    Result := InitPGPsc7(Parent, P, TLS, Flags)
  else Result := InitPGPsc6(Parent, P, TLS);
end;

function EncryptClipboard(Parent: Longint; const App: String; P: pPGPsc; TLS: pPGPtls;
			  Encrypt, Sign, StartingCR: Longbool): Longbool;
var
  pwApp: PWideChar;
begin
  Result := false;
  if PGP9X then begin
    pwApp := WideCharFromString(App);
    if pwApp <> nil then begin
      try
	Result := EncryptClipboard9(Parent, pwApp, P, TLS, Encrypt, Sign, StartingCR);
      finally
	GlobalFree(THandle(pwApp));
      end;
    end;
  end
  else if PGP7X then
    Result := EncryptClipboard7(Parent, PChar(App), P, TLS, Encrypt, Sign, StartingCR)
  else Result := EncryptClipboard6(Parent, PChar(App), P, TLS, Encrypt, Sign);
end;

function DecryptClipboard(Parent: Longint; const App: String; P: pPGPsc; TLS: pPGPtls): Longbool;
var
  pwApp: PWideChar;
begin
  Result := false;
  if PGP9X then begin
    pwApp := WideCharFromString(App);
    if pwApp <> nil then begin
      try
	Result := DecryptClipboard9(Parent, pwApp, P, TLS);
      finally
	GlobalFree(THandle(pwApp));
      end;
    end;
  end
  else if PGP7X then
    Result := DecryptClipboard7(Parent, PChar(App), P, TLS)
  else Result := DecryptClipboard6(Parent, PChar(App), P, TLS);
end;

function EncryptFileList(Parent: Longint; const App: String; P: pPGPsc; TLS: pPGPtls; ListHead: pFileList;
			 Encrypt: Longbool; Sign: Longbool; Tar: Longbool): Longbool;
var
  pwApp: PWideChar;
begin
  Result := false;
  if PGP9X then begin
    pwApp := WideCharFromString(App);
    if pwApp <> nil then begin
      try
	Result := EncryptFileList9(Parent, pwApp, P, TLS, ListHead, Encrypt, Sign, Tar);
      finally
	GlobalFree(THandle(pwApp));
      end;
    end;
  end
  else if PGP7X then
    Result := EncryptFileList7(Parent, PChar(App), P, TLS, ListHead, Encrypt, Sign)
  else Result := EncryptFileList6(Parent, PChar(App), P, TLS, ListHead, Encrypt, Sign);
end;

function DecryptFileList(Parent: Longint; const App: String; P: pPGPsc; TLS: pPGPtls; ListHead: pFileList): Longbool;
var
  pwApp: PWideChar;
begin
  Result := false;
  if PGP9X then begin
    pwApp := WideCharFromString(App);
    if pwApp <> nil then begin
      try
	Result := DecryptFileList9(Parent, pwApp, P, TLS, ListHead);
      finally
	GlobalFree(THandle(pwApp));
      end;
    end;
  end
  else if PGP7X then
    Result := DecryptFileList7(Parent, PChar(App), P, TLS, ListHead)
  else Result := DecryptFileList6(Parent, PChar(App), P, TLS, ListHead);
end;

function WipeFileList(Parent: Longint; P: pPGPsc; ListHead: pFileList;
		      dwWipeFlags: DWord; dwPasses: DWord): Longbool;
begin
  if PGP7X then
    Result := WipeFileList7(Parent, P, ListHead, dwWipeFlags, dwPasses)
  else Result := WipeFileList6(Parent, P, ListHead, (dwWipeFlags and WIPE_DONOTDELETE) = 0);
end;

function CmdLineToFileList(const CmdLine: String): pFileList;
var
  pwCmdLine: PWideChar;
begin
  Result := nil;
  if PGP9X then begin
    pwCmdLine := WideCharFromString(CmdLine);
    if pwCmdLine <> nil then begin
      try
	Result := CmdLineToFileList9(pwCmdLine);
      finally
	GlobalFree(THandle(pwCmdLine));
      end;
    end;
  end
  else if PGP7X then
    Result := CmdLineToFileList7(PChar(CmdLine))
  else Result := CmdLineToFileList6(PChar(CmdLine));
end;

function SendPGPlogMsg(Parent: Longint; const Msg: String): Longbool;
var
  pwMsg: PWideChar;
begin
  Result := false;
  if PGP9X then begin
    pwMsg := WideCharFromString(Msg);
    if pwMsg <> nil then begin
      try
	Result := SendPGPlogMsg9(Parent, pwMsg);
      finally
	GlobalFree(THandle(pwMsg));
      end;
    end;
  end
  else if PGP7X then
    Result := SendPGPlogMsg7(Parent, PChar(Msg))
  else Result := SendPGPlogMsg6(Parent, PChar(Msg));
end;


procedure PGPpath(var Path: String);
var
  aPath: TPath;
begin
  if PGP9X then begin
    PGPpath9(aPath);
    Path := WideCharToString(@aPath);
  end
  else begin
    if PGP7X then
      PGPpath7(@aPath)
    else PGPpath6(@aPath);
    Path := aPath;
  end;
end;

initialization

  if PGPInitErrorCode = ieNone then begin
    if PGP7X then begin
      InitPGPsc7 := GetProcAddress(hPGPscLib, 'PGPscInit');
      UninitPGPsc := GetProcAddress(hPGPscLib, 'PGPscDestroy');
      EncryptClipboard7 := GetProcAddress(hPGPscLib, 'PGPscEncryptClipboard');
      EncryptClipboard9 := GetProcAddress(hPGPscLib, 'PGPscEncryptClipboard');
      DecryptClipboard7 := GetProcAddress(hPGPscLib, 'PGPscDecryptClipboard');
      DecryptClipboard9 := GetProcAddress(hPGPscLib, 'PGPscDecryptClipboard');
      AddKeyClipboard := GetProcAddress(hPGPscLib, 'PGPscAddKeyClipboard');
      ClipboardWipe := GetProcAddress(hPGPscLib, 'PGPscEraseClipboard');
      EncryptFileList7 := GetProcAddress(hPGPscLib, 'PGPscEncryptFileList');
      EncryptFileList9 := GetProcAddress(hPGPscLib, 'PGPscEncryptFileList');
      DecryptFileList7 := GetProcAddress(hPGPscLib, 'PGPscDecryptFileList');
      DecryptFileList9 := GetProcAddress(hPGPscLib, 'PGPscDecryptFileList');
      AddKeyFileList := GetProcAddress(hPGPscLib, 'PGPscAddKeyFileList');
      WipeFileList7 := GetProcAddress(hPGPscLib, 'PGPscWipeFileList');
      HDropToFileList := GetProcAddress(hPGPscLib, 'PGPscHDropToFileList');
      CmdLineToFileList7 := GetProcAddress(hPGPscLib, 'PGPscCmdLineToFileList');
      CmdLineToFileList9 := GetProcAddress(hPGPscLib, 'PGPscCmdLineToFileList');
      GetValidityDrawPrefs := GetProcAddress(hPGPscLib, 'PGPscGetValidityDrawPrefs');
      GetMarginalInvalidPref := GetProcAddress(hPGPscLib, 'PGPscGetMarginalInvalidPref');
      GetSecureViewerPref := GetProcAddress(hPGPscLib, 'PGPscGetSecureViewerPref');
      TempestViewer := GetProcAddress(hPGPscLib, 'PGPscTempestViewer');
      {DoLaunchNet := GetProcAddress(hPGPscLib, 'PGPscDoLaunchNet');}
      DoLaunchKeys := GetProcAddress(hPGPscLib, 'PGPscDoLaunchKeys');
      DoLaunchTools := GetProcAddress(hPGPscLib, 'PGPscDoLaunchTools');
      DoLaunchDisk := GetProcAddress(hPGPscLib, 'PGPscDoLaunchDisk');
      SendPGPlogMsg7 := GetProcAddress(hPGPscLib, 'PGPscSendPGPlogMsg');
      SendPGPlogMsg9 := GetProcAddress(hPGPscLib, 'PGPscSendPGPlogMsg');
      PGPpath7 := GetProcAddress(hPGPscLib, 'PGPscPGPpath');
      PGPpath9 := GetProcAddress(hPGPscLib, 'PGPscPGPpath');
    end
    else begin
      InitPGPsc6 := GetProcAddress(hPGPscLib, 'InitPGPsc');
      UninitPGPsc := GetProcAddress(hPGPscLib, 'UninitPGPsc');
      EncryptClipboard6 := GetProcAddress(hPGPscLib, 'EncryptClipboard');
      DecryptClipboard6 := GetProcAddress(hPGPscLib, 'DecryptClipboard');
      AddKeyClipboard := GetProcAddress(hPGPscLib, 'AddKeyClipboard');
      ClipboardWipe := GetProcAddress(hPGPscLib, 'ClipboardWipe');
      EncryptFileList6 := GetProcAddress(hPGPscLib, 'EncryptFileList');
      DecryptFileList6 := GetProcAddress(hPGPscLib, 'DecryptFileList');
      AddKeyFileList := GetProcAddress(hPGPscLib, 'AddKeyFileList');
      WipeFileList6 := GetProcAddress(hPGPscLib, 'WipeFileList');
      HDropToFileList := GetProcAddress(hPGPscLib, 'HDropToFileList');
      CmdLineToFileList6 := GetProcAddress(hPGPscLib, 'CmdLineToFileList');
      GetValidityDrawPrefs := GetProcAddress(hPGPscLib, 'GetValidityDrawPrefs');
      GetMarginalInvalidPref := GetProcAddress(hPGPscLib, 'GetMarginalInvalidPref');
      GetSecureViewerPref := GetProcAddress(hPGPscLib, 'GetSecureViewerPref');
      TempestViewer := GetProcAddress(hPGPscLib, 'TempestViewer');
      {DoLaunchNet := GetProcAddress(hPGPscLib, 'DoLaunchNet');}
      DoLaunchKeys := GetProcAddress(hPGPscLib, 'DoLaunchKeys');
      DoLaunchTools := GetProcAddress(hPGPscLib, 'DoLaunchTools');
      DoLaunchDisk := GetProcAddress(hPGPscLib, 'DoLaunchDisk');
      SendPGPlogMsg6 := GetProcAddress(hPGPscLib, 'SendPGPlogMsg');
      PGPpath6 := GetProcAddress(hPGPscLib, 'PGPpath');
    end;
  end;

end.

