{$J+,Z4}
unit pgpBase;

{ $DEFINE SILENT_FAILURE}

// by removing the space preceding $DEFINE you may enable SILENT_FAILURE,
// which disables all initialization error messages in case of a
// missing or incorrect PGP installation; this requires checking
// PGPInitErrorCode before using any PGP functionality, though

{ $DEFINE FORCE_LOCAL_EXEC}

// for some reason PGP 7.X doesn't show the key generation progress properly any more
// if kPGPFlags_ForceLocalExecution is omitted as library initialization flag;
// but if enabled PGP 7.X returns a "file locked" error when accessing keyring
// files while either PGPnet or PGPkeys are running simultaneously;
// it's now up to you to decide which one is more important ...

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the "Borland Delphi Runtime Library PGPsdk" released 10 Apr }
{ 2000, available at http://www.oz.net/~srheller/dpgp/sdk/.                        }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpBase.pas based on pgpBase.h from the PGP sources         }
{ which are Copyright (C) Network Associates Inc. and affiliated companies.        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{**********************************************************************************}

interface

uses
  Windows,
  ShellApi,
  Messages,
  SysUtils;

const	// added by idw
  UTF8Ver	= $1400;
  UTF8Lib	= 'UTF8Sec.dll';
  PathPGP	= '\PGP Corporation\PGP';
  PathNAI	= '\Network Associates\PGP';
  ErrorTitle	= 'PGP Components fatal error:';
  SDKError	= 'PGP Software Development Kit Core Library not found';
  SDKNLError	= 'PGP Software Development Kit Networking Library not found';
  SDKUIError	= 'PGP Software Development Kit User Interface Library not found';
  CLError	= 'PGP Client Library not found';
  SCError	= 'PGP Cryptographic Support Library not found';
  UTF8Error	= 'Cannot load Secure UTF8 Conversion Library';
  SDKInitError	= 'Cannot initialize PGP SDK (e.g. PGP(sdk)Serv.exe)';
  VersionError	= 'Wrong PGP version: 6.5.x, 7.x, 8.x or 9.x required';

type	// added by idw
  TPGPInitErrorCode = (ieNone, ieSDK, ieSDKNL, ieSDKUI, ieCL, ieSC, ieUTF8, ieSDKInit, ieVersion);

const	// added by idw
  PGPInitErrorCode: TPGPInitErrorCode = ieNone;
  PGP9X: Longbool = false;
  PGP81: Longbool = false;
  PGP8X: Longbool = false;
  PGP7X: Longbool = false;
  PGPPath: String = '';
  PGPVersion: String = '';
  UTF8Version: String = '';
  PGPsdkLib: PChar = nil;
  PGPsdkNLLib: PChar = nil;
  PGPsdkUILib: PChar = nil;
  PGPclLib: PChar = nil;
  PGPscLib: PChar = nil;
  hPGPsdkLib: Longint = 0;
  hPGPsdkNLLib: Longint = 0;
  hPGPsdkUILib: Longint = 0;
  hPGPclLib: Longint = 0;
  hPGPscLib: Longint = 0;
  hUTF8Lib: Longint = 0;
  InitFlags: Longint = 0;

type
  PGPBoolean	  = Byte;			// can be TRUE (1) or FALSE (0)
  PGPInt8	  = Byte;
  PGPUInt8	  = Byte;
  PGPInt16	  = Smallint;
  PGPUInt16	  = Word;
  PGPInt32	  = Longint;
  PGPUInt32	  = DWord;			// changed from Cardinal to DWord by idw
  PGPByte	  = PGPUInt8;
  PGPError	  = PGPInt32;
  PGPEnumType	  = Longint;			// added by idw
  PGPUserValue	  = Pointer;
  PGPSize	  = PGPUInt32;
  PGPFlags	  = PGPUInt32;
  PGPFileOffset	  = PGPInt32;
  PGPTime	  = PGPUInt32;
  PGPTimeInterval = PGPUInt32;			// in milliseconds

  pPChar	  = ^PChar;			// for those weird char** variables

  TPGPVersion = Record
    MajorVersion: PGPUInt16;
    MinorVersion: PGPUInt16;
  end;

  TVersionString = Array[0..255] of Char;	// added by idw

const
  PGPFalse  = 0;
  PGPTrue   = 1;

const	// 7.X & later
  kPGPFlags_ForceLocalExecution	= $02;
  kPGPFlags_SuppressCacheThread	= $04;

var	// added by idw
  MyVersion: TVersionString;

var	// added by idw from pgpUtilities.h
  PGPsdkInit: function(Options: PGPFlags): PGPError; cdecl;		// Options is ignored prior to 7.X
  PGPsdkCleanup: function: PGPError; cdecl;
  PGPsdkReconnect: function: PGPError; cdecl;

var
  // 6.5.X: PGPGetSDKVersion from pgpFeatures.h; 7.X & later: PGPGetPGPsdkVersion from pgpUtilities.h
  PGPGetSDKVersion: function(var Version: PGPUInt32): PGPUInt32; cdecl;	// 7.X & later return version as result
  // 6.5.X: PGPGetSDKString from pgpFeatures.h; 7.X & later: PGPGetPGPsdkVersionString from pgpUtilities.h
  PGPGetSDKString: function(const TheString: TVersionString): PGPError; cdecl;
  // from pgpErrors.h
  PGPGetErrorString: function(TheErrorCode: PGPError; AvailLength: PGPSize; TheErrorText: PChar): PGPError; cdecl;

function StartPGPsdkServ: Longbool;				// added by idw
function PGP65X: Boolean;					// added by idw
procedure ProcessMessages;					// added by idw

implementation	// code added by idw

const
  SC_MANAGER_CONNECT		= $0001;
  SC_MANAGER_CREATE_SERVICE	= $0002;
  SC_MANAGER_ENUMERATE_SERVICE	= $0004;
  SC_MANAGER_LOCK		= $0008;
  SC_MANAGER_QUERY_LOCK_STATUS	= $0010;
  SC_MANAGER_MODIFY_BOOT_CONFIG	= $0020;

  SERVICE_QUERY_CONFIG		= $0001;
  SERVICE_CHANGE_CONFIG		= $0002;
  SERVICE_QUERY_STATUS		= $0004;
  SERVICE_ENUMERATE_DEPENDENTS	= $0008;
  SERVICE_START			= $0010;
  SERVICE_STOP			= $0020;
  SERVICE_PAUSE_CONTINUE	= $0040;
  SERVICE_INTERROGATE		= $0080;
  SERVICE_USER_DEFINED_CONTROL	= $0100;

  SERVICE_STOPPED		= $00000001;
  SERVICE_START_PENDING		= $00000002;
  SERVICE_STOP_PENDING		= $00000003;
  SERVICE_RUNNING		= $00000004;
  SERVICE_CONTINUE_PENDING	= $00000005;
  SERVICE_PAUSE_PENDING		= $00000006;
  SERVICE_PAUSED		= $00000007;

type
  SC_HANDLE = THandle;
  PServiceStatus = ^TServiceStatus;
  TServiceStatus = Record
    dwServiceType: DWORD;
    dwCurrentState: DWORD;
    dwControlsAccepted: DWORD;
    dwWin32ExitCode: DWORD;
    dwServiceSpecificExitCode: DWORD;
    dwCheckPoint: DWORD;
    dwWaitHint: DWORD;
  end;

var
  hAdvapi32: THandle;
  OpenSCManager: function(lpMachineName, lpDatabaseName: PChar; dwDesiredAccess: DWORD): SC_HANDLE; stdcall;
  OpenService: function(hSCManager: SC_HANDLE; lpServiceName: PChar; dwDesiredAccess: DWORD): SC_HANDLE; stdcall;
  StartService: function(hService: SC_HANDLE; dwNumServiceArgs: DWORD; var lpServiceArgVectors: PChar): BOOL; stdcall;
  QueryServiceStatus: function(hService: SC_HANDLE; var lpServiceStatus: TServiceStatus): BOOL; stdcall;
  CloseServiceHandle: function(hSCObject: SC_HANDLE): BOOL; stdcall;

function LoadServiceApiFunctions: Longbool;
begin
  Result := false;
  hAdvapi32 := GetModuleHandle('advapi32.dll');
  if hAdvapi32 <> 0 then begin
    OpenSCManager := GetProcAddress(hAdvapi32, 'OpenSCManagerA');
    OpenService := GetProcAddress(hAdvapi32, 'OpenServiceA');
    StartService := GetProcAddress(hAdvapi32, 'StartServiceA');
    QueryServiceStatus := GetProcAddress(hAdvapi32, 'QueryServiceStatus');
    CloseServiceHandle := GetProcAddress(hAdvapi32, 'CloseServiceHandle');
    Result := Assigned(OpenSCManager);
  end;
end;

function StartPGPsdkServ: Longbool;
var
  viOS: TOSVersionInfo;
  hSCManager: THandle;
  hService: THandle;
  ssBuffer: TServiceStatus;
  savBuffer: PChar;
  dwWaitTime: DWord;
  dwStartTickCount: DWord;
begin
  Result := false;
  viOS.dwOSVersionInfoSize := SizeOf(TOSVersionInfo);
  if GetVersionEx(viOS) and (viOS.dwPlatformId = VER_PLATFORM_WIN32_NT) and LoadServiceApiFunctions then begin
    // WinNT, Win2K, WinXP
    hSCManager := OpenSCManager(nil, nil, GENERIC_EXECUTE);
    if hSCManager <> 0 then begin
      try
	hService := OpenService(hSCManager, 'PGPSERV', SERVICE_QUERY_STATUS or SERVICE_START); // PGP 8.1x & 9.0x
	if hService = 0 then OpenService(hSCManager, 'PGPSDKSERV', SERVICE_QUERY_STATUS or SERVICE_START); // PGP 8.0x
	if hService <> 0 then begin
	  try
	    if not QueryServiceStatus(hService, ssBuffer) or (ssBuffer.dwCurrentState <> SERVICE_RUNNING) then begin
	      savBuffer := nil;
	      if StartService(hService, 0, savBuffer) then begin
		dwStartTickCount := 0;
		repeat
		  if QueryServiceStatus(hService, ssBuffer) then with ssBuffer do begin
		    if dwStartTickCount = 0 then dwStartTickCount := GetTickCount;
		    dwWaitTime := dwWaitHint div 10;
		    Sleep(dwWaitTime);
		  end
		  else Exit;
		until (ssBuffer.dwCurrentState = SERVICE_RUNNING)
		or ((GetTickCount - dwStartTickCount) > ssBuffer.dwWaitHint);
		Result := (ssBuffer.dwCurrentState = SERVICE_RUNNING);
	      end;
	    end;
	  finally
	    CloseServiceHandle(hService);
	  end;
	end;
      finally
	CloseServiceHandle(hSCManager);
      end;
    end;
  end
  else begin
    // Win95, Win98, WinME
    Result := (ShellExecute(0, nil, 'PGPSERV.EXE', nil, nil, SW_SHOWDEFAULT) > 32); // PGP 8.1x & 9.0x
    if not Result then Result := (ShellExecute(0, nil, 'PGPSDKSERV.EXE', nil, nil, SW_SHOWDEFAULT) > 32); // PGP 8.0x
  end;
  ProcessMessages;
  Sleep(0);
end;

function PGP65X: Boolean;
var
  Version: PGPUInt32;
begin // Version evaluation see unit pgpUtilities.h
  PGP9X := (PGPGetSDKVersion(Version) >= $03050000);
  PGP81 := (PGPGetSDKVersion(Version) >= $03020000);
  PGP8X := (PGPGetSDKVersion(Version) >= $03000000);
  PGP7X := (PGPGetSDKVersion(Version) >= $02000000);
  Result := not PGP7X and (Version >= $03002000);
end; // PGP7X etc. include later versions for our purposes

procedure ProcessMessages;
var
  Msg: TMsg;
begin
  while PeekMessage(Msg, 0, 0, 0, PM_REMOVE) and (Msg.Message <> WM_QUIT) do begin
    TranslateMessage(Msg);
    DispatchMessage(Msg);
  end;
end;

function PGPInitError(ErrorCode: TPGPInitErrorCode): Longbool;
{$IFNDEF SILENT_FAILURE}
var
  ErrorMsg: String;
{$ENDIF}
begin
  PGPInitErrorCode := ErrorCode;
  {$IFNDEF SILENT_FAILURE}
  ErrorMsg := '';
  case ErrorCode of
    ieSDK:	ErrorMsg := SDKError;
    ieSDKNL:	ErrorMsg := SDKNLError;
    ieSDKUI:	ErrorMsg := SDKUIError;
    ieCL:	ErrorMsg := CLError;
    ieSC:	ErrorMsg := SCError;
    ieUTF8:	ErrorMsg := UTF8Error + UTF8Version;
    ieSDKInit:	ErrorMsg := SDKInitError;
    ieVersion:	ErrorMsg := VersionError;
  end;
  MessageBox(0, PChar(ErrorMsg), ErrorTitle, MB_ICONERROR);
  //Halt(ERROR_DLL_INIT_FAILED);
  {$ENDIF}
  Result := true;
end;

function GetPGPPath(const RegEntry: String): String;
var
  hRegKey: HKey;
  dwValSize: DWord;
begin
  dwValSize := succ(MAX_PATH);
  SetLength(Result, MAX_PATH);
  if RegOpenKeyEx(HKEY_LOCAL_MACHINE, PChar(RegEntry), 0, KEY_QUERY_VALUE, hRegKey) = ERROR_SUCCESS then begin
    try
      if RegQueryValueEx(hRegKey, 'InstallPath', nil, nil, @Result[1], @dwValSize) = ERROR_SUCCESS then begin
	Delete(Result, dwValSize, MAXINT);
	Exit;
      end;
    finally
      RegCloseKey(hRegKey);
    end;
  end;
  Result := '';
end;

function GetPGPVersion: String;
var
  hInfo: THandle;
  dwSize: DWord;
  sInfo: String;
  dwFFSize: UINT;
  pFFInfo: Pointer;
begin
  Result := '';
  dwSize := succ(GetFileVersionInfoSize(PGPclLib, hInfo));
  if dwSize > 1 then begin
    SetLength(sInfo, dwSize);
    if GetFileVersionInfo(PGPclLib, hInfo, dwSize, PChar(sInfo)) then begin
      if VerQueryValue(PChar(sInfo), '\', pFFInfo, dwFFSize) and (dwFFSize <> 0) then begin
	with PVSFixedFileInfo(pFFInfo)^ do begin
	  Result := Format('%x.%x.%x', [dwProductVersionMS shr 16, dwProductVersionMS and $FFFF, dwProductVersionLS shr 16]);
	end;
      end;
    end;
  end;
end;

function LastUTF8Version: Longbool;
var
  hInfo: THandle;
  dwSize: DWord;
  sInfo: String;
  dwFFSize: UINT;
  pFFInfo: Pointer;
begin
  Result := false;
  dwSize := succ(GetFileVersionInfoSize(UTF8Lib, hInfo));
  if dwSize > 1 then begin
    SetLength(sInfo, dwSize);
    if GetFileVersionInfo(UTF8Lib, hInfo, dwSize, PChar(sInfo)) then begin
      if VerQueryValue(PChar(sInfo), '\', pFFInfo, dwFFSize) and (dwFFSize <> 0) then begin
	with PVSFixedFileInfo(pFFInfo)^ do begin
	  Result := (dwProductVersionMS shr 16) shl 12 + (dwProductVersionMS and $FFFF) shl 8 +
		    (dwProductVersionLS shr 16) shl 4 + (dwProductVersionLS and $FFFF) >= UTF8Ver;
	  UTF8Version := Format(': version %x.%x.%x.%x required', [UTF8Ver and $F000 shr 12, UTF8Ver and $0F00 shr 8,
				UTF8Ver and $00F0 shr 4, UTF8Ver and $000F]);
	end;
      end;
    end;
  end;
end;

function IsUTF8Lib: Longbool;
var
  sModule: String;
begin
  Result := false;
  SetLength(sModule, MAX_PATH);
  Delete(sModule, succ(GetModuleFileName(hInstance, Pointer(sModule), MAX_PATH)), MAXINT);
  if CompareText(ExtractFileName(sModule), UTF8Lib) = 0 then Result := true;
end;

initialization

  // Load Software Development Kit Core Library
  PGPsdkLib := 'PGPSDK.dll';		// 5.X, 7.X & later
  hPGPsdkLib := LoadLibrary(PGPsdkLib);
  if hPGPsdkLib = 0 then begin
    PGPsdkLib := 'PGP_SDK.dll';		// 6.X
    hPGPsdkLib := LoadLibrary(PGPsdkLib);
  end;
  if (hPGPsdkLib = 0) and PGPInitError(ieSDK) then Exit;

  {$IFDEF FORCE_LOCAL_EXEC}
  InitFlags := kPGPFlags_ForceLocalExecution;
  {$ENDIF}

  // Check SDK Version
  PGPsdkInit := GetProcAddress(hPGPsdkLib, 'PGPsdkInit');
  PGPsdkCleanup := GetProcAddress(hPGPsdkLib, 'PGPsdkCleanup');
  PGPGetSDKVersion := GetProcAddress(hPGPsdkLib, 'PGPGetSDKVersion');						// 5.X & 6.X
  if not Assigned(PGPGetSDKVersion) then PGPGetSDKVersion := GetProcAddress(hPGPsdkLib, 'PGPGetPGPsdkVersion');	// 7.X & later
  if (PGPsdkInit(InitFlags) <> 0) and PGPInitError(ieSDKInit) then Exit;
  if not (PGP65X or PGP7X) and PGPInitError(ieVersion) then Exit;

  // For checking PGPsdkService status
  if PGP7X then PGPsdkReconnect := GetProcAddress(hPGPsdkLib, 'PGPsdkReconnect');

  // Get SDK Version String
  if PGP7X then
    PGPGetSDKString := GetProcAddress(hPGPsdkLib, 'PGPGetPGPsdkVersionString')
  else PGPGetSDKString := GetProcAddress(hPGPsdkLib, 'PGPGetSDKString');
  if PGPGetSDKString(MyVersion) <> 0 then MyVersion := 'N/A';

  PGPGetErrorString := GetProcAddress(hPGPsdkLib, 'PGPGetErrorString');

  // Load Software Development Kit Networking Library
  PGPsdkNLLib := 'PGPsdkNL.dll';
  hPGPsdkNLLib := LoadLibrary(PGPsdkNLLib);
  if (hPGPsdkNLLib = 0) and PGPInitError(ieSDKNL) then Exit;

  // Load Software Development Kit User Interface Library
  PGPsdkUILib := 'PGPsdkUI.dll';
  hPGPsdkUILib := LoadLibrary(PGPsdkUILib);
  if (hPGPsdkUILib = 0) and PGPInitError(ieSDKUI) then Exit;

  // Load Client Library
  if not (PGP65X or PGP9X) then begin
    PGPclLib := 'PGPclientLib.dll';	// 7.X, 8.X
    hPGPclLib := LoadLibrary(PGPclLib);
  end
  else begin
    PGPclLib := 'PGPcl.dll';		// 6.X, 9.X
    hPGPclLib := LoadLibrary(PGPclLib);
  end;
  if (hPGPclLib = 0) and PGPInitError(ieCL) then Exit;

  // Load Cryptographic Support Library
  PGPscLib := 'PGPsc.dll';
  hPGPscLib := LoadLibrary(PGPscLib);
  if (hPGPscLib = 0) and PGPInitError(ieSC) then Exit;

  // Prior to Delphi 6 load UTF8 Conversion Library
  {$IFNDEF CONDITIONALEXPRESSIONS}
  SetLastError(0);
  if not IsUTF8Lib then begin
    hUTF8Lib := LoadLibrary(UTF8Lib);
    if ((hUTF8Lib = 0) or (GetLastError <> 0) or (not LastUTF8Version)) and PGPInitError(ieUTF8) then Exit;
  end;
  {$ENDIF}

  // Get PGP's Home Directory
  if PGP8X then
    PGPPath := GetPGPPath('Software' + PathPGP)
  else PGPPath := GetPGPPath('Software' + PathNAI);

  // Get PGP Version String
  PGPVersion := GetPGPVersion;

finalization

  if Assigned(PGPsdkCleanup) then PGPsdkCleanup;

  if hUTF8Lib <> 0 then FreeLibrary(hUTF8Lib);
  if hPGPscLib <> 0 then FreeLibrary(hPGPscLib);
  if hPGPclLib <> 0 then FreeLibrary(hPGPclLib);
  if hPGPsdkUILib <> 0 then FreeLibrary(hPGPsdkUILib);
  if hPGPsdkNLLib <> 0 then FreeLibrary(hPGPsdkNLLib);
  if hPGPsdkLib <> 0 then FreeLibrary(hPGPsdkLib);

end.

