{$J+,Z4}
unit X509Types;
{$IFDEF CONDITIONALEXPRESSIONS} {$DEFINE FIXED} {$ENDIF} // Delphi 6 and later

{------------------------------------------------------------------------------}
{                                                                              }
{                 This unit is partly based on Steve Heller's                  }
{         SPGP sources available from http://www.oz.net/~srheller/spgp/        }
{                                                                              }
{                Portions created by Michael in der Wiesche are                }
{              Copyright (C) 2004-2006 by Michael in der Wiesche               }
{                                                                              }
{------------------------------------------------------------------------------}

interface

uses
  Windows,
  Classes,
  KeyPropTypes,
  pgpOptionList;

const // from pgpX509Keys.c
  MAX_509_CERT_SIZE			= $10000;
  // returned by VerifyX509CertificateChain
  k509Error_NeededCertNotAvailable	= -10;
  k509Error_SelfSignedCert		= -20;
  k509Error_InvalidCertificateSignature	= -30;
  k509Error_InvalidCertificateFormat	= -40;
  // certificate delimiters
  X509Cert_Beg = '-----BEGIN CERTIFICATE-----';
  X509Cert_End = '-----END CERTIFICATE-----';

type
  TX509CertProp = (
    CertProp_CertSerialNumber,
    CertProp_IssuerKeyAlgorithm,
    CertProp_IssuerHashAlgorithm,
    CertProp_IssuerLongName,
    CertProp_IssuerSerialNumber,
    CertProp_OwnerHexID,
    CertProp_OwnerUserID,
    CertProp_OwnerLongName,
    CertProp_OwnerSerialNumber,
    CertProp_CreaTimeStr,
    CertProp_ExpTimeStr,
    CertProp_CreaTimeNum,
    CertProp_ExpTimeNum,
    CertProp_Verified,
    CertProp_Corrupt,
    CertProp_Revoked,
    CertProp_Expired,
    CertProp_Root
  );
  TX509CertProps = Set of TX509CertProp;
  // Verisign's EmbedEmail excluded
  TX509CertAttrArray = Array[kPGPAVAttributeFirstPointer..kPGPAVAttributeLastPointer] of TPGPAttributeValue;
  // Verisign attributes excluded
  TX509CertAttributes = Record
    CommonName				: String;
    Email				: String;
    OrganizationName			: String;
    OrganizationalUnitName		: String;
    SurName				: String;
    SerialNumber			: String;
    Country				: String;
    Locality				: String;
    State				: String;
    StreetAddress			: String;
    Title				: String;
    Description				: String;
    PostalCode				: String;
    POBOX				: String;
    PhysicalDeliveryOfficeName		: String;
    TelephoneNumber			: String;
    X121Address				: String;
    ISDN				: String;
    DestinationIndicator		: String;
    Name				: String;
    GivenName				: String;
    Initials				: String;
    HouseIdentifier			: String;
    DirectoryManagementDomain		: String;
    DomainComponent			: String;
    UnstructuredName			: String;
    UnstructuredAddress			: String;
    RFC822Name				: String;
    DNSName				: String;
    AnotherName				: String;
    IPAddress				: String;
    CertificateExtension		: String;
  end;
  TX509CertData = Array[0..pred(MAX_509_CERT_SIZE)] of Char;
  pX509CertPropsRec = ^TX509CertPropsRec;
  TX509CertPropsRec = Record
    x509CertificateID			: String;
    x509IssuerKeyAlgorithm		: TKeyAlgorithm;
    x509IssuerHashAlgorithm		: THashAlgorithm;
    x509IssuerLongName			: String;
    x509IssuerSerialNumber		: String;
    x509OwnerKeyHexID			: String;
    x509OwnerCertUserID			: String;
    x509OwnerLongName			: String;
    x509OwnerSerialNumber		: String;
    x509CreaTimeStr			: String;
    x509ExpTimeStr			: String;
    x509CreaTimeNum			: DWord;
    x509ExpTimeNum			: DWord;
    x509IsVerified			: Longbool;
    x509IsCorrupt			: Longbool;
    x509IsRevoked			: Longbool;
    x509IsExpired			: Longbool;
    x509IsRoot				: Longbool;
  end;

  pX509CertPropsList = ^TX509CertPropsList;
  TX509CertPropsList = class(TStringList)
  private
    FDuplicates: Longbool;
    function	AllocX509CertPropsRec: pX509CertPropsRec;
    function	GetX509CertProps(Index: Longint): TX509CertPropsRec;
    function	FreeX509CertPropsRec(Index: Longint): pX509CertPropsRec;
  public
    constructor	Create;
    destructor	Destroy; override;
    procedure	Clear; override;
    procedure 	Changed; override;
    procedure 	Changing; override;
    procedure	Delete(Index: Integer); override;
    procedure	Move(CurIndex, NewIndex: Integer); override;
    function	Add(const S: String): Integer; override;
    function	AddObject(const S: String; AObject: TObject): Integer; override;
    procedure	Insert(Index: Integer; const S: String); override;
    // returns true if requested record item exists
    function	GetCertPropsRec(var CertPropsRec: TX509CertPropsRec; Index: Integer): Longbool;
    // access indexed KeyProps record like Strings[] or Objects[]
    property	X509CertProps[Index: Longint]: TX509CertPropsRec read GetX509CertProps;
    // just a dummy to prevent using the inherited property
    property	Duplicates: Longbool read FDuplicates;
  end;

implementation

function TX509CertPropsList.AllocX509CertPropsRec: pX509CertPropsRec;
begin
  New(Result);
  if Result <> nil then FillChar(Result^, SizeOf(TX509CertPropsRec), 0);
end;

function TX509CertPropsList.FreeX509CertPropsRec(Index: Longint): pX509CertPropsRec;
begin
  Result := pX509CertPropsRec(Objects[Index]);
  if Result <> nil then Result := nil;
end;

function TX509CertPropsList.GetX509CertProps(Index: Longint): TX509CertPropsRec;
begin
  Result := pX509CertPropsRec(Objects[Index])^;
end;

constructor TX509CertPropsList.Create;
begin
  inherited Create;
  BeginUpdate;
  inherited Duplicates := dupAccept;
end;

destructor TX509CertPropsList.Destroy;
var Index: Integer;
begin
  try
    for Index := 0 to pred(Count) do FreeX509CertPropsRec(Index);
  finally
    inherited Destroy;
  end;
end;

procedure TX509CertPropsList.Clear;
var Index: Integer;
begin
  try
    for Index := 0 to pred(Count) do FreeX509CertPropsRec(Index);
  finally
    inherited Clear;
  end;
end;

procedure TX509CertPropsList.Changed;
begin
  // save clock cycles
end;

procedure TX509CertPropsList.Changing;
begin
  // save clock cycles
end;

procedure TX509CertPropsList.Delete(Index: Integer);
begin
  FreeX509CertPropsRec(Index);
  inherited Delete(Index);
end;

procedure TX509CertPropsList.Move(CurIndex, NewIndex: Integer);
var TempStr: String; TempObj: TObject;
begin
  if CurIndex <> NewIndex then begin
    TempStr := Strings[CurIndex];
    TempObj := Objects[CurIndex];
    inherited Delete(CurIndex);
    InsertObject(NewIndex, TempStr, TempObj);
  end;
end;

function TX509CertPropsList.Add(const S: String): Integer;
begin
  {$IFDEF FIXED}
  Result := inherited AddObject(S, TObject(AllocX509CertPropsRec));
  {$ELSE}
  if not (Sorted and (inherited Duplicates = dupIgnore) and Find(S, Result)) then begin
    Result := inherited Add(S);
    Objects[Result] := TObject(AllocX509CertPropsRec);
  end;
  {$ENDIF}
end;

function TX509CertPropsList.AddObject(const S: String; AObject: TObject): Integer;
begin
  Result := -1;
end;

procedure TX509CertPropsList.Insert(Index: Integer; const S: String);
begin
  inherited Insert(Index, S);
  Objects[Index] := TObject(AllocX509CertPropsRec);
end;

function TX509CertPropsList.GetCertPropsRec(var CertPropsRec: TX509CertPropsRec; Index: Integer): Longbool;
begin
  Result := false;
  if (Index < Count) and (Objects[Index] <> nil) then begin
    CertPropsRec := pX509CertPropsRec(Objects[Index])^;
    Result := true;
  end;
end;

end.

