{$J+,Z4}
unit StrTools;

{------------------------------------------------------------------------------}
{                                                                              }
{                                 This code is                                 }
{              Copyright (C) 2005-2006 by Michael in der Wiesche               }
{                                                                              }
{------------------------------------------------------------------------------}

interface

const
  E = '';
  SP = ' ';
  CR = #13;
  LF = #10;
  AM = '&';
  AT = '@';
  QU = '"';
  EQ = '=';
  BS = '\';
  SL = '/';
  GT = '>';
  LT = '<';
  LB = '(';
  RB = ')';
  CL = ':';
  CM = ',';
  SC = ';';
  TAB = #9;
  DOT = '.';
  CRLF = CR + LF;
  PARA = CRLF + CRLF;

function GetCharCount(Find: Char; const sText: String): Integer;

function ExtractStr(var Source: String; Pos, Len: Integer): String;

function FastStrPos(const Find, Dest: String; Pos: Integer): Boolean;
function ShortStrPos(const Find, Dest: String; Pos: Integer): Integer;

function FastLoStrPos(const Find, Dest: String; Pos: Integer): Boolean;
function ShortLoStrPos(const Find, Dest: String; Pos: Integer): Integer;

function FirstStrPos(const Find, Dest: String): Integer;
function LastStrPos(const Find, Dest: String): Integer;

function FirstLoStrPos(const Find, Dest: String): Integer;
function LastLoStrPos(const Find, Dest: String): Integer;

function FirstPos(Find: Char; const Dest: String): Integer;
function LastPos(Find: Char; const Dest: String): Integer;

function FirstShortPos(Find: Char; const Dest: String; Pos: Integer): Integer;
function LastShortPos(Find: Char; const Dest: String; Pos: Integer): Integer;

procedure XChgChars(var Str: String; Old, New: Char);

implementation

function GetCharCount(Find: Char; const sText: String): Integer; register; assembler;
asm	// EAX = Find, EDX = @sText
  OR	EDX,EDX
  JE	@EXIT
  PUSH	EBX
  MOV	ECX,[EDX - 04h]
  XOR	EBX,EBX
  @LOOP:
  DEC	ECX
  JL	@END
  CMP	AL,[EDX + ECX]
  JNE	@LOOP
  INC	EBX
  JMP	@LOOP
  @END:
  MOV	EAX,EBX
  POP	EBX
  RET
  @EXIT:
  XOR	EAX,EAX
end;

function ExtractStr(var Source: String; Pos, Len: Integer): String; register; assembler;
asm	// EAX = @pSource, EDX = Pos, ECX = Len, [EBP + 08h] = @Result
  PUSH	EBX
  PUSH	EDI
  PUSH	ESI
  MOV	EBX,EAX
  MOV	EDI,EDX
  MOV	ESI,ECX
  MOV	EAX,[EBP + 08h]
  CALL	SYSTEM.@LSTRCLR
  OR	DWORD PTR [EBX],0
  JE	@EXIT
  OR	EDI,EDI
  JLE	@EXIT
  OR	ESI,ESI
  JLE	@EXIT
  MOV	EAX,[EBX]
  CMP	[EAX - 04h],EDI
  JL	@EXIT
  DEC	EDI
  MOV	EAX,[EAX - 04h]
  SUB	EAX,EDI
  CMP	EAX,ESI
  JLE	@ALLOC
  MOV	EAX,ESI
  @ALLOC:
  CALL	SYSTEM.@NEWANSISTRING
  MOV	EDX,[EBP + 08h]
  MOV	[EDX],EAX
  MOV	ECX,[EAX - 04h]
  MOV	EBP,[EBX]
  MOV	ESI,ECX
  ADD	EBP,EDI
  TEST	ECX,03h
  JE	@FASTCOPY
  @COPY:
  DEC	ECX
  MOV	DL,[EBP + ECX]
  MOV	[EAX + ECX],DL
  TEST	ECX,03h
  JE	@STOPCOPY
  DEC	ECX
  MOV	DL,[EBP + ECX]
  MOV	[EAX + ECX],DL
  TEST	ECX,03h
  JE	@STOPCOPY
  DEC	ECX
  MOV	DL,[EBP + ECX]
  MOV	[EAX + ECX],DL
  @STOPCOPY:
  OR	ECX,ECX
  JE	@NOCOPY
  @FASTCOPY:
  SUB	ECX,04h
  MOV	EDX,[EBP + ECX]
  MOV	[EAX + ECX],EDX
  JNE	@FASTCOPY
  @NOCOPY:
  MOV	EAX,[EBX]
  MOV	EDX,EBP
  ADD	EDX,ESI
  SUB	EDX,EAX
  CMP	EDX,[EAX - 04h]
  JNZ	@DELETE
  MOV	EAX,EBX
  CALL	UniqueString
  SUB	[EAX - 04h],ESI
  MOV	BYTE PTR [EAX + EDI],0
  JNZ	@EXIT
  MOV	EAX,EBX
  CALL	SYSTEM.@LSTRCLR
  JMP	@EXIT
  @DELETE:
  MOV	EAX,EBX
  CALL	UniqueString
  SUB	[EAX - 04h],ESI
  MOV	ECX,[EAX - 04h]
  ADD	EAX,EDI
  SUB	ECX,EDI
  MOV	EBP,EAX
  ADD	EAX,ECX
  ADD	EBP,ECX
  ADD	EBP,ESI
  NEG	ECX
  TEST	ECX,03h
  JE	@FASTMOVE
  @MOVE:
  MOV	DL,[EBP + ECX]
  MOV	[EAX + ECX],DL
  INC	ECX
  TEST	ECX,03h
  JE	@STOPMOVE
  MOV	DL,[EBP + ECX]
  MOV	[EAX + ECX],DL
  INC	ECX
  TEST	ECX,03h
  JE	@STOPMOVE
  MOV	DL,[EBP + ECX]
  MOV	[EAX + ECX],DL
  INC	ECX
  @STOPMOVE:
  OR	ECX,ECX
  JE	@NOMOVE
  @FASTMOVE:
  MOV	EDX,[EBP + ECX]
  MOV	[EAX + ECX],EDX
  ADD	ECX,04h
  JLE	@FASTMOVE
  @NOMOVE:
  MOV	BYTE PTR [EAX],0
  @EXIT:
  POP	ESI
  POP	EDI
  POP	EBX
end;

function FastStrPos(const Find, Dest: String; Pos: Integer): Boolean; register; assembler;
asm	// EAX = @Find, EDX = @Dest, ECX = Pos
  OR	EAX,EAX
  JE	@EXIT
  OR	EDX,EDX
  JE	@EXIT
  OR	ECX,ECX
  JLE	@EXIT
  PUSH	EBX
  MOV	EBX,[EDX - 04h]
  SUB	EBX,ECX
  INC	EBX
  CMP	EBX,[EAX - 04h]
  JL	@END
  ADD	EDX,ECX
  MOV	ECX,[EAX - 04h]
  DEC	EDX
  @LOOP:
  DEC	ECX
  JL	@MATCH
  MOV	BL,[EAX + ECX]
  CMP	BL,[EDX + ECX]
  JE	@LOOP
  POP	EBX
  XOR	EAX,EAX
  RET
  @MATCH:
  POP	EBX
  MOV	EAX,true
  RET
  @END:
  POP	EBX
  @EXIT:
  XOR	EAX,EAX
end;

function ShortStrPos(const Find, Dest: String; Pos: Integer): Integer; register; assembler;
asm	// EAX = @Find, EDX = @Dest, ECX = Pos
  OR	EAX,EAX
  JE	@EXIT
  OR	EDX,EDX
  JE	@EXIT
  OR	ECX,ECX
  JLE	@EXIT
  PUSH	EBX
  MOV	EBX,[EAX - 04h]
  SUB	ECX,[EDX - 04h]
  ADD	EBX,ECX
  CMP	EBX,1
  JG	@END
  CMP	DWORD PTR [EAX - 04h],1
  JE	@CHAR
  PUSH	EBP
  PUSH	EDI
  PUSH	ESI
  MOV	EDI,EDX
  MOV	ESI,EAX
  ADD	EDI,[EDX - 04h]
  MOV	AL,[ESI]
  DEC	EDI
  @LOOP:
  CMP	[EDI + ECX],AL
  JE	@MATCH
  INC	ECX
  JNE	@LOOP
  XOR	EAX,EAX
  POP	ESI
  POP	EDI
  POP	EBP
  POP	EBX
  RET
  @MATCH:
  PUSH	EDI
  MOV	EBX,[ESI - 04h]
  MOV	EBP,ESI
  ADD	EDI,EBX
  ADD	EBP,EBX
  ADD	EDI,ECX
  NEG	EBX
  @CMP:
  INC	EBX
  JE	@YES
  MOV	AH,[EDI + EBX]
  CMP	[EBP + EBX],AH
  JE	@CMP
  POP	EDI
  INC	ECX
  JNE	@LOOP
  XOR	EAX,EAX
  POP	ESI
  POP	EDI
  POP	EBP
  POP	EBX
  RET
  @YES:
  ADD	ECX,[EDX - 04h]
  POP	EDI
  MOV	EAX,ECX
  POP	ESI
  POP	EDI
  POP	EBP
  POP	EBX
  RET
  @END:
  POP	EBX
  @EXIT:
  XOR	EAX,EAX
  RET
  @CHAR:
  POP	EBX
  PUSH	EDX
  DEC	ECX
  ADD	EDX,[EDX - 04h]
  MOV	AL,[EAX]
  @@LOOP:
  CMP	[EDX + ECX],AL
  JE	@@MATCH
  INC	ECX
  JNE	@@LOOP
  POP	EDX
  XOR	EAX,EAX
  RET
  @@MATCH:
  INC	ECX
  POP	EDX
  MOV	EAX,ECX
  ADD	EAX,[EDX - 04]
end;

function FastLoStrPos(const Find, Dest: String; Pos: Integer): Boolean; register; assembler;
asm	// EAX = @Find, EDX = @Dest, ECX = Pos
  OR	EAX,EAX
  JE	@EXIT
  OR	EDX,EDX
  JE	@EXIT
  OR	ECX,ECX
  JLE	@EXIT
  PUSH	EBX
  MOV	EBX,[EDX - 04h]
  SUB	EBX,ECX
  INC	EBX
  CMP	EBX,[EAX - 04h]
  JL	@END
  ADD	EDX,ECX
  MOV	ECX,[EAX - 04h]
  DEC	EDX
  @LOOP:
  DEC	ECX
  JL	@MATCH
  MOV	BL,[EDX + ECX]
  XOR	BL,[EAX + ECX]
  AND	BL,0DFh
  JE	@LOOP
  POP	EBX
  XOR	EAX,EAX
  RET
  @MATCH:
  POP	EBX
  MOV	EAX,true
  RET
  @END:
  POP	EBX
  @EXIT:
  XOR	EAX,EAX
end;

function ShortLoStrPos(const Find, Dest: String; Pos: Integer): Integer; register; assembler;
asm	// EAX = @Find, EDX = @Dest, ECX = Pos
  OR	EAX,EAX
  JE	@EXIT
  OR	EDX,EDX
  JE	@EXIT
  OR	ECX,ECX
  JLE	@EXIT
  PUSH	EBX
  MOV	EBX,[EAX - 04h]
  SUB	ECX,[EDX - 04h]
  ADD	EBX,ECX
  CMP	EBX,1
  JG	@END
  CMP	DWORD PTR [EAX - 04h],1
  JE	@CHAR
  PUSH	EBP
  PUSH	EDI
  PUSH	ESI
  MOV	EDI,EDX
  MOV	ESI,EAX
  ADD	EDI,[EDX - 04h]
  MOV	AL,[ESI]
  DEC	EDI
  @LOOP:
  MOV	AH,[EDI + ECX]
  XOR	AH,AL
  AND	AH,0DFh
  JE	@MATCH
  INC	ECX
  JNE	@LOOP
  XOR	EAX,EAX
  POP	ESI
  POP	EDI
  POP	EBP
  POP	EBX
  RET
  @MATCH:
  PUSH	EDI
  MOV	EBX,[ESI - 04h]
  MOV	EBP,ESI
  ADD	EDI,EBX
  ADD	EBP,EBX
  ADD	EDI,ECX
  NEG	EBX
  @CMP:
  INC	EBX
  JE	@YES
  MOV	AH,[EDI + EBX]
  XOR	AH,[EBP + EBX]
  AND	AH,0DFh
  JE	@CMP
  POP	EDI
  INC	ECX
  JNE	@LOOP
  XOR	EAX,EAX
  POP	ESI
  POP	EDI
  POP	EBP
  POP	EBX
  RET
  @YES:
  ADD	ECX,[EDX - 04h]
  POP	EDI
  MOV	EAX,ECX
  POP	ESI
  POP	EDI
  POP	EBP
  POP	EBX
  RET
  @END:
  POP	EBX
  @EXIT:
  XOR	EAX,EAX
  RET
  @CHAR:
  POP	EBX
  PUSH	EDX
  DEC	ECX
  ADD	EDX,[EDX - 04h]
  MOV	AL,[EAX]
  @@LOOP:
  MOV	AH,[EDX + ECX]
  XOR	AH,AL
  AND	AH,0DFh
  JE	@@MATCH
  INC	ECX
  JNE	@@LOOP
  POP	EDX
  XOR	EAX,EAX
  RET
  @@MATCH:
  INC	ECX
  POP	EDX
  MOV	EAX,ECX
  ADD	EAX,[EDX - 04]
end;

function FirstStrPos(const Find, Dest: String): Integer; register; assembler;
asm	// EAX = @Find, EDX = @Dest
  OR	EAX,EAX
  JE	@END
  OR	EDX,EDX
  JE	@END
  CMP	DWORD PTR [EAX - 04h],1
  JE	@CHAR
  MOV	ECX,[EDX - 04h]
  PUSH	EBX
  PUSH	EBP
  PUSH	EDI
  PUSH	ESI
  MOV	EDI,EDX
  MOV	ESI,EAX
  ADD	EDI,ECX
  MOV	AL,[ESI]
  NEG	ECX
  @LOOP:
  CMP	[EDI + ECX],AL
  JE	@MATCH
  ADD	ECX,[ESI - 04h]
  JE	@NOT
  SUB	ECX,[ESI - 04h]
  INC	ECX
  JNE	@LOOP
  @NOT:
  XOR	EAX,EAX
  POP	ESI
  POP	EDI
  POP	EBP
  POP	EBX
  RET
  @MATCH:
  PUSH	EDI
  MOV	EBX,[ESI - 04h]
  MOV	EBP,ESI
  ADD	EDI,EBX
  ADD	EBP,EBX
  ADD	EDI,ECX
  NEG	EBX
  @CMP:
  INC	EBX
  JE	@YES
  MOV	AH,[EDI + EBX]
  CMP	[EBP + EBX],AH
  JE	@CMP
  POP	EDI
  INC	ECX
  JNE	@LOOP
  XOR	EAX,EAX
  POP	ESI
  POP	EDI
  POP	EBP
  POP	EBX
  RET
  @YES:
  ADD	ECX,[EDX - 04h]
  POP	EDI
  MOV	EAX,ECX
  INC	EAX
  POP	ESI
  POP	EDI
  POP	EBP
  POP	EBX
  RET
  @END:
  XOR	EAX,EAX
  RET
  @CHAR:
  PUSH	EDX
  MOV	ECX,[EDX - 04h]
  ADD	EDX,[EDX - 04h]
  NEG	ECX
  MOV	AL,[EAX]
  @@LOOP:
  CMP	[EDX + ECX],AL
  JE	@@MATCH
  INC	ECX
  JNE	@@LOOP
  POP	EDX
  XOR	EAX,EAX
  RET
  @@MATCH:
  INC	ECX
  POP	EDX
  MOV	EAX,ECX
  ADD	EAX,[EDX - 04h]
end;

function LastStrPos(const Find, Dest: String): Integer; register; assembler;
asm	// EAX = @Find, EDX = @Dest
  OR	EAX,EAX
  JE	@END
  OR	EDX,EDX
  JE	@END
  CMP	DWORD PTR [EAX - 04h],1
  JE	@CHAR
  MOV	ECX,[EDX - 04h]
  CMP	ECX,[EAX - 04h]
  JL	@END
  PUSH	EBX
  PUSH	EBP
  PUSH	EDI
  PUSH	ESI
  MOV	ESI,EAX
  MOV	EBX,[EAX - 04h]
  MOV	EDI,EDX
  MOV	AL,[ESI + EBX - 01h]
  @LOOP:
  CMP	[EDI + ECX - 01h],AL
  JE	@MATCH
  DEC	ECX
  CMP	ECX,[ESI - 04h]
  JNL	@LOOP
  XOR	EAX,EAX
  POP	ESI
  POP	EDI
  POP	EBP
  POP	EBX
  RET
  @MATCH:
  PUSH	EDI
  MOV	EBX,[ESI - 04h]
  MOV	EBP,ESI
  ADD	EDI,ECX
  ADD	EBP,EBX
  NEG	EBX
  @CMP:
  INC	EBX
  JE	@YES
  MOV	AH,[EDI + EBX - 01h]
  CMP	[EBP + EBX - 01h],AH
  JE	@CMP
  POP	EDI
  DEC	ECX
  JNE	@LOOP
  XOR	EAX,EAX
  POP	ESI
  POP	EDI
  POP	EBP
  POP	EBX
  RET
  @YES:
  SUB	ECX,[ESI - 04h]
  POP	EDI
  MOV	EAX,ECX
  INC	EAX
  POP	ESI
  POP	EDI
  POP	EBP
  POP	EBX
  RET
  @END:
  XOR	EAX,EAX
  RET
  @CHAR:
  MOV	ECX,[EDX - 04h]
  MOV	AL,[EAX]
  @@LOOP:
  DEC	ECX
  JL	@@EXIT
  CMP	AL,[EDX + ECX]
  JNE	@@LOOP
  MOV	EAX,ECX
  INC	EAX
  RET
  @@EXIT:
  XOR	EAX,EAX
end;

function FirstLoStrPos(const Find, Dest: String): Integer; register; assembler;
asm	// EAX = @Find, EDX = @Dest
  OR	EAX,EAX
  JE	@END
  OR	EDX,EDX
  JE	@END
  CMP	DWORD PTR [EAX - 04h],1
  JE	@CHAR
  MOV	ECX,[EDX - 04h]
  PUSH	EBX
  PUSH	EBP
  PUSH	EDI
  PUSH	ESI
  MOV	EDI,EDX
  MOV	ESI,EAX
  ADD	EDI,ECX
  MOV	AL,[ESI]
  NEG	ECX
  @LOOP:
  MOV	AH,[EDI + ECX]
  XOR	AH,AL
  AND	AH,0DFh
  JE	@MATCH
  ADD	ECX,[ESI - 04h]
  JE	@NOT
  SUB	ECX,[ESI - 04h]
  INC	ECX
  JNE	@LOOP
  @NOT:
  XOR	EAX,EAX
  POP	ESI
  POP	EDI
  POP	EBP
  POP	EBX
  RET
  @MATCH:
  PUSH	EDI
  MOV	EBX,[ESI - 04h]
  MOV	EBP,ESI
  ADD	EDI,EBX
  ADD	EBP,EBX
  ADD	EDI,ECX
  NEG	EBX
  @CMP:
  INC	EBX
  JE	@YES
  MOV	AH,[EDI + EBX]
  XOR	AH,[EBP + EBX]
  AND	AH,0DFh
  JE	@CMP
  POP	EDI
  INC	ECX
  JNE	@LOOP
  XOR	EAX,EAX
  POP	ESI
  POP	EDI
  POP	EBP
  POP	EBX
  RET
  @YES:
  ADD	ECX,[EDX - 04h]
  POP	EDI
  MOV	EAX,ECX
  INC	EAX
  POP	ESI
  POP	EDI
  POP	EBP
  POP	EBX
  RET
  @END:
  XOR	EAX,EAX
  RET
  @CHAR:
  PUSH	EDX
  MOV	ECX,[EDX - 04h]
  ADD	EDX,[EDX - 04h]
  NEG	ECX
  MOV	AL,[EAX]
  @@LOOP:
  MOV	AH,[EDX + ECX]
  XOR	AH,AL
  AND	AH,0DFh
  JE	@@MATCH
  INC	ECX
  JNE	@@LOOP
  POP	EDX
  XOR	EAX,EAX
  RET
  @@MATCH:
  INC	ECX
  POP	EDX
  MOV	EAX,ECX
  ADD	EAX,[EDX - 04h]
end;

function LastLoStrPos(const Find, Dest: String): Integer; register; assembler;
asm	// EAX = @Find, EDX = @Dest
  OR	EAX,EAX
  JE	@END
  OR	EDX,EDX
  JE	@END
  CMP	DWORD PTR [EAX - 04h],1
  JE	@CHAR
  MOV	ECX,[EDX - 04h]
  CMP	ECX,[EAX - 04h]
  JL	@END
  PUSH	EBX
  PUSH	EBP
  PUSH	EDI
  PUSH	ESI
  MOV	ESI,EAX
  MOV	EBX,[EAX - 04h]
  MOV	EDI,EDX
  MOV	AL,[ESI + EBX - 01h]
  @LOOP:
  MOV	AH,[EDI + ECX - 01h]
  XOR	AH,AL
  AND	AH,0DFh
  JE	@MATCH
  DEC	ECX
  CMP	ECX,[ESI - 04h]
  JNL	@LOOP
  XOR	EAX,EAX
  POP	ESI
  POP	EDI
  POP	EBP
  POP	EBX
  RET
  @MATCH:
  PUSH	EDI
  MOV	EBX,[ESI - 04h]
  MOV	EBP,ESI
  ADD	EDI,ECX
  ADD	EBP,EBX
  NEG	EBX
  @CMP:
  INC	EBX
  JE	@YES
  MOV	AH,[EDI + EBX - 01h]
  XOR	AH,[EBP + EBX - 01h]
  AND	AH,0DFh
  JE	@CMP
  POP	EDI
  DEC	ECX
  JNE	@LOOP
  XOR	EAX,EAX
  POP	ESI
  POP	EDI
  POP	EBP
  POP	EBX
  RET
  @YES:
  SUB	ECX,[ESI - 04h]
  POP	EDI
  MOV	EAX,ECX
  INC	EAX
  POP	ESI
  POP	EDI
  POP	EBP
  POP	EBX
  RET
  @END:
  XOR	EAX,EAX
  RET
  @CHAR:
  MOV	ECX,[EDX - 04h]
  MOV	AL,[EAX]
  @@LOOP:
  DEC	ECX
  JL	@@EXIT
  MOV	AH,[EDX + ECX]
  XOR	AH,AL
  AND	AH,0DFh
  JNE	@@LOOP
  MOV	EAX,ECX
  INC	EAX
  RET
  @@EXIT:
  XOR	EAX,EAX
end;

function FirstPos(Find: Char; const Dest: String): Integer; register; assembler;
asm	// EAX = Find, EDX = @Dest
  OR	EDX,EDX
  JE	@EXIT
  PUSH	EDX
  MOV	ECX,[EDX - 04h]
  ADD	EDX,[EDX - 04h]
  NEG	ECX
  @LOOP:
  CMP	[EDX + ECX],AL
  JE	@MATCH
  INC	ECX
  JNE	@LOOP
  POP	EDX
  @EXIT:
  XOR	EAX,EAX
  RET
  @MATCH:
  INC	ECX
  POP	EDX
  MOV	EAX,ECX
  ADD	EAX,[EDX - 04h]
end;

function LastPos(Find: Char; const Dest: String): Integer; register; assembler;
asm	// EAX = Find, EDX = @Dest
  OR	EDX,EDX
  JE	@EXIT
  MOV	ECX,[EDX - 04h]
  @LOOP:
  DEC	ECX
  JL	@EXIT
  CMP	AL,[EDX + ECX]
  JNE	@LOOP
  MOV	EAX,ECX
  INC	EAX
  RET
  @EXIT:
  XOR	EAX,EAX
end;

function FirstShortPos(Find: Char; const Dest: String; Pos: Integer): Integer; register; assembler;
asm	// EAX = Find, EDX = @Dest, ECX = Pos
  OR	EDX,EDX
  JE	@EXIT
  OR	ECX,ECX
  JLE	@EXIT
  SUB	ECX,[EDX - 04h]
  JG	@EXIT
  PUSH	EDX
  DEC	ECX
  ADD	EDX,[EDX - 04h]
  @LOOP:
  CMP	[EDX + ECX],AL
  JE	@MATCH
  INC	ECX
  JNE	@LOOP
  POP	EDX
  @EXIT:
  XOR	EAX,EAX
  RET
  @MATCH:
  INC	ECX
  POP	EDX
  MOV	EAX,ECX
  ADD	EAX,[EDX - 04h]
end;

function LastShortPos(Find: Char; const Dest: String; Pos: Integer): Integer; register; assembler;
asm	// EAX = Find, EDX = @Dest, ECX = Pos
  OR	EDX,EDX
  JE	@EXIT
  CMP	ECX,[EDX - 04h]
  JG	@EXIT
  @LOOP:
  DEC	ECX
  JL	@EXIT
  CMP	AL,[EDX + ECX]
  JNE	@LOOP
  MOV	EAX,ECX
  INC	EAX
  RET
  @EXIT:
  XOR	EAX,EAX
end;

procedure XChgChars(var Str: String; Old, New: Char); register; assembler;
asm	// EAX = @pStr, EDX = Old, ECX = New
  OR	DWORD PTR [EAX],0
  JE	@EXIT
  PUSH	EAX
  PUSH	EDX
  PUSH	ECX
  CALL	UniqueString
  POP	ECX
  POP	EDX
  POP	EAX
  MOV	DH,CL
  MOV	EAX,[EAX]
  MOV	ECX,[EAX - 04h]
  @LOOP:
  DEC	ECX
  JL	@EXIT
  CMP	DL,[EAX + ECX]
  JNE	@LOOP
  MOV	[EAX + ECX],DH
  JMP	@LOOP
  @EXIT:
end;

end.

