{$J+,Z4}
unit pgpSC;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the SPGP 2.5.6.0 sources,                                   }
{ available at http://www.oz.net/~srheller/spgp/.                                  }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpSC.pas based on pgpSC.h from the PGP sources             }
{ which are Copyright (C) Network Associates Inc. and affiliated companies.        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ Some comments and declarations removed, some declarations activated              }
{                                                                                  }
{**********************************************************************************}

interface

uses
  Windows,
  pgpBase,
  pgpPubTypes;


type	// modified by idw
  pPGPsc = pPGPContext;
  pPGPtls = pPGPtlsContext;

type	// modified by idw
  TPath = Array[0..260] of Char;
  pFileList = ^TFileList;
  TFileList = Record
    Name: TPath;
    IsDirectory: Longbool;
    Next: pFileList;
  end;

const	// 7.X & 8.X
  WIPE_DEFAULT		=  0;
  WIPE_DONOTDELETE	=  1;
  WIPE_DONOTWARN	=  2;
  WIPE_DONOTPROGRESS	=  4;
  WIPE_DONOTERROR	=  8;
  WIPE_ADS		= 16;

// Library initialization routines
var InitPGPsc6: function(Parent: Longint; var P: pPGPsc; var TLS: pPGPtls): Longbool; cdecl;
var InitPGPsc7: function(Parent: Longint; var P: pPGPsc; var TLS: pPGPtls; Flags: Integer): Longbool; cdecl;
var UninitPGPsc: function(Parent: Longint; P: pPGPsc; TLS: pPGPtls): Longbool; cdecl;

// Clipboard routines
var EncryptClipboard6: function(Parent: Longint;
    App			: PChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    Encrypt		: Longbool;
    Sign		: Longbool): Longbool; cdecl;
var EncryptClipboard7: function(Parent: Longint;
    App			: PChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    Encrypt		: Longbool;
    Sign		: Longbool;
    StartingCR		: Longbool): Longbool; cdecl;
var DecryptClipboard: function(Parent: Longint;
    App			: PChar;
    P			: pPGPsc;
    TLS			: pPGPtls): Longbool; cdecl;
var AddKeyClipboard: function(Parent: Longint;
    P			: pPGPsc;
    TLS			: pPGPtls): Longbool; cdecl;
var ClipboardWipe: function(Parent: Longint; P: pPGPsc): Longbool; cdecl;

// Filelist routines
var EncryptFileList: function(Parent: Longint;
    App			: PChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    ListHead		: pFileList;
    Encrypt		: Longbool;
    Sign		: Longbool): Longbool; cdecl;
var DecryptFileList: function(Parent: Longint;
    App			: PChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    ListHead		: pFileList): Longbool; cdecl;
var AddKeyFileList: function(Parent: Longint;
    P			: pPGPsc;
    TLS			: pPGPtls;
    ListHead		: pFileList): Longbool; cdecl;
var WipeFileList6: function(Parent: Longint;
    P			: pPGPsc;
    ListHead		: pFileList;
    DelFilePostWipe	: Longbool): Longbool; cdecl;
var WipeFileList7: function(Parent: Longint;
    P			: pPGPsc;
    ListHead		: pFileList;
    dwWipeFlags		: DWord;
    dwPasses		: DWord): Longbool; cdecl;

var HDropToFileList: function(hDrop: Longint): pFileList; cdecl;
var CmdLineToFileList: function(szCmdLine: PChar): pFileList; cdecl;

// Grabs preferences from pref file
var GetValidityDrawPrefs: function(P: pPGPsc; var InputBool: Longbool): Longbool; cdecl;
var GetMarginalInvalidPref: function(P: pPGPsc; var InputBool: Longbool): Longbool; cdecl;
var GetSecureViewerPref: function(P: pPGPsc): Longbool; cdecl;

// Use secure viewer and/or anti-tempest font
var TempestViewer: function(P: pPGPsc;
    Parent		: Longint;
    pInput		: PChar;
    InSize		: Longint;
    Warn		: Longbool): Cardinal; cdecl;

// Launches Keys/Tools
var DoLaunchNet: function(Parent: Longint): Longbool; cdecl;
var DoLaunchKeys: function(Parent: Longint): Longbool; cdecl;
var DoLaunchTools: function(Parent: Longint): Longbool; cdecl;
var DoLaunchDisk: function(Parent: Longint): Longbool; cdecl;

// Sends signature info to PGPlog
var SendPGPlogMsg: function(Parent: Longint; Msg: PChar): Longbool; cdecl;

// Returns path for PGPkeys
var PGPpath: procedure(var Path: TPath); cdecl;

// Wrappers added by idw
function InitPGPsc(Parent: Longint; var P: pPGPsc; var TLS: pPGPtls; Flags: Integer): Longbool;
function EncryptClipboard(Parent: Longint; App: PChar; P: pPGPsc; TLS: pPGPtls;
			  Encrypt,Sign, StartingCR: Longbool): Longbool;
function WipeFileList(Parent: Longint; P: pPGPsc; ListHead: pFileList;
		      dwWipeFlags: DWord; dwPasses: DWord): Longbool;

implementation	// code modified by idw

function InitPGPsc(Parent: Longint; var P: pPGPsc; var TLS: pPGPtls; Flags: Integer): Longbool;
begin
  if PGP7X then
    Result := InitPGPsc7(Parent, P, TLS, Flags)
  else Result := InitPGPsc6(Parent, P, TLS);
end;

function EncryptClipboard(Parent: Longint; App: PChar; P: pPGPsc; TLS: pPGPtls;
			  Encrypt,Sign, StartingCR: Longbool): Longbool;
begin
  if PGP7X then
    Result := EncryptClipboard7(Parent, App, P, TLS, Encrypt, Sign, StartingCR)
  else Result := EncryptClipboard6(Parent, App, P, TLS, Encrypt, Sign);
end;

function WipeFileList(Parent: Longint; P: pPGPsc; ListHead: pFileList;
		      dwWipeFlags: DWord; dwPasses: DWord): Longbool;
begin
  if PGP7X then
    Result := WipeFileList7(Parent, P, ListHead, dwWipeFlags, dwPasses)
  else Result := WipeFileList6(Parent, P, ListHead, (dwWipeFlags and WIPE_DONOTDELETE) = 0);
end;

initialization

  if PGPInitErrorCode = ieNone then begin
    if PGP7X then begin
      InitPGPsc7 := GetProcAddress(hPGPscLib, 'PGPscInit');
      UninitPGPsc := GetProcAddress(hPGPscLib, 'PGPscDestroy');
      EncryptClipboard7 := GetProcAddress(hPGPscLib, 'PGPscEncryptClipboard');
      DecryptClipboard := GetProcAddress(hPGPscLib, 'PGPscDecryptClipboard');
      AddKeyClipboard := GetProcAddress(hPGPscLib, 'PGPscAddKeyClipboard');
      ClipboardWipe := GetProcAddress(hPGPscLib, 'PGPscEraseClipboard');
      EncryptFileList := GetProcAddress(hPGPscLib, 'PGPscEncryptFileList');
      DecryptFileList := GetProcAddress(hPGPscLib, 'PGPscDecryptFileList');
      AddKeyFileList := GetProcAddress(hPGPscLib, 'PGPscAddKeyFileList');
      WipeFileList7 := GetProcAddress(hPGPscLib, 'PGPscWipeFileList');
      HDropToFileList := GetProcAddress(hPGPscLib, 'PGPscHDropToFileList');
      CmdLineToFileList := GetProcAddress(hPGPscLib, 'PGPscCmdLineToFileList');
      GetValidityDrawPrefs := GetProcAddress(hPGPscLib, 'PGPscGetValidityDrawPrefs');
      GetMarginalInvalidPref := GetProcAddress(hPGPscLib, 'PGPscGetMarginalInvalidPref');
      GetSecureViewerPref := GetProcAddress(hPGPscLib, 'PGPscGetSecureViewerPref');
      TempestViewer := GetProcAddress(hPGPscLib, 'PGPscTempestViewer');
      DoLaunchNet := GetProcAddress(hPGPscLib, 'PGPscDoLaunchNet');
      DoLaunchKeys := GetProcAddress(hPGPscLib, 'PGPscDoLaunchKeys');
      DoLaunchTools := GetProcAddress(hPGPscLib, 'PGPscDoLaunchTools');
      DoLaunchDisk := GetProcAddress(hPGPscLib, 'PGPscDoLaunchDisk');
      SendPGPlogMsg := GetProcAddress(hPGPscLib, 'PGPscSendPGPlogMsg');
      PGPpath := GetProcAddress(hPGPscLib, 'PGPscPGPpath');
    end
    else begin
      InitPGPsc6 := GetProcAddress(hPGPscLib, 'InitPGPsc');
      UninitPGPsc := GetProcAddress(hPGPscLib, 'UninitPGPsc');
      EncryptClipboard6 := GetProcAddress(hPGPscLib, 'EncryptClipboard');
      DecryptClipboard := GetProcAddress(hPGPscLib, 'DecryptClipboard');
      AddKeyClipboard := GetProcAddress(hPGPscLib, 'AddKeyClipboard');
      ClipboardWipe := GetProcAddress(hPGPscLib, 'ClipboardWipe');
      EncryptFileList := GetProcAddress(hPGPscLib, 'EncryptFileList');
      DecryptFileList := GetProcAddress(hPGPscLib, 'DecryptFileList');
      AddKeyFileList := GetProcAddress(hPGPscLib, 'AddKeyFileList');
      WipeFileList6 := GetProcAddress(hPGPscLib, 'WipeFileList');
      HDropToFileList := GetProcAddress(hPGPscLib, 'HDropToFileList');
      CmdLineToFileList := GetProcAddress(hPGPscLib, 'CmdLineToFileList');
      GetValidityDrawPrefs := GetProcAddress(hPGPscLib, 'GetValidityDrawPrefs');
      GetMarginalInvalidPref := GetProcAddress(hPGPscLib, 'GetMarginalInvalidPref');
      GetSecureViewerPref := GetProcAddress(hPGPscLib, 'GetSecureViewerPref');
      TempestViewer := GetProcAddress(hPGPscLib, 'TempestViewer');
      DoLaunchNet := GetProcAddress(hPGPscLib, 'DoLaunchNet');
      DoLaunchKeys := GetProcAddress(hPGPscLib, 'DoLaunchKeys');
      DoLaunchTools := GetProcAddress(hPGPscLib, 'DoLaunchTools');
      DoLaunchDisk := GetProcAddress(hPGPscLib, 'DoLaunchDisk');
      SendPGPlogMsg := GetProcAddress(hPGPscLib, 'SendPGPlogMsg');
      PGPpath := GetProcAddress(hPGPscLib, 'PGPpath');
    end;
  end;

end.

