{$J+,Z4}
unit pgpOptionList;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the "Borland Delphi Runtime Library PGPsdk" released 10 Apr }
{ 2000, available at http://www.oz.net/~srheller/dpgp/sdk/.                        }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw"),            }
{ Graham Grieve from Kestral Computing <http://www.kestral.com.au/devtools/pgp/>   }
{                                                                                  }
{ The original file is pgpOptionList.pas based on pgpOptionList.h                  }
{ from the PGP sources which are Copyright (C) Network Associates Inc.             }
{ and affiliated companies.                                                        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ Lots of constants and comments removed, TPGPEventHandlerProcPtr moved to         }
{ pgpEvent.pas, PGPAddJobOptions added and other decalarations removed,            }
{ PGPBuildOptionList and PGPAppendOptionList implementations changed               }
{ according to a suggestion by Steven R. Heller: instead of passing open arrays    }
{ use PGPBuildOptionList and PGPAppendOptionList to create OptionLists and pass    }
{ PGPOLastOption() as a separate function parameter, see comments below            }
{                                                                                  }
{**********************************************************************************}

interface

uses
  pgpBase,
  pgpPubTypes,
  pgpEvents,
  pgpKeys;

type
  PGPExportFormat = PGPEnumType;
const
  kPGPExportFormat_Basic				= 1;
  kPGPExportFormat_Complete				= 255;
  kPGPExportFormat_TokenKeyContainer			= 256;			// PGP 7.X
  kPGPExportFormat_X509Cert				= 10000;

  kPGPExportFormat_X509CertReq				= 11000;
  kPGPExportFormat_NetToolsCAV1_CertReq			= 11001;
  kPGPExportFormat_VerisignV1_CertReq			= 11002;
  kPGPExportFormat_EntrustV1_CertReq			= 11003;
  kPGPExportFormat_NetscapeV1_CertReq			= 11004;		// PGP 7.X
  kPGPExportFormat_MicrosoftV1_CertReq			= 11005;		// PGP 7.X

  kPGPExportFormat_X509GetCertInitial			= 11010;
  kPGPExportFormat_NetToolsCAV1_GetCertInitial		= 11011;
  kPGPExportFormat_VerisignV1_GetCertInitial		= 11012;
  kPGPExportFormat_EntrustV1_GetCertInitial		= 11013;
  kPGPExportFormat_NetscapeV1_GetCertInitial		= 11014;		// PGP 7.X
  kPGPExportFormat_MicrosoftV1_GetCertInitial		= 11015;		// PGP 7.X

  kPGPExportFormat_X509GetCRL				= 11020;
  kPGPExportFormat_NetToolsCAV1_GetCRL			= 11021;
  kPGPExportFormat_VerisignV1_GetCRL			= 11022;
  kPGPExportFormat_EntrustV1_GetCRL			= 11023;
  kPGPExportFormat_NetscapeV1_GetCRL			= 11024;		// PGP 7.X
  kPGPExportFormat_MicrosoftV1_GetCRL			= 11025;		// PGP 7.X

// PGP 7.X
type
  PGPInputFormat = PGPEnumType;
const
  kPGPInputFormat_Unknown				= 0;
  kPGPInputFormat_PGP					= 1;

  kPGPInputFormat_X509DataInPKCS7			= 10000;
  kPGPInputFormat_NetToolsCAV1_DataInPKCS7		= 10001;
  kPGPInputFormat_VerisignV1_DataInPKCS7		= 10002;
  kPGPInputFormat_EntrustV1_DataInPKCS7			= 10003;
  kPGPInputFormat_MicrosoftV1_DataInPKCS7		= 10004;
  kPGPInputFormat_NetscapeV1_DataInPKCS7		= 10005;

  kPGPInputFormat_PEMEncodedX509Cert			= 10006;
  kPGPInputFormat_NetToolsCAV1_PEMEncoded		= 10007;
  kPGPInputFormat_VerisignV1_PEMEncoded			= 10008;
  kPGPInputFormat_EntrustV1_PEMEncoded			= 10009;
  kPGPInputFormat_MicrosoftV1_PEMEncoded		= 10010;
  kPGPInputFormat_NetscapeV1_PEMEncoded			= 10011;

  // Input formats for X.509 private keys
  kPGPInputFormat_PrivateKeyInfo			= 10012;
  kPGPInputFormat_PKCS12				= 10013;

// PGP 7.X
type
  PGPOutputFormat = PGPEnumType;
const
  kPGPOutputFormat_Unknown				= 0;
  kPGPOutputFormat_PGP					= 1;

  kPGPOutputFormat_X509CertReqInPKCS7			= 10000;
  kPGPOutputFormat_NetToolsCAV1_CertReqInPKCS7		= 10001;
  kPGPOutputFormat_VerisignV1_CertReqInPKCS7		= 10002;
  kPGPOutputFormat_EntrustV1_CertReqInPKCS7		= 10003;
  kPGPOutputFormat_NetscapeV1_CertReqInPKCS7		= 10004;
  kPGPOutputFormat_MicrosoftV1_CertReqInPKCS7		= 10005;

  kPGPOutputFormat_X509GetCertInitialInPKCS7		= 10010;
  kPGPOutputFormat_NetToolsCAV1_GetCertInitialInPKCS7	= 10011;
  kPGPOutputFormat_VerisignV1_GetCertInitialInPKCS7	= 10012;
  kPGPOutputFormat_EntrustV1_GetCertInitialInPKCS7	= 10013;
  kPGPOutputFormat_NetscapeV1_GetCertInitialInPKCS7	= 10014;
  kPGPOutputFormat_MicrosoftV1_GetCertInitialInPKCS7	= 10015;

  kPGPOutputFormat_X509GetCRLInPKCS7			= 10020;
  kPGPOutputFormat_NetToolsCAV1_GetCRLInPKCS7		= 10021;
  kPGPOutputFormat_VerisignV1_GetCRLInPKCS7		= 10022;
  kPGPOutputFormat_EntrustV1_GetCRLInPKCS7		= 10023;
  kPGPOutputFormat_NetscapeV1_GetCRLInPKCS7		= 10024;
  kPGPOutputFormat_MicrosoftV1_GetCRLInPKCS7		= 10025;

type
  PGPAVAttribute = PGPEnumType;
const
  // Pointer properties
  kPGPAVAttribute_CommonName				=  0;
  kPGPAVAttribute_Email					=  1;
  kPGPAVAttribute_OrganizationName			=  2;
  kPGPAVAttribute_OrganizationalUnitName		=  3;
  kPGPAVAttribute_SurName				=  4;
  kPGPAVAttribute_SerialNumber				=  5;
  kPGPAVAttribute_Country				=  6;
  kPGPAVAttribute_Locality				=  7;
  kPGPAVAttribute_State					=  8;
  kPGPAVAttribute_StreetAddress				=  9;
  kPGPAVAttribute_Title					= 10;
  kPGPAVAttribute_Description				= 11;
  kPGPAVAttribute_PostalCode				= 12;
  kPGPAVAttribute_POBOX					= 13;
  kPGPAVAttribute_PhysicalDeliveryOfficeName		= 14;
  kPGPAVAttribute_TelephoneNumber			= 15;
  kPGPAVAttribute_X121Address				= 16;
  kPGPAVAttribute_ISDN					= 17;
  kPGPAVAttribute_DestinationIndicator			= 18;
  kPGPAVAttribute_Name					= 19;
  kPGPAVAttribute_GivenName				= 20;
  kPGPAVAttribute_Initials				= 21;
  kPGPAVAttribute_HouseIdentifier			= 22;
  kPGPAVAttribute_DirectoryManagementDomain		= 23;
  kPGPAVAttribute_DomainComponent			= 24;
  kPGPAVAttribute_UnstructuredName			= 25;
  kPGPAVAttribute_UnstructuredAddress			= 26;
  kPGPAVAttribute_RFC822Name				= 27;
  kPGPAVAttribute_DNSName				= 28;
  kPGPAVAttribute_AnotherName				= 29;
  kPGPAVAttribute_IPAddress				= 30;
  kPGPAVAttribute_CertificateExtension			= 31;
  // Verisign specific
  kPGPAVAttribute_Challenge				= 32;
  kPGPAVAttribute_CertType				= 33;
  kPGPAVAttribute_MailFirstName				= 34;
  kPGPAVAttribute_MailMiddleName			= 35;
  kPGPAVAttribute_MailLastName				= 36;
  kPGPAVAttribute_EmployeeID				= 37;
  kPGPAVAttribute_MailStop				= 38;
  kPGPAVAttribute_AdditionalField4			= 39;
  kPGPAVAttribute_AdditionalField5			= 40;
  kPGPAVAttribute_AdditionalField6			= 41;
  kPGPAVAttribute_Authenticate				= 42;

  kPGPAVAttributeFirstPointer 	= kPGPAVAttribute_CommonName;
  kPGPAVAttributeLastPointer 	= kPGPAVAttribute_Authenticate;

  // Boolean properties
  kPGPAVAttributeFirstBoolean				= 1000;
  // Verisign specific
  kPGPAVAttribute_EmbedEmail				= 1001;

  // Numeric (PGPUInt32) properties
  kPGPAVAttributeFirstNumber				= 2000;

type
  PPGPAttributeValue = ^TPGPAttributeValue;
  TPGPAttributeValue = Packed Record
    Attribute: PGPAVAttribute;
    Size: PGPSize;
    Value: Record case Longint of
      1: (BooleanValue: PGPBoolean);
      2: (LongValue: PGPUInt32);
      3: (PointerValue: PChar);
    end;
    Unused: PGPUInt32;
  end;

const
  kPGPMaxTimeInterval					= PGPTime(not 0);	// PGP 7.X

var
  // both
  PGPNewOptionList: function(Context: pPGPContext; var OptionList: pPGPOptionList): PGPError; cdecl;
  PGPCopyOptionList: function(OptionListOrig: pPGPOptionList; var OptionListCopy: pPGPOptionList): PGPError; cdecl;
  PGPFreeOptionList: function(OptionList: pPGPOptionList): PGPError; cdecl;
  PGPAddJobOptions: function(TheJob: pPGPJob; OptionList, LastOption: pPGPOptionList): PGPError; cdecl;

  { Common encode/decode options }
  // both
  PGPOInputBuffer: function(Context: pPGPContext; Buffer: PChar;
			    BufferSize: PGPSize): pPGPOptionList; cdecl;
  PGPOInputFile: function(Context: pPGPContext; FileSpec: pPGPFileSpec): pPGPOptionList; cdecl;
  // PGP 7.X
  PGPOAppendOutput: function(Context: pPGPContext; AppendOutput: PGPBoolean): pPGPOptionList; cdecl;
  // both
  PGPODiscardOutput: function(Context: pPGPContext; DiscardOutput: PGPBoolean): pPGPOptionList; cdecl;
  PGPOAllocatedOutputBuffer: function(Context: pPGPContext; var Buffer: PChar;
				      MaximumBufLength: PGPSize; var ActualBufLength: PGPSize): pPGPOptionList; cdecl;
  PGPOOutputBuffer: function(Context: pPGPContext; Buffer: PChar;
			     BufferSize: PGPSize; var OutputDataLength: PGPSize): pPGPOptionList; cdecl;
  PGPOOutputFile: function(Context: pPGPContext; FileSpec: pPGPFileSpec): pPGPOptionList; cdecl;
  PGPOPGPMIMEEncoding: function(Context: pPGPContext; MimeEncoding: PGPBoolean; var MimeBodyOffset: PGPSize;
				MimeSeparator: pMimeSeparator): pPGPOptionList; cdecl;
  PGPOOmitMIMEVersion: function(Context: pPGPContext; OmitVersion: PGPBoolean): pPGPOptionList; cdecl;
  PGPOLocalEncoding: function(Context: pPGPContext; LocalEncode: TPGPLocalEncodingFlags): pPGPOptionList; cdecl;
  PGPOOutputLineEndType: function(Context: pPGPContext; LineEnd: PGPLineEndType): pPGPOptionList; cdecl;
  PGPODetachedSig: function(Context: pPGPContext; Options: pPGPOptionList;
			    LastOption: pPGPOptionList): pPGPOptionList; cdecl;

  { Common encrypting/signing options }
  // both
  PGPOConventionalEncrypt: function(Context: pPGPContext; Options: pPGPOptionList;
				    LastOption: pPGPOptionList): pPGPOptionList; cdecl;
  // both
  PGPOCipherAlgorithm: function(Context: pPGPContext; Algorithm: PGPCipherAlgorithm): pPGPOptionList; cdecl;
  // PGP 6.5.X
  PGPOEncryptToKey: function(Context: pPGPContext; Key: pPGPKey): pPGPOptionList; cdecl;
  // PGP 7.X
  {PGPOEncryptToKeyDBObj: function(Context: pPGPContext; Key: pPGPKeyDBObj): pPGPOptionList; cdecl;}
  // both
  PGPOEncryptToKeySet: function(Context: pPGPContext; KeySet: pPGPKeySet): pPGPOptionList; cdecl;
  // both
  PGPOHashAlgorithm: function(Context: pPGPContext; Algorithm: PGPHashAlgorithm): pPGPOptionList; cdecl;
  // PGP 6.5.X
  PGPOSignWithKey: function(Context: pPGPContext; Key: pPGPKey; Options: pPGPOptionList;
			    LastOption: pPGPOptionList): pPGPOptionList; cdecl;
  // PGP 7.X
  {PGPOSignWithKey: function(Context: pPGPContext; Key: pPGPKeyDBObj; Options: pPGPOptionList;
			     LastOption: pPGPOptionList): pPGPOptionList; cdecl;}
  // both
  PGPOWarnBelowValidity: function(Context: pPGPContext; MinValidity: PGPValidity): pPGPOptionList; cdecl;
  // both
  PGPOFailBelowValidity: function(Context: pPGPContext; MinValidity: PGPValidity): pPGPOptionList; cdecl;

  { Encode only options }
  // both
  PGPOAskUserForEntropy: function(Context: pPGPContext; AskUserForEntropy: PGPBoolean): pPGPOptionList; cdecl;
  PGPODataIsASCII: function(Context: pPGPContext; DataIsASCII: PGPBoolean): pPGPOptionList; cdecl;
  PGPORawPGPInput: function(Context: pPGPContext; RawPGPInput: PGPBoolean): pPGPOptionList; cdecl;
  PGPOForYourEyesOnly: function(Context: pPGPContext; ForYourEyesOnly: PGPBoolean): pPGPOptionList; cdecl;
  PGPOArmorOutput: function(Context: pPGPContext; ArmorOutput: PGPBoolean): pPGPOptionList; cdecl;
  PGPOFileNameString: function(Context: pPGPContext; FileName: PChar): pPGPOptionList; cdecl;
  PGPOClearSign: function(Context: pPGPContext; ClearSign: PGPBoolean): pPGPOptionList; cdecl;

  { Decode only options }
  // both
  PGPOPassThroughIfUnrecognized: function(Context: pPGPContext; PassThroughIfUnrecognized: PGPBoolean): pPGPOptionList; cdecl;
  PGPOPassThroughClearSigned: function(Context: pPGPContext; PassThroughClearSigned: PGPBoolean): pPGPOptionList; cdecl;
  PGPOPassThroughKeys: function(Context: pPGPContext; PassThroughKeys: PGPBoolean): pPGPOptionList; cdecl;
  PGPOSendEventIfKeyFound: function(Context: pPGPContext; SendEventIfKeyFound: PGPBoolean): pPGPOptionList; cdecl;
  PGPORecursivelyDecode: function(Context: pPGPContext; Recurse: PGPBoolean): pPGPOptionList; cdecl;

  { Key generation options }
  // both
  PGPOAdditionalRecipientRequestKeySet: function(Context: pPGPContext; ARKeySet: pPGPKeySet;
						 ARKClass: PGPByte): pPGPOptionList; cdecl;
  PGPOKeyGenName: function(Context: pPGPContext; Name: Pointer; NameLength: PGPSize): pPGPOptionList; cdecl;
  // PGP 6.5.X
  PGPOKeyGenMasterKey: function(Context: pPGPContext; MasterKey: pPGPKey): pPGPOptionList; cdecl;
  // PGP 7.X
  {PGPOKeyGenMasterKey: function(Context: pPGPContext; MasterKey: pPGPKeyDBObj): pPGPOptionList; cdecl;}
  // both
  PGPOKeyGenFast: function(Context: pPGPContext; FastGen: PGPBoolean): pPGPOptionList; cdecl;
  PGPOKeyGenParams: function(Context: pPGPContext; PubKeyAlg: PGPPublicKeyAlgorithm;
			     Bits: PGPUInt32): pPGPOptionList; cdecl;
  PGPOCreationDate: function(Context: pPGPContext; CreationDate: PGPTime): pPGPOptionList; cdecl;
  PGPOExpiration: function(Context: pPGPContext; ExpirationDays: PGPUInt32): pPGPOptionList; cdecl;
  PGPOExportable: function(Context: pPGPContext; Exportable: PGPBoolean): pPGPOptionList; cdecl;
  PGPOSigRegularExpression: function(Context: pPGPContext; RegularExpression: PChar): pPGPOptionList; cdecl;
  PGPOSigTrust: function(Context: pPGPContext; TrustLevel: PGPUInt32; TrustValue: PGPUInt32): pPGPOptionList; cdecl;
  PGPORevocationKeySet: function(Context: pPGPContext; RKeySet: pPGPKeySet): pPGPOptionList; cdecl;
  // PGP 7.X
  PGPOKeyFlags: function(Context: pPGPContext; Flags: PGPUInt32): pPGPOptionList; cdecl;

  { Miscellaneous options }
  // both
  PGPONullOption: function(Context: pPGPContext): pPGPOptionList; cdecl;
  PGPOCompression: function(Context: pPGPContext; Compression: PGPBoolean): pPGPOptionList; cdecl;
  PGPOCommentString: function(Context: pPGPContext; Comment: PChar): pPGPOptionList; cdecl;
  PGPOVersionString: function(Context: pPGPContext; Version: PChar): pPGPOptionList; cdecl;
  // both
  PGPOPassphrase: function(Context: pPGPContext; Passphrase: PChar): pPGPOptionList; cdecl;
  PGPOPassphraseBuffer: function(Context: pPGPContext; Passphrase: PChar;
				 PassphraseLength: PGPSize): pPGPOptionList; cdecl;
  PGPOPasskeyBuffer: function(Context: pPGPContext; Passkey: PChar; PasskeyLength: PGPSize): pPGPOptionList; cdecl;
  // PGP 7.X
  PGPOCachePassphrase: function(Context: pPGPContext; TimeOutSeconds: PGPUInt32;
				GlobalCache: PGPBoolean): pPGPOptionList; cdecl;
  // both
  PGPOPreferredAlgorithms: function(Context: pPGPContext; const PrefAlg: TPGPCipherAlgorithms;
				    NumAlgs: PGPUInt32): pPGPOptionList; cdecl;
  // PGP 6.5.X
  PGPOKeySetRef6: function(Context: pPGPContext; KeySet: pPGPKeySet): pPGPOptionList; cdecl;
  // PGP 7.X
  PGPOKeyDBRef7: function(Context: pPGPContext; KeyDB: pPGPKeyDB): pPGPOptionList; cdecl;
  // both
  PGPOSendNullEvents: function(Context: pPGPContext; ApproxInterval: PGPTimeInterval): pPGPOptionList; cdecl;
  PGPOX509Encoding: function(Context: pPGPContext; x509Encoding: PGPBoolean): pPGPOptionList; cdecl;
  PGPOExportFormat: function(Context: pPGPContext; ExportFormat: PGPExportFormat): pPGPOptionList; cdecl;
  PGPOExportKeySet: function(Context: pPGPContext; KeySet: pPGPKeySet): pPGPOptionList; cdecl;
  // PGP 6.5.X
  PGPOExportKey: function(Context: pPGPContext; Key: pPGPKey): pPGPOptionList; cdecl;
  PGPOExportUserID: function(Context: pPGPContext; UserID: pPGPUserID): pPGPOptionList; cdecl;
  PGPOExportSig: function(Context: pPGPContext; Sig: pPGPSig): pPGPOptionList; cdecl;
  // PGP 7.X
  {PGPOExportKeyDBObj: function(Context: pPGPContext; KeyDBObj: pPGPKeyDBObj): pPGPOptionList; cdecl;}
  // both
  PGPOExportPrivateKeys: function(Context: pPGPContext; ExportKeys: PGPBoolean): pPGPOptionList; cdecl;
  PGPOExportPrivateSubkeys: function(Context: pPGPContext; ExportSubkeys: PGPBoolean): pPGPOptionList; cdecl;
  // PGP 6.5.X
  PGPOImportKeysTo6: function(Context: pPGPContext; KeySet: pPGPKeySet): pPGPOptionList; cdecl;
  // PGP 7.X
  PGPOImportKeysTo7: function(Context: pPGPContext; KeyDB: pPGPKeyDB): pPGPOptionList; cdecl;
  // both
  PGPOInputFormat: function(Context: pPGPContext; InputFormat: PGPInputFormat): pPGPOptionList; cdecl;
  PGPOOutputFormat: function(Context: pPGPContext; OutputFormat: PGPOutputFormat): pPGPOptionList; cdecl;
  PGPOAttributeValue: function(Context: pPGPContext; const AttributeValue: PPGPAttributeValue;
			       AttributeValueCount: PGPUInt32): pPGPOptionList; cdecl;
  PGPOEventHandler: function(Context: pPGPContext; Handler: TPGPEventHandlerProcPtr;
			     UserValue: PGPUserValue): pPGPOptionList; cdecl;
  PGPOLastOption: function(Context: pPGPContext): pPGPOptionList; cdecl;

// wrappers for the respective PGP functions as Delphi cannot handle open arrays with the cdecl convention
function PGPBuildOptionList(Context: pPGPContext; var OptionList: pPGPOptionList;
			    const Options: Array of pPGPOptionList): PGPError;
function PGPAppendOptionList(OutList: pPGPOptionList; const Options: Array of pPGPOptionList): PGPError;
// wrapper functions for version compatibility
function PGPOKeySetRef(Context: pPGPContext; KeySet: pPGPKeySet): pPGPOptionList;
function PGPOImportKeysTo(Context: pPGPContext; KeySet: pPGPKeySet): pPGPOptionList; 

implementation	// code modified by idw

uses
  Windows;

// the ASM technique for accessing open arrays is based on the
// original work of Graham Grieve in Kestral Computing's
// PGPAPI.PAS file: <http://www.kestral.com.au/devtools/pgp/>
var
  PGPBuildOptionListProcPtr: Pointer;
  PGPAppendOptionListProcPtr: Pointer;

function PGPBuildOptionList(Context: pPGPContext; var OptionList: pPGPOptionList;
			    const Options: Array of pPGPOptionList): PGPError; register; assembler;
// EAX = Context; EDX = @OptionList; ECX = Options; EBP + 8 = high(Options)
asm	// Delphi automatically creates a stack frame here which helps us cleaning up the stack
  SUB	ESP,4				// for temporary OptionList variable
  MOV	[EBP - 4],EDX			// free EDX for using as variable
  MOV	EDX,[EBP + 8]			// get high(Options) from stack
  PUSH	-1				// push PGPLastOption = kPGPEndOfArgsOptionListRef (see pgpOptionListPriv.h)
  @LOOP:		   		// push Options
  PUSH	DWORD PTR [ECX + EDX * TYPE pPGPOptionList]
  DEC	EDX
  JNS	@LOOP
  PUSH	DWORD PTR [EBP - 4]		// push OptionList
  PUSH	EAX				// push Context
  CALL	PGPBuildOptionListProcPtr	// result comes in EAX
  MOV	ESP,EBP				// restore stack pointer
end;

function PGPAppendOptionList(OutList: pPGPOptionList; const Options: Array of pPGPOptionList): PGPError; register; assembler;
// EAX = OutList; EDX = Options; ECX = high(Options)
asm	// Delphi does not create a stack frame here, but we do it for conveniently cleaning up the stack
  PUSH	EBP				// save base pointer
  MOV	EBP,ESP				// save stack pointer
  PUSH	-1				// push PGPLastOption = kPGPEndOfArgsOptionListRef (see pgpOptionListPriv.h)
  @LOOP:		   		// push Options
  PUSH	DWORD PTR [EDX + ECX * TYPE pPGPOptionList]
  DEC	ECX
  JNS	@LOOP
  PUSH	EAX				// push OutList
  CALL	PGPAppendOptionListProcPtr	// result comes in EAX
  MOV	ESP,EBP				// restore stack pointer
  POP	EBP				// restore base pointer
end;

function PGPOKeySetRef(Context: pPGPContext; KeySet: pPGPKeySet): pPGPOptionList;
begin
  if PGP7X then
    Result := PGPOKeyDBRef7(Context, PGPPeekKeySetKeyDB(KeySet))
  else Result := PGPOKeySetRef6(Context, KeySet);
end;

function PGPOImportKeysTo(Context: pPGPContext; KeySet: pPGPKeySet): pPGPOptionList;
begin
  if PGP7X then
    Result := PGPOImportKeysTo7(Context, PGPPeekKeySetKeyDB(KeySet))
  else Result := PGPOImportKeysTo6(Context, KeySet);
end;

initialization

  if PGPInitErrorCode = ieNone then begin
    PGPBuildOptionListProcPtr := GetProcAddress(hPGPsdkLib, 'PGPBuildOptionList');
    PGPAppendOptionListProcPtr := GetProcAddress(hPGPsdkLib, 'PGPAppendOptionList');

    PGPNewOptionList := GetProcAddress(hPGPsdkLib, 'PGPNewOptionList');
    PGPCopyOptionList := GetProcAddress(hPGPsdkLib, 'PGPCopyOptionList');
    PGPFreeOptionList := GetProcAddress(hPGPsdkLib, 'PGPFreeOptionList');
    PGPAddJobOptions := GetProcAddress(hPGPsdkLib, 'PGPAddJobOptions');
    PGPOInputBuffer := GetProcAddress(hPGPsdkLib, 'PGPOInputBuffer');
    PGPOInputFile := GetProcAddress(hPGPsdkLib, 'PGPOInputFile');
    PGPOAppendOutput := GetProcAddress(hPGPsdkLib, 'PGPOAppendOutput');
    PGPODiscardOutput := GetProcAddress(hPGPsdkLib, 'PGPODiscardOutput');
    PGPOAllocatedOutputBuffer := GetProcAddress(hPGPsdkLib, 'PGPOAllocatedOutputBuffer');
    PGPOOutputBuffer := GetProcAddress(hPGPsdkLib, 'PGPOOutputBuffer');
    PGPOOutputFile := GetProcAddress(hPGPsdkLib, 'PGPOOutputFile');
    PGPOPGPMIMEEncoding := GetProcAddress(hPGPsdkLib, 'PGPOPGPMIMEEncoding');
    PGPOOmitMIMEVersion := GetProcAddress(hPGPsdkLib, 'PGPOOmitMIMEVersion');
    PGPOLocalEncoding := GetProcAddress(hPGPsdkLib, 'PGPOLocalEncoding');
    PGPOOutputLineEndType := GetProcAddress(hPGPsdkLib, 'PGPOOutputLineEndType');
    PGPODetachedSig := GetProcAddress(hPGPsdkLib, 'PGPODetachedSig');
    PGPOConventionalEncrypt := GetProcAddress(hPGPsdkLib, 'PGPOConventionalEncrypt');
    PGPOCipherAlgorithm := GetProcAddress(hPGPsdkLib, 'PGPOCipherAlgorithm');
    if PGP7X then
      PGPOEncryptToKey := GetProcAddress(hPGPsdkLib, 'PGPOEncryptToKeyDBObj')
    else PGPOEncryptToKey := GetProcAddress(hPGPsdkLib, 'PGPOEncryptToKey');
    PGPOEncryptToKeySet := GetProcAddress(hPGPsdkLib, 'PGPOEncryptToKeySet');
    PGPOHashAlgorithm := GetProcAddress(hPGPsdkLib, 'PGPOHashAlgorithm');
    PGPOSignWithKey := GetProcAddress(hPGPsdkLib, 'PGPOSignWithKey');
    PGPOWarnBelowValidity := GetProcAddress(hPGPsdkLib, 'PGPOWarnBelowValidity');
    PGPOFailBelowValidity := GetProcAddress(hPGPsdkLib, 'PGPOFailBelowValidity');
    PGPOAskUserForEntropy := GetProcAddress(hPGPsdkLib, 'PGPOAskUserForEntropy');
    PGPODataIsASCII := GetProcAddress(hPGPsdkLib, 'PGPODataIsASCII');
    PGPORawPGPInput := GetProcAddress(hPGPsdkLib, 'PGPORawPGPInput');
    PGPOForYourEyesOnly := GetProcAddress(hPGPsdkLib, 'PGPOForYourEyesOnly');
    PGPOArmorOutput := GetProcAddress(hPGPsdkLib, 'PGPOArmorOutput');
    PGPOFileNameString := GetProcAddress(hPGPsdkLib, 'PGPOFileNameString');
    PGPOClearSign := GetProcAddress(hPGPsdkLib, 'PGPOClearSign');
    PGPOPassThroughIfUnrecognized := GetProcAddress(hPGPsdkLib, 'PGPOPassThroughIfUnrecognized');
    PGPOPassThroughClearSigned := GetProcAddress(hPGPsdkLib, 'PGPOPassThroughClearSigned');
    PGPOPassThroughKeys := GetProcAddress(hPGPsdkLib, 'PGPOPassThroughKeys');
    PGPOSendEventIfKeyFound := GetProcAddress(hPGPsdkLib, 'PGPOSendEventIfKeyFound');
    PGPORecursivelyDecode := GetProcAddress(hPGPsdkLib, 'PGPORecursivelyDecode');
    PGPOAdditionalRecipientRequestKeySet := GetProcAddress(hPGPsdkLib, 'PGPOAdditionalRecipientRequestKeySet');
    PGPOKeyGenName := GetProcAddress(hPGPsdkLib, 'PGPOKeyGenName');
    PGPOKeyGenMasterKey := GetProcAddress(hPGPsdkLib, 'PGPOKeyGenMasterKey');
    PGPOKeyGenFast := GetProcAddress(hPGPsdkLib, 'PGPOKeyGenFast');
    PGPOKeyGenParams := GetProcAddress(hPGPsdkLib, 'PGPOKeyGenParams');
    PGPOCreationDate := GetProcAddress(hPGPsdkLib, 'PGPOCreationDate');
    PGPOExpiration := GetProcAddress(hPGPsdkLib, 'PGPOExpiration');
    PGPOExportable := GetProcAddress(hPGPsdkLib, 'PGPOExportable');
    PGPOSigRegularExpression := GetProcAddress(hPGPsdkLib, 'PGPOSigRegularExpression');
    PGPOSigTrust := GetProcAddress(hPGPsdkLib, 'PGPOSigTrust');
    PGPORevocationKeySet := GetProcAddress(hPGPsdkLib, 'PGPORevocationKeySet');
    PGPOKeyFlags := GetProcAddress(hPGPsdkLib, 'PGPOKeyFlags');
    PGPONullOption := GetProcAddress(hPGPsdkLib, 'PGPONullOption');
    PGPOCompression := GetProcAddress(hPGPsdkLib, 'PGPOCompression');
    PGPOCommentString := GetProcAddress(hPGPsdkLib, 'PGPOCommentString');
    PGPOVersionString := GetProcAddress(hPGPsdkLib, 'PGPOVersionString');
    PGPOPassphrase := GetProcAddress(hPGPsdkLib, 'PGPOPassphrase');
    PGPOPassphraseBuffer := GetProcAddress(hPGPsdkLib, 'PGPOPassphraseBuffer');
    PGPOPasskeyBuffer := GetProcAddress(hPGPsdkLib, 'PGPOPasskeyBuffer');
    PGPOCachePassphrase := GetProcAddress(hPGPsdkLib, 'PGPOCachePassphrase');
    PGPOPreferredAlgorithms := GetProcAddress(hPGPsdkLib, 'PGPOPreferredAlgorithms');
    if PGP7X then
      PGPOKeyDBRef7 := GetProcAddress(hPGPsdkLib, 'PGPOKeyDBRef')
    else PGPOKeySetRef6 := GetProcAddress(hPGPsdkLib, 'PGPOKeySetRef');
    PGPOSendNullEvents := GetProcAddress(hPGPsdkLib, 'PGPOSendNullEvents');
    PGPOX509Encoding := GetProcAddress(hPGPsdkLib, 'PGPOX509Encoding');
    PGPOExportFormat := GetProcAddress(hPGPsdkLib, 'PGPOExportFormat');
    PGPOExportKeySet := GetProcAddress(hPGPsdkLib, 'PGPOExportKeySet');
    if PGP7X then begin
      PGPOExportKey := GetProcAddress(hPGPsdkLib, 'PGPOExportKeyDBObj');
      PGPOExportUserID := GetProcAddress(hPGPsdkLib, 'PGPOExportKeyDBObj');
      PGPOExportSig := GetProcAddress(hPGPsdkLib, 'PGPOExportKeyDBObj');
    end
    else begin
      PGPOExportKey := GetProcAddress(hPGPsdkLib, 'PGPOExportKey');
      PGPOExportUserID := GetProcAddress(hPGPsdkLib, 'PGPOExportUserID');
      PGPOExportSig := GetProcAddress(hPGPsdkLib, 'PGPOExportSig');
    end;
    PGPOExportPrivateKeys := GetProcAddress(hPGPsdkLib, 'PGPOExportPrivateKeys');
    PGPOExportPrivateSubkeys := GetProcAddress(hPGPsdkLib, 'PGPOExportPrivateSubkeys');
    if PGP7X then
      PGPOImportKeysTo7 := GetProcAddress(hPGPsdkLib, 'PGPOImportKeysTo')
    else PGPOImportKeysTo6 := GetProcAddress(hPGPsdkLib, 'PGPOImportKeysTo');
    PGPOInputFormat := GetProcAddress(hPGPsdkLib, 'PGPOInputFormat');
    PGPOOutputFormat := GetProcAddress(hPGPsdkLib, 'PGPOOutputFormat');
    PGPOAttributeValue := GetProcAddress(hPGPsdkLib, 'PGPOAttributeValue');
    PGPOEventHandler := GetProcAddress(hPGPsdkLib, 'PGPOEventHandler');
    PGPOLastOption := GetProcAddress(hPGPsdkLib, 'PGPOLastOption');
  end;

end.

