{$J+,Z4}
unit pgpGroups;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the "Borland Delphi Runtime Library PGPsdk" released 10 Apr }
{ 2000, available at http://www.oz.net/~srheller/dpgp/sdk/.                        }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpGroups.pas based on pgpGroups.h from the PGP sources     }
{ which are Copyright (C) Network Associates Inc. and affiliated companies.        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ Lots of stuff removed (especially from PGP versions 5.5.X and 6.0.X)             }
{                                                                                  }
{**********************************************************************************}

interface

uses
  pgpBase,
  pgpPubTypes;

const
  kPGPMaxGroupNameLength	= 63;
  kPGPMaxGroupDescriptionLength	= 63;

type
  PGPGroupName = Array[0..kPGPMaxGroupNameLength] of Char;
  PGPGroupDescription = Array[0..kPGPMaxGroupDescriptionLength] of Char;

  pPGPGroupSet = Pointer;
  pPGPGroupItemIter = Pointer;

  // any type will do that is distinct
  PGPGroupID = PGPUInt32;

type
  PGPGroupItemType = PGPEnumType;
const
  kPGPGroupItem_KeyID = 1;
  kPGPGroupItem_Group = 2;

{____________________________________________________________________________
  A run-time group item, used when iterating through a group.
  For client use; not necessarily the internal storage format.
____________________________________________________________________________}

type
  // substructures for TPGPGroupItem union by SRH, modified by idw
  TSubstructGroup = Packed Record
    GroupID: PGPGroupID;
  end;
  TSubstructKey6 = Packed Record
    Algorithm: PGPPublicKeyAlgorithm;
    KeyID: TPGPKeyID7;
  end;
  TSubstructKey7 = Packed Record
    KeyID: TPGPKeyID7;
  end;
  // TPGPGroupItem union by SRH, modified by idw
  pPGPGroupItem = ^TPGPGroupItem;
  TPGPGroupItem = Packed Record
    ItemType	: PGPGroupItemType;		// selects which substructure
    UserValue	: PGPUserValue;			// is *not* saved to disk
    Item	: Record case Longint of
      1: (Group: TSubstructGroup);		// if kGroupItem_Group
      2: (Key: Record case Longint of		// if kGroupItem_KeyID
	6: (KeyStruct6: TSubstructKey6);
	7: (KeyStruct7: TSubstructKey7);
      end);
    end;
    Reserved: Array[0..3] of PGPUInt32;		// PGP 6.5.X only
  end;

type
  TPGPGroupItemCompareProc = function(var Group1: pPGPGroupItem;
    Group2: pPGPGroupItem; UserValue: PGPUserValue): PGPInt32; cdecl;

{____________________________________________________________________________
  Info obtained via PGPGetGroupInfo.
____________________________________________________________________________}

type
  TPGPGroupInfo = Record
    ID		: PGPGroupID;
    Name	: PGPGroupName;
    Description	: PGPGroupDescription;
    UserValue	: PGPUserValue;
  end;

type
  TPGPGroupItemIterFlags = PGPFlags;
const
  // flag (1 shl 0 ) is reserved
  kPGPGroupIterFlags_Recursive	= (1 shl 1);
  kPGPGroupIterFlags_Keys	= (1 shl 2);
  kPGPGroupIterFlags_Groups	= (1 shl 3);

  kPGPGroupIterFlags_AllKeysRecursive	= kPGPGroupIterFlags_Recursive or kPGPGroupIterFlags_Keys;
  kPGPGroupIterFlags_AllGroupsRecursive	= kPGPGroupIterFlags_Recursive or kPGPGroupIterFlags_Groups;
  kPGPGroupIterFlags_AllItems		= kPGPGroupIterFlags_Keys or kPGPGroupIterFlags_Groups;
  kPGPGroupIterFlags_AllRecursive	= kPGPGroupIterFlags_Recursive or kPGPGroupIterFlags_AllItems;

{____________________________________________________________________________
  Manipulating pgp group sets (pPGPGroupSet)
____________________________________________________________________________}

{ create a new, empty groups collection }
var PGPNewGroupSet: function(Context: pPGPContext;
    var OutRef: pPGPGroupSet): PGPError; cdecl;

{ file is *not* left open; all data is loaded into memory }
var PGPNewGroupSetFromFile: function(Context: pPGPContext;
    aFile: pPGPFileSpec;
    var OutRef: pPGPGroupSet): PGPError; cdecl;

{ overwrites existing.  Don't bother unless PGPGroupSetNeedsCommit() }
var PGPSaveGroupSetToFile: function(TheSet: pPGPGroupSet; aFile: pPGPFileSpec): PGPError; cdecl;

{ free all data structures; be sure to save first if you want }
var PGPFreeGroupSet: function(TheSet: pPGPGroupSet): PGPError; cdecl;

{ has the group changed? }
var PGPGroupSetNeedsCommit: function(TheSet: pPGPGroupSet): PGPBoolean; cdecl;

var PGPGetGroupSetContext: function(TheSet: pPGPGroupSet): pPGPContext; cdecl;

{ export the groupset to a buffer. Use PGPFreeData to free the buffer }
var PGPExportGroupSetToBuffer: function(TheSet: pPGPGroupSet;
    var Buffer: Pointer;
    var BufSize: PGPSize): PGPError; cdecl;

{ import a groupset from a buffer }
var PGPImportGroupSetFromBuffer: function(Context: pPGPContext;
    var Buffer: Pointer;
    BufSize: PGPSize;
    var OutSet: pPGPGroupSet): PGPError; cdecl;

{____________________________________________________________________________
  Manipulating groups

  Groups are always referred to by IDs which remain valid until the set
  is disposed.
____________________________________________________________________________}

{ initial parent ID is kPGPInvalidGroupID }
var PGPNewGroup: function(TheSet: pPGPGroupSet;
    const Name: PChar;
    const Description: PChar;
    var Id: PGPGroupID): PGPError; cdecl;

var PGPCountGroupsInSet: function(TheSet: pPGPGroupSet;
    var NumGroups: PGPUInt32): PGPError; cdecl;

var PGPGetIndGroupID: function(TheSet: pPGPGroupSet;
    GroupIndex: PGPUInt32;
    var Id: PGPGroupID): PGPError; cdecl;

{ delete this group from the Set: }
{ all references to it are removed in all sets }
var PGPDeleteGroup: function(TheSet: pPGPGroupSet;
    Id: PGPGroupID): PGPError; cdecl;

{ delete the indexed item from the group }
{ the item may be a group or a key }
var PGPDeleteIndItemFromGroup: function(TheSet: pPGPGroupSet;
    Id: PGPGroupID;
    Item: PGPUInt32): PGPError; cdecl;

{ same as PGPDeleteIndItemFromGroup, but accepts an item }
var PGPDeleteItemFromGroup: function(TheSet: pPGPGroupSet;
    Id: PGPGroupID;
    const Item: pPGPGroupItem): PGPError; cdecl;

var PGPGetGroupInfo: function(TheSet: pPGPGroupSet;
    Id: PGPGroupID;
    var Info: TPGPGroupInfo): PGPError; cdecl;

var PGPSetGroupName: function(TheSet: pPGPGroupSet;
    Id: PGPGroupID;
    const Name: PChar): PGPError; cdecl;

var PGPSetGroupUserValue: function(TheSet: pPGPGroupSet;
    Id: PGPGroupID;
    UserValue: PGPUserValue): PGPError; cdecl;

var PGPSetGroupDescription: function(TheSet: pPGPGroupSet;
    Id: PGPGroupID;
    const Name: PChar): PGPError; cdecl;

{ 'item' specifies a group or a key id }
{ you must fill the item in completely }
var PGPAddItemToGroup: function(TheSet: pPGPGroupSet;
    const Item: pPGPGroupItem;
    Group: PGPGroupID): PGPError; cdecl;

var PGPMergeGroupIntoDifferentSet: function(FromSet: pPGPGroupSet;
    FromId: PGPGroupID;
    ToSet: pPGPGroupSet): PGPError; cdecl;

var PGPMergeGroupSets: function(FromSet: pPGPGroupSet;
    IntoSet: pPGPGroupSet): PGPError; cdecl;

var PGPCopyGroupSet: function(SourceSet: pPGPGroupSet;
    var DestSet: pPGPGroupSet): PGPError; cdecl;

{____________________________________________________________________________
  Manipulating group items
____________________________________________________________________________}

{ count how many items there are in a group }
{ TotalItems includes keys and groups }
var PGPCountGroupItems: function(TheSet: pPGPGroupSet;
    Id: PGPGroupID;
    Recursive: PGPBoolean;
    var NumKeys: PGPUInt32;
    var TotalItems: PGPUInt32): PGPError; cdecl;

{ non-recursive call; index only applies to group itself }
var PGPGetIndGroupItem: function(TheSet: pPGPGroupSet;
    Id: PGPGroupID;
    GroupIndex: PGPUInt32;
    var Item: TPGPGroupItem): PGPError; cdecl;

{ use PGPGetIndGroupItem() if you want to get the user value }
var PGPSetIndGroupItemUserValue: function(TheSet: pPGPGroupSet;
    Id: PGPGroupID;
    GroupIndex: PGPUInt32;
    UserValue: PGPUserValue): PGPError; cdecl;

var PGPSortGroupItems: function(TheSet: pPGPGroupSet;
    Id: PGPGroupID;
    CompareProc: TPGPGroupItemCompareProc;
    UserValue: PGPUserValue): PGPError; cdecl;

var PGPSortGroupSet: function(TheSet: pPGPGroupSet;
    CompareProc: TPGPGroupItemCompareProc;
    UserValue: PGPUserValue): PGPError; cdecl;

{____________________________________________________________________________
  PGPGroupItemIterRef--iterator through group items.

  Special note: this is not a full-fledged iterator.  You may *not* add
  or delete items while iterating and you may only move forward.  However,
  you may change the values of items.
____________________________________________________________________________}

var PGPNewGroupItemIter: function(TheSet: pPGPGroupSet;
    Id: PGPGroupID;
    Flags: TPGPGroupItemIterFlags;
    var Iter: pPGPGroupItemIter): PGPError; cdecl;

var PGPFreeGroupItemIter: function(Iter: pPGPGroupItemIter): PGPError; cdecl;

{ returns kPGPError_EndOfIteration when done }
var PGPGroupItemIterNext: function(Iter: pPGPGroupItemIter;
    var Item: TPGPGroupItem): PGPError; cdecl;

{____________________________________________________________________________
  Group utilities
____________________________________________________________________________}

{____________________________________________________________________________
  Return the lowest validity of any item in the group
  keyset should contain all keys available
  It is not an error if keys can't be found; you may want to check
  the not found count.

  The lowest validity is kPGPValidity_Invalid and kPGPValidity_Unknown
  is never returned.
____________________________________________________________________________}
// PGP 6.5.X
var PGPGetGroupLowestValidity: function(TheSet: pPGPGroupSet;
    Id: PGPGroupID;
    KeySet: pPGPKeySet;
    var LowestValidity: PGPValidity;
    var NumKeysNotFound: PGPUInt32): PGPError; cdecl;
// PGP 7.X
{var PGPGetGroupLowestValidity: function(TheSet: pPGPGroupSet;
    Id: PGPGroupID;
    KeyDB: pPGPKeyDB;
    var LowestValidity: PGPValidity;
    var NumKeysNotFound: PGPUInt32): PGPError; cdecl;}


{____________________________________________________________________________
  All all the keys in the group (and its subgroups) to the keyset
____________________________________________________________________________}
// PGP 6.5.X
var PGPNewKeySetFromGroup: function(TheSet: pPGPGroupSet;
    Id: PGPGroupID;
    MasterSet: pPGPKeySet;
    var ResultSet: pPGPKeySet;
    var NumKeysNotFound: PGPUInt32): PGPError; cdecl;
// PGP 7.X
{var PGPNewKeySetFromGroup: function(TheSet: pPGPGroupSet;
    Id: PGPGroupID;
    KeyDB: pPGPKeyDB;
    var ResultSet: pPGPKeySet;
    var NumKeysNotFound: PGPUInt32): PGPError; cdecl;}

{____________________________________________________________________________
  Create a simple, flattened group of unique key IDs from the source group.
  Note that sourceSet and destSet must be different.
____________________________________________________________________________}
var PGPNewFlattenedGroupFromGroup: function(SourceSet: pPGPGroupSet;
    SourceId: PGPGroupID;
    DestSet: pPGPGroupSet;
    var DestID: PGPGroupID): PGPError; cdecl;

{____________________________________________________________________________
  Perform a "standard" sort on a group
____________________________________________________________________________}
// PGP 6.5.X
var PGPSortGroupSetStd: function(TheSet: pPGPGroupSet; Keys: pPGPKeySet): PGPError; cdecl;
// PGP 7.X
{var PGPSortGroupSetStd: function(TheSet: pPGPGroupSet; Keys: pPGPKeyDB): PGPError; cdecl;}

implementation

uses
  Windows;

initialization

  if PGPInitErrorCode = ieNone then begin
    PGPNewGroupSet := GetProcAddress(hPGPsdkLib,'PGPNewGroupSet');
    PGPNewGroupSetFromFile := GetProcAddress(hPGPsdkLib,'PGPNewGroupSetFromFile');
    PGPSaveGroupSetToFile := GetProcAddress(hPGPsdkLib,'PGPSaveGroupSetToFile');
    PGPFreeGroupSet := GetProcAddress(hPGPsdkLib,'PGPFreeGroupSet');
    PGPGroupSetNeedsCommit := GetProcAddress(hPGPsdkLib,'PGPGroupSetNeedsCommit');
    PGPGetGroupSetContext := GetProcAddress(hPGPsdkLib,'PGPGetGroupSetContext');
    PGPExportGroupSetToBuffer := GetProcAddress(hPGPsdkLib,'PGPExportGroupSetToBuffer');
    PGPImportGroupSetFromBuffer := GetProcAddress(hPGPsdkLib,'PGPImportGroupSetFromBuffer');
    PGPNewGroup := GetProcAddress(hPGPsdkLib,'PGPNewGroup');
    PGPCountGroupsInSet := GetProcAddress(hPGPsdkLib,'PGPCountGroupsInSet');
    PGPGetIndGroupID := GetProcAddress(hPGPsdkLib,'PGPGetIndGroupID');
    PGPDeleteGroup := GetProcAddress(hPGPsdkLib,'PGPDeleteGroup');
    PGPDeleteIndItemFromGroup := GetProcAddress(hPGPsdkLib,'PGPDeleteIndItemFromGroup');
    PGPDeleteItemFromGroup := GetProcAddress(hPGPsdkLib,'PGPDeleteItemFromGroup');
    PGPGetGroupInfo := GetProcAddress(hPGPsdkLib,'PGPGetGroupInfo');
    PGPSetGroupName := GetProcAddress(hPGPsdkLib,'PGPSetGroupName');
    PGPSetGroupUserValue := GetProcAddress(hPGPsdkLib,'PGPSetGroupUserValue');
    PGPSetGroupDescription := GetProcAddress(hPGPsdkLib,'PGPSetGroupDescription');
    PGPAddItemToGroup := GetProcAddress(hPGPsdkLib,'PGPAddItemToGroup');
    PGPMergeGroupIntoDifferentSet := GetProcAddress(hPGPsdkLib,'PGPMergeGroupIntoDifferentSet');
    PGPMergeGroupSets := GetProcAddress(hPGPsdkLib,'PGPMergeGroupSets');
    PGPCopyGroupSet := GetProcAddress(hPGPsdkLib,'PGPCopyGroupSet');
    PGPCountGroupItems := GetProcAddress(hPGPsdkLib,'PGPCountGroupItems');
    PGPGetIndGroupItem := GetProcAddress(hPGPsdkLib,'PGPGetIndGroupItem');
    PGPSetIndGroupItemUserValue := GetProcAddress(hPGPsdkLib,'PGPSetIndGroupItemUserValue');
    PGPSortGroupItems := GetProcAddress(hPGPsdkLib,'PGPSortGroupItems');
    PGPSortGroupSet := GetProcAddress(hPGPsdkLib,'PGPSortGroupSet');
    PGPNewGroupItemIter := GetProcAddress(hPGPsdkLib,'PGPNewGroupItemIter');
    PGPFreeGroupItemIter := GetProcAddress(hPGPsdkLib,'PGPFreeGroupItemIter');
    PGPGroupItemIterNext := GetProcAddress(hPGPsdkLib,'PGPGroupItemIterNext');
    PGPGetGroupLowestValidity := GetProcAddress(hPGPsdkLib,'PGPGetGroupLowestValidity');
    PGPNewKeySetFromGroup := GetProcAddress(hPGPsdkLib,'PGPNewKeySetFromGroup');
    PGPNewFlattenedGroupFromGroup := GetProcAddress(hPGPsdkLib,'PGPNewFlattenedGroupFromGroup');
    PGPSortGroupSetStd := GetProcAddress(hPGPsdkLib,'PGPSortGroupSetStd');
  end;

end.
