{$J+,Z4}
unit UTF8;
{$IFDEF CONDITIONALEXPRESSIONS} {$WARN SYMBOL_PLATFORM OFF} {$ENDIF}

{------------------------------------------------------------------------------}
{                                                                              }
{          UTF8 utilities - especially for versions prior to Delphi 6          }
{                                                                              }
{                                 This code is                                 }
{                 Copyright (C) 2003 by Michael in der Wiesche                 }
{                                                                              }
{------------------------------------------------------------------------------}

// These functions are only required when using PGP 8.X
// UTF8Sec.dll provides them for using Delphi versions prior to 6.X
// Secure memory management prevents passphrases from being swapped to disk
// Using secure memory within Delphi causes crashes, so it is disabled when debugging
// IsDebuggerPresent isn't available on Windows 95 - but neither is PGP 8.X - so we can use it ...

interface

type UTF8String = type String;

var AnsiToUtf8PChar: function(const Ansi, Utf8: PChar; Len: Cardinal): Longint; stdcall;
var Utf8ToAnsiPChar: function(const Utf8, Ansi: PChar; Len: Cardinal): Longint; stdcall;

function AnsiToUtf8(const S: String): UTF8String;
function Utf8ToAnsi(const S: UTF8String): String;
function Utf8OrAnsi(const S: UTF8String): String;

const MaxUTF8Length = 256 * 4;

implementation

uses Windows, SysUtils, pgpBase;

var SecureMemoryMgr: procedure; stdcall;
var DefaultMemoryMgr: procedure; stdcall;
var IsSecureMemoryMgr: function: Longbool; stdcall;

function AnsiToUtf8(const S: String): UTF8String;
var
  Len: Cardinal;
begin
  Len := succ(Length(S) shl 2);
  SetLength(Result, Len);
  Len := AnsiToUtf8PChar(PChar(S), PChar(Result), Len);
  SetLength(Result, Len);
end;

function Utf8ToAnsi(const S: UTF8String): String;
var
  Len: Cardinal;
begin
  Len := succ(Length(S));
  SetLength(Result, Len);
  Len := Utf8ToAnsiPChar(PChar(S), PChar(Result), Len);
  SetLength(Result, Len);
end;

function Utf8OrAnsi(const S: UTF8String): String;
begin
  Result := Utf8ToAnsi(S);
  if Result = '' then Result := S;
end;

function Debugging: Longbool;
var
  IsDebuggerPresent: function: Bool; stdcall;
begin
  IsDebuggerPresent := GetProcAddress(GetModuleHandle(Kernel32), 'IsDebuggerPresent');
  Result := IsDebuggerPresent;
end;

function UsingSecMemIsSafe: Longbool;
begin
  Result := (PGP8X and not Debugging and (pos('delphi32.exe', LowerCase(ParamStr(0))) = 0));
end;

initialization
  if hUTF8Lib <> 0 then begin
    AnsiToUtf8PChar := GetProcAddress(hUTF8Lib, ptr(1));
    Utf8ToAnsiPChar := GetProcAddress(hUTF8Lib, ptr(2));
    SecureMemoryMgr := GetProcAddress(hUTF8Lib, ptr(3));
    DefaultMemoryMgr := GetProcAddress(hUTF8Lib, ptr(4));
    IsSecureMemoryMgr := GetProcAddress(hUTF8Lib, ptr(5));
    if UsingSecMemIsSafe then SecureMemoryMgr;
  end;

finalization
  if (hUTF8Lib <> 0) and IsSecureMemoryMgr then DefaultMemoryMgr;

end.

