{$J+,Z4}
unit pgpCL;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the "Borland Delphi Runtime Library PGPsdk" released 10 Apr }
{ 2000, available at http://www.oz.net/~srheller/dpgp/sdk/.                        }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpClient.pas based on pgpCl.h from the PGP sources         }
{ which are Copyright (C) Network Associates Inc. and affiliated companies.        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ Lots of stuff removed (especially from PGP versions 5.5.X and 6.0.X)             }
{                                                                                  }
{**********************************************************************************}

interface

uses
  Windows,
  pgpBase,
  pgpPubTypes,
  pgpMemoryMgr,
  pgpKeyServer,
  pgpEvents,
  pgpKeys,
  pgpTLS;

const	// added by idw
  WM_PGPReloadPrefs: Longint = 0;
  WM_PGPReloadKeyring: Longint = 0;
  WM_PGPReloadKeyserverPrefs: Longint = 0;


//	_______________________________________________________
//
//	from pflPrefs		// added by idw

type
  PGPPrefIndex = PGPInt32;


//	_______________________________________________________
//
//	from pgpClientPrefs	// added by idw

const
  // (enum)
  kPGPPrefMacBinaryOff			= 1;
  kPGPPrefMacBinarySmart		= 2;
  kPGPPrefMacBinaryOn			= 3;

  // _PGPClientPrefsBool (enum)
  kPGPPrefBoolFirst			= 0;
  kPGPPrefEncryptToSelf			= 0;
  kPGPPrefWordWrapEnable		= 1;
  kPGPPrefDecryptCacheEnable		= 2;
  kPGPPrefSignCacheEnable		= 3;
  kPGPPrefMailEncryptPGPMIME		= 4;
  kPGPPrefMailSignPGPMIME		= 5;
  kPGPPrefFastKeyGen			= 6;
  kPGPPrefWarnOnMixRSAElGamal		= 7;
  kPGPPrefMailEncryptDefault		= 8;
  kPGPPrefMailSignDefault		= 9;
  kPGPPrefMarginalIsInvalid		= 10;
  kPGPPrefDisplayMarginalValidity	= 11;
  kPGPPrefFirstKeyGenerated		= 12;
  kPGPPrefWarnOnRSARecipAndNonRSASigner	= 13;
  kPGPPrefKeyServerSyncUnknownKeys	= 14;
  kPGPPrefKeyServerSyncOnAdd		= 15;
  kPGPPrefKeyServerSyncOnKeySign	= 16;
  kPGPPrefKeyServerSyncOnRevocation	= 17;
  kPGPPrefWarnOnReadOnlyKeyRings	= 18;
  kPGPPrefWarnOnWipe			= 19;
  kPGPPrefAutoDecrypt			= 20;
  kPGPPrefWarnOnADK			= 21;
  kPGPPrefKeyServerSyncOnVerify		= 22;	// 6.0
  kPGPPrefPGPkeysMacShowToolbar		= 23;	// 6.0
  kPGPPrefWarnOnMemLockFailure		= 24;	// 6.0
  kPGPPrefExportKeysCompatible		= 25;	// 6.0
  kPGPPrefAlwaysUseSecureViewer		= 26;	// 6.5
  kPGPPrefUseHexFingerprint		= 27;	// 6.5
  kPGPPrefDiskAutoUnmountOnTime		= 28;	// 7.0
  kPGPPrefDiskAutoUnmountOnSleep	= 29;	// 7.0
  kPGPPrefDiskNoSleepIfFailAU		= 30;	// 7.0
  kPGPPrefTrashIntegration		= 31;	// 6.5
  kPGPPrefBoolLast			= 31;

  // _PGPClientPrefsNumber (enum)
  kPGPPrefNumberFirst			= 200;
  kPGPPrefVersion			= 200;
  kPGPPrefWordWrapWidth			= 201;
  kPGPPrefDecryptCacheSeconds		= 202;
  kPGPPrefSignCacheSeconds		= 203;
  kPGPPrefDateOfLastSplashScreen	= 204;	// PGPTime
  kPGPPrefPreferredAlgorithm		= 205;
  kPGPPrefAllowedAlgorithms		= 206;	// OBSOLETE
  kPGPPrefMacBinaryDefault		= 207;
  kPGPPrefDateOfLastFreewareNotice	= 208;	// OBSOLETE
  kPGPPrefFileWipePasses		= 209;	// 6.0
  kPGPPrefDiskWipePasses		= 210;	// 6.0
  kPGPPrefLastSearchWindowSelection	= 211;	// 6.0
  kPGPPrefLastAllKeysUpdate		= 212;	// 6.5(moved from admin)
  kPGPPrefLastTrustedIntroducersUpdate	= 213;	// 6.5(moved from admin)
  kPGPPrefCAType			= 214;	// 6.5
  kPGPPrefCARootKeyAlg			= 215;	// 6.5
  kPGPPrefCAServerAuthKeyAlg		= 216;	// 6.5
  kPGPPrefCARevocationServerAuthKeyAlg	= 217;	// 6.5
  kPGPPrefNextAutoCRLUpdate		= 218;	// 6.5
  kPGPPrefDiskLastCreateSize		= 219;	// 7.0
  kPGPPrefDiskLastCreateScale		= 220;	// 7.0
  kPGPPrefDiskAutoUnmountTimeout	= 221;	// 7.0
  kPGPPrefNumberLast			= 221;

  // _PGPClientPrefsString (enum)
  kPGPPrefStringFirst			= 400;
  kPGPPrefOwnerName			= 400;
  kPGPPrefCompanyName			= 401;
  kPGPPrefLicenseNumber			= 402;
  kPGPPrefComment			= 403;
  kPGPPrefCAServerURL			= 405;	// 6.5
  kPGPPrefCARevocationServerURL		= 406;	// 6.5
  kPGPPrefDiskLastOpenDir		= 407;	// 7.0
  kPGPPrefDiskLastSaveDir		= 408;	// 7.0
  kPGPPrefStringLast			= 408;

  // _PGPClientPrefsByte (enum)

  kPGPPrefByteFirst			= 600;
  kPGPPrefPGPtoolsMacPrivateData	= 600;
  kPGPPrefPGPmenuMacAppSignatures	= 601;
  kPGPPrefPGPkeysMacMainWinPos		= 602;
  kPGPPrefPGPkeysMacColumnData		= 603;
  kPGPPrefKeyServerList			= 604;
  kPGPPrefPGPkeysWinMainWinPos		= 605;
  kPGPPrefPGPkeysWinColumnData		= 606;
  kPGPPrefPGPkeysWinGroupsData		= 607;
  kPGPPrefAllowedAlgorithmsList		= 608;	// 5.5.1
  kPGPPrefPGPdiskWin32PrivateData	= 609;	// 6.5
  kPGPPrefCARootKeyID			= 610;	// 6.5
  kPGPPrefCARootX509IASN		= 611;	// 6.5
  kPGPPrefCAServerAuthKeyID		= 612;	// 6.5
  kPGPPrefCARevocationServerAuthKeyID	= 613;	// 6.5
  kPGPPrefPGPdiskMacPrivateData		= 614;	// 6.5
  kPGPPrefHotKeyData			= 615;	// 6.5
  kPGPPrefByteLast			= 615;


//	_______________________________________________________
//
//	from pgpKeyServerPrefs	// added by idw

type
  PGPKeyServerEntryFlags = PGPEnumType;
const
  kKeyServerListed		= 1;
  kKeyServerIsRoot		= 2;

const
  kMaxServerNameLength		= 255;
type
  TKeyServer = Array[0..kMaxServerNameLength] of Char;

type
  pPGPKeyServerEntry = ^TPGPKeyServerEntry;
  TPGPKeyServerEntry = Record
    StructSize		: PGPSize;
    Protocol		: PGPKeyServerProtocol;
    Domain		: TKeyServer;
    ServerDNS		: TKeyServer;
    ServerPort		: PGPUInt16;
    AuthKeyIDString 	: TKeyID;
    AuthAlg		: PGPPublicKeyAlgorithm;
    Flags		: PGPUInt32;
    Reserved		: Array[0..63] of Char;
  end;


//	_______________________________________________________
//
//	Library Initialization/Cleanup

//	Open library and initialize

var
  PGPclInitLibrary6: function(Context: pPGPContext): PGPError; cdecl;
  PGPclInitLibrary7: function(var Context: pPGPContext; Options: PGPFlags): PGPError; stdcall;

//	Close down DLL and purge passphrase buffers.

var
  PGPclCloseLibrary6: function: PGPError; cdecl;
  PGPclCloseLibrary7: function: PGPError; stdcall;


//	_______________________________________________________
//
//	Miscellaneous common dialogs and UI elements

//	Post PGP preferences property sheets.
//
//	This function posts the "PGP Preferences" property
//	sheet dialog boxes.  Appropriate calls are made into
//	the pgpkeydb library to set the preferences.
//
//	Entry parameters :
//		Context			- PGP library context
//		hWndParent		- handle of parent window
//		iStartsheet		- zero-based index of property sheet
//					  page to display initially.
//					  use the below-defined constants
//		keysetMain		- main keyset, if available.  If not
//					  available, NULL is OK.
//
//	This function returns kPGPError_UserAbort (if the user
//	presses the cancel button)

//	preferences pages (used for "iStartsheet")

const
  PGPCL_GENERALPREFS		= 0;
  PGPCL_KEYRINGPREFS		= 1;
  PGPCL_EMAILPREFS		= 2;
  PGPCL_HOTKEYPREFS		= 3;
  PGPCL_KEYSERVERPREFS		= 4;
  PGPCL_CAPREFS			= 5;
  PGPCL_ADVANCEDPREFS		= 6;
  PGPCL_PREFPAGES7: Array[PGPCL_GENERALPREFS..PGPCL_ADVANCEDPREFS] of Longint = ($01, $02, $04, $08, $10, $20, $40);

var
  PGPclPreferences6: function(Context: pPGPContext; hWndParent: Longint;
			      iStartsheet: Longint; KeySetMain: pPGPKeySet): PGPError; cdecl;
  PGPclPreferences7: function(Context: pPGPContext; hWndParent: Longint;
			      iStartsheet: Longint; KeySetMain: pPGPKeySet): PGPError; stdcall;


//	______________________________________________
//
//  The following functions are wrappers for
//  the pfl prefs routines. These are needed so
//  groupwise plugin can access prefs (Delphi)
//  using code in the PGPcl DLL			// activated by idw

var
  PGPclGetPrefBoolean6: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; var Data: PGPBoolean): PGPError; cdecl;
  PGPclGetPrefBoolean7: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; var Data: PGPBoolean): PGPError; stdcall;
  PGPclSetPrefBoolean6: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; Data: PGPBoolean): PGPError; cdecl;
  PGPclSetPrefBoolean7: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; Data: PGPBoolean): PGPError; stdcall;
  PGPclGetPrefNumber6: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; var Data: PGPUInt32): PGPError; cdecl;
  PGPclGetPrefNumber7: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; var Data: PGPUInt32): PGPError; stdcall;
  PGPclSetPrefNumber6: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; Data: PGPUInt32): PGPError; cdecl;
  PGPclSetPrefNumber7: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; Data: PGPUInt32): PGPError; stdcall;
  PGPclGetPrefStringAlloc6: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; var Str: PChar): PGPError; cdecl;
  PGPclGetPrefStringAlloc7: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; var Str: PChar): PGPError; stdcall;
  PGPclGetPrefStringBuffer6: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex;
				      MaxSize: PGPSize; Str: PChar): PGPError; cdecl;
  PGPclGetPrefStringBuffer7: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex;
				      MaxSize: PGPSize; Str: PChar): PGPError; stdcall;
  PGPclSetPrefString6: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; Str: PChar): PGPError; cdecl;
  PGPclSetPrefString7: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; Str: PChar): PGPError; stdcall;
  PGPclGetPrefData6: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex;
			      var DataLength: PGPSize; var InBuffer: Pointer): PGPError; cdecl;
  PGPclGetPrefData7: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex;
			      var DataLength: PGPSize; var InBuffer: Pointer): PGPError; stdcall;
  PGPclSetPrefData6: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex;
			      DataLength: PGPSize; OutBuffer: Pointer): PGPError; cdecl;
  PGPclSetPrefData7: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex;
			      DataLength: PGPSize; OutBuffer: Pointer): PGPError; stdcall;
  PGPclRemovePref6: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex): PGPError; cdecl;
  PGPclRemovePref7: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex): PGPError; stdcall;

//	_______________________________________________________
//
//	Preference files convenience functions	// activated by idw

//	Open client preferences file and returns PrefRef to caller
//
//	Entry parameters :
//		memMgr			- memory manager to user for allocating fileref
//		pPrefRef		- pointer to buffer to receive PrefRef

var
  PGPclOpenClientPrefs6: function(MemMgr: pPGPMemoryMgr; var PGPPref: pPGPPref): PGPError; cdecl;
  PGPclOpenClientPrefs7: function(MemMgr: pPGPMemoryMgr; var PGPPref: pPGPPref): PGPError; stdcall;

//	Close, and optionally save changes to, open client preference file
//
//	Entry parameters :
//		PrefRef			- PrefRef of file to close
//		bSave			- TRUE => save changes before closing

var
  PGPclCloseClientPrefs6: function(PGPPref: pPGPPref; bSave: Longbool): PGPError; cdecl;
  PGPclCloseClientPrefs7: function(PGPPref: pPGPPref; bSave: Longbool): PGPError; stdcall;

//	Broadcast message that indicates that the prefs
//	have been changed and that others should reload from
//	disk.
//
//	Entry parameters :
//		lParam		- 32 value which is passed along as the LPARAM
//				  of the broadcast message.  Current usage
//				  is to set this to your process ID or your
//				  window handle so that you can ignore
//				  your own messages, if you want.  Set to
//				  zero to ensure all recipients process message.

//	broadcast message used to inform others of prefs changes

const
  RELOADPREFSMSG6 = 'PGPM_RELOADPREFS';
  RELOADPREFSMSG7 = 'PGP Prefs Reload';

var
  PGPclNotifyPrefsChanges6: procedure(lParam: Longint); cdecl;
  PGPclNotifyPrefsChanges7: procedure(lParam: Longint); stdcall;

//	Broadcast message that indicates that the keyring
//	has been changed and that others should reload from
//	disk.
//
//	Entry parameters :
//		lParam		- 32 value which is passed along as the LPARAM
//				  of the broadcast message.  Current usage
//				  is to set this to your process ID or your
//				  window handle so that you can ignore
//				  your own messages, if you want.  Set to
//				  zero to ensure all recipients process message.

//	broadcast message used to inform others of keyring changes

const
  RELOADKEYRINGMSG6 = 'PGPM_RELOADKEYRING';
  RELOADKEYRINGMSG7 = 'PGP Keyrings Reload';

var
  PGPclNotifyKeyringChanges6: procedure(lParam: Longint); cdecl;
  PGPclNotifyKeyringChanges7: procedure(wParam, lParam: Longint); stdcall;

//	Broadcast message that indicates that the keyserver prefs
//	have been changed and that others should reload from
//	disk.
//
//	Entry parameters :
//		lParam		- 32 value which is passed along as the LPARAM
//				  of the broadcast message.  Current usage
//				  is to set this to your process ID or your
//				  window handle so that you can ignore
//				  your own messages, if you want.  Set to
//				  zero to ensure all recipients process message.

//	broadcast message used to inform others of keyserver prefs changes

const
  RELOADKEYSERVERPREFSMSG6 = 'PGPM_RELOADKEYSERVERPREFS';
  RELOADKEYSERVERPREFSMSG7 = 'PGP Keyserver Prefs Reload';

var
  PGPclNotifyKeyserverPrefsChanges6: procedure(lParam: Longint); cdecl;
  PGPclNotifyKeyserverPrefsChanges7: procedure(lParam: Longint); stdcall;


//	_______________________________________________________
//
//	Miscellaneous common dialogs and UI elements

// option flag bits

const	// added by idw
  PGPCL_SINGLESELECTION		= 1;

var	// added by idw
  PGPclSelectKeysEx6: function(Context: pPGPContext;
			       tlsContext: pPGPtlsContext;
			       hWndParent: Longint;
			       pszPrompt: PChar;
			       KeySetToDisplay: pPGPKeySet;
			       KeySetMain: pPGPKeySet;
			       Flags: Longint;
			       var KeySetSelected: pPGPKeySet): PGPError; cdecl;
var	// added by idw
  PGPclSelectKeysEx7: function(Context: pPGPContext;
			       tlsContext: pPGPtlsContext;
			       hWndParent: Longint;
			       pszPrompt: PChar;
			       KeySetToDisplay: pPGPKeySet;
			       Flags: Longint;
			       var KeySetSelected: pPGPKeySet): PGPError; stdcall;

//	display keyset and allow user to select keys
//	- extended calling parameters -- added option flags
//
//	Entry parameters :
//		hWndParent		- handle of parent window
//		pszPrompt		- prompt string
//		KeySetToDisplay		- keyset containing keys to show
//		KeySetMain		- backing keyset
//		uFlags			- option flags (see below)
//		pKeySetSelected		- buffer to receive keyset ref of selected keys
//
//
//	Returns kPGPError_NoErr if no error
//

//	_______________________________________________________

// wrapper functions for version compatibility
function PGPclInitLibrary(Context: pPGPContext; Options: PGPFlags): PGPError;
function PGPclCloseLibrary: PGPError;
function PGPclPreferences(Context: pPGPContext; hWndParent: Longint;
			  iStartsheet: Longint; KeySetMain: pPGPKeySet): PGPError;
function PGPclGetPrefBoolean(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; var Data: PGPBoolean): PGPError;
function PGPclSetPrefBoolean(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; Data: PGPBoolean): PGPError;
function PGPclGetPrefNumber(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; var Data: PGPUInt32): PGPError;
function PGPclSetPrefNumber(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; Data: PGPUInt32): PGPError;
function PGPclGetPrefStringAlloc(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; var Str: PChar): PGPError;
function PGPclGetPrefStringBuffer(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; MaxSize: PGPSize; Str: PChar): PGPError;
function PGPclSetPrefString(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; Str: PChar): PGPError;
function PGPclGetPrefData(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex;
			  var DataLength: PGPSize; var InBuffer: Pointer): PGPError;
function PGPclSetPrefData(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex;
			  DataLength: PGPSize; OutBuffer: Pointer): PGPError;
function PGPclRemovePref(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex): PGPError;
function PGPclOpenClientPrefs(MemMgr: pPGPMemoryMgr; var PGPPref: pPGPPref): PGPError;
function PGPclCloseClientPrefs(PGPPref: pPGPPref; bSave: Longbool): PGPError;
procedure PGPclNotifyPrefsChanges(lParam: Longint);
procedure PGPclNotifyKeyringChanges(lParam: Longint);
procedure PGPclNotifyKeyserverPrefsChanges(lParam: Longint);
function PGPclSelectKeys(Context: pPGPContext;
			 tlsContext: pPGPtlsContext;
			 hWndParent: Longint;
			 pszPrompt: PChar;
			 KeySetToDisplay: pPGPKeySet;
			 KeySetMain: pPGPKeySet;
			 Flags: Longint;
			 var KeySetSelected: pPGPKeySet): PGPError;
function PGPGetKeyServerPrefs(Pref: pPGPPref;
			      var KeyServerList: pPGPKeyServerEntry;
			      var KeyServerCount: PGPUInt32): PGPError;
function PGPSetKeyServerPrefs(Pref: pPGPPref;
			      KeyServerList: pPGPKeyServerEntry;
			      KeyServerCount: PGPUInt32): PGPError;

implementation	// code modified by idw

function PGPclInitLibrary(Context: pPGPContext; Options: PGPFlags): PGPError;
var
  Dummy: pPGPContext;
begin
  if PGP7X then
    Result := PGPclInitLibrary7(Dummy, Options)
  else Result := PGPclInitLibrary6(Context);
end;

function PGPclCloseLibrary: PGPError;
begin
  if PGP7X then
    Result := PGPclCloseLibrary7
  else Result := PGPclCloseLibrary6;
end;

function PGPclPreferences(Context: pPGPContext; hWndParent: Longint;
			  iStartsheet: Longint; KeySetMain: pPGPKeySet): PGPError;
begin
  if PGP7X then
    Result := PGPclPreferences7(Context, hWndParent, PGPCL_PREFPAGES7[iStartsheet], KeySetMain)
  else Result := PGPclPreferences6(Context, hWndParent, iStartsheet, KeySetMain);
end;

function PGPclGetPrefBoolean(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; var Data: PGPBoolean): PGPError;
begin
  if PGP7X then
    Result := PGPclGetPrefBoolean7(PGPPref, PrefIndex, Data)
  else Result := PGPclGetPrefBoolean6(PGPPref, PrefIndex, Data);
end;

function PGPclSetPrefBoolean(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; Data: PGPBoolean): PGPError;
begin
  if PGP7X then
    Result := PGPclSetPrefBoolean7(PGPPref, PrefIndex, Data)
  else Result := PGPclSetPrefBoolean6(PGPPref, PrefIndex, Data);
end;

function PGPclGetPrefNumber(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; var Data: PGPUInt32): PGPError;
begin
  if PGP7X then
    Result := PGPclGetPrefNumber7(PGPPref, PrefIndex, Data)
  else Result := PGPclGetPrefNumber6(PGPPref, PrefIndex, Data);
end;

function PGPclSetPrefNumber(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; Data: PGPUInt32): PGPError;
begin
  if PGP7X then
    Result := PGPclSetPrefNumber7(PGPPref, PrefIndex, Data)
  else Result := PGPclSetPrefNumber6(PGPPref, PrefIndex, Data);
end;

function PGPclGetPrefStringAlloc(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; var Str: PChar): PGPError;
begin
  if PGP7X then
    Result := PGPclGetPrefStringAlloc7(PGPPref, PrefIndex, Str)
  else Result := PGPclGetPrefStringAlloc6(PGPPref, PrefIndex, Str);
end;

function PGPclGetPrefStringBuffer(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; MaxSize: PGPSize; Str: PChar): PGPError;
begin
  if PGP7X then
    Result := PGPclGetPrefStringBuffer7(PGPPref, PrefIndex, MaxSize, Str)
  else Result := PGPclGetPrefStringBuffer6(PGPPref, PrefIndex, MaxSize, Str);
end;

function PGPclSetPrefString(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; Str: PChar): PGPError;
begin
  if PGP7X then
    Result := PGPclSetPrefString7(PGPPref, PrefIndex, Str)
  else Result := PGPclSetPrefString6(PGPPref, PrefIndex, Str);
end;

function PGPclGetPrefData(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex;
			  var DataLength: PGPSize; var InBuffer: Pointer): PGPError;
begin
  if PGP7X then
    Result := PGPclGetPrefData7(PGPPref, PrefIndex, DataLength, InBuffer)
  else Result := PGPclGetPrefData6(PGPPref, PrefIndex, DataLength, InBuffer);
end;

function PGPclSetPrefData(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex;
			  DataLength: PGPSize; OutBuffer: Pointer): PGPError;
begin
  if PGP7X then
    Result := PGPclSetPrefData7(PGPPref, PrefIndex, DataLength, OutBuffer)
  else Result := PGPclSetPrefData6(PGPPref, PrefIndex, DataLength, OutBuffer);
end;

function PGPclRemovePref(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex): PGPError;
begin
  if PGP7X then
    Result := PGPclRemovePref7(PGPPref, PrefIndex)
  else Result := PGPclRemovePref6(PGPPref, PrefIndex);
end;

function PGPclOpenClientPrefs(MemMgr: pPGPMemoryMgr; var PGPPref: pPGPPref): PGPError;
begin
  if PGP7X then
    Result := PGPclOpenClientPrefs7(MemMgr, PGPPref)
  else Result := PGPclOpenClientPrefs6(MemMgr, PGPPref);
end;

function PGPclCloseClientPrefs(PGPPref: pPGPPref; bSave: Longbool): PGPError;
begin
  if PGP7X then
    Result := PGPclCloseClientPrefs7(PGPPref, bSave)
  else Result := PGPclCloseClientPrefs6(PGPPref, bSave);
end;

procedure PGPclNotifyPrefsChanges(lParam: Longint);
begin
  if PGP7X then
    PGPclNotifyPrefsChanges7(lParam)
  else PGPclNotifyPrefsChanges6(lParam);
end;

procedure PGPclNotifyKeyringChanges(lParam: Longint);
begin
  if PGP7X then
    PGPclNotifyKeyringChanges7(InitFlags, lParam)
  else PGPclNotifyKeyringChanges6(lParam);
end;

procedure PGPclNotifyKeyserverPrefsChanges(lParam: Longint);
begin
  if PGP7X then
    PGPclNotifyKeyserverPrefsChanges7(lParam)
  else PGPclNotifyKeyserverPrefsChanges6(lParam);
end;

function PGPclSelectKeys(Context: pPGPContext;
			 tlsContext: pPGPtlsContext;
			 hWndParent: Longint;
			 pszPrompt: PChar;
			 KeySetToDisplay: pPGPKeySet;
			 KeySetMain: pPGPKeySet;
			 Flags: Longint;
			 var KeySetSelected: pPGPKeySet): PGPError;
begin
  if PGP7X then begin
    Result := PGPclSelectKeysEx7(Context, tlsContext, hWndParent, pszPrompt,
				 KeySetToDisplay, Flags, KeySetSelected);
  end
  else begin
    Result := PGPclSelectKeysEx6(Context, tlsContext, hWndParent, pszPrompt,
				 KeySetToDisplay, KeySetMain, Flags, KeySetSelected);
  end;
end;

function PGPGetKeyServerPrefs(Pref: pPGPPref;
			      var KeyServerList: pPGPKeyServerEntry;
			      var KeyServerCount: PGPUInt32): PGPError;
var
  DataLength: PGPSize;
begin
  if PGP7X then
    Result := PGPclGetPrefData7(Pref, kPGPPrefKeyServerList, DataLength, pointer(KeyServerList))
  else Result := PGPclGetPrefData6(Pref, kPGPPrefKeyServerList, DataLength, pointer(KeyServerList));
  KeyServerCount := DataLength div SizeOf(TPGPKeyServerEntry);
end;

function PGPSetKeyServerPrefs(Pref: pPGPPref;
			      KeyServerList: pPGPKeyServerEntry;
			      KeyServerCount: PGPUInt32): PGPError;
var
  DataLength: PGPSize;
begin
  DataLength := KeyServerCount * SizeOf(TPGPKeyServerEntry);
  if PGP7X then
    Result := PGPclSetPrefData7(Pref, kPGPPrefKeyServerList, DataLength, pointer(KeyServerList))
  else Result := PGPclSetPrefData6(Pref, kPGPPrefKeyServerList, DataLength, pointer(KeyServerList));
end;

initialization

  if PGPInitErrorCode = ieNone then begin
    if PGP7X then begin
      PGPclInitLibrary7 := GetProcAddress(hPGPclLib, '_PGPclInitLibrary@8');
      PGPclCloseLibrary7 := GetProcAddress(hPGPclLib, '_PGPclCloseLibrary@0');
      PGPclPreferences7 := GetProcAddress(hPGPclLib, '_PGPclPreferences@16');
      PGPclGetPrefBoolean7 := GetProcAddress(hPGPclLib, '_PGPclGetPrefBoolean@12');
      PGPclSetPrefBoolean7 := GetProcAddress(hPGPclLib, '_PGPclSetPrefBoolean@12');
      PGPclGetPrefNumber7 := GetProcAddress(hPGPclLib, '_PGPclGetPrefNumber@12');
      PGPclSetPrefNumber7 := GetProcAddress(hPGPclLib, '_PGPclSetPrefNumber@12');
      PGPclGetPrefStringAlloc7 := GetProcAddress(hPGPclLib, '_PGPclGetPrefStringAlloc@12');
      PGPclGetPrefStringBuffer7 := GetProcAddress(hPGPclLib, '_PGPclGetPrefStringBuffer@16');
      PGPclSetPrefString7 := GetProcAddress(hPGPclLib, '_PGPclSetPrefString@12');
      PGPclGetPrefData7 := GetProcAddress(hPGPclLib, '_PGPclGetPrefData@16');
      PGPclSetPrefData7 := GetProcAddress(hPGPclLib, '_PGPclSetPrefData@16');
      PGPclRemovePref7 := GetProcAddress(hPGPclLib, '_PGPclRemovePref@8');
      PGPclOpenClientPrefs7 := GetProcAddress(hPGPclLib, '_PGPclPeekClientLibPrefRefs@8');
      PGPclCloseClientPrefs7 := GetProcAddress(hPGPclLib, '_PGPclFlushClientLibPrefs@8');
      PGPclNotifyPrefsChanges7 := GetProcAddress(hPGPclLib, '_PGPclNotifyPrefsChanges@4');
      PGPclNotifyKeyringChanges7 := GetProcAddress(hPGPclLib, '_PGPclNotifyKeyringChanges@8');
      PGPclNotifyKeyserverPrefsChanges7 := GetProcAddress(hPGPclLib, '_PGPclNotifyKeyserverPrefsChanges@4');
      PGPclSelectKeysEx7 := GetProcAddress(hPGPclLib, '_PGPclSelectKeys@28');
      WM_PGPReloadPrefs := RegisterWindowMessage(RELOADPREFSMSG7);
      WM_PGPReloadKeyring := RegisterWindowMessage(RELOADKEYRINGMSG7);
      WM_PGPReloadKeyserverPrefs := RegisterWindowMessage(RELOADKEYSERVERPREFSMSG7);
    end
    else begin
      PGPclInitLibrary6 := GetProcAddress(hPGPclLib, 'PGPclInitLibrary');
      PGPclCloseLibrary6 := GetProcAddress(hPGPclLib, 'PGPclCloseLibrary');
      PGPclPreferences6 := GetProcAddress(hPGPclLib, 'PGPclPreferences');
      PGPclGetPrefBoolean6 := GetProcAddress(hPGPclLib, 'PGPclGetPrefBoolean');
      PGPclSetPrefBoolean6 := GetProcAddress(hPGPclLib, 'PGPclSetPrefBoolean');
      PGPclGetPrefNumber6 := GetProcAddress(hPGPclLib, 'PGPclGetPrefNumber');
      PGPclSetPrefNumber6 := GetProcAddress(hPGPclLib, 'PGPclSetPrefNumber');
      PGPclGetPrefStringAlloc6 := GetProcAddress(hPGPclLib, 'PGPclGetPrefStringAlloc');
      PGPclGetPrefStringBuffer6 := GetProcAddress(hPGPclLib, 'PGPclGetPrefStringBuffer');
      PGPclSetPrefString6 := GetProcAddress(hPGPclLib, 'PGPclSetPrefString');
      PGPclGetPrefData6 := GetProcAddress(hPGPclLib, 'PGPclGetPrefData');
      PGPclSetPrefData6 := GetProcAddress(hPGPclLib, 'PGPclSetPrefData');
      PGPclRemovePref6 := GetProcAddress(hPGPclLib, 'PGPclRemovePref');
      PGPclOpenClientPrefs6 := GetProcAddress(hPGPclLib, 'PGPclOpenClientPrefs');
      PGPclCloseClientPrefs6 := GetProcAddress(hPGPclLib, 'PGPclCloseClientPrefs');
      PGPclNotifyPrefsChanges6 := GetProcAddress(hPGPclLib, 'PGPclNotifyPrefsChanges');
      PGPclNotifyKeyringChanges6 := GetProcAddress(hPGPclLib, 'PGPclNotifyKeyringChanges');
      PGPclNotifyKeyserverPrefsChanges6 := GetProcAddress(hPGPclLib, 'PGPclNotifyKeyserverPrefsChanges');
      PGPclSelectKeysEx6 := GetProcAddress(hPGPclLib, 'PGPclSelectKeysEx');
      WM_PGPReloadPrefs := RegisterWindowMessage(RELOADPREFSMSG6);
      WM_PGPReloadKeyring := RegisterWindowMessage(RELOADKEYRINGMSG6);
      WM_PGPReloadKeyserverPrefs := RegisterWindowMessage(RELOADKEYSERVERPREFSMSG6);
    end;
  end;

end.

