{$J+,Z4}
unit pgpKeyServer;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the "Borland Delphi Runtime Library PGPsdk" released 10 Apr }
{ 2000, available at http://www.oz.net/~srheller/dpgp/sdk/.                        }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpKeyServer.pas based on pgpKeyServer.h                    }
{ from the PGP sources which are Copyright (C) Network Associates Inc.             }
{ and affiliated companies.                                                        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ Several functions removed, all functions taking OptionLists modified             }
{ according to a suggestion by Steven R. Heller, for details see pgpOptionList.pas }
{                                                                                  }
{**********************************************************************************}

interface

uses
  pgpBase,
  pgpPubTypes,
  pgpEvents,
  pgpTLS;

type
  PGPKeyServerState = PGPEnumType;
const
  kPGPKeyServerState_Invalid				= 00;
  kPGPKeyServerState_Opening				= 01;
  kPGPKeyServerState_Querying				= 02;
  kPGPKeyServerState_ReceivingResults			= 03;
  kPGPKeyServerState_ProcessingResults			= 04;
  kPGPKeyServerState_Uploading				= 05;
  kPGPKeyServerState_Deleting				= 06;
  kPGPKeyServerState_Disabling				= 07;
  kPGPKeyServerState_Closing				= 08;

  kPGPKeyServerState_TLSUnableToSecureConnection	= 09;
  kPGPKeyServerState_TLSConnectionSecured		= 10;

type
  PGPKeyServerProtocol = PGPEnumType;
const
  kPGPKeyServerProtocol_Invalid		= 0;
  kPGPKeyServerProtocol_LDAP		= 1;
  kPGPKeyServerProtocol_HTTP		= 2;
  kPGPKeyServerProtocol_LDAPS		= 3;
  kPGPKeyServerProtocol_HTTPS		= 4;

type
  PGPKeyServerClass = PGPEnumType;
const
  // both
  kPGPKeyServerClass_Invalid		= 0;
  kPGPKeyServerClass_PGP    		= 1;

  {// PGP 6.5.X
  kPGPKeyServerClass_NetToolsCA		= 2;
  kPGPKeyServerClass_Verisign		= 3;
  kPGPKeyServerClass_Entrust		= 4;
  }

  {// PGP 7.X
  kPGPKeyServerClass_LDAPX509		= 2;
  kPGPKeyServerClass_LDAPPGP		= 3;
  kPGPKeyServerClass_NetToolsCA		= 10;
  kPGPKeyServerClass_Verisign		= 11;
  kPGPKeyServerClass_Entrust		= 12;
  kPGPKeyServerClass_Netscape		= 13;
  kPGPKeyServerClass_Microsoft		= 14;
  }

// These are only valid for LDAP keyservers
type
  PGPKeyServerKeySpace = PGPEnumType;
const
  kPGPKeyServerKeySpace_Invalid		= 0;
  kPGPKeyServerKeySpace_Default		= 1;
  kPGPKeyServerKeySpace_Normal		= 2;
  kPGPKeyServerKeySpace_Pending		= 3;

// These are only valid for LDAP keyservers
type
  PGPKeyServerAccessType = PGPEnumType;
const
  kPGPKeyServerAccessType_Invalid	= 0;
  kPGPKeyServerAccessType_Default	= 1;
  kPGPKeyServerAccessType_Normal	= 2;
  kPGPKeyServerAccessType_Administrator	= 3;

{ PGPKeyServerMonitorValues are null terminated linked lists.
  The values member is a null terminated array of PChar(s). }
type
  pPGPKeyServerMonitorValues = ^TPGPKeyServerMonitorValues;
  TPGPKeyServerMonitorValues = Record
    Name   : PChar;
    Values : pPChar;
    Next   : pPGPKeyServerMonitorValues;
  end;

type
  pPGPKeyServerMonitor = ^TPGPKeyServerMonitor;
  TPGPKeyServerMonitor = Record
    KeyServerRef : pPGPKeyServer;
    ValuesHead   : pPGPKeyServerMonitorValues;
  end;

type
  pPGPKeyServerThreadStorage = Pointer;

{ Use the idle event handler to receive periodic idle events during
  network calls. Usually this is used only in non-preemptive multi-tasking
  OSes to allow yielding in threads. Pre-emptive multi-tasking systems
  should probably not use the call as it interrupts the efficient wait state
  of threads waiting on network calls.
  Idle event handlers need to be added on a per thread basis.
  Returning an error from the idle event handler will cause the keyserver
  to quit processing and to return a kPGPError_UserAbort. }
var
  PGPSetKeyServerIdleEventHandler: function(InCallback: TPGPEventHandlerProcPtr; InUserData: PGPUserValue): PGPError; cdecl;
  PGPGetKeyServerIdleEventHandler: function(OutCallback: TPGPEventHandlerProcPtr; OutUserData: PGPUserValue): PGPError; cdecl;

// Network library options
var
  // both
  PGPONetURL: function(Context: pPGPContext; URL: PChar): pPGPOptionList; cdecl;
  PGPONetHostName: function(Context: pPGPContext; HostName: PChar; Port: PGPUInt16): pPGPOptionList; cdecl;
  PGPONetHostAddress: function(Context: pPGPContext; HostAddress: PGPUInt32; Port: PGPUInt16): pPGPOptionList; cdecl;
  PGPOKeyServerProtocol: function(Context: pPGPContext; ServerProtocol: PGPKeyServerProtocol): pPGPOptionList; cdecl;
  PGPOKeyServerKeySpace: function(Context: pPGPContext; ServerSpace: PGPKeyServerKeySpace): pPGPOptionList; cdecl;
  PGPOKeyServerAccessType: function(Context: pPGPContext; AccessType: PGPKeyServerAccessType): pPGPOptionList; cdecl;
  {// PGP 6.5.X
  PGPOKeyServerCAKey: function(Context: pPGPContext; CaKey: pPGPKey): pPGPOptionList; cdecl;
  PGPOKeyServerRequestKey: function(Context: pPGPContext; RequestKey: pPGPKey): pPGPOptionList; cdecl;
  PGPOKeyServerSearchKey: function(Context: pPGPContext; SearchKey: pPGPKey): pPGPOptionList; cdecl;}
  {// PGP 7.X
  PGPOKeyServerCAKey: function(Context: pPGPContext; CaKey: pPGPKeyDBObj): pPGPOptionList; cdecl;
  PGPOKeyServerRequestKey: function(Context: pPGPContext; RequestKey: pPGPKeyDBObj): pPGPOptionList; cdecl;
  PGPOKeyServerSearchKey: function(Context: pPGPContext; SearchKey: pPGPKeyDBObj): pPGPOptionList; cdecl;}
  // both
  PGPOKeyServerSearchFilter: function(Context: pPGPContext; SearchFilter: pPGPFilter): pPGPOptionList; cdecl;

// Static storage creation
var
  PGPKeyServerCreateThreadStorage: function(var OutPreviousStorage: pPGPKeyServerThreadStorage): PGPError; cdecl;
  PGPKeyServerDisposeThreadStorage: function(InPreviousStorage: pPGPKeyServerThreadStorage): PGPError; cdecl;

// Initialize and close the keyserver library
var
  PGPKeyServerInit: function: PGPError; cdecl;
  PGPKeyServerCleanup: function: PGPError; cdecl;

// Creating and freeing a keyserver ref
var
  PGPNewKeyServer: function(InContext: pPGPContext; InClass: PGPKeyServerClass; var OutKeyServer: pPGPKeyServer;
			    OptionsList, LastOption: pPGPOptionList): PGPError; cdecl;
  PGPFreeKeyServer: function(InKeyServerRef: pPGPKeyServer): PGPError; cdecl;
  PGPIncKeyServerRefCount: function(InKeyServerRef: pPGPKeyServer): PGPError; cdecl;

{ Set and get the keyserver's event handler. Note that returning an error
  for a keyserver event will abort the current call. }
var
  PGPSetKeyServerEventHandler: function(InKeyServerRef: pPGPKeyServer; InCallback: TPGPEventHandlerProcPtr;
					InUserData: PGPUserValue): PGPError; cdecl;
  PGPGetKeyServerEventHandler: function(InKeyServerRef: pPGPKeyServer; OutCallback: TPGPEventHandlerProcPtr;
					OutUserData: PGPUserValue): PGPError; cdecl;

{ Canceling a call to a keyserver. This is the only call that can be made
  to a keyserver that is currently in another call. Also, once you have
  returned from a canceled call, you may only close the keyserver. }
var
  PGPCancelKeyServerCall: function(InKeyServerRef: pPGPKeyServer): PGPError; cdecl;

{ Opening and closing the keyserver. A keyserver ref can be opened and
  closed multiple times as necessary. }
var
  PGPKeyServerOpen: function(InKeyServerRef: pPGPKeyServer; InTLSSessionRef: pPGPtlsSession): PGPError; cdecl;
  PGPKeyServerClose: function(InKeyServerRef: pPGPKeyServer): PGPError; cdecl;

{ Get keyserver info. }
var
  PGPGetKeyServerTLSSession: function(InKeyServerRef: pPGPKeyServer; var OutTLSSessionRef: pPGPtlsSession): PGPError; cdecl;
  PGPGetKeyServerProtocol: function(InKeyServerRef: pPGPKeyServer; var OutType: PGPKeyServerProtocol): PGPError; cdecl;
  PGPGetKeyServerAccessType: function(InKeyServerRef: pPGPKeyServer; var OutAccessType: PGPKeyServerAccessType): PGPError; cdecl;
  PGPGetKeyServerKeySpace: function(InKeyServerRef: pPGPKeyServer; var OutKeySpace: PGPKeyServerKeySpace): PGPError; cdecl;
  PGPGetKeyServerPort: function(InKeyServerRef: pPGPKeyServer; var OutPort: PGPUInt16): PGPError; cdecl;

  // Use PGPFreeData to free OutHostName
  PGPGetKeyServerHostName: function(InKeyServerRef: pPGPKeyServer; OutHostName: PChar): PGPError; cdecl;

  PGPGetKeyServerAddress: function(InKeyServerRef: pPGPKeyServer; var OutAddress: PGPUInt32): PGPError; cdecl;

  // Use PGPFreeData to free OutPath
  PGPGetKeyServerPath: function(InKeyServerRef: pPGPKeyServer; OutPath: PChar): PGPError; cdecl;

  PGPGetKeyServerContext: function(InKeyServerRef: pPGPKeyServer): pPGPContext; cdecl;

{ If there was an error string returned from the server, you can get it with
  this function. Note that if there is no string, the function will return
  kPGPError_NoErr and OutErrorString will be NIL }
  // Use PGPFreeData to free OutErrorString
  PGPGetLastKeyServerErrorString: function(InKeyServerRef: pPGPKeyServer; OutErrorString: PChar): PGPError; cdecl;

// These functions may be used with both HTTP and LDAP keyservers
var
  {// PGP 6.5.X
  PGPQueryKeyServer: function(InKeyServerRef: pPGPKeyServer; InFilterRef: pPGPFilter;
			      var OutFoundKeys: pPGPKeySet): PGPError; cdecl;}
  {// PGP 7.X
  PGPQueryKeyServer: function(InKeyServerRef: pPGPKeyServer; InFilterRef: pPGPFilter;
			      var OutFoundKeys: pPGPKeyDB): PGPError; cdecl;}
  // both
  PGPUploadToKeyServer: function(InKeyServerRef: pPGPKeyServer; InKeysToUpload: pPGPKeySet;
    				 var OutKeysThatFailed: pPGPKeySet): PGPError; cdecl;

// These functions may only be used with LDAP keyservers
var
  PGPDeleteFromKeyServer: function(InKeyServerRef: pPGPKeyServer; InKeysToDelete: pPGPKeySet;
				   var OutKeysThatFailed: pPGPKeySet): PGPError; cdecl;
  PGPDisableFromKeyServer: function(InKeyServerRef: pPGPKeyServer; InKeysToDisable: pPGPKeySet;
    				    var OutKeysThatFailed: pPGPKeySet): PGPError; cdecl;

implementation	// code modified by idw

uses
  Windows;

initialization

  if PGPInitErrorCode=ieNone then begin
    PGPSetKeyServerIdleEventHandler:=GetProcAddress(hPGPsdkNLLib, 'PGPSetKeyServerIdleEventHandler');
    PGPGetKeyServerIdleEventHandler:=GetProcAddress(hPGPsdkNLLib, 'PGPGetKeyServerIdleEventHandler');
    PGPONetURL:=GetProcAddress(hPGPsdkNLLib, 'PGPONetURL');
    PGPONetHostName:=GetProcAddress(hPGPsdkNLLib, 'PGPONetHostName');
    PGPONetHostAddress:=GetProcAddress(hPGPsdkNLLib, 'PGPONetHostAddress');
    PGPOKeyServerProtocol:=GetProcAddress(hPGPsdkNLLib, 'PGPOKeyServerProtocol');
    PGPOKeyServerKeySpace:=GetProcAddress(hPGPsdkNLLib, 'PGPOKeyServerKeySpace');
    PGPOKeyServerAccessType:=GetProcAddress(hPGPsdkNLLib, 'PGPOKeyServerAccessType');
    {PGPOKeyServerCAKey:=GetProcAddress(hPGPsdkNLLib, 'PGPOKeyServerCAKey');}
    {PGPOKeyServerRequestKey:=GetProcAddress(hPGPsdkNLLib, 'PGPOKeyServerRequestKey');}
    {PGPOKeyServerSearchKey:=GetProcAddress(hPGPsdkNLLib, 'PGPOKeyServerSearchKey');}
    PGPOKeyServerSearchFilter:=GetProcAddress(hPGPsdkNLLib, 'PGPOKeyServerSearchFilter');
    PGPKeyServerCreateThreadStorage:=GetProcAddress(hPGPsdkNLLib, 'PGPKeyServerCreateThreadStorage');
    PGPKeyServerDisposeThreadStorage:=GetProcAddress(hPGPsdkNLLib, 'PGPKeyServerDisposeThreadStorage');
    PGPKeyServerInit:=GetProcAddress(hPGPsdkNLLib, 'PGPKeyServerInit');
    PGPKeyServerCleanup:=GetProcAddress(hPGPsdkNLLib, 'PGPKeyServerCleanup');
    PGPNewKeyServer:=GetProcAddress(hPGPsdkNLLib, 'PGPNewKeyServer');
    PGPFreeKeyServer:=GetProcAddress(hPGPsdkNLLib, 'PGPFreeKeyServer');
    PGPIncKeyServerRefCount:=GetProcAddress(hPGPsdkNLLib, 'PGPIncKeyServerRefCount');
    PGPSetKeyServerEventHandler:=GetProcAddress(hPGPsdkNLLib, 'PGPSetKeyServerEventHandler');
    PGPGetKeyServerEventHandler:=GetProcAddress(hPGPsdkNLLib, 'PGPGetKeyServerEventHandler');
    PGPCancelKeyServerCall:=GetProcAddress(hPGPsdkNLLib, 'PGPCancelKeyServerCall');
    PGPKeyServerOpen:=GetProcAddress(hPGPsdkNLLib, 'PGPKeyServerOpen');
    PGPKeyServerClose:=GetProcAddress(hPGPsdkNLLib, 'PGPKeyServerClose');
    PGPGetKeyServerTLSSession:=GetProcAddress(hPGPsdkNLLib, 'PGPGetKeyServerTLSSession');
    PGPGetKeyServerProtocol:=GetProcAddress(hPGPsdkNLLib, 'PGPGetKeyServerProtocol');
    PGPGetKeyServerAccessType:=GetProcAddress(hPGPsdkNLLib, 'PGPGetKeyServerAccessType');
    PGPGetKeyServerKeySpace:=GetProcAddress(hPGPsdkNLLib, 'PGPGetKeyServerKeySpace');
    PGPGetKeyServerPort:=GetProcAddress(hPGPsdkNLLib, 'PGPGetKeyServerPort');
    PGPGetKeyServerHostName:=GetProcAddress(hPGPsdkNLLib, 'PGPGetKeyServerHostName');
    PGPGetKeyServerAddress:=GetProcAddress(hPGPsdkNLLib, 'PGPGetKeyServerAddress');
    PGPGetKeyServerPath:=GetProcAddress(hPGPsdkNLLib, 'PGPGetKeyServerPath');
    PGPGetKeyServerContext:=GetProcAddress(hPGPsdkNLLib, 'PGPGetKeyServerContext');
    PGPGetLastKeyServerErrorString:=GetProcAddress(hPGPsdkNLLib, 'PGPGetLastKeyServerErrorString');
    {PGPQueryKeyServer:=GetProcAddress(hPGPsdkNLLib, 'PGPQueryKeyServer');}
    PGPUploadToKeyServer:=GetProcAddress(hPGPsdkNLLib, 'PGPUploadToKeyServer');
    PGPDeleteFromKeyServer:=GetProcAddress(hPGPsdkNLLib, 'PGPDeleteFromKeyServer');
    PGPDisableFromKeyServer:=GetProcAddress(hPGPsdkNLLib, 'PGPDisableFromKeyServer');
  end;

end.

