{$J+,Z4}
unit pgpUtilities;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the "Borland Delphi Runtime Library PGPsdk" released 10 Apr }
{ 2000, available at http://www.oz.net/~srheller/dpgp/sdk/.                        }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpUtilities.pas based on pgpUtilities.h                    }
{ from the PGP sources which are Copyright (C) Network Associates Inc.             }
{ and affiliated companies.                                                        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ Some functions removed, Init/Cleanup functions moved to context related files,   }
{ PGPFreeData moved to pgpMemoryMgr.pas                                            }
{                                                                                  }
{**********************************************************************************}

interface

uses
  pgpBase,
  pgpPubTypes;

type
  TIME_T = Longint;

const
  kPGPsdkAPIVersion = $01000000;

{
  API version:
  Top byte is major, next 3 nibbles minor, next 2 bug fix,
  last nibble reserved:  0xMMmmmrrR

  example: 1.0.0 = 0x01000000

  // PGP 6.5.X
  0x01000000    SDK 1.0.0	// PGP 5.5
  0x02000000    SDK 1.1.0
  0x02000010    SDK 1.1.1
  0x03000000    SDK 1.5.0	// PGP 6.0
  0x03000010    SDK 1.5.1
  0x03000020    SDK 1.5.2
  0x03002000    SDK 1.7.0	// PGP 6.5
  0x03002010    SDK 1.7.1
  0x03002020    SDK 1.7.2
  // PGP 7.X
  0x02000000	SDK 2.0.0	// PGP 7.0
  0x02000100	SDK 2.0.1
  0x02010100	SDK 2.1.1
  // PGP 8.X
  0x03000000	SDK 3.0.0	// PGP 8.0
}

var	// added by idw from pgpErrors.h
  PGPGetErrorString: function(TheErrorCode: PGPError; AvailLength: PGPSize; TheErrorText: PChar): PGPError; cdecl;

var
  PGPNewContext: function(ClientAPIVersion: PGPUInt32; var NewContext: pPGPContext): PGPError; cdecl;
  PGPFreeContext: function(Context: pPGPContext): PGPError; cdecl;
  PGPGetContextUserValue: function(Context: pPGPContext; var UserValue: PGPUserValue): PGPError; cdecl;
  PGPSetContextUserValue: function(Context: pPGPContext; UserValue: PGPUserValue): PGPError; cdecl;
  PGPContextGetRandomBytes: function(Context: pPGPContext; Buf: Pointer; Len: PGPSize): PGPError; cdecl;
  PGPCopyFileSpec: function(FileRef: pPGPFileSpec; var Ref: pPGPFileSpec): PGPError; cdecl;
  PGPFreeFileSpec: function(FileRef: pPGPFileSpec): PGPError; cdecl;
  PGPNewFileSpecFromFullPath: function(Context: pPGPContext; Path: PChar; var Ref: pPGPFileSpec): PGPError; cdecl;
  PGPGetFullPathFromFileSpec: function(FileRef: pPGPFileSpec; var FullPath: PChar): PGPError; cdecl;
  PGPGetTime: function: PGPTime; cdecl;
  PGPGetStdTimeFromPGPTime: function(theTime: PGPTime): TIME_T; cdecl;
  PGPGetPGPTimeFromStdTime: function(theTime: TIME_T): PGPTime; cdecl;
  PGPGetYMDFromPGPTime: procedure(TheTime: PGPTime; var Year: PGPUINT16; var Month: PGPUINT16; var Day: PGPUINT16); cdecl;

implementation	// code modified by idw

uses
  Windows;

initialization

  if PGPInitErrorCode=ieNone then begin
    PGPGetErrorString:=GetProcAddress(hPGPsdkLib, 'PGPGetErrorString');
    PGPNewContext:=GetProcAddress(hPGPsdkLib, 'PGPNewContext');
    PGPFreeContext:=GetProcAddress(hPGPsdkLib, 'PGPFreeContext');
    PGPGetContextUserValue:=GetProcAddress(hPGPsdkLib, 'PGPGetContextUserValue');
    PGPSetContextUserValue:=GetProcAddress(hPGPsdkLib, 'PGPSetContextUserValue');
    PGPContextGetRandomBytes:=GetProcAddress(hPGPsdkLib, 'PGPContextGetRandomBytes');
    PGPCopyFileSpec:=GetProcAddress(hPGPsdkLib, 'PGPCopyFileSpec');
    PGPFreeFileSpec:=GetProcAddress(hPGPsdkLib, 'PGPFreeFileSpec');
    PGPNewFileSpecFromFullPath:=GetProcAddress(hPGPsdkLib, 'PGPNewFileSpecFromFullPath');
    PGPGetFullPathFromFileSpec:=GetProcAddress(hPGPsdkLib, 'PGPGetFullPathFromFileSpec');
    PGPGetTime:=GetProcAddress(hPGPsdkLib, 'PGPGetTime');
    PGPGetStdTimeFromPGPTime:=GetProcAddress(hPGPsdkLib, 'PGPGetStdTimeFromPGPTime');
    PGPGetPGPTimeFromStdTime:=GetProcAddress(hPGPsdkLib, 'PGPGetPGPTimeFromStdTime');
    PGPGetYMDFromPGPTime:=GetProcAddress(hPGPsdkLib, 'PGPGetYMDFromPGPTime');
  end;

end.

