{$J+,Z4}
unit pgpOptionList;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the "Borland Delphi Runtime Library PGPsdk" released 10 Apr }
{ 2000, available at http://www.oz.net/~srheller/dpgp/sdk/.                        }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw"),            }
{ Graham Grieve from Kestral Computing <http://www.kestral.com.au/devtools/pgp/>   }
{                                                                                  }
{ The original file is pgpOptionList.pas based on pgpOptionList.h                  }
{ from the PGP sources which are Copyright (C) Network Associates Inc.             }
{ and affiliated companies.                                                        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ Lots of constants and comments removed, TPGPEventHandlerProcPtr moved to         }
{ pgpEvent.pas, PGPAddJobOptions added and other decalarations removed,            }
{ PGPBuildOptionList and PGPAppendOptionList implementations changed               }
{ according to a suggestion by Steven R. Heller: instead of passing open arrays    }
{ use PGPBuildOptionList and PGPAppendOptionList to create OptionLists and pass    }
{ PGPOLastOption() as a separate function parameter, see comments below            }
{                                                                                  }
{**********************************************************************************}

interface

uses
  pgpBase,
  pgpPubTypes,
  pgpEvents,
  pgpKeys;

type
  PGPExportFormat = PGPEnumType;
const
  kPGPExportFormat_Basic			= 1;
  kPGPExportFormat_Complete			= 255;
  kPGPExportFormat_TokenKeyContainer		= 256;		// PGP 7.X
  kPGPExportFormat_X509Cert			= 10000;

  kPGPExportFormat_X509CertReq			= 11000;
  kPGPExportFormat_NetToolsCAV1_CertReq		= 11001;
  kPGPExportFormat_VerisignV1_CertReq		= 11002;
  kPGPExportFormat_EntrustV1_CertReq		= 11003;
  kPGPExportFormat_NetscapeV1_CertReq		= 11004;	// PGP 7.X
  kPGPExportFormat_MicrosoftV1_CertReq		= 11005;	// PGP 7.X

  kPGPExportFormat_X509GetCertInitial		= 11010;
  kPGPExportFormat_NetToolsCAV1_GetCertInitial	= 11011;
  kPGPExportFormat_VerisignV1_GetCertInitial	= 11012;
  kPGPExportFormat_EntrustV1_GetCertInitial	= 11013;
  kPGPExportFormat_NetscapeV1_GetCertInitial	= 11014;	// PGP 7.X
  kPGPExportFormat_MicrosoftV1_GetCertInitial	= 11015;	// PGP 7.X

  kPGPExportFormat_X509GetCRL			= 11020;
  kPGPExportFormat_NetToolsCAV1_GetCRL		= 11021;
  kPGPExportFormat_VerisignV1_GetCRL		= 11022;
  kPGPExportFormat_EntrustV1_GetCRL		= 11023;
  kPGPExportFormat_NetscapeV1_GetCRL		= 11024;	// PGP 7.X
  kPGPExportFormat_MicrosoftV1_GetCRL		= 11025;	// PGP 7.X

var
  // both
  PGPNewOptionList: function(Context: pPGPContext; var OptionList: pPGPOptionList): PGPError; cdecl;
  PGPCopyOptionList: function(OptionListOrig: pPGPOptionList; var OptionListCopy: pPGPOptionList): PGPError; cdecl;
  PGPFreeOptionList: function(OptionList: pPGPOptionList): PGPError; cdecl;
  PGPAddJobOptions: function(TheJob: pPGPJob; OptionList, LastOption: pPGPOptionList): PGPError; cdecl;

  { Common encode/decode options }
  // both
  PGPOInputBuffer: function(Context: pPGPContext; Buffer: PChar;
			    BufferSize: PGPSize): pPGPOptionList; cdecl;
  PGPOInputFile: function(Context: pPGPContext; FileSpec: pPGPFileSpec): pPGPOptionList; cdecl;
  PGPODiscardOutput: function(Context: pPGPContext; DiscardOutput: PGPBoolean): pPGPOptionList; cdecl;
  PGPOAllocatedOutputBuffer: function(Context: pPGPContext; var Buffer: PChar;
				      MaximumBufLength: PGPSize; var ActualBufLength: PGPSize): pPGPOptionList; cdecl;
  PGPOOutputBuffer: function(Context: pPGPContext; Buffer: PChar;
			     BufferSize: PGPSize; var OutputDataLength: PGPSize): pPGPOptionList; cdecl;
  PGPOOutputFile: function(Context: pPGPContext; FileSpec: pPGPFileSpec): pPGPOptionList; cdecl;
  PGPOPGPMIMEEncoding: function(Context: pPGPContext; MimeEncoding: PGPBoolean; var MimeBodyOffset: PGPSize;
				MimeSeparator: pMimeSeparator): pPGPOptionList; cdecl;
  PGPOOmitMIMEVersion: function(Context: pPGPContext; OmitVersion: PGPBoolean): pPGPOptionList; cdecl;
  PGPOLocalEncoding: function(Context: pPGPContext; LocalEncode: TPGPLocalEncodingFlags): pPGPOptionList; cdecl;
  PGPOOutputLineEndType: function(Context: pPGPContext; LineEnd: PGPLineEndType): pPGPOptionList; cdecl;
  PGPODetachedSig: function(Context: pPGPContext; Options: pPGPOptionList;
			    LastOption: pPGPOptionList): pPGPOptionList; cdecl;

  { Common encrypting/signing options }
  // both
  PGPOConventionalEncrypt: function(Context: pPGPContext; Options: pPGPOptionList;
				    LastOption: pPGPOptionList): pPGPOptionList; cdecl;
  // both
  PGPOCipherAlgorithm: function(Context: pPGPContext; Algorithm: PGPCipherAlgorithm): pPGPOptionList; cdecl;
  // PGP 6.5.X
  PGPOEncryptToKey: function(Context: pPGPContext; Key: pPGPKey): pPGPOptionList; cdecl;
  // PGP 7.X
  {PGPOEncryptToKeyDBObj: function(Context: pPGPContext; Key: pPGPKeyDBObj): pPGPOptionList; cdecl;}
  // both
  PGPOEncryptToKeySet: function(Context: pPGPContext; KeySet: pPGPKeySet): pPGPOptionList; cdecl;
  // both
  PGPOHashAlgorithm: function(Context: pPGPContext; Algorithm: PGPHashAlgorithm): pPGPOptionList; cdecl;
  // PGP 6.5.X
  PGPOSignWithKey: function(Context: pPGPContext; Key: pPGPKey; Options: pPGPOptionList;
			    LastOption: pPGPOptionList): pPGPOptionList; cdecl;
  // PGP 7.X
  {PGPOSignWithKey: function(Context: pPGPContext; Key: pPGPKeyDBObj; Options: pPGPOptionList;
			     LastOption: pPGPOptionList): pPGPOptionList; cdecl;}
  // both
  PGPOWarnBelowValidity: function(Context: pPGPContext; MinValidity: PGPValidity): pPGPOptionList; cdecl;
  // both
  PGPOFailBelowValidity: function(Context: pPGPContext; MinValidity: PGPValidity): pPGPOptionList; cdecl;

  { Encode only options }
  // both
  PGPOAskUserForEntropy: function(Context: pPGPContext; AskUserForEntropy: PGPBoolean): pPGPOptionList; cdecl;
  PGPODataIsASCII: function(Context: pPGPContext; DataIsASCII: PGPBoolean): pPGPOptionList; cdecl;
  PGPORawPGPInput: function(Context: pPGPContext; RawPGPInput: PGPBoolean): pPGPOptionList; cdecl;
  PGPOForYourEyesOnly: function(Context: pPGPContext; ForYourEyesOnly: PGPBoolean): pPGPOptionList; cdecl;
  PGPOArmorOutput: function(Context: pPGPContext; ArmorOutput: PGPBoolean): pPGPOptionList; cdecl;
  PGPOFileNameString: function(Context: pPGPContext; FileName: PChar): pPGPOptionList; cdecl;
  PGPOClearSign: function(Context: pPGPContext; ClearSign: PGPBoolean): pPGPOptionList; cdecl;

  { Decode only options }
  // both
  PGPOPassThroughIfUnrecognized: function(Context: pPGPContext; PassThroughIfUnrecognized: PGPBoolean): pPGPOptionList; cdecl;
  PGPOPassThroughClearSigned: function(Context: pPGPContext; PassThroughClearSigned: PGPBoolean): pPGPOptionList; cdecl;
  PGPOPassThroughKeys: function(Context: pPGPContext; PassThroughKeys: PGPBoolean): pPGPOptionList; cdecl;
  PGPOSendEventIfKeyFound: function(Context: pPGPContext; SendEventIfKeyFound: PGPBoolean): pPGPOptionList; cdecl;
  PGPORecursivelyDecode: function(Context: pPGPContext; Recurse: PGPBoolean): pPGPOptionList; cdecl;

  { Key generation options }
  // both
  PGPOAdditionalRecipientRequestKeySet: function(Context: pPGPContext; ARKeySet: pPGPKeySet;
						 ARKClass: PGPByte): pPGPOptionList; cdecl;
  PGPOKeyGenName: function(Context: pPGPContext; Name: Pointer; NameLength: PGPSize): pPGPOptionList; cdecl;
  // PGP 6.5.X
  PGPOKeyGenMasterKey: function(Context: pPGPContext; MasterKey: pPGPKey): pPGPOptionList; cdecl;
  // PGP 7.X
  {PGPOKeyGenMasterKey: function(Context: pPGPContext; MasterKey: pPGPKeyDBObj): pPGPOptionList; cdecl;}
  // both
  PGPOExportPrivateKeys: function(Context: pPGPContext; ExportPrivate: PGPBoolean): pPGPOptionList; cdecl;
  PGPOKeyGenFast: function(Context: pPGPContext; FastGen: PGPBoolean): pPGPOptionList; cdecl;
  PGPOKeyGenParams: function(Context: pPGPContext; PubKeyAlg: PGPPublicKeyAlgorithm;
			     Bits: PGPUInt32): pPGPOptionList; cdecl;
  PGPOCreationDate: function(Context: pPGPContext; CreationDate: PGPTime): pPGPOptionList; cdecl;
  PGPOExpiration: function(Context: pPGPContext; ExpirationDays: PGPUInt32): pPGPOptionList; cdecl;
  PGPOExportable: function(Context: pPGPContext; Exportable: PGPBoolean): pPGPOptionList; cdecl;
  PGPOSigRegularExpression: function(Context: pPGPContext; RegularExpression: PChar): pPGPOptionList; cdecl;
  PGPOSigTrust: function(Context: pPGPContext; TrustLevel: PGPUInt32; TrustValue: PGPUInt32): pPGPOptionList; cdecl;
  PGPORevocationKeySet: function(Context: pPGPContext; RKeySet: pPGPKeySet): pPGPOptionList; cdecl;
  // PGP 7.X
  PGPOKeyFlags: function(Context: pPGPContext; Flags: PGPUInt32): pPGPOptionList; cdecl;

  { Miscellaneous options }
  // both
  PGPONullOption: function(Context: pPGPContext): pPGPOptionList; cdecl;
  PGPOCompression: function(Context: pPGPContext; Compression: PGPBoolean): pPGPOptionList; cdecl;
  PGPOCommentString: function(Context: pPGPContext; Comment: PChar): pPGPOptionList; cdecl;
  PGPOVersionString: function(Context: pPGPContext; Version: PChar): pPGPOptionList; cdecl;
  // both
  PGPOPassphrase: function(Context: pPGPContext; Passphrase: PChar): pPGPOptionList; cdecl;
  PGPOPassphraseBuffer: function(Context: pPGPContext; Passphrase: PChar;
				 PassphraseLength: PGPSize): pPGPOptionList; cdecl;
  PGPOPasskeyBuffer: function(Context: pPGPContext; Passkey: PChar; PasskeyLength: PGPSize): pPGPOptionList; cdecl;
  PGPOPreferredAlgorithms: function(Context: pPGPContext; const PrefAlg: TPGPCipherAlgorithms;
				    NumAlgs: PGPUInt32): pPGPOptionList; cdecl;
  // PGP 6.5.X
  PGPOKeySetRef6: function(Context: pPGPContext; KeySet: pPGPKeySet): pPGPOptionList; cdecl;
  // PGP 7.X
  PGPOKeyDBRef7: function(Context: pPGPContext; KeyDB: pPGPKeyDB): pPGPOptionList; cdecl;
  // both
  PGPOSendNullEvents: function(Context: pPGPContext; ApproxInterval: PGPTimeInterval): pPGPOptionList; cdecl;
  PGPOExportFormat: function(Context: pPGPContext; ExportFormat: PGPExportFormat): pPGPOptionList; cdecl;
  PGPOExportKeySet: function(Context: pPGPContext; KeySet: pPGPKeySet): pPGPOptionList; cdecl;
  PGPOExportPrivateSubkeys: function(Context: pPGPContext; ExportSubkeys: PGPBoolean): pPGPOptionList; cdecl;
  // PGP 6.5.X
  PGPOImportKeysTo: function(Context: pPGPContext; KeySet: pPGPKeySet): pPGPOptionList; cdecl;
  // PGP 7.X
  {PGPOImportKeysTo: function(Context: pPGPContext; KeyDB: pPGPKeyDB): pPGPOptionList; cdecl;}
  // both
  PGPOEventHandler: function(Context: pPGPContext; Handler: TPGPEventHandlerProcPtr;
			     UserValue: PGPUserValue): pPGPOptionList; cdecl;
  PGPOLastOption: function(Context: pPGPContext): pPGPOptionList; cdecl;

// wrappers for the respective PGP functions as Delphi cannot handle open arrays with the cdecl convention
function PGPBuildOptionList(Context: pPGPContext; var OptionList: pPGPOptionList;
			    const Options: Array of pPGPOptionList): PGPError;
function PGPAppendOptionList(OutList: pPGPOptionList; const Options: Array of pPGPOptionList): PGPError;
// wrapper function for version compatibility
function PGPOKeySetRef(Context: pPGPContext; KeySet: pPGPKeySet): pPGPOptionList;

implementation	// code modified by idw

uses
  Windows;

// the ASM technique for accessing open arrays is based on the
// original work of Graham Grieve in Kestral Computing's
// PGPAPI.PAS file: <http://www.kestral.com.au/devtools/pgp/>
const
  PGPBuildOptionListProcPtr: Pointer = nil;
  PGPAppendOptionListProcPtr: Pointer = nil;

function PGPBuildOptionList(Context: pPGPContext; var OptionList: pPGPOptionList;
			    const Options: Array of pPGPOptionList): PGPError; assembler;
// EAX = Context; EDX = @OptionList; ECX = Options; EBP+08h = high(Options)
asm	// Delphi automatically creates a stack frame here which helps us cleaning up the stack
  SUB	ESP,4				// for temporary OptionList variable
  MOV	[EBP-4],EDX			// free EDX for using as variable
  MOV	EDX,[EBP+8]			// get high(Options) from stack
  SHL	EDX,2				// mul SizeOf(pPGPOptionList)
  PUSH	-1				// push PGPLastOption = kPGPEndOfArgsOptionListRef (see pgpOptionListPriv.h)
  @LOOP:                   		// push Options
  PUSH	DWORD PTR [ECX+EDX]
  SUB	EDX,4
  JNS	@LOOP
  PUSH	DWORD PTR [EBP-4]		// push OptionList
  PUSH	EAX				// push Context
  CALL	PGPBuildOptionListProcPtr	// result comes in EAX
  POP	ECX				// remove Context from stack
  POP	EDX				// get OptionList from stack
  MOV	ESP,EBP				// restore stack pointer (and cleanup cdecl stack)
end;

function PGPAppendOptionList(OutList: pPGPOptionList; const Options: Array of pPGPOptionList): PGPError; assembler;
// EAX = OutList; EDX = Options; ECX = high(Options)
asm	// Delphi does not create a stack frame here, but we do it for conveniently cleaning up the stack
  PUSH	EBP				// save base pointer
  MOV	EBP,ESP				// save stack pointer
  SHL	ECX,2				// high(Options) mul SizeOf(pPGPOptionList)
  PUSH	-1				// push PGPLastOption = kPGPEndOfArgsOptionListRef (see pgpOptionListPriv.h)
  @LOOP:                   		// push Options
  PUSH	DWORD PTR [EDX+ECX]
  SUB	ECX,4
  JNS	@LOOP
  PUSH	EAX				// push OutList
  CALL	PGPAppendOptionListProcPtr	// result comes in EAX
  MOV	ESP,EBP				// restore stack pointer
  POP	EBP				// restore base pointer
end;

function PGPOKeySetRef(Context: pPGPContext; KeySet: pPGPKeySet): pPGPOptionList;
begin
  if PGP7X then
    Result:=PGPOKeyDBRef7(Context, PGPPeekKeySetKeyDB(KeySet))
  else Result:=PGPOKeySetRef6(Context, KeySet);
end;

initialization

  if PGPInitErrorCode=ieNone then begin
    PGPBuildOptionListProcPtr:=GetProcAddress(hPGPsdkLib, 'PGPBuildOptionList');
    PGPAppendOptionListProcPtr:=GetProcAddress(hPGPsdkLib, 'PGPAppendOptionList');

    PGPNewOptionList:=GetProcAddress(hPGPsdkLib, 'PGPNewOptionList');
    PGPCopyOptionList:=GetProcAddress(hPGPsdkLib, 'PGPCopyOptionList');
    PGPFreeOptionList:=GetProcAddress(hPGPsdkLib, 'PGPFreeOptionList');
    PGPAddJobOptions:=GetProcAddress(hPGPsdkLib, 'PGPAddJobOptions');
    PGPOInputBuffer:=GetProcAddress(hPGPsdkLib, 'PGPOInputBuffer');
    PGPOInputFile:=GetProcAddress(hPGPsdkLib, 'PGPOInputFile');
    PGPODiscardOutput:=GetProcAddress(hPGPsdkLib, 'PGPODiscardOutput');
    PGPOAllocatedOutputBuffer:=GetProcAddress(hPGPsdkLib, 'PGPOAllocatedOutputBuffer');
    PGPOOutputBuffer:=GetProcAddress(hPGPsdkLib, 'PGPOOutputBuffer');
    PGPOOutputFile:=GetProcAddress(hPGPsdkLib, 'PGPOOutputFile');
    PGPOPGPMIMEEncoding:=GetProcAddress(hPGPsdkLib, 'PGPOPGPMIMEEncoding');
    PGPOOmitMIMEVersion:=GetProcAddress(hPGPsdkLib, 'PGPOOmitMIMEVersion');
    PGPOLocalEncoding:=GetProcAddress(hPGPsdkLib, 'PGPOLocalEncoding');
    PGPOOutputLineEndType:=GetProcAddress(hPGPsdkLib, 'PGPOOutputLineEndType');
    PGPODetachedSig:=GetProcAddress(hPGPsdkLib, 'PGPODetachedSig');
    PGPOConventionalEncrypt:=GetProcAddress(hPGPsdkLib, 'PGPOConventionalEncrypt');
    PGPOCipherAlgorithm:=GetProcAddress(hPGPsdkLib, 'PGPOCipherAlgorithm');
    if PGP7X then
      PGPOEncryptToKey:=GetProcAddress(hPGPsdkLib, 'PGPOEncryptToKeyDBObj')
    else PGPOEncryptToKey:=GetProcAddress(hPGPsdkLib, 'PGPOEncryptToKey');
    PGPOEncryptToKeySet:=GetProcAddress(hPGPsdkLib, 'PGPOEncryptToKeySet');
    PGPOHashAlgorithm:=GetProcAddress(hPGPsdkLib, 'PGPOHashAlgorithm');
    PGPOSignWithKey:=GetProcAddress(hPGPsdkLib, 'PGPOSignWithKey');
    PGPOWarnBelowValidity:=GetProcAddress(hPGPsdkLib, 'PGPOWarnBelowValidity');
    PGPOFailBelowValidity:=GetProcAddress(hPGPsdkLib, 'PGPOFailBelowValidity');
    PGPOAskUserForEntropy:=GetProcAddress(hPGPsdkLib, 'PGPOAskUserForEntropy');
    PGPODataIsASCII:=GetProcAddress(hPGPsdkLib, 'PGPODataIsASCII');
    PGPORawPGPInput:=GetProcAddress(hPGPsdkLib, 'PGPORawPGPInput');
    PGPOForYourEyesOnly:=GetProcAddress(hPGPsdkLib, 'PGPOForYourEyesOnly');
    PGPOArmorOutput:=GetProcAddress(hPGPsdkLib, 'PGPOArmorOutput');
    PGPOFileNameString:=GetProcAddress(hPGPsdkLib, 'PGPOFileNameString');
    PGPOClearSign:=GetProcAddress(hPGPsdkLib, 'PGPOClearSign');
    PGPOPassThroughIfUnrecognized:=GetProcAddress(hPGPsdkLib, 'PGPOPassThroughIfUnrecognized');
    PGPOPassThroughClearSigned:=GetProcAddress(hPGPsdkLib, 'PGPOPassThroughClearSigned');
    PGPOPassThroughKeys:=GetProcAddress(hPGPsdkLib, 'PGPOPassThroughKeys');
    PGPOSendEventIfKeyFound:=GetProcAddress(hPGPsdkLib, 'PGPOSendEventIfKeyFound');
    PGPORecursivelyDecode:=GetProcAddress(hPGPsdkLib, 'PGPORecursivelyDecode');
    PGPOAdditionalRecipientRequestKeySet:=GetProcAddress(hPGPsdkLib, 'PGPOAdditionalRecipientRequestKeySet');
    PGPOKeyGenName:=GetProcAddress(hPGPsdkLib, 'PGPOKeyGenName');
    PGPOKeyGenMasterKey:=GetProcAddress(hPGPsdkLib, 'PGPOKeyGenMasterKey');
    PGPOExportPrivateKeys:=GetProcAddress(hPGPsdkLib, 'PGPOExportPrivateKeys');
    PGPOKeyGenFast:=GetProcAddress(hPGPsdkLib, 'PGPOKeyGenFast');
    PGPOKeyGenParams:=GetProcAddress(hPGPsdkLib, 'PGPOKeyGenParams');
    PGPOCreationDate:=GetProcAddress(hPGPsdkLib, 'PGPOCreationDate');
    PGPOExpiration:=GetProcAddress(hPGPsdkLib, 'PGPOExpiration');
    PGPOExportable:=GetProcAddress(hPGPsdkLib, 'PGPOExportable');
    PGPOSigRegularExpression:=GetProcAddress(hPGPsdkLib, 'PGPOSigRegularExpression');
    PGPOSigTrust:=GetProcAddress(hPGPsdkLib, 'PGPOSigTrust');
    PGPORevocationKeySet:=GetProcAddress(hPGPsdkLib, 'PGPORevocationKeySet');
    if PGP7X then
      PGPOKeyFlags:=GetProcAddress(hPGPsdkLib, 'PGPOKeyFlags')
    else PGPOKeyFlags:=nil;
    PGPONullOption:=GetProcAddress(hPGPsdkLib, 'PGPONullOption');
    PGPOCompression:=GetProcAddress(hPGPsdkLib, 'PGPOCompression');
    PGPOCommentString:=GetProcAddress(hPGPsdkLib, 'PGPOCommentString');
    PGPOVersionString:=GetProcAddress(hPGPsdkLib, 'PGPOVersionString');
    PGPOPassphrase:=GetProcAddress(hPGPsdkLib, 'PGPOPassphrase');
    PGPOPassphraseBuffer:=GetProcAddress(hPGPsdkLib, 'PGPOPassphraseBuffer');
    PGPOPasskeyBuffer:=GetProcAddress(hPGPsdkLib, 'PGPOPasskeyBuffer');
    PGPOPreferredAlgorithms:=GetProcAddress(hPGPsdkLib, 'PGPOPreferredAlgorithms');
    if PGP7X then
      PGPOKeyDBRef7:=GetProcAddress(hPGPsdkLib, 'PGPOKeyDBRef')
    else PGPOKeySetRef6:=GetProcAddress(hPGPsdkLib, 'PGPOKeySetRef');
    PGPOSendNullEvents:=GetProcAddress(hPGPsdkLib, 'PGPOSendNullEvents');
    PGPOExportFormat:=GetProcAddress(hPGPsdkLib, 'PGPOExportFormat');
    PGPOExportKeySet:=GetProcAddress(hPGPsdkLib, 'PGPOExportKeySet');
    PGPOExportPrivateSubkeys:=GetProcAddress(hPGPsdkLib, 'PGPOExportPrivateSubkeys');
    PGPOImportKeysTo:=GetProcAddress(hPGPsdkLib, 'PGPOImportKeysTo');
    PGPOEventHandler:=GetProcAddress(hPGPsdkLib, 'PGPOEventHandler');
    PGPOLastOption:=GetProcAddress(hPGPsdkLib, 'PGPOLastOption');
  end;

end.

