{$J+,Z4}
unit pgpKeys;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the "Borland Delphi Runtime Library PGPsdk" released 10 Apr }
{ 2000, available at http://www.oz.net/~srheller/dpgp/sdk/.                        }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpKeys.pas based on pgpKeys.h from the PGP sources         }
{ which are Copyright (C) Network Associates Inc. and affiliated companies.        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ Lots of stuff removed (especially from PGP versions 5.5.X and 6.0.X);            }
{ all functions taking OptionLists modified according to a suggestion              }
{ by Steven R. Heller, for details see pgpOptionList.pas; wrapper                  }
{ functions added for version specific implementations                             }
{                                                                                  }
{**********************************************************************************}

interface

uses
  pgpBase,
  pgpErrors,
  pgpPubTypes,
  pgpEvents;

type
  { Key Ordering }
  PGPKeyOrdering = PGPEnumType;
const
  // PGP 6.5.X
  kPGPInvalidOrdering			= 00;
  kPGPAnyOrdering			= 01;
  kPGPUserIDOrdering			= 02;
  kPGPReverseUserIDOrdering		= 03;
  kPGPKeyIDOrdering			= 04;
  kPGPReverseKeyIDOrdering		= 05;
  kPGPValidityOrdering			= 06;
  kPGPReverseValidityOrdering		= 07;
  kPGPTrustOrdering			= 08;
  kPGPReverseTrustOrdering		= 09;
  kPGPEncryptKeySizeOrdering		= 10;
  kPGPReverseEncryptKeySizeOrdering	= 11;
  kPGPSigKeySizeOrdering		= 12;
  kPGPReverseSigKeySizeOrdering		= 13;
  kPGPCreationOrdering			= 14;
  kPGPReverseCreationOrdering		= 15;
  kPGPExpirationOrdering		= 16;
  kPGPReverseExpirationOrdering		= 17;
  // PGP 7.X
  kPGPKeyOrdering_Invalid		= 0;
  kPGPKeyOrdering_Any			= 1;
  kPGPKeyOrdering_UserID		= 2;
  kPGPKeyOrdering_KeyID			= 3;
  kPGPKeyOrdering_Validity		= 4;
  kPGPKeyOrdering_Trust			= 5;
  kPGPKeyOrdering_EncryptionKeySize	= 6;
  kPGPKeyOrdering_SigningKeySize	= 7;
  kPGPKeyOrdering_CreationDate		= 8;
  kPGPKeyOrdering_ExpirationDate	= 9;

// properties PGP 6.5.X
type
  { Key Properties }
  PGPKeyPropName = PGPEnumType;
const

  // String Properties
  kPGPKeyPropFingerprint			= 001;
  kPGPKeyPropPreferredAlgorithms		= 002;
  kPGPKeyPropThirdPartyRevocationKeyID		= 003;

  // Number Properties
  kPGPKeyPropAlgID				= 020;
  kPGPKeyPropBits				= 021;
  kPGPKeyPropTrust				= 022;
  kPGPKeyPropValidity				= 023;
  kPGPKeyPropLockingAlgID			= 024;
  kPGPKeyPropLockingBits			= 025;
  kPGPKeyPropFlags				= 026;

  // Time Properties
  kPGPKeyPropCreation				= 040;
  kPGPKeyPropExpiration				= 041;

  // PGPBoolean Properties
  kPGPKeyPropIsSecret				= 060;
  kPGPKeyPropIsAxiomatic			= 061;
  kPGPKeyPropIsRevoked				= 062;
  kPGPKeyPropIsDisabled				= 063;
  kPGPKeyPropIsNotCorrupt			= 064;
  kPGPKeyPropIsExpired				= 065;
  kPGPKeyPropNeedsPassphrase			= 066;
  kPGPKeyPropHasUnverifiedRevocation		= 067;
  kPGPKeyPropCanEncrypt				= 068;
  kPGPKeyPropCanDecrypt				= 069;
  kPGPKeyPropCanSign				= 070;
  kPGPKeyPropCanVerify				= 071;
  kPGPKeyPropIsEncryptionKey			= 072;
  kPGPKeyPropIsSigningKey			= 073;
  kPGPKeyPropIsSecretShared			= 074;
  kPGPKeyPropIsRevocable			= 075;
  kPGPKeyPropHasThirdPartyRevocation		= 076;

type
  { User ID Properties }
  PGPUserIDPropName = PGPEnumType;
const

  // String Properties
  kPGPUserIDPropName				= 080;
  kPGPUserIDPropAttributeData			= 081;

  // Number Properties
  kPGPUserIDPropValidity			= 100;
  kPGPUserIDPropConfidence			= 101;
  kPGPUserIDPropAttributeType			= 102;

  // PGPBoolean Properties
  kPGPUserIDPropIsAttribute			= 110;

type
  { Signature Properties }
  PGPSigPropName = PGPEnumType;
const

  // String Properties
  kPGPSigPropKeyID				= 120;
  kPGPSigPropX509Certificate			= 121;

  // Number Properties
  kPGPSigPropAlgID				= 140;
  kPGPSigPropTrustLevel				= 141;
  kPGPSigPropTrustValue				= 142;

  // Time Properties
  kPGPSigPropCreation				= 160;
  kPGPSigPropExpiration				= 161;

  // PGPBoolean Properties
  kPGPSigPropIsRevoked				= 180;
  kPGPSigPropIsNotCorrupt			= 181;
  kPGPSigPropIsTried				= 182;
  kPGPSigPropIsVerified				= 183;
  kPGPSigPropIsMySig				= 184;
  kPGPSigPropIsExportable			= 185;
  kPGPSigPropHasUnverifiedRevocation		= 186;
  kPGPSigPropIsExpired				= 187;
  kPGPSigPropIsX509				= 188;

// properties PGP 7.X
type
  PGPKeyDBObjProperty = PGPEnumType;
const
  kPGPKeyDBObjProperty_Invalid 			= 000;

  // Generic numeric properties
  kPGPKeyDBObjProperty_ObjectType		= 020;

  // Key boolean properties
  kPGPKeyProperty_IsSecret 			= 100;
  kPGPKeyProperty_IsAxiomatic			= 101;
  kPGPKeyProperty_IsRevoked			= 102;
  kPGPKeyProperty_IsDisabled			= 103;
  kPGPKeyProperty_IsNotCorrupt			= 104;
  kPGPKeyProperty_IsExpired			= 105;
  kPGPKeyProperty_NeedsPassphrase		= 106;
  kPGPKeyProperty_HasUnverifiedRevocation	= 107;
  kPGPKeyProperty_CanEncrypt			= 108;
  kPGPKeyProperty_CanDecrypt			= 109;
  kPGPKeyProperty_CanSign			= 110;
  kPGPKeyProperty_CanVerify			= 111;
  kPGPKeyProperty_IsEncryptionKey		= 112;
  kPGPKeyProperty_IsSigningKey			= 113;
  kPGPKeyProperty_IsSecretShared		= 114;
  kPGPKeyProperty_IsRevocable			= 115;
  kPGPKeyProperty_HasThirdPartyRevocation	= 116;
  kPGPKeyProperty_HasCRL			= 117;
  kPGPKeyProperty_IsOnToken			= 118;

  // Key numeric properties
  kPGPKeyProperty_AlgorithmID 			= 200;
  kPGPKeyProperty_Bits				= 201;
  kPGPKeyProperty_Trust				= 202;
  kPGPKeyProperty_Validity			= 203;
  kPGPKeyProperty_LockingAlgorithmID		= 204;
  kPGPKeyProperty_LockingBits			= 205;
  kPGPKeyProperty_Flags				= 206;
  kPGPKeyProperty_HashAlgorithmID		= 207;
  kPGPKeyProperty_Version			= 208;
  kPGPKeyProperty_KeyServerPreferences		= 209;
  kPGPKeyProperty_TokenNum			= 210;

  // Key time properties
  kPGPKeyProperty_Creation 			= 300;
  kPGPKeyProperty_Expiration			= 301;
  kPGPKeyProperty_CRLThisUpdate			= 302;
  kPGPKeyProperty_CRLNextUpdate			= 303;

  // Key data (variable sized) properties
  kPGPKeyProperty_Fingerprint			= 401;
  kPGPKeyProperty_KeyID				= 402;
  kPGPKeyProperty_PreferredAlgorithms		= 403;
  kPGPKeyProperty_ThirdPartyRevocationKeyID 	= 404;
  kPGPKeyProperty_KeyData			= 405;
  kPGPKeyProperty_X509MD5Hash			= 406;
  kPGPKeyProperty_PreferredKeyServer		= 407;

  // SubKey boolean properties
  kPGPSubKeyProperty_IsRevoked			= 501;
  kPGPSubKeyProperty_IsNotCorrupt		= 502;
  kPGPSubKeyProperty_IsExpired			= 503;
  kPGPSubKeyProperty_NeedsPassphrase		= 504;
  kPGPSubKeyProperty_HasUnverifiedRevocation	= 505;
  kPGPSubKeyProperty_IsRevocable		= 506;
  kPGPSubKeyProperty_HasThirdPartyRevocation	= 507;
  kPGPSubKeyProperty_IsOnToken			= 508;

  // SubKey numeric properties
  kPGPSubKeyProperty_AlgorithmID 		= 600;
  kPGPSubKeyProperty_Bits			= 601;
  kPGPSubKeyProperty_LockingAlgorithmID		= 602;
  kPGPSubKeyProperty_LockingBits		= 603;
  kPGPSubKeyProperty_Version			= 604;
  kPGPSubKeyProperty_Flags			= 605;

  // SubKey time properties
  kPGPSubKeyProperty_Creation 			= 700;
  kPGPSubKeyProperty_Expiration			= 701;

  // SubKey data (variable sized) properties
  kPGPSubKeyProperty_KeyData			= 800;
  kPGPSubKeyProperty_KeyID			= 801;

  // User ID boolean properties
  kPGPUserIDProperty_IsAttribute		= 900;

  // User ID numeric properties
  kPGPUserIDProperty_Validity 			= 1000;
  kPGPUserIDProperty_Confidence			= 1001;
  kPGPUserIDProperty_AttributeType		= 1002;

  // User ID data (variable sized) properties
  kPGPUserIDProperty_Name 			= 1200;
  kPGPUserIDProperty_AttributeData		= 1201;
  kPGPUserIDProperty_CommonName			= 1202;
  kPGPUserIDProperty_EmailAddress		= 1203;

  // Signature boolean properties
  kPGPSigProperty_IsRevoked 			= 1300;
  kPGPSigProperty_IsNotCorrupt			= 1301;
  kPGPSigProperty_IsTried			= 1302;
  kPGPSigProperty_IsVerified			= 1303;
  kPGPSigProperty_IsMySig			= 1304;
  kPGPSigProperty_IsExportable			= 1305;
  kPGPSigProperty_HasUnverifiedRevocation	= 1306;
  kPGPSigProperty_IsExpired			= 1307;
  kPGPSigProperty_IsX509			= 1308;

  // Signature numeric properties
  kPGPSigProperty_AlgorithmID			= 1400;
  kPGPSigProperty_TrustLevel			= 1401;
  kPGPSigProperty_TrustValue			= 1402;

  // Signature time properties
  kPGPSigProperty_Creation 			= 1500;
  kPGPSigProperty_Expiration			= 1501;

  // Signature data (variable sized) properties
  kPGPSigProperty_KeyID 			= 1600;
  kPGPSigProperty_X509Certificate		= 1601;
  kPGPSigProperty_X509IASN			= 1602;
  kPGPSigProperty_X509LongName			= 1603;
  kPGPSigProperty_X509IssuerLongName		= 1604;
  kPGPSigProperty_X509DNSName			= 1605;
  kPGPSigProperty_X509IPAddress			= 1606;
  kPGPSigProperty_X509DERDName			= 1607;

// PGP 7.X only
type
  { For kPGPKeyProperty_Version }
  PGPKeyVersion = PGPEnumType;
const
  kPGPKeyVersion_V3				= 3;
  kPGPKeyVersion_V4				= 4;

// both versions
type
  { kPGPKeyPropFlags bits }
  PGPKeyPropertyFlags = PGPEnumType;	// PGPKeyPropFlags in PGP 6.5.X
const
  kPGPKeyPropertyFlags_UsageSignUserIDs			= (1 shl 0);
  kPGPKeyPropertyFlags_UsageSignMessages		= (1 shl 1);
  kPGPKeyPropertyFlags_UsageEncryptCommunications	= (1 shl 2);
  kPGPKeyPropertyFlags_UsageEncryptStorage		= (1 shl 3);

  kPGPKeyPropertyFlags_PrivateSplit			= (1 shl 4);
  kPGPKeyPropertyFlags_PrivateShared			= (1 shl 7);

  kPGPKeyPropertyFlags_UsageSign			= kPGPKeyPropertyFlags_UsageSignUserIDs			// PGP 7.X
  							or kPGPKeyPropertyFlags_UsageSignMessages;
  kPGPKeyPropertyFlags_UsageEncrypt			= kPGPKeyPropertyFlags_UsageEncryptCommunications	// PGP 7.X
  							or kPGPKeyPropertyFlags_UsageEncryptStorage;
  kPGPKeyPropertyFlags_UsageSignEncrypt			= kPGPKeyPropertyFlags_UsageSign			// PGP 7.X
							or kPGPKeyPropertyFlags_UsageEncrypt;

// PGP 6.5.X only
type
  { PGPKeyRingOpenFlags }
  PGPKeyRingOpenFlags = PGPUInt32;
const
  kPGPKeyRingOpenFlags_Reserved				= (1 shl 0);
  kPGPKeyRingOpenFlags_Mutable				= (1 shl 1);
  kPGPKeyRingOpenFlags_Create				= (1 shl 2);

  // The following flags are only used by PGPOpenKeyRing
  kPGPKeyRingOpenFlags_Private				= (1 shl 8);
  kPGPKeyRingOpenFlags_Trusted				= (1 shl 9);

// PGP 7.X only
type
  { PGPKeyDBFileOptions }
  PGPOpenKeyDBFileOptions = PGPEnumType;
const
  kPGPOpenKeyDBFileOptions_None				= 0;
  kPGPOpenKeyDBFileOptions_Mutable			= (1 shl 0);
  kPGPOpenKeyDBFileOptions_Create			= (1 shl 1);

type
  { Key DB object types for the property kPGPKeyDBObjProperty_ObjectType }
  PGPKeyDBObjType = PGPEnumType;
const
  kPGPKeyDBObjType_Invalid				= 0;
  kPGPKeyDBObjType_Key					= (1 shl 0);
  kPGPKeyDBObjType_SubKey				= (1 shl 1);
  kPGPKeyDBObjType_UserID				= (1 shl 2);
  kPGPKeyDBObjType_Signature				= (1 shl 3);
  kPGPKeyDBObjType_Any					= -1;

// both versions
type
  { Used by Filtering functions to specify type of Match }
  PGPMatchCriterion = PGPEnumType;
const
  kPGPMatchDefault					= 1;
  kPGPMatchEqual					= 1; // val == supplied val
  kPGPMatchGreaterOrEqual				= 2; // val >= supplied val
  kPGPMatchLessOrEqual					= 3; // val <= supplied val
  kPGPMatchSubString					= 4; // val is in supplied val

const
  { This is the value of the Expiration time which means "never expires" }
  kPGPExpirationTime_Never				= 0;

type
    PGPKeyIDStringType = PGPEnumType;
const
  // typed constants because of version specific values
  kPGPKeyIDString_Abbreviated: PGPKeyIDStringType = 0;
  kPGPKeyIDString_Full: PGPKeyIDStringType = 0;

var
  { Key ring management 6.5.X }
  PGPOpenDefaultKeyRings: function(Context: pPGPContext;
		OpenFlags: PGPKeyRingOpenFlags;
		var KeySet: pPGPKeySet): PGPError; cdecl;
  PGPOpenKeyRingPair: function(Context: pPGPContext;
		OpenFlags: PGPKeyRingOpenFlags;
		PubFileSpec: pPGPFileSpec;
		SecFileSpec: pPGPFileSpec;
		var KeySet: pPGPKeySet): PGPError; cdecl;
  PGPOpenKeyRing: function(Context: pPGPContext;
		OpenFlags: PGPKeyRingOpenFlags;
		FileSpec: pPGPFileSpec;
		var KeySet: pPGPKeySet): PGPError; cdecl;
  PGPReloadKeyRings: function(KeySet: pPGPKeySet): PGPError; cdecl;
  PGPKeySetIsMutable: function(KeySet: pPGPKeySet): PGPBoolean; cdecl;
  PGPKeySetNeedsCommit: function(KeySet: pPGPKeySet): PGPBoolean; cdecl;
  PGPCommitKeyRingChanges: function(KeySet: pPGPKeySet): PGPError; cdecl;
  PGPRevertKeyRingChanges: function(KeySet: pPGPKeySet): PGPError; cdecl;
  { Key DB management 7.X }
  PGPNewKeyDB: function(Context: pPGPContext; var KeyDB: pPGPKeyDB): PGPError; cdecl;
  PGPOpenKeyDBFile: function(Context: pPGPContext;
		Options: PGPOpenKeyDBFileOptions;
		PubKeysFileSpec: pPGPFileSpec;
		PrivKeysFileSpec: pPGPFileSpec;
		var KeyDB: pPGPKeyDB): PGPError; cdecl;
  PGPFreeKeyDB: function(KeyDB: pPGPKeyDB): PGPError; cdecl;
  PGPFlushKeyDB: function(KeyDB: pPGPKeyDB): PGPError; cdecl;
  PGPIncKeyDBRefCount: function(KeyDB: pPGPKeyDB): PGPError; cdecl;
  PGPKeyDBIsMutable: function(KeyDB: pPGPKeyDB): PGPBoolean; cdecl;
  PGPKeyDBIsUpdated: function(KeyDB: pPGPKeyDB; var IsUpdated: PGPBoolean): PGPError; cdecl;
  PGPCountKeysInKeyDB: function(KeyDB: pPGPKeyDB; var NumKeys: PGPUInt32): PGPError; cdecl;
  PGPPeekKeyDBRootKeySet: function(KeyDB: pPGPKeyDB): pPGPKeySet; cdecl;
  PGPPeekKeySetKeyDB: function(KeySet: pPGPKeySet): pPGPKeyDB; cdecl;

  { Keyset management }
  // PGP 6.5.X
  PGPNewKeySet: function(Context: pPGPContext;
		var KeySet: pPGPKeySet): PGPError; cdecl;
  // PGP 7.X
  {PGPNewKeySet: function(KeyDB: pPGPKeyDB;
		var KeySet: pPGPKeySet): PGPError; cdecl;}
  // PGP 6.5.X
  PGPNewEmptyKeySet: function(OrigSet: pPGPKeySet;
		var NewSet: pPGPKeySet): PGPError; cdecl;
  // PGP 7.X
  {PGPNewEmptyKeySet: function(KeyDB: pPGPKeyDB;
		var NewSet: pPGPKeySet): PGPError; cdecl;}
  // PGP 6.5.X
  PGPNewSingletonKeySet: function(Key: pPGPKey;
		var KeySet: pPGPKeySet): PGPError; cdecl;
  // PGP 7.X
  PGPNewOneKeySet: function(KeyDBObj: pPGPKeyDBObj;
		var KeySet: pPGPKeySet): PGPError; cdecl;
  // both
  PGPIncKeySetRefCount: function(KeySet: pPGPKeySet): PGPError; cdecl;
  // both
  PGPFreeKeySet: function(KeySet: pPGPKeySet): PGPError; cdecl;
  // PGP 6.5.X
  PGPImportKeySet: function(Context: pPGPContext;
		var KeySet: pPGPKeySet;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 7.X
  PGPImport: function(Context: pPGPContext; var ImportedKeys: pPGPKeyDB;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 6.5.X
  PGPExportKeySet: function(KeySet: pPGPKeySet;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 7.X
  PGPExport: function(Context: pPGPContext;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  // both
  PGPAddKeys: function(KeysToAdd: pPGPKeySet;
		ASet: pPGPKeySet): PGPError; cdecl;
  // PGP 7.X
  PGPCopyKeys: function(KeySet: pPGPKeySet; DestKeyDB: pPGPKeyDB;
		 var DestKeySet: pPGPKeySet): PGPError; cdecl;
  // PGP 6.5.X
  PGPRemoveKeys6: function(KeysToRemove: pPGPKeySet;
		ASet: pPGPKeySet): PGPError; cdecl;
  // PGP 7.X
  PGPDeleteKeys7: function(KeysToDelete: pPGPKeySet): PGPError; cdecl;
  // both
  PGPCountKeys: function(KeySet: pPGPKeySet;
		var NumKeys: PGPUInt32): PGPError; cdecl;
  // PGP 6.5.X
  PGPKeySetIsMember: function(Key: pPGPKey;
		KeySet: pPGPKeySet): PGPBoolean; cdecl;
  // PGP 7.X
  {PGPKeySetIsMember: function(KeyDBObj: pPGPKeyDBObj;
		KeySet: pPGPKeySet): PGPBoolean; cdecl;}

  { Key filter functions 6.5.X }
  PGPNewKeyBooleanFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyCreationTimeFilter: function(Context: pPGPContext;
		CreationTime: PGPTime;
		Match: PGPMatchCriterion;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyExpirationTimeFilter: function(Context: pPGPContext;
		ExpirationTime: PGPTime;
		Match: PGPMatchCriterion;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyDisabledFilter: function(Context: pPGPContext;
		Disabled: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyNumberFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Value: PGPUInt32;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyTimeFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Value: PGPTime;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyPropertyBufferFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		var Buffer: Pointer;
		Length: PGPSize;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyRevokedFilter: function(Context: pPGPContext;
		Revoked: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyEncryptAlgorithmFilter: function(Context: pPGPContext;
		EncryptAlgorithm: PGPPublicKeyAlgorithm;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyEncryptKeySizeFilter: function(Context: pPGPContext;
		KeySize: PGPUInt32;
		Match: PGPMatchCriterion;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyFingerPrintFilter: function(Context: pPGPContext;
		FingerPrint: Pointer;
		FingerPrintLength: PGPSize;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyIDFilter: function(Context: pPGPContext;
		var PGPKeyID: TPGPKeyID7;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSubKeyBooleanFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSubKeyIDFilter: function(Context: pPGPContext;
		var SubPGPKeyID: TPGPKeyID7;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSubKeyNumberFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Value: PGPUInt32;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSubKeyTimeFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Value: PGPTime;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSubKeyPropertyBufferFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		var Buffer: Pointer;
		Length: PGPSize;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeySigAlgorithmFilter: function(Context: pPGPContext;
		SigAlgorithm: PGPPublicKeyAlgorithm;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeySigKeySizeFilter: function(Context: pPGPContext;
		KeySize: PGPUInt32;
		Match: PGPMatchCriterion;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSigBooleanFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSigKeyIDFilter: function(Context: pPGPContext;
		var PGPKeyID: TPGPKeyID7;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSigNumberFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Value: PGPUInt32;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSigTimeFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Value: PGPTime;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSigPropertyBufferFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		var Buffer: Pointer;
		Length: PGPSize;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewUserIDBooleanFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewUserIDNameFilter: function(Context: pPGPContext;
		NameString: PChar;
		Match: PGPMatchCriterion;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewUserIDNumberFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Value: PGPUInt32;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewUserIDStringBufferFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		var Buffer: Pointer;
		Length: PGPSize;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewUserIDStringFilter: function(Context: pPGPContext;
		UserIDString: PChar;
		Match: PGPMatchCriterion;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewUserIDEmailFilter: function(Context: pPGPContext;
		EmailString: PChar;
		Match: PGPMatchCriterion;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  { Key filter functions 7.X }
  PGPNewKeyDBObjBooleanFilter7: function(Context: pPGPContext;
		WhichProperty: PGPKeyDBObjProperty; Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;

  PGPNewKeyDBObjNumericFilter7: function(Context: pPGPContext;
		WhichProperty: PGPKeyDBObjProperty; MatchValue: PGPUInt32;
		MatchCriteria: PGPMatchCriterion; var OutFilter: pPGPFilter): PGPError; cdecl;

  PGPNewKeyDBObjTimeFilter7: function(Context: pPGPContext;
		WhichProperty: PGPKeyDBObjProperty; MatchValue: PGPTime;
		MatchCriteria: PGPMatchCriterion; var OutFilter: pPGPFilter): PGPError; cdecl;

  PGPNewKeyDBObjDataFilter7: function(Context: pPGPContext;
		WhichProperty: PGPKeyDBObjProperty; const MatchData: Pointer;
		MatchDataSize: PGPSize; MatchCriteria: PGPMatchCriterion;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  { Key filter functions both }
  // freeing OutFilter will call PGPFreeFilter on all Filters
  PGPIncFilterRefCount: function(Filter: pPGPFilter): PGPError; cdecl;
  PGPNegateFilter: function(Filter: pPGPFilter;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPIntersectFilters: function(Filter1: pPGPFilter;
		Filter2: pPGPFilter;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPUnionFilters: function(Filter1: pPGPFilter;
		Filter2: pPGPFilter;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPFreeFilter: function(Filter: pPGPFilter): PGPError; cdecl;
  PGPFilterKeySet: function(OrigSet: pPGPKeySet;
		Filter: pPGPFilter;
		var ResultSet: pPGPKeySet): PGPError; cdecl;

  { Key iteration functions }
  // PGP 6.5.X
  PGPOrderKeySet6: function(KeySet: pPGPKeySet;
		Order: PGPKeyOrdering;
		var KeyList: pPGPKeyList): PGPError; cdecl;
  // PGP 7.X
  PGPOrderKeySet7: function(KeySet: pPGPKeySet;
		Order: PGPKeyOrdering; ReverseOrder: PGPBoolean;
		var KeyList: pPGPKeyList): PGPError; cdecl;
  // both
  PGPIncKeyListRefCount: function(KeyList: pPGPKeyList): PGPError; cdecl;
  // both
  PGPFreeKeyList: function(KeyList: pPGPKeyList): PGPError; cdecl;
  // both
  PGPNewKeyIter: function(KeyList: pPGPKeyList;
		var OutRef: pPGPKeyIter): PGPError; cdecl;
  // PGP 7.X
  PGPNewKeyIterFromKeySet: function(KeySet: pPGPKeySet;
  		var OutRef: pPGPKeyIter): PGPError; cdecl;
  // PGP 7.X
  PGPNewKeyIterFromKeyDB: function(KeyDB: pPGPKeyDB;
		var OutRef: pPGPKeyIter): PGPError; cdecl;
  // both
  PGPCopyKeyIter: function(OrigIter: pPGPKeyIter;
		var CopyIter: pPGPKeyIter): PGPError; cdecl;
  // both
  PGPFreeKeyIter: function(Iter: pPGPKeyIter): PGPError; cdecl;
  // both
  PGPKeyIterIndex: function(Iter: pPGPKeyIter): PGPInt32; cdecl;
  // PGP 6.5.X
  PGPKeyIterKey: function(Iter: pPGPKeyIter;
		var OutRef: pPGPKey): PGPError; cdecl;
  // PGP 6.5.X
  PGPKeyIterSubKey: function(Iter: pPGPKeyIter;
		var OutRef: pPGPSubKey): PGPError; cdecl;
  // PGP 6.5.X
  PGPKeyIterUserID: function(Iter: pPGPKeyIter;
		var OutRef: pPGPUserID): PGPError; cdecl;
  // PGP 6.5.X
  PGPKeyIterSig: function(Iter: pPGPKeyIter;
		var OutRef: pPGPSig): PGPError; cdecl;
  // PGP 7.X
  PGPKeyIterGetKeyDBObj: function(Iter: pPGPKeyIter;
		ObjectType: PGPKeyDBObjType; var OutRef: pPGPKey): PGPError; cdecl;
  // both
  PGPKeyIterMove: function(Iter: pPGPKeyIter;
		RelOffset: PGPInt32;
		var OutRef: pPGPKey): PGPError; cdecl;
  // PGP 6.5.X
  PGPKeyIterSeek: function(Iter: pPGPKeyIter;
		Key: pPGPKey): PGPInt32; cdecl;
  // PGP 7.X
  {PGPKeyIterSeek: function(Iter: pPGPKeyIter;
		Key: pPGPKeyDBObj): PGPInt32; cdecl;}
  // PGP 6.5.X
  PGPKeyIterNext: function(Iter: pPGPKeyIter;
		var OutRef: pPGPKey): PGPError; cdecl;
  // PGP 6.5.X
  PGPKeyIterNextSubKey: function(Iter: pPGPKeyIter;
		var OutRef: pPGPSubKey): PGPError; cdecl;
  // PGP 6.5.X
  PGPKeyIterNextUserID: function(Iter: pPGPKeyIter;
		var OutRef: pPGPUserID): PGPError; cdecl;
  // PGP 6.5.X
  PGPKeyIterNextUIDSig: function(Iter: pPGPKeyIter;
		var OutRef: pPGPSig): PGPError; cdecl;
  // PGP 7.X
  PGPKeyIterNextKeyDBObj7: function(Iter: pPGPKeyIter;
		ObjectType: PGPKeyDBObjType; var OutRef: pPGPKeyDBObj): PGPError; cdecl;
  // PGP 6.5.X
  PGPKeyIterPrev: function(Iter: pPGPKeyIter;
		var OutRef: pPGPKey): PGPError; cdecl;
  // PGP 6.5.X
  PGPKeyIterPrevSubKey: function(Iter: pPGPKeyIter;
		var OutRef: pPGPSubKey): PGPError; cdecl;
  // PGP 6.5.X
  PGPKeyIterPrevUserID: function(Iter: pPGPKeyIter;
		var OutRef: pPGPUserID): PGPError; cdecl;
  // PGP 6.5.X
  PGPKeyIterPrevUIDSig: function(Iter: pPGPKeyIter;
		var OutRef: pPGPSig): PGPError; cdecl;
  // PGP 7.X
  PGPKeyIterPrevKeyDBObj7: function(Iter: pPGPKeyIter;
		ObjectType: PGPKeyDBObjType; var OutRef: pPGPKeyDBObj): PGPError; cdecl;
  // PGP 6.5.X
  PGPKeyIterRewind: function(Iter: pPGPKeyIter): PGPError; cdecl;
  // PGP 6.5.X
  PGPKeyIterRewindSubKey: function(Iter: pPGPKeyIter): PGPError; cdecl;
  // PGP 6.5.X
  PGPKeyIterRewindUserID: function(Iter: pPGPKeyIter): PGPError; cdecl;
  // PGP 6.5.X
  PGPKeyIterRewindUIDSig: function(Iter: pPGPKeyIter): PGPError; cdecl;
  // PGP 7.X
  PGPKeyIterRewindKeyDBObj7: function(Iter: pPGPKeyIter; ObjectType: PGPKeyDBObjType): PGPError; cdecl;

  { Key manipulation functions }
  // PGP 6.5.X
  PGPGenerateKey: function(Context: pPGPContext;
		var Key: pPGPKey;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 7.X
  {PGPGenerateKey: function(Context: pPGPContext;
		var Key: pPGPKeyDBObj;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;}
  // PGP 6.5.X
  PGPGenerateSubKey: function(Context: pPGPContext;
		var SubKey: pPGPSubKey;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 7.X
  {PGPGenerateSubKey: function(Context: pPGPContext;
		var SubKey: pPGPKeyDBObj;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;}
  // PGP 6.5.X
  PGPChangePassphrase6: function(Key: pPGPKey;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 6.5.X
  PGPChangeSubKeyPassphrase6: function(SubKey: pPGPSubKey;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 7.X
  PGPChangePassphrase7: function(Key: pPGPKeyDBObj;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 6.5.X
  PGPEnableKey6: function(Key: pPGPKey): PGPError; cdecl;
  // PGP 6.5.X
  PGPDisableKey6: function(Key: pPGPKey): PGPError; cdecl;
  // PGP 7.X
  PGPSetKeyDBObjEnabled7: function(Key: pPGPKeyDBObj; Enable: PGPBoolean): PGPError; cdecl;
  // PGP 6.5.X
  PGPRevokeKey6: function(Key: pPGPKey;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 6.5.X
  PGPRevokeSubKey6: function(SubKey: pPGPSubKey;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 7.X
  PGPRevoke7: function(Key: pPGPKeyDBObj;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 6.5.X
  PGPSetKeyAxiomatic: function(Key: pPGPKey;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 6.5.X
  PGPUnsetKeyAxiomatic: function(Key: pPGPKey): PGPError; cdecl;
  // PGP 7.X
  PGPSetKeyDBObjAxiomatic: function(Key: pPGPKeyDBObj; SetAxiomatic: PGPBoolean;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 6.5.X
  PGPCompareKeys: function(A: pPGPKey; B: pPGPKey;
		Order: PGPKeyOrdering): PGPInt32; cdecl;
  // PGP 7.X
  {PGPCompareKeys: function(A: pPGPKeyDBObj; B: pPGPKeyDBObj;
		Order: PGPKeyOrdering): PGPInt32; cdecl;}
  // PGP 6.5.X
  PGPRemoveSubKey: function(SubKey: pPGPSubKey): PGPError; cdecl;
  // PGP 6.5.X
  PGPRemoveUserID: function(UserID: pPGPUserID): PGPError; cdecl;
  // PGP 6.5.X
  PGPRemoveSig: function(Cert: pPGPSig): PGPError; cdecl;
  // PGP 7.X
  PGPDeleteKeyDBObj: function(KeyDBObj: pPGPKeyDBObj): PGPError; cdecl;
  // PGP 6.5.X
  PGPAddUserID: function(Key: pPGPKey;
		const UserID: PChar;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 7.X
  {PGPAddUserID: function(Key: pPGPKeyDBObj;
		const UserID: PChar;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;}
  // PGP 6.5.X
  PGPSetPrimaryUserID6: function(UserID: pPGPUserID): PGPError; cdecl;
  // PGP 7.X
  PGPSetPrimaryUserID7: function(UserID: pPGPKeyDBObj;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  // both
  PGPCompareUserIDStrings: function(A: PChar;
		B: PChar): PGPInt32; cdecl;
  // PGP 6.5.X
  PGPSignUserID: function(UserID: pPGPUserID;
		CertifyingKey: pPGPKey;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 7.X
  {PGPCertifyUserID: function(UserID: pPGPKeyDBObj;
		CertifyingKey: pPGPKeyDBObj;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;}
  // PGP 6.5.X
  PGPRevokeSig6: function(Cert: pPGPSig;
		AllKeys: pPGPKeySet;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 7.X
  PGPRevokeSig7: function(Cert: pPGPKeyDBObj;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 6.5.X
  PGPCountAdditionalRecipientRequests: function(BaseKey: pPGPKey;
		var NumARKeys: PGPUInt32): PGPError; cdecl;
  // PGP 7.X
  {PGPCountAdditionalRecipientRequests: function(BaseKey: pPGPKeyDBObj;
		var NumARKeys: PGPUInt32): PGPError; cdecl;}
  // PGP 6.5.X
  PGPGetIndexedAdditionalRecipientRequestKey6: function(BaseKey: pPGPKey;
		AllKeys: pPGPKeySet;
		ARKeyIndex: PGPUInt32;
		var ARKey: pPGPKey;
		var ARKeyID: TPGPKeyID7;
		var ARClass: PGPByte): PGPError; cdecl;
  // PGP 7.X
  PGPGetIndexedAdditionalRecipientRequestKey7: function(BaseKey: pPGPKeyDBObj;
		ARKeyIndex: PGPUInt32;
		var ARKey: pPGPKeyDBObj;
		var ARKeyID: TPGPKeyID7;
		var ARClass: PGPByte): PGPError; cdecl;
  // PGP 6.5.X
  PGPGetSigCertifierKey: function(Cert: pPGPSig;
		AllKeys: pPGPKeySet;
		var CertKey: pPGPKey): PGPError; cdecl;
  // PGP 7.X
  {PGPGetSigCertifierKey: function(Cert: pPGPKeyDBObj;
		AllKeys: pPGPKeyDBObj;
		var CertKey: pPGPKeyDBObj): PGPError; cdecl;}
  // PGP 6.5.X
  PGPCountRevocationKeys: function(BaseKey: pPGPKey;
		var NumRevKeys: PGPUInt32): PGPError; cdecl;
  // PGP 7.X
  {PGPCountRevocationKeys: function(BaseKey: pPGPKeyDBObj;
		var NumRevKeys: PGPUInt32): PGPError; cdecl;}
  // PGP 6.5.X
  PGPGetIndexedRevocationKey6: function(BaseKey: pPGPKey;
		AllKeys: pPGPKeySet;
		RevKeyIndex: PGPUInt32;
		var RevKey: pPGPKey;
		var RevKeyID: TPGPKeyID7): PGPError; cdecl;
  // PGP 7.X
  PGPGetIndexedRevocationKey7: function(BaseKey: pPGPKeyDBObj;
		RevKeyIndex: PGPUInt32;
		var RevKey: pPGPKey;
		var RevKeyID: TPGPKeyID7): PGPError; cdecl;

  { Entropy/Passkey/Passphrase }
  // both
  PGPGetKeyEntropyNeeded: function(Context: pPGPContext;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPUInt32; cdecl;
  // PGP 6.5.X
  PGPGetKeyPasskeyBuffer6: function(Key: pPGPKey;
		 pPasskeyBuffer: Pointer;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 6.5.X
  PGPGetSubKeyPasskeyBuffer6: function(SubKey: pPGPSubKey;
		 pPasskeyBuffer: Pointer;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 7.X
  PGPGetPasskeyBuffer7: function(Key: pPGPKeyDBObj;
		 pPasskeyBuffer: Pointer;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 6.5.X
  PGPPassphraseIsValid: function(Key: pPGPKey;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPBoolean; cdecl;
  // PGP 7.X
  {PGPPassphraseIsValid: function(Key: pPGPKeyDBObj;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPBoolean; cdecl;}

  { Get property functions 6.5.X}
  PGPGetHashAlgUsed: function(Key: pPGPKey;
		var HashAlg: PGPHashAlgorithm): PGPError; cdecl;
  PGPGetKeyBoolean: function(Key: pPGPKey;
		PropName: PGPKeyPropName;
		var Prop: PGPBoolean): PGPError; cdecl;
  PGPGetKeyNumber: function(Key: pPGPKey;
		PropName: PGPKeyPropName;
		var Prop: PGPInt32): PGPError; cdecl;
  PGPGetKeyPropertyBuffer: function(Key: pPGPKey;
		PropName: PGPKeyPropName;
		BufferSize: PGPSize;
		pProp: Pointer;
		var FullSize: PGPSize): PGPError; cdecl;
  PGPGetKeyTime: function(Key: pPGPKey;
		PropName: PGPKeyPropName;
		var Prop: PGPTime): PGPError; cdecl;
  PGPGetSubKeyBoolean: function(SubKey: pPGPSubKey;
		PropName: PGPKeyPropName;
		var Prop: PGPBoolean): PGPError; cdecl;
  PGPGetSubKeyNumber: function(SubKey: pPGPSubKey;
		PropName: PGPKeyPropName;
		var Prop: PGPInt32): PGPError; cdecl;
  PGPGetSubKeyPropertyBuffer: function(SubKey: pPGPSubKey;
		PropName: PGPKeyPropName;
		BufferSize: PGPSize;
		pProp: Pointer;
		var FullSize: PGPSize): PGPError; cdecl;
  PGPGetSubKeyTime: function(SubKey: pPGPSubKey;
		PropName: PGPKeyPropName;
		var Prop: PGPTime): PGPError; cdecl;
  PGPGetUserIDBoolean: function(UserID: pPGPUserID;
		PropName: PGPUserIDPropName;
		var Prop: PGPBoolean): PGPError; cdecl;
  PGPGetUserIDNumber: function(UserID: pPGPUserID;
		PropName: PGPUserIDPropName;
		var Prop: PGPInt32): PGPError; cdecl;
  PGPGetUserIDStringBuffer: function(UserID: pPGPUserID;
		PropName: PGPUserIDPropName;
		BufferSize: PGPSize;
		Data: PChar;
		var FullSize: PGPSize): PGPError; cdecl;
  PGPGetSigBoolean: function(Cert: pPGPSig;
		PropName: PGPSigPropName;
		var Prop: PGPBoolean): PGPError; cdecl;
  PGPGetSigNumber: function(Cert: pPGPSig;
		PropName: PGPSigPropName;
		var Prop: PGPInt32): PGPError; cdecl;
  PGPGetSigPropertyBuffer: function(Cert: pPGPSig;
		PropName: PGPSigPropName;
		BufferSize: PGPSize;
		Data: PChar;
		var FullSize: PGPSize): PGPError; cdecl;
  PGPGetSigTime: function(Cert: pPGPSig;
		PropName: PGPSigPropName;
		var Prop: PGPTime): PGPError; cdecl;
  { Get property functions 7.X}
  PGPGetKeyDBObjBooleanProperty7: function(Obj: pPGPKeyDBObj;
		WhichProperty: PGPKeyDBObjProperty; var Prop: PGPBoolean): PGPError; cdecl;
  PGPGetKeyDBObjNumericProperty7: function(Obj: pPGPKeyDBObj;
		WhichProperty: PGPKeyDBObjProperty; var Prop: PGPInt32): PGPError; cdecl;
  PGPGetKeyDBObjTimeProperty7: function(Obj: pPGPKeyDBObj;
		WhichProperty: PGPKeyDBObjProperty; var Prop: PGPTime): PGPError; cdecl;
  // Get the data for a binary property. Returns kPGPError_BufferTooSmall if
  // the buffer is too small. Both buffer and dataSize can be NULL.
  PGPGetKeyDBObjDataProperty7: function(Obj: pPGPKeyDBObj;
		WhichProperty: PGPKeyDBObjProperty; Buffer: PChar;
		BufferSize: PGPSize; var DataSize: PGPSize): PGPError; cdecl;

  { Convenience property functions }
  // PGP 6.5.X
  PGPGetPrimaryUserID: function(Key: pPGPKey;
		var UserID: pPGPUserID): PGPError; cdecl;
  // PGP 7.X
  {PGPGetPrimaryUserID: function(Key: pPGPKeyDBObj;
		var UserID: pPGPKeyDBObj): PGPError; cdecl;}
  // PGP 6.5.X
  PGPGetPrimaryUserIDNameBuffer6: function(Key: pPGPKey;
		BufferSize: PGPSize;
		UserID: PChar;
		var FullSize: PGPSize): PGPError; cdecl;
  // PGP 7.X
  PGPGetPrimaryUserIDName7: function(Key: pPGPKeyDBObj;
		UserID: PChar;
		BufferSize: PGPSize;
		var FullSize: PGPSize): PGPError; cdecl;
  // PGP 6.5.X
  PGPGetPrimaryUserIDValidity: function(Key: pPGPKey;
		var Validity: PGPValidity): PGPError; cdecl;
  // PGP 7.X
  {PGPGetPrimaryUserIDValidity: function(Key: pPGPKeyBDObj;
		var Validity: PGPValidity): PGPError; cdecl;}

  { Default private key functions 6.5.X }
  PGPSetDefaultPrivateKey: function(Key: pPGPKey): PGPError; cdecl;
  PGPGetDefaultPrivateKey: function(Keyset: pPGPKeySet;
		var Key: pPGPKey): PGPError; cdecl;

  { Key ID functions }
  // PGP 6.5.X
  PGPGetKeyByKeyID6: function(KeySet: pPGPKeySet;
		const PGPKeyID: TPGPKeyID7;
		PubKeyAlgorithm: PGPPublicKeyAlgorithm;
		var Key: pPGPKey): PGPError; cdecl;
  // PGP 7.X
  PGPFindKeyByKeyID7: function(KeyDB: pPGPKeyDB;
  		const PGPKeyID: TPGPKeyID7;
		var Key: pPGPKeyDBObj): PGPError; cdecl;
  // must be in format output by PGPExportKeyID
  // PGP 6.5.X
  PGPImportKeyID: function(const KeyID: PChar;
		var PGPKeyID: TPGPKeyID7): PGPError; cdecl;
  // outputs opaque string of bytes for storage of maximum size as KeyID
  // PGP 6.5.X
  PGPExportKeyID: function(const KeyID: PChar;
		var PGPKeyID: TPGPKeyID7;
		var IDLength: PGPSize): PGPError; cdecl;
  // both
  PGPGetKeyIDString: function(const PGPKeyID: TPGPKeyID7;
		AType: PGPKeyIDStringType;
		KeyID: TKeyID): PGPError; cdecl;
  // PGP 6.5.X
  PGPGetKeyIDFromString6: function(KeyID: PChar;
		var PGPkeyID: TPGPKeyID7): PGPError; cdecl;
  // PGP 7.X
  PGPNewKeyIDFromString7: function(KeyID: PChar;
		PubKeyAlgorithm: PGPPublicKeyAlgorithm;
		var PGPkeyID: TPGPKeyID7): PGPError; cdecl;
  // PGP 6.5.X
  PGPGetKeyIDFromKey6: function(Key: pPGPKey;
		var PGPKeyID: TPGPKeyID7): PGPError; cdecl;
  // PGP 6.5.X
  PGPGetKeyIDFromSubKey6: function(Key: pPGPSubKey;
		var PGPKeyID: TPGPKeyID7): PGPError; cdecl;
  // PGP 6.5.X
  PGPGetKeyIDOfCertifier6: function(Sig: pPGPSig;
		var PGPKeyID: TPGPKeyID7): PGPError; cdecl;
  // PGP 7.X
  PGPGetKeyID7: function(Key: pPGPKeyDBObj;
		var PGPKeyID: TPGPKeyID7): PGPError; cdecl;
  // both
  // returns 0 if equal, -1 if Key1 < Key2, 1 if Key1 > Key2
  PGPCompareKeyIDs: function(var Key: TPGPKeyID7;
		var Key2: TPGPKeyID7): PGPInt32; cdecl;

  { Context retrieval functions both}
  PGPGetKeySetContext: function(KeySet: pPGPKeySet): pPGPContext; cdecl;
  PGPGetKeyListContext: function(KeyList: pPGPKeyList): pPGPContext; cdecl;
  PGPGetKeyIterContext: function(KeyIter: pPGPKeyIter): pPGPContext; cdecl;

  { Context retrieval functions 6.5.X}
  PGPGetKeyContext: function(Key: pPGPKey): pPGPContext; cdecl;
  PGPGetSubKeyContext: function(SubKey: pPGPSubKey): pPGPContext; cdecl;
  PGPGetUserIDContext: function(UserID: pPGPUserID): pPGPContext; cdecl;

  { Context retrieval functions 7.X}
  PGPPeekKeyDBContext: function(KeyDB: pPGPKeyDB): pPGPContext; cdecl;
  PGPPeekKeyDBObjContext: function(KeyDBObj: pPGPKeyDBObj): pPGPContext; cdecl;

  { Self signature options }
  // PGP 6.5.X
  PGPAddKeyOptions: function(Key: pPGPKey;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 7.X
  {PGPAddKeyOptions: function(Key: pPGPKeyDBObj;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError; cdecl;}
  // PGP 6.5.X
  PGPRemoveKeyOptions: function(Key: pPGPKey;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 7.X
  {PGPRemoveKeyOptions: function(Key: pPGPKeyDBObj;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError; cdecl;}
  // PGP 6.5.X
  PGPUpdateKeyOptions: function(Key: pPGPKey;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 7.X
  {PGPUpdateKeyOptions: function(Key: pPGPKeyDBObj;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError; cdecl;}

// wrapper functions for version compatibility
function PGPRemoveKeys(KeysToRemove: pPGPKeySet;
		ASet: pPGPKeySet): PGPError;
function PGPEnableKey(Key: Pointer): PGPError;
function PGPDisableKey(Key: Pointer): PGPError;
function PGPRevokeKey(Key: Pointer;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError;
function PGPRevokeSubKey(SubKey: Pointer;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError;
function PGPOrderKeySet(KeySet: pPGPKeySet;
		Order: PGPKeyOrdering; ReverseOrder: PGPBoolean;
		var KeyList: pPGPKeyList): PGPError;
function PGPKeyIterNextKeyDBObj(Iter: pPGPKeyIter;
		ObjectType: PGPKeyDBObjType; var OutRef: Pointer): PGPError;
function PGPKeyIterPrevKeyDBObj(Iter: pPGPKeyIter;
		ObjectType: PGPKeyDBObjType; var OutRef: Pointer): PGPError;
function PGPKeyIterRewindKeyDBObj(Iter: pPGPKeyIter; ObjectType: PGPKeyDBObjType): PGPError;
function PGPChangePassphrase(Key: Pointer;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError;
function PGPChangeSubKeyPassphrase(SubKey: Pointer;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError;
function PGPSetPrimaryUserID(UserID: pPGPUserID;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError;
function PGPRevokeSig(Cert: Pointer;
		AllKeys: pPGPKeySet;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError;
function PGPGetIndexedAdditionalRecipientRequestKey(BaseKey: Pointer;
		AllKeys: pPGPKeySet;
		ARKeyIndex: PGPUInt32;
		var ARKey: Pointer;
		var ARKeyID: TPGPKeyID7;
		var ARClass: PGPByte): PGPError;
function PGPGetIndexedRevocationKey(BaseKey: Pointer;
		AllKeys: pPGPKeySet;
		RevKeyIndex: PGPUInt32;
		var RevKey: Pointer;
		var RevKeyID: TPGPKeyID7): PGPError;
function PGPGetKeyPasskeyBuffer(Key: pPGPKey;
		 pPasskeyBuffer: Pointer;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError;
function PGPGetSubKeyPasskeyBuffer(SubKey: pPGPSubKey;
		 pPasskeyBuffer: Pointer;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError;
function PGPGetPrimaryUserIDNameBuffer(Key: Pointer;
		UserID: PChar;
		BufferSize: PGPSize;
		var FullSize: PGPSize): PGPError;
function PGPGetKeyByKeyID(KeySet: pPGPKeySet;
		const PGPKeyID: TPGPKeyID7;
		PubKeyAlgorithm: PGPPublicKeyAlgorithm;
		var Key: Pointer): PGPError;
function PGPGetKeyIDFromString(KeyID: PChar;
		PubKeyAlgorithm: PGPPublicKeyAlgorithm;
		var PGPkeyID: TPGPKeyID7): PGPError;
function PGPGetKeyIDFromKey(Key: pPGPKey;
		var PGPKeyID: TPGPKeyID7): PGPError;
function PGPGetKeyIDFromSubKey(Key: pPGPSubKey;
		var PGPKeyID: TPGPKeyID7): PGPError;
function PGPGetKeyIDOfCertifier(Sig: pPGPSig;
		var PGPKeyID: TPGPKeyID7): PGPError;
function PGPNewKeyDBObjBooleanFilter(Context: pPGPContext;
		WhichProperty: PGPKeyDBObjProperty; Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError;
function PGPNewKeyDBObjNumericFilter(Context: pPGPContext;
		WhichProperty: PGPKeyDBObjProperty; MatchValue: PGPUInt32;
		MatchCriteria: PGPMatchCriterion; var OutFilter: pPGPFilter): PGPError;
function PGPNewKeyDBObjTimeFilter(Context: pPGPContext;
		WhichProperty: PGPKeyDBObjProperty; MatchValue: PGPTime;
		MatchCriteria: PGPMatchCriterion; var OutFilter: pPGPFilter): PGPError;
function PGPNewKeyDBObjDataFilter(Context: pPGPContext;
		WhichProperty: PGPKeyDBObjProperty; const MatchData: Pointer;
		MatchDataSize: PGPSize; MatchCriteria: PGPMatchCriterion;
		var OutFilter: pPGPFilter): PGPError;
function PGPGetKeyDBObjBooleanProperty(Obj: Pointer;
		WhichProperty: PGPKeyDBObjProperty; var Prop: PGPBoolean): PGPError;
function PGPGetKeyDBObjNumericProperty(Obj: Pointer;
		WhichProperty: PGPKeyDBObjProperty; var Prop: PGPInt32): PGPError;
function PGPGetKeyDBObjTimeProperty(Obj: Pointer;
		WhichProperty: PGPKeyDBObjProperty; var Prop: PGPTime): PGPError;
function PGPGetKeyDBObjDataProperty(Obj: Pointer;
		WhichProperty: PGPKeyDBObjProperty; Buffer: PChar;
		BufferSize: PGPSize; var DataSize: PGPSize): PGPError;

implementation	// code modified by idw

uses
  Windows;

function PGPRemoveKeys(KeysToRemove: pPGPKeySet;
		ASet: pPGPKeySet): PGPError;
begin
  if PGP7X then
    Result:=PGPDeleteKeys7(KeysToRemove)
  else Result:=PGPRemoveKeys6(KeysToRemove, ASet);
end;

function PGPEnableKey(Key: Pointer): PGPError;
begin
  if PGP7X
    then Result:=PGPSetKeyDBObjEnabled7(pPGPKeyDBObj(Key), PGPTrue)
  else Result:=PGPEnableKey6(pPGPKey(Key));
end;

function PGPDisableKey(Key: Pointer): PGPError;
begin
  if PGP7X
    then Result:=PGPSetKeyDBObjEnabled7(pPGPKeyDBObj(Key), PGPFalse)
  else Result:=PGPDisableKey6(pPGPKey(Key));
end;

function PGPRevokeKey(Key: Pointer;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError;
begin
  if PGP7X
    then Result:=PGPRevoke7(pPGPKeyDBObj(Key), Options, LastOption)
  else Result:=PGPRevokeKey6(pPGPKey(Key), Options, LastOption);
end;

function PGPRevokeSubKey(SubKey: Pointer;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError;
begin
  if PGP7X
    then Result:=PGPRevoke7(pPGPKeyDBObj(SubKey), Options, LastOption)
  else Result:=PGPRevokeSubKey6(pPGPSubKey(SubKey), Options, LastOption);
end;

// takes PGP 7.X PGPKeyOrdering constants
function PGPOrderKeySet(KeySet: pPGPKeySet;
		Order: PGPKeyOrdering; ReverseOrder: PGPBoolean;
		var KeyList: pPGPKeyList): PGPError;
begin
  if PGP7X then
    Result:=PGPOrderKeySet7(KeySet, Order, ReverseOrder, KeyList)
  else begin
    if Order>kPGPKeyOrdering_Any then Order:=pred(Order) shl 1 + ReverseOrder;
    Result:=PGPOrderKeySet6(KeySet, Order, KeyList);
  end;
end;

// takes PGP 7.X PGPKeyDBObjType constants
function PGPKeyIterNextKeyDBObj(Iter: pPGPKeyIter;
		ObjectType: PGPKeyDBObjType; var OutRef: Pointer): PGPError;
begin
  if PGP7X then
    Result:=PGPKeyIterNextKeyDBObj7(Iter, ObjectType, pPGPKeyDBObj(OutRef))
  else begin
    case ObjectType of
      kPGPKeyDBObjType_Key: Result:=PGPKeyIterNext(Iter, pPGPKey(OutRef));
      kPGPKeyDBObjType_SubKey: Result:=PGPKeyIterNextSubKey(Iter, pPGPSubKey(OutRef));
      kPGPKeyDBObjType_UserID: Result:=PGPKeyIterNextUserID(Iter, pPGPUserID(OutRef));
      kPGPKeyDBObjType_Signature: Result:=PGPKeyIterNextUIDSig(Iter, pPGPSig(OutRef));
    else
      Result:=kPGPError_EndOfIteration;
    end;
  end;
end;

// takes PGP 7.X PGPKeyDBObjType constants
function PGPKeyIterPrevKeyDBObj(Iter: pPGPKeyIter;
		ObjectType: PGPKeyDBObjType; var OutRef: Pointer): PGPError;
begin
  if PGP7X then
    Result:=PGPKeyIterPrevKeyDBObj7(Iter, ObjectType, pPGPKeyDBObj(OutRef))
  else begin
    case ObjectType of
      kPGPKeyDBObjType_Key: Result:=PGPKeyIterPrev(Iter, pPGPKey(OutRef));
      kPGPKeyDBObjType_SubKey: Result:=PGPKeyIterPrevSubKey(Iter, pPGPSubKey(OutRef));
      kPGPKeyDBObjType_UserID: Result:=PGPKeyIterPrevUserID(Iter, pPGPUserID(OutRef));
      kPGPKeyDBObjType_Signature: Result:=PGPKeyIterPrevUIDSig(Iter, pPGPSig(OutRef));
    else
      Result:=kPGPError_EndOfIteration;
    end;
  end;
end;

// takes PGP 7.X PGPKeyDBObjType constants
function PGPKeyIterRewindKeyDBObj(Iter: pPGPKeyIter; ObjectType: PGPKeyDBObjType): PGPError;
begin
  if PGP7X then
    Result:=PGPKeyIterRewindKeyDBObj7(Iter, ObjectType)
  else begin
    case ObjectType of
      kPGPKeyDBObjType_Key: Result:=PGPKeyIterRewind(Iter);
      kPGPKeyDBObjType_SubKey: Result:=PGPKeyIterRewindSubKey(Iter);
      kPGPKeyDBObjType_UserID: Result:=PGPKeyIterRewindUserID(Iter);
      kPGPKeyDBObjType_Signature: Result:=PGPKeyIterRewindUIDSig(Iter);
    else
      Result:=kPGPError_EndOfIteration;
    end;
  end;
end;

function PGPChangePassphrase(Key: Pointer;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError;
begin
  if PGP7X then
    Result:=PGPChangePassphrase7(pPGPKeyDBObj(Key), Options, LastOption)
  else Result:=PGPChangePassphrase6(pPGPKey(Key), Options, LastOption);
end;

function PGPChangeSubKeyPassphrase(SubKey: Pointer;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError;
begin
  if PGP7X then
    Result:=PGPChangePassphrase7(pPGPKeyDBObj(SubKey), Options, LastOption)
  else Result:=PGPChangeSubKeyPassphrase6(pPGPSubKey(SubKey), Options, LastOption);
end;

// UserID type depends on PGP version
function PGPSetPrimaryUserID(UserID: Pointer;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError;
begin
  if PGP7X then
    Result:=PGPSetPrimaryUserID7(pPGPKeyDBObj(UserID), Options, LastOption)
  else Result:=PGPSetPrimaryUserID6(pPGPUserID(UserID));
end;

// Cert type depends on PGP version
function PGPRevokeSig(Cert: Pointer;
		AllKeys: pPGPKeySet;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError;
begin
  if PGP7X then
    Result:=PGPRevokeSig7(pPGPKeyDBObj(Cert), Options, LastOption)
  else Result:=PGPRevokeSig6(pPGPSig(Cert), AllKeys, Options, LastOption);
end;

// BaseKey/ARKey types depend on PGP version
function PGPGetIndexedAdditionalRecipientRequestKey(BaseKey: pPGPKey;
		AllKeys: pPGPKeySet;
		ARKeyIndex: PGPUInt32;
		var ARKey: pPGPKey;
		var ARKeyID: TPGPKeyID7;
		var ARClass: PGPByte): PGPError;
begin
  if PGP7X then
    Result:=PGPGetIndexedAdditionalRecipientRequestKey7(pPGPKeyDBObj(BaseKey), ARKeyIndex,
							pPGPKeyDBObj(ARKey), ARKeyID, ARClass)
  else Result:=PGPGetIndexedAdditionalRecipientRequestKey6(pPGPKey(BaseKey), AllKeys, ARKeyIndex,
							   pPGPKey(ARKey), ARKeyID, ARClass);
end;

// BaseKey/RevKey types depend on PGP version
function PGPGetIndexedRevocationKey(BaseKey: Pointer;
		AllKeys: pPGPKeySet;
		RevKeyIndex: PGPUInt32;
		var RevKey: Pointer;
		var RevKeyID: TPGPKeyID7): PGPError;
begin
  if PGP7X then
    Result:=PGPGetIndexedRevocationKey7(pPGPKeyDBObj(BaseKey), RevKeyIndex,
					pPGPKeyDBObj(RevKey), RevKeyID)
  else Result:=PGPGetIndexedRevocationKey6(pPGPKey(BaseKey), AllKeys, RevKeyIndex,
					   pPGPKey(RevKey), RevKeyID);
end;

function PGPGetKeyPasskeyBuffer(Key: pPGPKey;
		 pPasskeyBuffer: Pointer;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError;
begin
  if PGP7X then
    Result:=PGPGetPasskeyBuffer7(Key, pPasskeyBuffer, Options, LastOption)
  else Result:=PGPGetKeyPasskeyBuffer6(Key, pPasskeyBuffer, Options, LastOption);
end;

function PGPGetSubKeyPasskeyBuffer(SubKey: pPGPSubKey;
		 pPasskeyBuffer: Pointer;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError;
begin
  if PGP7X then
    Result:=PGPGetPasskeyBuffer7(SubKey, pPasskeyBuffer, Options, LastOption)
  else Result:=PGPGetSubKeyPasskeyBuffer6(SubKey, pPasskeyBuffer, Options, LastOption);
end;

// Key type depends on PGP version
function PGPGetPrimaryUserIDNameBuffer(Key: Pointer;
		UserID: PChar;
		BufferSize: PGPSize;
		var FullSize: PGPSize): PGPError;
begin
  if PGP7X then
    Result:=PGPGetPrimaryUserIDName7(pPGPKeyDBObj(Key), UserID, BufferSize, FullSize)
  else Result:=PGPGetPrimaryUserIDNameBuffer6(pPGPKey(Key), BufferSize, UserID, FullSize);
end;

// Keys/Key types depend on PGP version
function PGPGetKeyByKeyID(KeySet: pPGPKeySet;
		const PGPKeyID: TPGPKeyID7;
		PubKeyAlgorithm: PGPPublicKeyAlgorithm;
		var Key: Pointer): PGPError;
begin
  if PGP7X then
    Result:=PGPFindKeyByKeyID7(PGPPeekKeySetKeyDB(KeySet), PGPKeyID, pPGPKeyDBObj(Key))
  else Result:=PGPGetKeyByKeyID6(pPGPKeySet(KeySet), PGPKeyID, PubKeyAlgorithm, pPGPKey(Key));
end;

// no version specific types
function PGPGetKeyIDFromString(KeyID: PChar;
		PubKeyAlgorithm: PGPPublicKeyAlgorithm;
		var PGPkeyID: TPGPKeyID7): PGPError;
begin
  if PGP7X then
    Result:=PGPNewKeyIDFromString7(KeyID, PubKeyAlgorithm, PGPkeyID)
  else Result:=PGPGetKeyIDFromString6(KeyID, PGPkeyID);
end;

// Key type depends on PGP version
function PGPGetKeyIDFromKey(Key: Pointer;
		var PGPKeyID: TPGPKeyID7): PGPError;
begin
  if PGP7X then
    Result:=PGPGetKeyID7(pPGPKeyDBObj(Key), PGPKeyID)
  else Result:=PGPGetKeyIDFromKey6(pPGPKey(Key), PGPKeyID);
end;

// Key type depends on PGP version
function PGPGetKeyIDFromSubKey(Key: Pointer;
		var PGPKeyID: TPGPKeyID7): PGPError;
begin
  if PGP7X then
    Result:=PGPGetKeyID7(pPGPKeyDBObj(Key), PGPKeyID)
  else Result:=PGPGetKeyIDFromSubKey6(pPGPSubKey(Key), PGPKeyID);
end;

// Sig type depends on PGP version
function PGPGetKeyIDOfCertifier(Sig: Pointer;
		var PGPKeyID: TPGPKeyID7): PGPError;
begin
  if PGP7X then
    Result:=PGPGetKeyID7(pPGPKeyDBObj(Sig), PGPKeyID)
  else Result:=PGPGetKeyIDOfCertifier6(pPGPSig(Sig), PGPKeyID);
end;

// takes PGP 7.X PGPKeyDBObjProperty constants
function PGPNewKeyDBObjBooleanFilter(Context: pPGPContext;
		WhichProperty: PGPKeyDBObjProperty; Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError;
begin
  if PGP7X then
    Result:=PGPNewKeyDBObjBooleanFilter7(Context, WhichProperty, Match, OutFilter)
  else begin
    // only implements selected filters
    case WhichProperty of
      kPGPKeyProperty_IsSecret: Result:=PGPNewKeyBooleanFilter(Context, WhichProperty, Match, OutFilter);
      kPGPKeyProperty_IsDisabled: Result:=PGPNewKeyDisabledFilter(Context, Match, OutFilter);
      kPGPKeyProperty_CanEncrypt..kPGPKeyProperty_CanVerify: begin
	WhichProperty:=WhichProperty - kPGPKeyProperty_CanEncrypt + kPGPKeyPropCanEncrypt;
	Result:=PGPNewKeyBooleanFilter(Context, WhichProperty, Match, OutFilter);
      end;
    else
      Result:=kPGPError_InvalidProperty;
    end;
  end;
end;

// takes PGP 7.X PGPKeyDBObjProperty constants
function PGPNewKeyDBObjNumericFilter(Context: pPGPContext;
		WhichProperty: PGPKeyDBObjProperty; MatchValue: PGPUInt32;
		MatchCriteria: PGPMatchCriterion; var OutFilter: pPGPFilter): PGPError;
begin
  if PGP7X then
    Result:=PGPNewKeyDBObjNumericFilter7(Context, WhichProperty, MatchValue, MatchCriteria, OutFilter)
  else begin
    // only implements selected filters
    case WhichProperty of
      kPGPKeyProperty_AlgorithmID: Result:=PGPNewKeySigAlgorithmFilter(Context, MatchValue, OutFilter);
      kPGPKeyProperty_Validity: begin
	Result:=PGPNewKeyNumberFilter(Context, kPGPKeyPropValidity, MatchValue, MatchCriteria, OutFilter);
      end;
    else
      Result:=kPGPError_InvalidProperty;
    end;
  end;
end;

// takes PGP 7.X PGPKeyDBObjProperty constants
function PGPNewKeyDBObjTimeFilter(Context: pPGPContext;
		WhichProperty: PGPKeyDBObjProperty; MatchValue: PGPTime;
		MatchCriteria: PGPMatchCriterion; var OutFilter: pPGPFilter): PGPError;
begin
  if PGP7X then
    Result:=PGPNewKeyDBObjTimeFilter7(Context, WhichProperty, MatchValue, MatchCriteria, OutFilter)
  else begin
    // only implements selected filters
    case WhichProperty of
      kPGPKeyProperty_Creation: Result:=PGPNewKeyCreationTimeFilter(Context, MatchValue, MatchCriteria, OutFilter);
      kPGPKeyProperty_Expiration: Result:=PGPNewKeyExpirationTimeFilter(Context, MatchValue, MatchCriteria, OutFilter);
    else
      Result:=kPGPError_InvalidProperty;
    end;
  end;
end;

// takes PGP 7.X PGPKeyDBObjProperty constants
function PGPNewKeyDBObjDataFilter(Context: pPGPContext;
		WhichProperty: PGPKeyDBObjProperty; const MatchData: Pointer;
		MatchDataSize: PGPSize; MatchCriteria: PGPMatchCriterion;
		var OutFilter: pPGPFilter): PGPError;
begin
  if PGP7X then
    Result:=PGPNewKeyDBObjDataFilter7(Context, WhichProperty, MatchData, MatchDataSize, MatchCriteria, OutFilter)
  else begin
    // only implements selected filters
    case WhichProperty of
      kPGPKeyProperty_KeyID: Result:=PGPNewKeyIDFilter(Context, pPGPKeyID7(MatchData)^, OutFilter);
      kPGPSubKeyProperty_KeyID: Result:=PGPNewSubKeyIDFilter(Context, pPGPKeyID7(MatchData)^, OutFilter);
      kPGPSigProperty_KeyID: Result:=PGPNewSigKeyIDFilter(Context, pPGPKeyID7(MatchData)^, OutFilter);
      kPGPUserIDProperty_Name: Result:=PGPNewUserIDStringFilter(Context, MatchData, MatchCriteria, OutFilter);
      kPGPUserIDProperty_CommonName: Result:=PGPNewUserIDNameFilter(Context, MatchData, MatchCriteria, OutFilter);
      kPGPUserIDProperty_EmailAddress: Result:=PGPNewUserIDEmailFilter(Context, MatchData, MatchCriteria, OutFilter);
    else
      Result:=kPGPError_InvalidProperty;
    end;
  end;
end;

// takes PGP 7.X PGPKeyDBObjProperty constants
function PGPGetKeyDBObjBooleanProperty(Obj: Pointer;
		WhichProperty: PGPKeyDBObjProperty; var Prop: PGPBoolean): PGPError;
begin
  if PGP7X then
    Result:=PGPGetKeyDBObjBooleanProperty7(pPGPKeyDBObj(Obj), WhichProperty, Prop)
  else begin
    // only implements compatible properties
    case WhichProperty of
      kPGPKeyProperty_IsSecret..kPGPKeyProperty_HasThirdPartyRevocation: begin
	WhichProperty:=WhichProperty - kPGPKeyProperty_IsSecret + kPGPKeyPropIsSecret;
	Result:=PGPGetKeyBoolean(pPGPKey(Obj), WhichProperty, Prop);
      end;
      kPGPSubKeyProperty_IsRevoked..kPGPSubKeyProperty_HasThirdPartyRevocation: begin
	case WhichProperty of
	  kPGPSubKeyProperty_IsRevoked: WhichProperty:=kPGPKeyPropIsRevoked;
	  kPGPSubKeyProperty_IsNotCorrupt..kPGPSubKeyProperty_HasUnverifiedRevocation: begin
	    WhichProperty:=WhichProperty - kPGPSubKeyProperty_IsNotCorrupt + kPGPKeyPropIsNotCorrupt;
	  end;
	  kPGPSubKeyProperty_IsRevocable..kPGPSubKeyProperty_HasThirdPartyRevocation: begin
	    WhichProperty:=WhichProperty - kPGPSubKeyProperty_IsRevocable + kPGPKeyPropIsRevocable;
	  end;
	end;
	Result:=PGPGetSubKeyBoolean(pPGPSubKey(Obj), WhichProperty, Prop);
      end;
      kPGPUserIDProperty_IsAttribute: begin
	WhichProperty:=kPGPUserIDPropIsAttribute;
	Result:=PGPGetUserIDBoolean(pPGPUserID(Obj), WhichProperty, Prop);
      end;
      kPGPSigProperty_IsRevoked..kPGPSigProperty_IsX509: begin
	WhichProperty:=WhichProperty - kPGPSigProperty_IsRevoked + kPGPSigPropIsRevoked;
	Result:=PGPGetSigBoolean(pPGPSig(Obj), WhichProperty, Prop);
      end;
    else
      Result:=kPGPError_InvalidProperty;
    end;
  end;
end;

// takes PGP 7.X PGPKeyDBObjProperty constants
function PGPGetKeyDBObjNumericProperty(Obj: Pointer;
		WhichProperty: PGPKeyDBObjProperty; var Prop: PGPInt32): PGPError;
begin
  if PGP7X then
    Result:=PGPGetKeyDBObjNumericProperty7(pPGPKeyDBObj(Obj), WhichProperty, Prop)
  else begin
    // only implements compatible properties
    case WhichProperty of
      kPGPKeyProperty_AlgorithmID..kPGPKeyProperty_Flags: begin
	WhichProperty:=WhichProperty - kPGPKeyProperty_AlgorithmID + kPGPKeyPropAlgID;
	Result:=PGPGetKeyNumber(pPGPKey(Obj), WhichProperty, Prop);
      end;
      kPGPKeyProperty_HashAlgorithmID: Result:=PGPGetHashAlgUsed(pPGPKey(Obj), Prop);
      kPGPSubKeyProperty_AlgorithmID..kPGPSubKeyProperty_Flags: begin
	case WhichProperty of
	  kPGPSubKeyProperty_AlgorithmID..kPGPSubKeyProperty_Bits: begin
	    WhichProperty:=WhichProperty - kPGPSubKeyProperty_AlgorithmID + kPGPKeyPropAlgID;
	  end;
	  kPGPSubKeyProperty_LockingAlgorithmID..kPGPSubKeyProperty_LockingBits: begin
	    WhichProperty:=WhichProperty - kPGPSubKeyProperty_LockingAlgorithmID + kPGPKeyPropLockingAlgID;
	  end;
	  kPGPSubKeyProperty_Version: begin
	    Result:=kPGPError_InvalidProperty;
	    Exit;
	  end;
	  kPGPSubKeyProperty_Flags: WhichProperty:=kPGPKeyProperty_Flags;
	end;
	Result:=PGPGetSubKeyNumber(pPGPSubKey(Obj), WhichProperty, Prop);
      end;
      kPGPUserIDProperty_Validity..kPGPUserIDProperty_AttributeType: begin
	WhichProperty:=WhichProperty - kPGPUserIDProperty_Validity + kPGPUserIDPropValidity;
	Result:=PGPGetUserIDNumber(pPGPUserID(Obj), WhichProperty, Prop);
      end;
      kPGPSigProperty_AlgorithmID..kPGPSigProperty_TrustValue: begin
	WhichProperty:=WhichProperty - kPGPSigProperty_AlgorithmID + kPGPSigPropTrustValue;
	Result:=PGPGetSigNumber(pPGPSig(Obj), WhichProperty, Prop);
      end;
    else
      Result:=kPGPError_InvalidProperty;
    end;
  end;
end;

// takes PGP 7.X PGPKeyDBObjProperty constants
function PGPGetKeyDBObjTimeProperty(Obj: Pointer;
		WhichProperty: PGPKeyDBObjProperty; var Prop: PGPTime): PGPError;
begin
  if PGP7X then
    Result:=PGPGetKeyDBObjTimeProperty7(pPGPKeyDBObj(Obj), WhichProperty, Prop)
  else begin
    // only implements compatible properties
    case WhichProperty of
      kPGPKeyProperty_Creation..kPGPKeyProperty_Expiration: begin
	WhichProperty:=WhichProperty - kPGPKeyProperty_Creation + kPGPKeyPropCreation;
	Result:=PGPGetKeyTime(pPGPKey(Obj), WhichProperty, Prop);
      end;
      kPGPSubKeyProperty_Creation..kPGPSubKeyProperty_Expiration: begin
	WhichProperty:=WhichProperty - kPGPSubKeyProperty_Creation + kPGPKeyPropCreation;
	Result:=PGPGetSubKeyTime(pPGPSubKey(Obj), WhichProperty, Prop);
      end;
      kPGPSigProperty_Creation..kPGPSigProperty_Expiration: begin
	WhichProperty:=WhichProperty - kPGPSigProperty_Creation + kPGPSigPropCreation;
	Result:=PGPGetSigTime(pPGPSig(Obj), WhichProperty, Prop);
      end;
    else
      Result:=kPGPError_InvalidProperty;
    end;
  end;
end;

// takes PGP 7.X PGPKeyDBObjProperty constants
function PGPGetKeyDBObjDataProperty(Obj: Pointer;
		WhichProperty: PGPKeyDBObjProperty; Buffer: PChar;
		BufferSize: PGPSize; var DataSize: PGPSize): PGPError;
begin
  if PGP7X then
    Result:=PGPGetKeyDBObjDataProperty7(pPGPKeyDBObj(Obj), WhichProperty, Buffer, BufferSize, DataSize)
  else begin
    // only implements compatible properties
    case WhichProperty of
      kPGPKeyProperty_Fingerprint..kPGPKeyProperty_ThirdPartyRevocationKeyID: begin
	case WhichProperty of
	  kPGPKeyProperty_Fingerprint: WhichProperty:=kPGPKeyPropFingerprint;
	  kPGPKeyProperty_KeyID: begin
	    Result:=kPGPError_InvalidProperty;
	    Exit;
	  end;
	  kPGPKeyProperty_PreferredAlgorithms..kPGPKeyProperty_ThirdPartyRevocationKeyID: begin
	    WhichProperty:=WhichProperty - kPGPKeyProperty_PreferredAlgorithms + kPGPKeyPropPreferredAlgorithms;
	  end;
	end;
	Result:=PGPGetKeyPropertyBuffer(pPGPKey(Obj), WhichProperty, BufferSize, Buffer, DataSize);
      end;
      kPGPUserIDProperty_Name..kPGPUserIDProperty_AttributeData: begin
	WhichProperty:=WhichProperty - kPGPUserIDProperty_Name + kPGPUserIDPropName;
	Result:=PGPGetUserIDStringBuffer(pPGPUserID(Obj), WhichProperty, BufferSize, Buffer, DataSize);
      end;
      kPGPSigProperty_KeyID..kPGPSigProperty_X509Certificate: begin
	WhichProperty:=WhichProperty - kPGPSigProperty_KeyID + kPGPSigPropKeyID;
	Result:=PGPGetSigPropertyBuffer(pPGPSig(Obj), WhichProperty, BufferSize, Buffer, DataSize);
      end;
    else
      Result:=kPGPError_InvalidProperty;
    end;
  end;
end;

initialization

  if PGPInitErrorCode=ieNone then begin
    if PGP7X then begin
      kPGPKeyIDString_Abbreviated:=1;
      kPGPKeyIDString_Full:= 2;
      PGPNewKeyDB:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyDB');
      PGPOpenKeyDBFile:=GetProcAddress(hPGPsdkLib, 'PGPOpenKeyDBFile');
      PGPFreeKeyDB:=GetProcAddress(hPGPsdkLib, 'PGPFreeKeyDB');
      PGPFlushKeyDB:=GetProcAddress(hPGPsdkLib, 'PGPFlushKeyDB');
      PGPIncKeyDBRefCount:=GetProcAddress(hPGPsdkLib, 'PGPIncKeyDBRefCount');
      PGPKeyDBIsMutable:=GetProcAddress(hPGPsdkLib, 'PGPKeyDBIsMutable');
      PGPKeyDBIsUpdated:=GetProcAddress(hPGPsdkLib, 'PGPKeyDBIsUpdated');
      PGPCountKeysInKeyDB:=GetProcAddress(hPGPsdkLib, 'PGPCountKeysInKeyDB');
      PGPPeekKeyDBRootKeySet:=GetProcAddress(hPGPsdkLib, 'PGPPeekKeyDBRootKeySet');
      PGPPeekKeySetKeyDB:=GetProcAddress(hPGPsdkLib, 'PGPPeekKeySetKeyDB');
      PGPNewKeySet:=GetProcAddress(hPGPsdkLib, 'PGPNewKeySet');
      PGPNewEmptyKeySet:=GetProcAddress(hPGPsdkLib, 'PGPNewEmptyKeySet');
      PGPNewSingletonKeySet:=GetProcAddress(hPGPsdkLib, 'PGPNewOneKeySet');
      PGPIncKeySetRefCount:=GetProcAddress(hPGPsdkLib, 'PGPIncKeySetRefCount');
      PGPFreeKeySet:=GetProcAddress(hPGPsdkLib, 'PGPFreeKeySet');
      PGPImport:=GetProcAddress(hPGPsdkLib, 'PGPImport');
      PGPExport:=GetProcAddress(hPGPsdkLib, 'PGPExport');
      PGPCopyKeys:=GetProcAddress(hPGPsdkLib, 'PGPCopyKeys');
      PGPAddKeys:=GetProcAddress(hPGPsdkLib, 'PGPAddKeys');
      PGPDeleteKeys7:=GetProcAddress(hPGPsdkLib, 'PGPDeleteKeys');
      PGPCountKeys:=GetProcAddress(hPGPsdkLib, 'PGPCountKeys');
      PGPKeySetIsMember:=GetProcAddress(hPGPsdkLib, 'PGPKeySetIsMember');
      PGPNewKeyDBObjBooleanFilter7:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyDBObjBooleanFilter');
      PGPNewKeyDBObjNumericFilter7:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyDBObjNumericFilter');
      PGPNewKeyDBObjTimeFilter7:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyDBObjTimeFilter');
      PGPNewKeyDBObjDataFilter7:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyDBObjDataFilter');
      PGPIncFilterRefCount:=GetProcAddress(hPGPsdkLib, 'PGPIncFilterRefCount');
      PGPNegateFilter:=GetProcAddress(hPGPsdkLib, 'PGPNegateFilter');
      PGPIntersectFilters:=GetProcAddress(hPGPsdkLib, 'PGPIntersectFilters');
      PGPUnionFilters:=GetProcAddress(hPGPsdkLib, 'PGPUnionFilters');
      PGPFreeFilter:=GetProcAddress(hPGPsdkLib, 'PGPFreeFilter');
      PGPFilterKeySet:=GetProcAddress(hPGPsdkLib, 'PGPFilterKeySet');
      PGPOrderKeySet7:=GetProcAddress(hPGPsdkLib, 'PGPOrderKeySet');
      PGPIncKeyListRefCount:=GetProcAddress(hPGPsdkLib, 'PGPIncKeyListRefCount');
      PGPFreeKeyList:=GetProcAddress(hPGPsdkLib, 'PGPFreeKeyList');
      PGPNewKeyIter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyIter');
      PGPNewKeyIterFromKeySet:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyIterFromKeySet');
      PGPNewKeyIterFromKeyDB:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyIterFromKeyDB');
      PGPCopyKeyIter:=GetProcAddress(hPGPsdkLib, 'PGPCopyKeyIter');
      PGPFreeKeyIter:=GetProcAddress(hPGPsdkLib, 'PGPFreeKeyIter');
      PGPKeyIterIndex:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterIndex');
      PGPKeyIterGetKeyDBObj:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterGetKeyDBObj');
      PGPKeyIterMove:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterMove');
      PGPKeyIterSeek:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterSeek');
      PGPKeyIterNextKeyDBObj7:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterNextKeyDBObj');
      PGPKeyIterPrevKeyDBObj7:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterPrevKeyDBObj');
      PGPKeyIterRewindKeyDBObj7:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterRewind');
      PGPGenerateKey:=GetProcAddress(hPGPsdkLib, 'PGPGenerateKey');
      PGPGenerateSubKey:=GetProcAddress(hPGPsdkLib, 'PGPGenerateSubKey');
      PGPChangePassphrase7:=GetProcAddress(hPGPsdkLib, 'PGPChangePassphrase');
      PGPSetKeyDBObjEnabled7:=GetProcAddress(hPGPsdkLib, 'PGPSetKeyEnabled');
      PGPRevoke7:=GetProcAddress(hPGPsdkLib, 'PGPRevoke');
      PGPSetKeyDBObjAxiomatic:=GetProcAddress(hPGPsdkLib, 'PGPSetKeyAxiomatic');
      PGPCompareKeys:=GetProcAddress(hPGPsdkLib, 'PGPCompareKeys');
      PGPDeleteKeyDBObj:=GetProcAddress(hPGPsdkLib, 'PGPDeleteKeyDBObj');
      PGPAddUserID:=GetProcAddress(hPGPsdkLib, 'PGPAddUserID');
      PGPSetPrimaryUserID7:=GetProcAddress(hPGPsdkLib, 'PGPSetPrimaryUserID');
      PGPCompareUserIDStrings:=GetProcAddress(hPGPsdkLib, 'PGPCompareUserIDStrings');
      PGPSignUserID:=GetProcAddress(hPGPsdkLib, 'PGPCertifyUserID');
      PGPRevokeSig7:=GetProcAddress(hPGPsdkLib, 'PGPRevokeSig');
      PGPCountAdditionalRecipientRequests:=GetProcAddress(hPGPsdkLib, 'PGPCountAdditionalRecipientRequests');
      PGPGetIndexedAdditionalRecipientRequestKey7:=GetProcAddress(hPGPsdkLib, 'PGPGetIndexedAdditionalRecipientRequestKey');
      PGPGetSigCertifierKey:=GetProcAddress(hPGPsdkLib, 'PGPGetSigCertifierKey');
      PGPCountRevocationKeys:=GetProcAddress(hPGPsdkLib, 'PGPCountRevocationKeys');
      PGPGetIndexedRevocationKey7:=GetProcAddress(hPGPsdkLib, 'PGPGetIndexedRevocationKey');
      PGPGetKeyEntropyNeeded:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyEntropyNeeded');
      PGPGetPasskeyBuffer7:=GetProcAddress(hPGPsdkLib, 'PGPGetPasskeyBuffer');
      PGPPassphraseIsValid:=GetProcAddress(hPGPsdkLib, 'PGPPassphraseIsValid');
      PGPGetKeyDBObjBooleanProperty7:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyDBObjBooleanProperty');
      PGPGetKeyDBObjNumericProperty7:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyDBObjNumericProperty');
      PGPGetKeyDBObjTimeProperty7:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyDBObjTimeProperty');
      PGPGetKeyDBObjDataProperty7:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyDBObjDataProperty');
      PGPGetPrimaryUserID:=GetProcAddress(hPGPsdkLib, 'PGPGetPrimaryUserID');
      PGPGetPrimaryUserIDName7:=GetProcAddress(hPGPsdkLib, 'PGPGetPrimaryUserIDName');
      PGPGetPrimaryUserIDValidity:=GetProcAddress(hPGPsdkLib, 'PGPGetPrimaryUserIDValidity');
      PGPFindKeyByKeyID7:=GetProcAddress(hPGPsdkLib, 'PGPFindKeyByKeyID');
      PGPGetKeyIDString:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyIDString');
      PGPNewKeyIDFromString7:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyIDFromString');
      PGPGetKeyID7:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyID');
      PGPCompareKeyIDs:=GetProcAddress(hPGPsdkLib, 'PGPCompareKeyIDs');
      PGPGetKeySetContext:=GetProcAddress(hPGPsdkLib, 'PGPPeekKeySetContext');
      PGPGetKeyListContext:=GetProcAddress(hPGPsdkLib, 'PGPPeekKeyListContext');
      PGPGetKeyIterContext:=GetProcAddress(hPGPsdkLib, 'PGPPeekKeyIterContext');
      PGPPeekKeyDBContext:=GetProcAddress(hPGPsdkLib, 'PGPPeekKeyDBContext');
      PGPPeekKeyDBObjContext:=GetProcAddress(hPGPsdkLib, 'PGPPeekKeyDBObjContext');
      PGPAddKeyOptions:=GetProcAddress(hPGPsdkLib, 'PGPAddKeyOptions');
      PGPRemoveKeyOptions:=GetProcAddress(hPGPsdkLib, 'PGPRemoveKeyOptions');
      PGPUpdateKeyOptions:=GetProcAddress(hPGPsdkLib, 'PGPUpdateKeyOptions');
    end
    else begin
      kPGPKeyIDString_Abbreviated:=2;
      kPGPKeyIDString_Full:= 3;
      PGPOpenDefaultKeyRings:=GetProcAddress(hPGPsdkLib, 'PGPOpenDefaultKeyRings');
      PGPOpenKeyRingPair:=GetProcAddress(hPGPsdkLib, 'PGPOpenKeyRingPair');
      PGPOpenKeyRing:=GetProcAddress(hPGPsdkLib, 'PGPOpenKeyRing');
      PGPReloadKeyRings:=GetProcAddress(hPGPsdkLib, 'PGPReloadKeyRings');
      PGPKeySetIsMutable:=GetProcAddress(hPGPsdkLib, 'PGPKeySetIsMutable');
      PGPKeySetNeedsCommit:=GetProcAddress(hPGPsdkLib, 'PGPKeySetNeedsCommit');
      PGPCommitKeyRingChanges:=GetProcAddress(hPGPsdkLib, 'PGPCommitKeyRingChanges');
      PGPRevertKeyRingChanges:=GetProcAddress(hPGPsdkLib, 'PGPRevertKeyRingChanges');
      PGPNewKeySet:=GetProcAddress(hPGPsdkLib, 'PGPNewKeySet');
      PGPNewEmptyKeySet:=GetProcAddress(hPGPsdkLib, 'PGPNewEmptyKeySet');
      PGPNewSingletonKeySet:=GetProcAddress(hPGPsdkLib, 'PGPNewSingletonKeySet');
      PGPIncKeySetRefCount:=GetProcAddress(hPGPsdkLib, 'PGPIncKeySetRefCount');
      PGPFreeKeySet:=GetProcAddress(hPGPsdkLib, 'PGPFreeKeySet');
      PGPImportKeySet:=GetProcAddress(hPGPsdkLib, 'PGPImportKeySet');
      PGPExportKeySet:=GetProcAddress(hPGPsdkLib, 'PGPExportKeySet');
      PGPAddKeys:=GetProcAddress(hPGPsdkLib, 'PGPAddKeys');
      PGPRemoveKeys6:=GetProcAddress(hPGPsdkLib, 'PGPRemoveKeys');
      PGPCountKeys:=GetProcAddress(hPGPsdkLib, 'PGPCountKeys');
      PGPKeySetIsMember:=GetProcAddress(hPGPsdkLib, 'PGPKeySetIsMember');
      PGPNewKeyBooleanFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyBooleanFilter');
      PGPNewKeyCreationTimeFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyCreationTimeFilter');
      PGPNewKeyExpirationTimeFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyExpirationTimeFilter');
      PGPNewKeyDisabledFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyDisabledFilter');
      PGPNewKeyNumberFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyNumberFilter');
      PGPNewKeyTimeFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyTimeFilter');
      PGPNewKeyPropertyBufferFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyPropertyBufferFilter');
      PGPNewKeyRevokedFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyRevokedFilter');
      PGPNewKeyEncryptAlgorithmFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyEncryptAlgorithmFilter');
      PGPNewKeyEncryptKeySizeFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyEncryptKeySizeFilter');
      PGPNewKeyFingerPrintFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyFingerPrintFilter');
      PGPNewKeyIDFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyIDFilter');
      PGPNewSubKeyBooleanFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSubKeyBooleanFilter');
      PGPNewSubKeyIDFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSubKeyIDFilter');
      PGPNewSubKeyNumberFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSubKeyNumberFilter');
      PGPNewSubKeyTimeFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSubKeyTimeFilter');
      PGPNewSubKeyPropertyBufferFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSubKeyPropertyBufferFilter');
      PGPNewKeySigAlgorithmFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeySigAlgorithmFilter');
      PGPNewKeySigKeySizeFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeySigKeySizeFilter');
      PGPNewSigBooleanFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSigBooleanFilter');
      PGPNewSigKeyIDFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSigKeyIDFilter');
      PGPNewSigNumberFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSigNumberFilter');
      PGPNewSigTimeFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSigTimeFilter');
      PGPNewSigPropertyBufferFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSigPropertyBufferFilter');
      PGPNewUserIDBooleanFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewUserIDBooleanFilter');
      PGPNewUserIDNameFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewUserIDNameFilter');
      PGPNewUserIDNumberFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewUserIDNumberFilter');
      PGPNewUserIDStringBufferFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewUserIDStringBufferFilter');
      PGPNewUserIDStringFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewUserIDStringFilter');
      PGPNewUserIDEmailFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewUserIDEmailFilter');
      PGPIncFilterRefCount:=GetProcAddress(hPGPsdkLib, 'PGPIncFilterRefCount');
      PGPNegateFilter:=GetProcAddress(hPGPsdkLib, 'PGPNegateFilter');
      PGPIntersectFilters:=GetProcAddress(hPGPsdkLib, 'PGPIntersectFilters');
      PGPUnionFilters:=GetProcAddress(hPGPsdkLib, 'PGPUnionFilters');
      PGPFreeFilter:=GetProcAddress(hPGPsdkLib, 'PGPFreeFilter');
      PGPFilterKeySet:=GetProcAddress(hPGPsdkLib, 'PGPFilterKeySet');
      PGPOrderKeySet6:=GetProcAddress(hPGPsdkLib, 'PGPOrderKeySet');
      PGPIncKeyListRefCount:=GetProcAddress(hPGPsdkLib, 'PGPIncKeyListRefCount');
      PGPFreeKeyList:=GetProcAddress(hPGPsdkLib, 'PGPFreeKeyList');
      PGPNewKeyIter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyIter');
      PGPCopyKeyIter:=GetProcAddress(hPGPsdkLib, 'PGPCopyKeyIter');
      PGPFreeKeyIter:=GetProcAddress(hPGPsdkLib, 'PGPFreeKeyIter');
      PGPKeyIterIndex:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterIndex');
      PGPKeyIterKey:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterKey');
      PGPKeyIterSubKey:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterSubKey');
      PGPKeyIterUserID:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterUserID');
      PGPKeyIterSig:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterSig');
      PGPKeyIterMove:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterMove');
      PGPKeyIterSeek:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterSeek');
      PGPKeyIterNext:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterNext');
      PGPKeyIterNextSubKey:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterNextSubKey');
      PGPKeyIterNextUserID:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterNextUserID');
      PGPKeyIterNextUIDSig:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterNextUIDSig');
      PGPKeyIterPrev:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterPrev');
      PGPKeyIterPrevSubKey:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterPrevSubKey');
      PGPKeyIterPrevUserID:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterPrevUserID');
      PGPKeyIterPrevUIDSig:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterPrevUIDSig');
      PGPKeyIterRewind:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterRewind');
      PGPKeyIterRewindSubKey:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterRewindSubKey');
      PGPKeyIterRewindUserID:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterRewindUserID');
      PGPKeyIterRewindUIDSig:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterRewindUIDSig');
      PGPGenerateKey:=GetProcAddress(hPGPsdkLib, 'PGPGenerateKey');
      PGPGenerateSubKey:=GetProcAddress(hPGPsdkLib, 'PGPGenerateSubKey');
      PGPChangePassphrase6:=GetProcAddress(hPGPsdkLib, 'PGPChangePassphrase');
      PGPChangeSubKeyPassphrase6:=GetProcAddress(hPGPsdkLib, 'PGPChangeSubKeyPassphrase');
      PGPEnableKey6:=GetProcAddress(hPGPsdkLib, 'PGPEnableKey');
      PGPDisableKey6:=GetProcAddress(hPGPsdkLib, 'PGPDisableKey');
      PGPRevokeKey6:=GetProcAddress(hPGPsdkLib, 'PGPRevokeKey');
      PGPRevokeSubKey6:=GetProcAddress(hPGPsdkLib, 'PGPRevokeSubKey');
      PGPSetKeyAxiomatic:=GetProcAddress(hPGPsdkLib, 'PGPSetKeyAxiomatic');
      PGPUnsetKeyAxiomatic:=GetProcAddress(hPGPsdkLib, 'PGPUnsetKeyAxiomatic');
      PGPCompareKeys:=GetProcAddress(hPGPsdkLib, 'PGPCompareKeys');
      PGPRemoveSubKey:=GetProcAddress(hPGPsdkLib, 'PGPRemoveSubKey');
      PGPRemoveUserID:=GetProcAddress(hPGPsdkLib, 'PGPRemoveUserID');
      PGPRemoveSig:=GetProcAddress(hPGPsdkLib, 'PGPRemoveSig');
      PGPAddUserID:=GetProcAddress(hPGPsdkLib, 'PGPAddUserID');
      PGPSetPrimaryUserID6:=GetProcAddress(hPGPsdkLib, 'PGPSetPrimaryUserID');
      PGPCompareUserIDStrings:=GetProcAddress(hPGPsdkLib, 'PGPCompareUserIDStrings');
      PGPSignUserID:=GetProcAddress(hPGPsdkLib, 'PGPSignUserID');
      PGPRevokeSig6:=GetProcAddress(hPGPsdkLib, 'PGPRevokeSig');
      PGPCountAdditionalRecipientRequests:=GetProcAddress(hPGPsdkLib, 'PGPCountAdditionalRecipientRequests');
      PGPGetIndexedAdditionalRecipientRequestKey6:=GetProcAddress(hPGPsdkLib, 'PGPGetIndexedAdditionalRecipientRequestKey');
      PGPGetSigCertifierKey:=GetProcAddress(hPGPsdkLib, 'PGPGetSigCertifierKey');
      PGPCountRevocationKeys:=GetProcAddress(hPGPsdkLib, 'PGPCountRevocationKeys');
      PGPGetIndexedRevocationKey6:=GetProcAddress(hPGPsdkLib, 'PGPGetIndexedRevocationKey');
      PGPGetKeyEntropyNeeded:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyEntropyNeeded');
      PGPGetKeyPasskeyBuffer6:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyPasskeyBuffer');
      PGPGetSubKeyPasskeyBuffer6:=GetProcAddress(hPGPsdkLib, 'PGPGetSubKeyPasskeyBuffer');
      PGPPassphraseIsValid:=GetProcAddress(hPGPsdkLib, 'PGPPassphraseIsValid');
      PGPGetHashAlgUsed:=GetProcAddress(hPGPsdkLib, 'PGPGetHashAlgUsed');
      PGPGetKeyBoolean:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyBoolean');
      PGPGetKeyNumber:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyNumber');
      PGPGetKeyPropertyBuffer:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyPropertyBuffer');
      PGPGetKeyTime:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyTime');
      PGPGetSubKeyBoolean:=GetProcAddress(hPGPsdkLib, 'PGPGetSubKeyBoolean');
      PGPGetSubKeyNumber:=GetProcAddress(hPGPsdkLib, 'PGPGetSubKeyNumber');
      PGPGetSubKeyPropertyBuffer:=GetProcAddress(hPGPsdkLib, 'PGPGetSubKeyPropertyBuffer');
      PGPGetSubKeyTime:=GetProcAddress(hPGPsdkLib, 'PGPGetSubKeyTime');
      PGPGetUserIDBoolean:=GetProcAddress(hPGPsdkLib, 'PGPGetUserIDBoolean');
      PGPGetUserIDNumber:=GetProcAddress(hPGPsdkLib, 'PGPGetUserIDNumber');
      PGPGetUserIDStringBuffer:=GetProcAddress(hPGPsdkLib, 'PGPGetUserIDStringBuffer');
      PGPGetSigBoolean:=GetProcAddress(hPGPsdkLib, 'PGPGetSigBoolean');
      PGPGetSigNumber:=GetProcAddress(hPGPsdkLib, 'PGPGetSigNumber');
      PGPGetSigPropertyBuffer:=GetProcAddress(hPGPsdkLib, 'PGPGetSigPropertyBuffer');
      PGPGetSigTime:=GetProcAddress(hPGPsdkLib, 'PGPGetSigTime');
      PGPGetPrimaryUserID:=GetProcAddress(hPGPsdkLib, 'PGPGetPrimaryUserID');
      PGPGetPrimaryUserIDNameBuffer6:=GetProcAddress(hPGPsdkLib, 'PGPGetPrimaryUserIDNameBuffer');
      PGPGetPrimaryUserIDValidity:=GetProcAddress(hPGPsdkLib, 'PGPGetPrimaryUserIDValidity');
      PGPSetDefaultPrivateKey:=GetProcAddress(hPGPsdkLib, 'PGPSetDefaultPrivateKey');
      PGPGetDefaultPrivateKey:=GetProcAddress(hPGPsdkLib, 'PGPGetDefaultPrivateKey');
      PGPGetKeyByKeyID6:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyByKeyID');
      PGPImportKeyID:=GetProcAddress(hPGPsdkLib, 'PGPImportKeyID');
      PGPExportKeyID:=GetProcAddress(hPGPsdkLib, 'PGPExportKeyID');
      PGPGetKeyIDString:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyIDString');
      PGPGetKeyIDFromString6:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyIDFromString');
      PGPGetKeyIDFromKey6:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyIDFromKey');
      PGPGetKeyIDFromSubKey6:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyIDFromSubKey');
      PGPGetKeyIDOfCertifier6:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyIDOfCertifier');
      PGPCompareKeyIDs:=GetProcAddress(hPGPsdkLib, 'PGPCompareKeyIDs');
      PGPGetKeySetContext:=GetProcAddress(hPGPsdkLib, 'PGPGetKeySetContext');
      PGPGetKeyListContext:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyListContext');
      PGPGetKeyIterContext:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyIterContext');
      PGPGetKeyContext:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyContext');
      PGPGetSubKeyContext:=GetProcAddress(hPGPsdkLib, 'PGPGetSubKeyContext');
      PGPGetUserIDContext:=GetProcAddress(hPGPsdkLib, 'PGPGetUserIDContext');
      PGPAddKeyOptions:=GetProcAddress(hPGPsdkLib, 'PGPAddKeyOptions');
      PGPRemoveKeyOptions:=GetProcAddress(hPGPsdkLib, 'PGPRemoveKeyOptions');
      PGPUpdateKeyOptions:=GetProcAddress(hPGPsdkLib, 'PGPUpdateKeyOptions');
    end;
  end;

end.

