{$J+,Z4}
unit UTF8;
{$IFDEF CONDITIONALEXPRESSIONS} {$WARN SYMBOL_PLATFORM OFF} {$ENDIF}

{ $DEFINE DEBUG} // remove leading space in case of problems running inside IDE

{------------------------------------------------------------------------------}
{                                                                              }
{          UTF8 utilities - especially for versions prior to Delphi 6          }
{                                                                              }
{                                 This code is                                 }
{                 Copyright (C) 2003 by Michael in der Wiesche                 }
{                                                                              }
{------------------------------------------------------------------------------}

interface

const UTF8Sec = 'UTF8Sec.dll';

type UTF8String = type String;

procedure AnsiToUtf8PChar(const Ansi, Utf8: PChar; var Len: Cardinal); stdcall; external UTF8Sec index 1;
procedure Utf8ToAnsiPChar(const Utf8, Ansi: PChar; var Len: Cardinal); stdcall; external UTF8Sec index 2;

function AnsiToUtf8(const S: String): UTF8String;
function Utf8ToAnsi(const S: UTF8String): String;
function Utf8OrAnsi(const S: UTF8String): String;

const MaxUTF8Length = 256*6;

implementation

uses Windows, SysUtils;

procedure SecureMemoryMgr; stdcall; external UTF8Sec index 3;
procedure DefaultMemoryMgr; stdcall; external UTF8Sec index 4;
function IsSecureMemoryMgr: Longbool; stdcall; external UTF8Sec index 5;

function AnsiToUtf8(const S: String): UTF8String;
var
  Len: Cardinal;
begin
  Len:=succ(Length(S) shl 2);
  SetLength(Result, Len);
  AnsiToUtf8PChar(PChar(S), PChar(Result), Len);
  SetLength(Result, Len);
end;

function Utf8ToAnsi(const S: UTF8String): String;
var
  Len: Cardinal;
begin
  Len:=succ(Length(S));
  SetLength(Result, Len);
  Utf8ToAnsiPChar(PChar(S), PChar(Result), Len);
  SetLength(Result, Len);
end;

function Utf8OrAnsi(const S: UTF8String): String;
begin
  Result:=Utf8ToAnsi(S);
  if Result='' then Result:=S;
end;

// outside Delphi environment only
initialization
  {$IFNDEF DEBUG}
  if pos('delphi32.exe', LowerCase(ParamStr(0)))=0 then SecureMemoryMgr;
  {$ENDIF}

finalization
  if IsSecureMemoryMgr then DefaultMemoryMgr;
  FreeLibrary(GetModuleHandle(UTF8Sec));

end.

