{$J+,Z4}
unit pgpSC;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the SPGP 2.5.6.0 sources,                                   }
{ available at http://www.oz.net/~srheller/spgp/.                                  }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpSC.pas based on pgpSC.h from the PGP sources             }
{ which are Copyright (C) Network Associates Inc. and affiliated companies.        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ Some comments removed, some declarations activated                               }
{                                                                                  }
{**********************************************************************************}

interface

uses
  pgpPubTypes, pgpBase;

type	// modified by idw
  pPGPsc = pPGPContext;
  pPGPtls = pPGPtlsContext;

type	// modified by idw
  TPath = Array[0..260] of Char;
  pFileList = ^TFileList;
  TFileList = Record
    Name: TPath;
    IsDirectory: Longbool;
    Next: pFileList;
    Reserved: Array[0..260] of Char;
  end;

// Library initialization routines
var InitPGPsc: function(Parent: Longint; var P: pPGPsc; var TLS: pPGPtls): Longbool; cdecl;
var UninitPGPsc: function(Parent: Longint; P: pPGPsc; TLS: pPGPtls): Longbool; cdecl;

// Clipboard routines
var EncryptClipboard: function(Parent: Longint;
    App			: PChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    Encrypt		: Longbool;
    Sign		: Longbool): Longbool; cdecl;
var DecryptClipboard: function(Parent: Longint;
    App			: PChar;
    P			: pPGPsc;
    TLS			: pPGPtls): Longbool; cdecl;
var AddKeyClipboard: function(Parent: Longint;
    P			: pPGPsc;
    TLS			: pPGPtls): Longbool; cdecl;
var ClipboardWipe: function(Parent: Longint; P: pPGPsc): Longbool; cdecl;

// Filelist routines
var EncryptFileList: function(Parent: Longint;
    App			: PChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    ListHead		: pFileList;
    Encrypt		: Longbool;
    Sign		: Longbool): Longbool; cdecl;
var DecryptFileList: function(Parent: Longint;
    App			: PChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    ListHead		: pFileList): Longbool; cdecl;
var AddKeyFileList: function(Parent: Longint;
    P			: pPGPsc;
    TLS			: pPGPtls;
    ListHead		: pFileList): Longbool; cdecl;
var WipeFileList: function(Parent: Longint;
    P			: pPGPsc;
    ListHead		: pFileList;
    DelFilePostWipe	: Longbool): Longbool; cdecl;

// Filelist utility functions (Note that UserCancel can be NULL)
var AddToFileList: function(var FileList: pFileList;
    FileName		: PChar;
    var UserCancel	: Longbool): Longbool; cdecl;
var FreeFileList: function(FileList: pFileList): Longbool; cdecl;

var HDropToFileList: function(hDrop: Longint): pFileList; cdecl;
var CmdLineToFileList: function(szCmdLine: PChar): pFileList; cdecl;

// Grabs preferences from pref file
var GetValidityDrawPrefs: function(P: pPGPsc; var InputBool: Longbool): Longbool; cdecl;
var GetMarginalInvalidPref: function(P: pPGPsc; var InputBool: Longbool): Longbool; cdecl;
var GetSecureViewerPref: function(P: pPGPsc): Longbool; cdecl;

// Use secure viewer and/or anti-tempest font
var TempestViewer: function(P: pPGPsc;
    Parent		: Longint;
    pInput		: PChar;
    InSize		: Longint;
    Warn		: Longbool): Cardinal; cdecl;

// Launches Keys/Tools
var DoLaunchNet: function(Parent: Longint): Longbool; cdecl;
var DoLaunchKeys: function(Parent: Longint): Longbool; cdecl;
var DoLaunchTools: function(Parent: Longint): Longbool; cdecl;
var DoLaunchDisk: function(Parent: Longint): Longbool; cdecl;

// Sends signature info to PGPlog
var SendPGPlogMsg: function(Parent: Longint; Msg: PChar): Longbool; cdecl;

// Returns path for PGPkeys
var PGPpath: procedure(var Path: TPath); cdecl;

implementation	// code modified by idw

uses
  Windows;

initialization

  if PGPInitErrorCode=ieNone then begin
    if PGP7X then begin
      InitPGPsc:=GetProcAddress(hPGPscLib, 'PGPscInit');
      UninitPGPsc:=GetProcAddress(hPGPscLib, 'PGPscDestroy');
      EncryptClipboard:=GetProcAddress(hPGPscLib, 'PGPscEncryptClipboard');
      DecryptClipboard:=GetProcAddress(hPGPscLib, 'PGPscDecryptClipboard');
      AddKeyClipboard:=GetProcAddress(hPGPscLib, 'PGPscAddKeyClipboard');
      ClipboardWipe:=GetProcAddress(hPGPscLib, 'PGPscEraseClipboard');
      EncryptFileList:=GetProcAddress(hPGPscLib, 'PGPscEncryptFileList');
      DecryptFileList:=GetProcAddress(hPGPscLib, 'PGPscDecryptFileList');
      AddKeyFileList:=GetProcAddress(hPGPscLib, 'PGPscAddKeyFileList');
      WipeFileList:=GetProcAddress(hPGPscLib, 'PGPscWipeFileList');
      AddToFileList:=GetProcAddress(hPGPscLib, 'PGPscAddToFileList');
      FreeFileList:=GetProcAddress(hPGPscLib, 'PGPscFreeFileList');
      HDropToFileList:=GetProcAddress(hPGPscLib, 'PGPscHDropToFileList');
      CmdLineToFileList:=GetProcAddress(hPGPscLib, 'PGPscCmdLineToFileList');
      GetValidityDrawPrefs:=GetProcAddress(hPGPscLib, 'PGPscGetValidityDrawPrefs');
      GetMarginalInvalidPref:=GetProcAddress(hPGPscLib, 'PGPscGetMarginalInvalidPref');
      GetSecureViewerPref:=GetProcAddress(hPGPscLib, 'PGPscGetSecureViewerPref');
      TempestViewer:=GetProcAddress(hPGPscLib, 'PGPscTempestViewer');
      DoLaunchNet:=GetProcAddress(hPGPscLib, 'PGPscDoLaunchNet');
      DoLaunchKeys:=GetProcAddress(hPGPscLib, 'PGPscDoLaunchKeys');
      DoLaunchTools:=GetProcAddress(hPGPscLib, 'PGPscDoLaunchTools');
      DoLaunchDisk:=GetProcAddress(hPGPscLib, 'PGPscDoLaunchDisk');
      SendPGPlogMsg:=GetProcAddress(hPGPscLib, 'PGPscSendPGPlogMsg');
      PGPpath:=GetProcAddress(hPGPscLib, 'PGPscPGPpath');
    end
    else begin
      InitPGPsc:=GetProcAddress(hPGPscLib, 'InitPGPsc');
      UninitPGPsc:=GetProcAddress(hPGPscLib, 'UninitPGPsc');
      EncryptClipboard:=GetProcAddress(hPGPscLib, 'EncryptClipboard');
      DecryptClipboard:=GetProcAddress(hPGPscLib, 'DecryptClipboard');
      AddKeyClipboard:=GetProcAddress(hPGPscLib, 'AddKeyClipboard');
      ClipboardWipe:=GetProcAddress(hPGPscLib, 'ClipboardWipe');
      EncryptFileList:=GetProcAddress(hPGPscLib, 'EncryptFileList');
      DecryptFileList:=GetProcAddress(hPGPscLib, 'DecryptFileList');
      AddKeyFileList:=GetProcAddress(hPGPscLib, 'AddKeyFileList');
      WipeFileList:=GetProcAddress(hPGPscLib, 'WipeFileList');
      AddToFileList:=GetProcAddress(hPGPscLib, 'AddToFileList');
      FreeFileList:=GetProcAddress(hPGPscLib, 'FreeFileList');
      HDropToFileList:=GetProcAddress(hPGPscLib, 'HDropToFileList');
      CmdLineToFileList:=GetProcAddress(hPGPscLib, 'CmdLineToFileList');
      GetValidityDrawPrefs:=GetProcAddress(hPGPscLib, 'GetValidityDrawPrefs');
      GetMarginalInvalidPref:=GetProcAddress(hPGPscLib, 'GetMarginalInvalidPref');
      GetSecureViewerPref:=GetProcAddress(hPGPscLib, 'GetSecureViewerPref');
      TempestViewer:=GetProcAddress(hPGPscLib, 'TempestViewer');
      DoLaunchNet:=GetProcAddress(hPGPscLib, 'DoLaunchNet');
      DoLaunchKeys:=GetProcAddress(hPGPscLib, 'DoLaunchKeys');
      DoLaunchTools:=GetProcAddress(hPGPscLib, 'DoLaunchTools');
      DoLaunchDisk:=GetProcAddress(hPGPscLib, 'DoLaunchDisk');
      SendPGPlogMsg:=GetProcAddress(hPGPscLib, 'SendPGPlogMsg');
      PGPpath:=GetProcAddress(hPGPscLib, 'PGPpath');
    end;
  end;

end.

