{$J+,Z4}
unit pgpEvents;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the "Borland Delphi Runtime Library PGPsdk" released 10 Apr }
{ 2000, available at http://www.oz.net/~srheller/dpgp/sdk/.                        }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpEncodePas.pas based on pgpEncode.h from the PGP sources  }
{ which are Copyright (C) Network Associates Inc. and affiliated companies.        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ PGPAddJobOptions moved to pgpOptionLists.pas and pPGPJob to pgpPubTypes.pas,     }
{ all functions taking OptionLists modified according to a suggestion              }
{ by Steven R. Heller, for details see pgpOptionList.pas                           }
{                                                                                  }
{**********************************************************************************}

interface

uses
  pgpPubTypes, pgpBase;

type
  { PGP Event types }
  PGPEventType = PGPEnumType;
const
  kPGPEvent_NullEvent			=  0; // Nothing happened
  kPGPEvent_InitialEvent		=  1; // Initial event
  kPGPEvent_FinalEvent			=  2; // Final event
  kPGPEvent_ErrorEvent			=  3; // An error occurred
  kPGPEvent_WarningEvent		=  4; // Warning event
  kPGPEvent_EntropyEvent		=  5; // More entropy is needed
  kPGPEvent_PassphraseEvent		=  6; // A passphrase is needed
  kPGPEvent_InsertKeyEvent		=  7; // Smart card must be inserted
  kPGPEvent_AnalyzeEvent		=  8; // Initial analysis event, before any output
  kPGPEvent_RecipientsEvent		=  9; // Recipient list report, before any output
  kPGPEvent_KeyFoundEvent		= 10; // Key packet found
  kPGPEvent_OutputEvent			= 11; // Output specification needed
  kPGPEvent_SignatureEvent		= 12; // Signature status report
  kPGPEvent_BeginLexEvent		= 13; // Initial event per lexical unit
  kPGPEvent_EndLexEvent			= 14; // Final event per lexical unit
  kPGPEvent_RecursionEvent		= 15; // Notification of recursive job creation
  kPGPEvent_DetachedSignatureEvent	= 16; // Need input for verification of detached signature
  kPGPEvent_KeyGenEvent			= 17; // Key generation progress
  kPGPEvent_KeyServerEvent		= 18; // Key Server progress
  kPGPEvent_KeyServerSignEvent		= 19; // Key Server passphrase
  kPGPEvent_KeyServerTLSEvent		= 20; // Key Server TLS event
  kPGPEvent_KeyServerIdleEvent		= 21; // Idle during keyserver call
  kPGPEvent_SocketsIdleEvent		= 22; // Idle during sockets
  kPGPEvent_DecryptionEvent		= 23; // Decryption data report
  kPGPEvent_EncryptionEvent		= 24; // Encryption data report

type
  { PGP Analyze event callback codes }
  PGPAnalyzeType = PGPEnumType;
const
  kPGPAnalyze_Encrypted			=  0; // Encrypted message
  kPGPAnalyze_Signed			=  1; // Signed message
  kPGPAnalyze_DetachedSignature		=  2; // Detached signature
  kPGPAnalyze_Key			=  3; // Key data
  kPGPAnalyze_Unknown			=  4; // Non-pgp message
  kPGPAnalyze_X509Certificate		=  5; // X.509 certificate

type
  { Individual event information structs, combined as a union in PGPEvent }
  TPGPEventNullData = Record
    BytesWritten			: PGPFileOffset;
    BytesTotal				: PGPFileOffset;
  end;

  TPGPEventErrorData = Record
    Error				: PGPError;
    ErrorArg				: Pointer;
  end;

  TPGPEventWarningData = Record
    Warning				: PGPError;
    WarningArg				: Pointer;
  end;

  TPGPEventEntropyData = Record
    EntropyBitsNeeded			: PGPUInt32;
  end;

  TPGPEventPassphraseData = Record
    IsConventional			: PGPBoolean;
    KeySet				: pPGPKeySet;
  end;

  TPGPEventRecipientsData = Record
    RecipientSet			: pPGPKeySet;
    ConventionalPassphraseCount		: PGPUInt32;
    KeyCount				: PGPUInt32;
    KeyIDArray				: pPGPKeyID7;
  end;

  // PGP 6.5.X
  TPGPEventKeyFoundData = Record
    KeysFound				: pPGPKeySet;
  end;

  // PGP 7.X
  {TPGPEventKeyFoundData = Record
    KeysFound				: pPGPKeyDB;
  end;}

  TPGPEventSignatureData = Record case Longint of
    6:  (PGPEventSignatureData6: Record	// PGP 6.5.X
	  SigningKeyID			: TPGPKeyID6;
	  SigningKey			: pPGPKey;
	  Checked			: PGPBoolean;
	  Verified			: PGPBoolean;
	  KeyRevoked			: PGPBoolean;
	  KeyDisabled			: PGPBoolean;
	  KeyExpired			: PGPBoolean;
	  KeyMeetsValidityThreshold	: PGPBoolean;
	  KeyValidity			: PGPValidity;
	  CreationTime			: PGPTime;
	end);
    7:  (PGPEventSignatureData7: Record // PGP 7.X
	  SigningKeyID			: TPGPKeyID7;
	  SigningKey			: pPGPKeyDBObj;
	  Checked			: PGPBoolean;
	  Verified			: PGPBoolean;
	  KeyRevoked			: PGPBoolean;
	  KeyDisabled			: PGPBoolean;
	  KeyExpired			: PGPBoolean;
	  KeyMeetsValidityThreshold	: PGPBoolean;
	  KeyValidity			: PGPValidity;
	  CreationTime			: PGPTime;
	end);
  end;

  TPGPEventDecryptionData = Record
    CipherAlgorithm			: PGPCipherAlgorithm;
    SessionKey				: ^PGPByte;
    SessionKeyLength			: PGPSize;
  end;

  TPGPEventEncryptionData = Record
    CipherAlgorithm			: PGPCipherAlgorithm;
    SessionKey				: ^PGPByte;
    SessionKeyLength			: PGPSize;
  end;

  TPGPEventAnalyzeData = Record
    SectionType				: PGPAnalyzeType;
  end;

  TPGPEventOutputData = Record
    MessageType				: PGPUInt32;
    SuggestedName			: PChar;
    ForYourEyesOnly			: PGPBoolean;
  end;

  TPGPEventBeginLexData = Record
    SectionNumber			: PGPUInt32;
    SectionOffset			: PGPSize;
  end;

  TPGPEventEndLexData = Record
    SectionNumber			: PGPUInt32;
  end;

  TPGPEventKeyGenData = Record
    State				: PGPUInt32;
  end;

  TPGPEventKeyServerData = Record
    State				: PGPUInt32;
    SoFar				: PGPUInt32;
    Total				: PGPUInt32;
  end;

  TPGPEventKeyServerSignData = Record
    State				: PGPUInt32;
  end;

  TPGPEventKeyServerTLSData = Record
    KeyServerRef			: pPGPKeyServer;
    State				: PGPUInt32;
    TLSSession				: pPGPtlsSession;
  end;

  TPGPEventKeyServerIdleData = Record
    KeyServerRef			: pPGPKeyServer;
  end;

{ The following events have no event-specific data defined for them: }
  // kPGPEvent_InsertKeyEvent
  // kPGPEvent_RecursionEvent
  // kPGPEvent_DetachedSignatureEvent
  // kPGPEvent_InitialEvent
  // kPGPEvent_FinalEvent
  // kPGPEvent_SocketsIdleEvent

  TPGPEventData = Record case Longint of
    01: (NullData:		TPGPEventNullData);
    02: (ErrorData:		TPGPEventErrorData);
    03: (WarningData:		TPGPEventWarningData);
    04: (EntropyData:		TPGPEventEntropyData);
    05: (PassphraseData:	TPGPEventPassphraseData);
    06: (RecipientsData:	TPGPEventRecipientsData);
    07: (KeyFoundData:		TPGPEventKeyFoundData);
    08: (SignatureData:		TPGPEventSignatureData);
    09:	(DecryptionData:	TPGPEventDecryptionData);
    10:	(EncryptionData:	TPGPEventEncryptionData);
    11: (AnalyzeData:		TPGPEventAnalyzeData);
    12: (OutputData:		TPGPEventOutPutData);
    13: (BeginLexData:		TPGPEventBeginLexData);
    14: (EndLexData:		TPGPEventEndLexData);
    15: (KeyGenData:		TPGPEventKeyGenData);
    16: (KeyServerData:		TPGPEventKeyServerData);
    17: (KeyServerSignData:	TPGPEventKeyServerSignData);
    18: (KeyServerTLSData:	TPGPEventKeyServerTLSData);
    19: (KeyServerIdleData:	TPGPEventKeyServerIdleData);
  end;

  { PGPEvent structure }
  pPGPEvent = ^TPGPEvent;
  TPGPEvent = Record
    Version	: TPGPVersion;   // Version of event structure
    NextEvent	: pPGPEvent;     // Allow lists of events
    Job		: pPGPJob;       // Associated with what job
    EType	: PGPEventType;  // Type of event
    Data	: TPGPEventData; // Event specific data
  end;

type	// added by idw
  { PGPEventHandler function }
  TPGPEventHandlerProcPtr = function(Context: pPGPContext; Event: pPGPEvent; UserValue: PGPUserValue): PGPError cdecl;

var
  PGPEncode: function(Context: pPGPContext; OptionList: pPGPOptionList; LastOption: pPGPOptionList): PGPError; cdecl;
  PGPDecode: function(Context: pPGPContext; OptionList: pPGPOptionList; LastOption: pPGPOptionList): PGPError; cdecl;

implementation	// code modified by idw

uses
  Windows;

initialization

  if PGPInitErrorCode=ieNone then begin
    PGPEncode:=GetProcAddress(hPGPsdkLib, 'PGPEncode');
    PGPDecode:=GetProcAddress(hPGPsdkLib, 'PGPDecode');
  end;

end.

