{$A+,B-,C-,D+,E-,F-,G+,H+,I+,J+,K-,L+,M-,N+,O+,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y+,Z4}
unit PGP2Comp;							// Version 3.1.8

{------------------------------------------------------------------------------}
{                                                                              }
{                This unit was generated on 30.09.99 19:40:45 by               }
{                     the RTE Software Component Generator                     }
{                                                                              }
{               This code was written by:  Michael in der Wiesche              }
{                                                                              }
{                     This code is Copyright (c) 1999-2002                     }
{                           by Michael in der Wiesche                          }
{                                                                              }
{------------------------------------------------------------------------------}

interface

uses
  Forms,
  Windows,
  Classes,
  SysUtils,
  ExtCtrls,
  StdCtrls,
  PGPEncode,
  PGPDecode,
  PGPKeyGenerate,
  KeyPropTypes,
  PGPDialogs,
  PrefFuncs,
  KeyFuncs,
  pgpUI,
  pgpCL,
  pgpSC,
  pgpTLS,
  pgpKeys,
  pgpEvents,
  pgpKeyServer,
  pgpMemoryMgr,
  pgpUtilities,
  pgpOptionList,
  pgpErrors, pgpPubTypes, pgpBase;


// Register --------------------------------------------------------------------

procedure Register;


// PGP Initialization Error ----------------------------------------------------

type
  TPGPInitErrorCode = pgpBase.TPGPInitErrorCode;

const
  PGPInitErrorCode: TPGPInitErrorCode = ieNone;

// Notification Messages -------------------------------------------------------

const
  WM_PGP_ReloadPrefs: UInt = 0;
  WM_PGP_ReloadKeyring: UInt = 0;
  WM_PGP_ReloadKeyserverPrefs: UInt = 0;


// Common types ----------------------------------------------------------------

type

  // TPGP???KeyProps -----------------------------------------------------------

  TKeyPropsList = KeyPropTypes.TKeyPropsList;

  pKeyPropsRec = KeyPropTypes.pKeyPropsRec;
  TKeyPropsRec = KeyPropTypes.TKeyPropsRec;

  TKeyProp = (
    KeyProp_HexID,
    KeyProp_UserID,
    KeyProp_Fingerprint,
    KeyProp_CreaTimeStr,
    KeyProp_ExpTimeStr,
    KeyProp_Size,
    KeyProp_Algorithm,
    KeyProp_Trust,
    KeyProp_Validity,
    KeyProp_CreaTimeNum,
    KeyProp_ExpTimeNum,
    KeyProp_Secret,
    KeyProp_ImplicitTrust,
    KeyProp_Revoked,
    KeyProp_Disabled,
    KeyProp_Expired,
    KeyProp_SecretShared,
    KeyProp_CanEncrypt,
    KeyProp_CanDecrypt,
    KeyProp_CanSign,
    KeyProp_CanVerify,
    KeyProp_HasRevoker,
    KeyProp_HasADK,
    KeyProp_HasSubKey,
    KeyProp_IncludeUserIDs,
    KeyProp_IncludeSignerIDs,
    KeyProp_IncludeGroupsList
  );

  TKeyProps = Set of TKeyProp;

  TAlgorithmKeyFilter = (
    AlgorithmFilter_AllKeys,
    AlgorithmFilter_DHDSS,
    AlgorithmFilter_RSA,
    AlgorithmFilter_RSALegacy
  );

  TBooleanKeyFilter = (
    BoolFilter_AllKeys,
    BoolFilter_CanEncrypt,
    BoolFilter_CanDecrypt,
    BoolFilter_CanSign,
    BoolFilter_CanVerify
  );

  TKeyOrdering = (
    Any_Order,
    UserID_Order,
    ReverseUserID_Order,
    KeyID_Order,
    ReverseKeyID_Order,
    Validity_Order,
    ReverseValidity_Order,
    Trust_Order,
    ReverseTrust_Order,
    EncryptKeySize_Order,
    ReverseEncryptKeySize_Order,
    SigKeySize_Order,
    ReverseSigKeySize_Order,
    Creation_Order,
    ReverseCreation_Order,
    Expiration_Order,
    ReverseExpiration_Order
  );

  TTrustLevel = KeyPropTypes.TTrustLevel;

  TValidityLevel = KeyPropTypes.TValidityLevel;

  TKeyAlgorithm = KeyPropTypes.TKeyAlgorithm;

  TCipherAlgorithm = KeyPropTypes.TCipherAlgorithm;

  TADKType = KeyPropTypes.TADKType;

  // TPGPPreferences -----------------------------------------------------------

  TPGPPref = (
    Pref_DefaultKeyID,
    Pref_PublicKeyring,
    Pref_PrivateKeyring,
    Pref_RandomSeedFile,
    Pref_GroupsFile
  );

  TPGPPrefs = Set of TPGPPref;

  TPrefsPage = (
    PrefsPage_GeneralPrefs,
    PrefsPage_KeyringPrefs,
    PrefsPage_EmailPrefs,
    PrefsPage_HotkeyPrefs,
    PrefsPage_KeyserverPrefs,
    PrefsPage_CAPrefs,
    PrefsPage_AdvancedPrefs
  );

  TPreferenceRec = PrefFuncs.TPreferenceRec;

  // TPGPKeyServer -------------------------------------------------------------

  TServerType = (
    KeyServerType_Invalid,
    KeyServerType_LDAP,
    KeyServerType_HTTP,
    KeyServerType_LDAPS,
    KeyServerType_HTTPS
  );

  TServerFlag = (
    KeyServerListed,
    KeyServerIsRoot
  );

  TServerFlags = Set of TServerFlag;

  // TPGPKeysGenerate ----------------------------------------------------------

  TKeySize = PGPKeyGenerate.TKeySize;

  TSubKeySize = PGPKeyGenerate.TSubKeySize;

  TMinPassLen = PGPKeyGenerate.TMinPassLen;

  TMinPassQual = PGPKeyGenerate.TMinPassQual;

  // TPGPKeyImport -------------------------------------------------------------

  TIgnoreKnownKeys = Set of (Ignore_ByHexID, Ignore_ByUserID);

  // TPGPEncode ----------------------------------------------------------------

  TSignAlgorithm = PGPEncode.TSignAlgorithm;

  TConventionalAlgorithm = PGPEncode.TConventionalAlgorithm;

  // TPGPDecode ----------------------------------------------------------------

  TSigStatus = PGPDecode.TSigStatus;

  TSigPropsRec = PGPDecode.TSigPropsRec;


// Common Constants ------------------------------------------------------------

const
  KeyProps_IDFlags = [KeyProp_HexID, KeyProp_UserID];
  KeyProps_IDComplete = KeyProps_IDFlags + [KeyProp_Size, KeyProp_Algorithm];


// Common Procs ----------------------------------------------------------------

type
  TOnFailure = procedure(ErrorCode: Longint; const ErrorMsg: String) of Object;


// TPGPGetKeyProps -------------------------------------------------------------

type
  TKeyRingProps = class(TComponent)
  private
    FComboBox: TComboBox;
    FListBox: TListBox;
    FPrimaryIDs: TStringList;
    FRingAlgorithmFilter: TAlgorithmKeyFilter;
    FRingBoolFilter: TBooleanKeyFilter;
    FRingKeyOrdering: TKeyOrdering;
    FRingProps: TKeyProps;
    FRingPropsList: TKeyPropsList;
    FOnFailure: TOnFailure;
    function GetPrimaryIDs: Longint;
    function GetKeyFilter(AlgorithmFilter: TAlgorithmKeyFilter; BoolFilter: TBooleanKeyFilter): Longint;
  protected
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function Update: Longint;
    property RingPropsList: TKeyPropsList
      read FRingPropsList;
  published
    property RingAlgorithmFilter: TAlgorithmKeyFilter
      read FRingAlgorithmFilter
      write FRingAlgorithmFilter;
    property RingBoolFilter: TBooleanKeyFilter
      read FRingBoolFilter
      write FRingBoolFilter;
    property RingKeyOrdering: TKeyOrdering
      read FRingKeyOrdering
      write FRingKeyOrdering;
    property RingProps: TKeyProps
      read FRingProps
      write FRingProps;
    property ComboBox: TComboBox
      read FComboBox
      write FComboBox;
    property ListBox: TListBox
      read FListBox
      write FListBox;
    property OnFailure: TOnFailure
      read FOnFailure
      write FOnFailure;
  end;

  TOnGetKeyID = procedure(var KeyID: String) of Object;
  TOnGetKeyProps = procedure(const KeyPropsList: TKeyPropsList) of Object;

  TPGPGetKeyProps = class(TKeyRingProps)
  private
    FAlgorithmFilter: TAlgorithmKeyFilter;
    FBoolFilter: TBooleanKeyFilter;
    FKeyOrdering: TKeyOrdering;
    FKeyID: String;
    FKeyProps: TKeyProps;
    FOnGetKeyID: TOnGetKeyID;
    FOnGetKeyProps: TOnGetKeyProps;
  protected
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function DoGetKeyProps: Longint;
    function KeyIsOnRing: Longint;
    function KeyRingCount: Longint;
    function GetKeyProp(KeyPropsList: TKeyPropsList; KeyIndex: Longint; KeyProp: TKeyProp): Variant;
    function GetUserIDList(KeyPropsList: TKeyPropsList; KeyIndex: Longint): TStringList;
    function GetSignerIDList(KeyPropsList: TKeyPropsList; KeyIndex: Longint): TStringList;
    function GetRevKeyIDList(KeyPropsList: TKeyPropsList; KeyIndex: Longint): TStringList;
    function GetADKeyIDList(KeyPropsList: TKeyPropsList; KeyIndex: Longint): TStringList;
    function GetGroupHexIDs(KeyPropsList: TKeyPropsList; GroupIndex: Longint; var GroupName: String): String;
  published
    property AlgorithmFilter: TAlgorithmKeyFilter
      read FAlgorithmFilter
      write FAlgorithmFilter;
    property BoolFilter: TBooleanKeyFilter
      read FBoolFilter
      write FBoolFilter;
    property KeyOrdering: TKeyOrdering
      read FKeyOrdering
      write FKeyOrdering;
    property KeyID: String
      read FKeyID
      write FKeyID;
    property KeyProps: TKeyProps
      read FKeyProps
      write FKeyProps;
    property OnGetKeyID: TOnGetKeyID
      read FOnGetKeyID
      write FOnGetKeyID;
    property OnGetKeyProps: TOnGetKeyProps
      read FOnGetKeyProps
      write FOnGetKeyProps;
  end;


// TPGPSetKeyProps -------------------------------------------------------------

type
  TOnKeySelected = function(KeyProps: TKeyPropsRec): Longbool of Object;
  TOnGetPassphrase = procedure(const Passphrase: PChar; var Cancel: Longbool) of Object;
  TOnChangePassphrase = procedure(const OldPassphrase, NewPassphrase: PChar;
				  MinPassLen: TMinPassLen;
				  MinPassQual: TMinPassQual;
				  var Cancel: Longbool) of Object;

  TPGPSetKeyProps = class(TComponent)
  private
    FParentHandle: THandle;
    FKeyDlgPrompt: String;
    FKeyHexID: String;
    FKeyProps: TKeyProps;
    FMinPassLen: TMinPassLen;
    FMinPassQual: TMinPassQual;
    FPassDlgPrompt: String;
    FPassDlgNewPrompt: String;
    FPassDlgOldPrompt: String;
    FOnFailure: TOnFailure;
    FOnKeySelected: TOnKeySelected;
    FOnGetPassphrase: TOnGetPassphrase;
    FOnChangePassphrase: TOnChangePassphrase;
    function GetKeyHexID(FilterFlags: Longint): Longint;
  protected
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function DoKeyDisable: Longint;
    function DoKeyEnable: Longint;
    function DoKeyRemove: Longint;
    function DoKeyRevoke: Longint;
    function DoKeyPassChange: Longint;
    property ParentHandle: THandle
      read FParentHandle
      write FParentHandle;
  published
    property KeyID: String
      read FKeyHexID
      write FKeyHexID;
    property KeyProps: TKeyProps
      read FKeyProps
      write FKeyProps;
    property KeyDlgPrompt: String
      read FKeyDlgPrompt
      write FKeyDlgPrompt;
    property PassDlgPrompt: String
      read FPassDlgPrompt
      write FPassDlgPrompt;
    property PassDlgNewPrompt: String
      read FPassDlgNewPrompt
      write FPassDlgNewPrompt;
    property PassDlgOldPrompt: String
      read FPassDlgOldPrompt
      write FPassDlgOldPrompt;
    property MinPassLen: TMinPassLen
      read FMinPassLen
      write FMinPassLen;
    property MinPassQual: TMinPassQual
      read FMinPassQual
      write FMinPassQual;
    property OnFailure: TOnFailure
      read FOnFailure
      write FOnFailure;
    property OnKeySelected: TOnKeySelected
      read FOnKeySelected
      write FOnKeySelected;
    property OnGetPassphrase: TOnGetPassphrase
      read FOnGetPassphrase
      write FOnGetPassphrase;
    property OnChangePassphrase: TOnChangePassphrase
      read FOnChangePassphrase
      write FOnChangePassphrase;
  end;


// TPGPPreferences -------------------------------------------------------------

  TOnGetPreferences = procedure(const Preferences: TPreferenceRec) of Object;
  TOnSetPreferences = procedure(var Preferences: TPreferenceRec) of Object;

  TPGPPreferences = class(TComponent)
  private
    FAltPubringFile: String;
    FAltSecringFile: String;
    FAltGroupsFile: String;
    FParentHandle: THandle;
    FPreferences: TPreferenceRec;
    FPGPPrefs: TPGPPrefs;
    FPrefsPage: TPrefsPage;
    FOnFailure: TOnFailure;
    FOnGetPreferences: TOnGetPreferences;
    FOnSetPreferences: TOnSetPreferences;
    function GetFlags: Longint;
    function PrefsError: Longbool;
    function GetAltPubKeyring: String;
    function GetAltPrivKeyring: String;
    function GetAltGroupsFile: String;
    procedure SetAltPubKeyring(const Value: String);
    procedure SetAltPrivKeyring(const Value: String);
    procedure SetAltGroupsFile(const Value: String);
  protected
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function ShowPrefsDialog: Longint;
    function DoGetPreferences: Longint;
    function DoSetPreferences: Longint;
    property ParentHandle: THandle
      read FParentHandle
      write FParentHandle;
  published
    property AltPubKeyring: String
      read GetAltPubKeyring
      write SetAltPubKeyring;
    property AltPrivKeyring: String
      read GetAltPrivKeyring
      write SetAltPrivKeyring;
    property AltGroupsFile: String
      read GetAltGroupsFile
      write SetAltGroupsFile;
    property PrefsPage: TPrefsPage
      read FPrefsPage
      write FPrefsPage;
    property DefaultKeyHexID: String
      read FPreferences.DefaultKeyHexID
      write FPreferences.DefaultKeyHexID;
    property PublicKeyring: String
      read FPreferences.PublicKeyring
      write FPreferences.PublicKeyring;
    property PrivateKeyring: String
      read FPreferences.PrivateKeyring
      write FPreferences.PrivateKeyring;
    property RandomSeedFile: String
      read FPreferences.RandomSeedFile
      write FPreferences.RandomSeedFile;
    property GroupsFile: String
      read FPreferences.GroupsFile
      write FPreferences.GroupsFile;
    property PGPPrefs: TPGPPrefs
      read FPGPPrefs
      write FPGPPrefs;
    property OnFailure: TOnFailure
      read FOnFailure
      write FOnFailure;
    property OnGetPreferences: TOnGetPreferences
      read FOnGetPreferences
      write FOnGetPreferences;
    property OnSetPreferences: TOnSetPreferences
      read FOnSetPreferences
      write FOnSetPreferences;
  end;


// TPGPKeyServer ---------------------------------------------------------------

type
  TServerEntry = Record
    ServerProtocol: TServerType;
    ServerDNS: String;
    ServerPort: Word;
    ServerFlags: TServerFlags;
  end;

  TOnGetDefaultServer = procedure(const ServerEntry: TServerEntry) of Object;
  TOnSetDefaultServer = procedure(var ServerEntry: TServerEntry) of Object;
  TOnServerResults = procedure(const KeyPropsList: TKeyPropsList) of Object;

  TPGPKeyServer = class(TComponent)
  private
    FParentHandle: THandle;
    FKeyDlgPrompt: String;
    FKeyProps: TKeyProps;
    FServerEntry: TServerEntry;
    FOnFailure: TOnFailure;
    FOnGetDefaultServer: TOnGetDefaultServer;
    FOnSetDefaultServer: TOnSetDefaultServer;
    FOnServerResults: TOnServerResults;
  protected
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function DoGetKeysFromServer(const KeyData: String): Longint;
    function DoSendKeysToServer: Longint;
    function DoGetDefaultServer: Longint;
    function DoSetDefaultServer: Longint;
    property ParentHandle: THandle
      read FParentHandle
      write FParentHandle;
  published
    property KeyDlgPrompt: String
      read FKeyDlgPrompt
      write FKeyDlgPrompt;
    property KeyProps: TKeyProps
      read FKeyProps
      write FKeyProps;
    property ServerProtocol: TServerType
      read FServerEntry.ServerProtocol
      write FServerEntry.ServerProtocol;
    property ServerDNS: String
      read FServerEntry.ServerDNS
      write FServerEntry.ServerDNS;
    property ServerPort: Word
      read FServerEntry.ServerPort
      write FServerEntry.ServerPort;
    property ServerFlags: TServerFlags
      read FServerEntry.ServerFlags
      write FServerEntry.ServerFlags;
    property OnFailure: TOnFailure
      read FOnFailure
      write FOnFailure;
    property OnGetDefaultServer: TOnGetDefaultServer
      read FOnGetDefaultServer
      write FOnGetDefaultServer;
    property OnSetDefaultServer: TOnSetDefaultServer
      read FOnSetDefaultServer
      write FOnSetDefaultServer;
    property OnServerResults: TOnServerResults
      read FOnServerResults
      write FOnServerResults;
  end;


// TPGPKeysGenerate ------------------------------------------------------------

type
  TPGPKeysGenerate = class(TPGPKeysGenerateCustom)
  private
    FOnFailure: TOnFailure;
  protected
  public
    constructor Create(AOwner: TComponent); override;
    function DHDSSKeyGenerate: Longint; override;
    function DHSubKeyGenerate: Longint; override;
    function DSAKeyGenerate: Longint; override;
    function RSAKeyGenerate(Legacy: Longbool): Longint; override;
  published
    property OnFailure: TOnFailure
      read FOnFailure
      write FOnFailure;
  end;


// TPGPKeyImport ---------------------------------------------------------------

type
  TOnGetFileIn = procedure(var FileIn: String) of Object;
  TOnKeyImported = procedure(const KeyPropsList: TKeyPropsList; KeysImported: Longint) of Object;

  TPGPKeyImport = class(TComponent)
  private
    FParentHandle: THandle;
    FFileIn: String;
    FIgnoreKnownKeys: TIgnoreKnownKeys;
    FKeyData: String;
    FKeyDlgPrompt: String;
    FKeyProps: TKeyProps;
    FOnFailure: TOnFailure;
    FOnGetFileIn: TOnGetFileIn;
    FOnKeyImported: TOnKeyImported;
  protected
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function DoKeyImport: Longint;
    function DoKeyImportFile: Longint;
    property ParentHandle: THandle
      read FParentHandle
      write FParentHandle;
  published
    property FileIn: String
      read FFileIn
      write FFileIn;
    property IgnoreKnownKeys: TIgnoreKnownKeys
      read FIgnoreKnownKeys
      write FIgnoreKnownKeys;
    property KeyData: String
      read FKeyData
      write FKeyData;
    property KeyDlgPrompt: String
      read FKeyDlgPrompt
      write FKeyDlgPrompt;
    property KeyProps: TKeyProps
      read FKeyProps
      write FKeyProps;
    property OnFailure: TOnFailure
      read FOnFailure
      write FOnFailure;
    property OnGetFileIn: TOnGetFileIn
      read FOnGetFileIn
      write FOnGetFileIn;
    property OnKeyImported: TOnKeyImported
      read FOnKeyImported
      write FOnKeyImported;
  end;


// TPGPKeyExport ---------------------------------------------------------------

type
  TOnGetFileOut = procedure(var FileOut: String) of Object;
  TOnKeyExported = procedure(const KeyPropsList: TKeyPropsList; const KeyData: String; const FileOut: String) of Object;

  TPGPKeyExport = class(TComponent)
  private
    FParentHandle: THandle;
    FExportCompatible: Longbool;
    FExportPrivate: Longbool;
    FFileOut: String;
    FKeyData: String;
    FKeyIDs: TStrings;
    FKeyDlgPrompt: String;
    FKeyProps: TKeyProps;
    FOnFailure: TOnFailure;
    FOnGetFileOut: TOnGetFileOut;
    FOnKeyExported: TOnKeyExported;
    procedure SetVersionString(const Value: String);
    function GetVersionString: String;
    procedure SetKeyIDs(const Value: TStrings);
  protected
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function DoKeyExport: Longint;
    function DoKeyExportFile: Longint;
  published
    property ExportCompatible: Longbool
      read FExportCompatible
      write FExportCompatible;
    property ExportPrivate: Longbool
      read FExportPrivate
      write FExportPrivate;
    property FileOut: String
      read FFileOut
      write FFileOut;
    property KeyData: String
      read FKeyData
      write FKeyData;
    property KeyIDs: TStrings
      read FKeyIDs
      write SetKeyIDs;
    property KeyDlgPrompt: String
      read FKeyDlgPrompt
      write FKeyDlgPrompt;
    property VersionString: String
      read GetVersionString
      write SetVersionString;
    property KeyProps: TKeyProps
      read FKeyProps
      write FKeyProps;
    property OnFailure: TOnFailure
      read FOnFailure
      write FOnFailure;
    property OnGetFileOut: TOnGetFileOut
      read FOnGetFileOut
      write FOnGetFileOut;
    property OnKeyExported: TOnKeyExported
      read FOnKeyExported
      write FOnKeyExported;
  end;


// TPGPEncode ------------------------------------------------------------------

type
  TOnEncoded = procedure(const BufferOut, FileOut: String) of Object;

  TPGPEncode = class(TPGPEncodeCustom)
  private
    FOnEncoded: TOnEncoded;
    FOnFailure: TOnFailure;
  protected
  public
    constructor Create(AOwner: TComponent); override;
    function KeyEncryptBuffer(const DataBuffer: String; Sign: Longbool): Longint; override;
    function KeyEncryptFile(const FileName: String; Sign: Longbool): Longint; override;
    function ConventionalEncryptBuffer(const DataBuffer: String): Longint; override;
    function ConventionalEncryptFile(const FileName: String): Longint; override;
    function ClearSignBuffer(const DataBuffer: String): Longint; override;
    function ClearSignFile(const FileName: String): Longint; override;
    function ArmorBuffer(const DataBuffer: String): Longint; override;
    function ArmorFile(const FileName: String): Longint; override;
    function DetachedSignBuffer(const DataBuffer: String): Longint; override;
    function DetachedSignFile(const FileName: String): Longint; override;
  published
    property OnEncoded: TOnEncoded
      read FOnEncoded
      write FOnEncoded;
    property OnFailure: TOnFailure
      read FOnFailure
      write FOnFailure;
  end;


// TPGPDecode ------------------------------------------------------------------

type
  TOnDecoded = procedure(const BufferOut, FileOut: String;
			 const SigProps: TSigPropsRec;
			 const KeyPropsList: TKeyPropsList) of Object;

  TPGPDecode = class(TPGPDecodeCustom)
  private
    FOnDecoded: TOnDecoded;
    FOnFailure: TOnFailure;
  protected
  public
    constructor Create(AOwner: TComponent); override;
    function DecodeBuffer(const DataBuffer: String): Longint; override;
    function DecodeFile(const FileName: String): Longint; override;
  published
    property OnDecoded: TOnDecoded
      read FOnDecoded
      write FOnDecoded;
    property OnFailure: TOnFailure
      read FOnFailure
      write FOnFailure;
  end;


// Utilities -------------------------------------------------------------------

type
  EFailException = class(Exception);

function WipeFiles(const FileNames: TStrings; ParentHandle: THandle): Longbool;
function ValidPassphrase(const KeyID: String; Passphrase: PChar): Longbool;
function GetShortHexID(const HexID: String): String;
function ValidSecMem(Alloc: PChar): Longbool;
function SecAlloc(Size: Cardinal): PChar;
function SecFree(var Alloc: PChar): Longint;
function SecRealloc(var Alloc: PChar; Size: Cardinal; Copy: Longbool): Longint;


implementation


// String constants

const
  AT = '@';
  LT = '<';
  GT = '>';
  TAB = #9;
  ALL = '';
  EMPTY = '';
  SPACE = ' ';
  COMMA = ',';
  SLASH = '/';
  BSLASH = '\';
  CRLF = #13#10;
  HexFormError = 'Hex format error: ';
  PathStrError = 'Path string error: ';
  PGPInitError = 'PGP initialization failure';
  UnknownPrefsErr = 'Unknown Preferences error';
  UnknownServerErr = 'Unknown Server error';
  UnknownKeyRingErr = 'Unknown KeyRing error';
  UnknownKeyPropsErr = 'Unknown KeyProps error';
  UnknownKeyOnRingErr = 'Unknown KeyOnRing error';
  UnknownKeyRingCountErr = 'Unknown KeyRingCount error';
  UnknownKeyDisableErr = 'Unknown KeyDisable error';
  UnknownKeyEnableErr = 'Unknown KeyEnable error';
  UnknownKeyRemoveErr = 'Unknown KeyRemove error';
  UnknownKeyRevokeErr = 'Unknown KeyRevoke error';
  UnknownKeyPassChangeErr = 'Unknown KeyPassChange error';
  UnknownKeyGenErr = 'Unknown KeysGenerate error';
  UnknownKeyImportErr = 'Unknown KeyImport error';
  UnknownKeyExportErr = 'Unknown KeyExport error';
  UnknownEncodeErr = 'Unknown Encode error';
  UnknownDecodeErr = 'Unknown Decode error';


// Utility Funcs ---------------------------------------------------------------

function WipeFiles(const FileNames: TStrings; ParentHandle: THandle): Longbool;
var
  WarnPref	: Longbool;
  PGPsc		: pPGPsc;
  PGPtls	: pPGPtls;
  FileIndex	: Longint;
  FileList	: pFileList;
begin
  PGPsc:=nil;
  PGPtls:=nil;
  Result:=false;
  if (FileNames<>nil) then with FileNames do begin
    if GetPrefWarnOnWipe(WarnPref)=0 then SetPrefWarnOnWipe(false);
    try
      if InitPGPsc(ParentHandle, PGPsc, PGPtls) then begin
	try
	  if Count<>0 then for FileIndex:=0 to pred(Count) do begin
	    Result:=false;
	    FileList:=CmdLineToFileList(PChar(Strings[FileIndex]));
	    if FileList<>nil then Result:=WipeFileList(ParentHandle, PGPsc, FileList, longbool(succ(ord(PGP7X))));
	    // obviously they've changed the declaration of the DelFilePostWipe flag in PGP 7.X so it has to be 2 here
	  end;
	finally
	  UninitPGPsc(ParentHandle, PGPsc, PGPtls);
	end;
      end;
    finally
      SetPrefWarnOnWipe(WarnPref);
    end;
  end;
end;

function ValidPassphrase(const KeyID: String; Passphrase: PChar): Longbool;
var
  Context	: pPGPContext;
  KeySetMain	: pPGPKeySet;
begin
  Result:=false;
  Context:=nil;
  KeySetMain:=nil;
  if KeyRings.InitKeyRings(Context, KeySetMain)=0 then begin
    try
      Result:=PassphraseIsValid(Context, KeySetMain, PChar(KeyID), Passphrase);
    finally
      KeyRings.FreeKeyRings;
    end;
  end;
end;

function GetShortHexID(const HexID: String): String;
begin
  Result:=EMPTY;
  if (Length(HexID)>=10) and (HexID[1]='0') and ((ord(HexID[2]) and $DF)=ord('X')) then begin
    case Length(HexID) of
      10: Result:=HexID;
      18: Result:='0x' + Copy(HexID, 11, 8)
    end;
  end;
end;

function ValidSecMem(Alloc: PChar): Longbool;
begin
  Result:=(PGPGetMemoryMgrDataInfo(Alloc)=kPGPMemoryMgrBlockInfo_Valid or
					  kPGPMemoryMgrBlockInfo_Secure or
  					  kPGPMemoryMgrBlockInfo_NonPageable);
end;

function SecAlloc(Size: Cardinal): PChar;
begin
  Result:=PGPNewSecureData(PGPGetDefaultMemoryMgr, Size, kPGPMemoryMgrFlags_Clear);
end;

function SecFree(var Alloc: PChar): Longint;
begin
  Result:=kPGPError_BadMemAddress;
  if Alloc<>nil then begin
    Result:=PGPFreeData(Alloc);
    if Result=kPGPError_NoErr then Alloc:=nil;
  end;
end;

function SecRealloc(var Alloc: PChar; Size: Cardinal; Copy: Longbool): Longint;
begin
  Result:=PGPReallocData(PGPGetDefaultMemoryMgr, pointer(Alloc), Size, kPGPMemoryMgrFlags_Clear);
  // kPGPMemoryMgrFlags_Clear only clears excess bytes
  if (Result=kPGPError_NoErr) and not Copy then FillChar(Alloc^, Size, 0);
end;

{
  function GetKeyPropsSet(KeyPropsFlag: Longint): TKeyProps;
  begin
    Result:=[];
    if KeyPropsFlag and spgpKeyPropFlag_KeyID<>0 then Include(Result, KeyProp_HexID);
    if KeyPropsFlag and spgpKeyPropFlag_UserID<>0 then  Include(Result, KeyProp_UserID);
    if KeyPropsFlag and spgpKeyPropFlag_Fingerprint<>0 then Include(Result, KeyProp_Fingerprint);
    if KeyPropsFlag and spgpKeyPropFlag_CreationTimeStr<>0 then Include(Result, KeyProp_CreaTimeStr);
    if KeyPropsFlag and spgpKeyPropFlag_ExpirationTimeStr<>0 then Include(Result, KeyProp_ExpTimeStr);
    if KeyPropsFlag and spgpKeyPropFlag_Keybits<>0 then Include(Result, KeyProp_Size);
    if KeyPropsFlag and spgpKeyPropFlag_KeyAlg<>0 then Include(Result, KeyProp_Algorithm);
    if KeyPropsFlag and spgpKeyPropFlag_Trust<>0 then Include(Result, KeyProp_Trust);
    if KeyPropsFlag and spgpKeyPropFlag_Validity<>0 then Include(Result, KeyProp_Validity);
    if KeyPropsFlag and spgpKeyPropFlag_CreationTime<>0 then Include(Result, KeyProp_CreaTimeNum);
    if KeyPropsFlag and spgpKeyPropFlag_ExpirationTime<>0 then Include(Result, KeyProp_ExpTimeNum);
    if KeyPropsFlag and spgpKeyPropFlag_IsSecret<>0 then Include(Result, KeyProp_Secret);
    if KeyPropsFlag and spgpKeyPropFlag_IsAxiomatic<>0 then Include(Result, KeyProp_ImplicitTrust);
    if KeyPropsFlag and spgpKeyPropFlag_IsRevoked<>0 then Include(Result, KeyProp_Revoked);
    if KeyPropsFlag and spgpKeyPropFlag_IsDisabled<>0 then Include(Result, KeyProp_Disabled);
    if KeyPropsFlag and spgpKeyPropFlag_IsExpired<>0 then Include(Result, KeyProp_Expired);
    if KeyPropsFlag and spgpKeyPropFlag_IsSecretShared<>0 then Include(Result, KeyProp_SecretShared);
    if KeyPropsFlag and spgpKeyPropFlag_CanEncrypt<>0 then Include(Result, KeyProp_CanEncrypt);
    if KeyPropsFlag and spgpKeyPropFlag_CanDecrypt<>0 then Include(Result, KeyProp_CanDecrypt);
    if KeyPropsFlag and spgpKeyPropFlag_CanSign<>0 then Include(Result, KeyProp_CanSign);
    if KeyPropsFlag and spgpKeyPropFlag_CanVerify<>0 then Include(Result, KeyProp_CanVerify);
    if KeyPropsFlag and spgpKeyPropFlag_HasRevoker<>0 then Include(Result, KeyProp_HasRevoker);
    if KeyPropsFlag and spgpKeyPropFlag_HasADK<>0 then Include(Result, KeyProp_HasADK);
    if KeyPropsFlag and spgpKeyPropFlag_HasSubKey<>0 then Include(Result, KeyProp_HasSubKey);
    if KeyPropsFlag and spgpKeyPropFlag_IncludeUserIDs<>0 then Include(Result, KeyProp_IncludeUserIDs );
    if KeyPropsFlag and spgpKeyPropFlag_IncludeSignerIDs<>0 then Include(Result, KeyProp_IncludeSignerIDs);
    if KeyPropsFlag and spgpKeyPropFlag_IncludeGroupsList<>0 then Include(Result, KeyProp_IncludeGroupsList);
  end;
}

function GetKeyPropsFlag(const setKeyProps: TKeyProps): Longint;
begin
  Result:=
    ord(KeyProp_HexID in setKeyProps) * spgpKeyPropFlag_KeyID or
    ord(KeyProp_UserID in setKeyProps) * spgpKeyPropFlag_UserID or
    ord(KeyProp_Fingerprint in setKeyProps) * spgpKeyPropFlag_Fingerprint or
    ord(KeyProp_CreaTimeStr in setKeyProps) * spgpKeyPropFlag_CreationTimeStr or
    ord(KeyProp_ExpTimeStr in setKeyProps) * spgpKeyPropFlag_ExpirationTimeStr or
    ord(KeyProp_Size in setKeyProps) * spgpKeyPropFlag_Keybits or
    ord(KeyProp_Algorithm in setKeyProps) * spgpKeyPropFlag_KeyAlg or
    ord(KeyProp_Trust in setKeyProps) * spgpKeyPropFlag_Trust or
    ord(KeyProp_Validity in setKeyProps) * spgpKeyPropFlag_Validity or
    ord(KeyProp_CreaTimeNum in setKeyProps) * spgpKeyPropFlag_CreationTime or
    ord(KeyProp_ExpTimeNum in setKeyProps) * spgpKeyPropFlag_ExpirationTime or
    ord(KeyProp_Secret in setKeyProps) * spgpKeyPropFlag_IsSecret or
    ord(KeyProp_ImplicitTrust in setKeyProps) * spgpKeyPropFlag_IsAxiomatic or
    ord(KeyProp_Revoked in setKeyProps) * spgpKeyPropFlag_IsRevoked or
    ord(KeyProp_Disabled in setKeyProps) * spgpKeyPropFlag_IsDisabled or
    ord(KeyProp_Expired in setKeyProps) * spgpKeyPropFlag_IsExpired or
    ord(KeyProp_SecretShared in setKeyProps) * spgpKeyPropFlag_IsSecretShared or
    ord(KeyProp_CanEncrypt in setKeyProps) * spgpKeyPropFlag_CanEncrypt or
    ord(KeyProp_CanDecrypt in setKeyProps) * spgpKeyPropFlag_CanDecrypt or
    ord(KeyProp_CanSign in setKeyProps) * spgpKeyPropFlag_CanSign or
    ord(KeyProp_CanVerify in setKeyProps) * spgpKeyPropFlag_CanVerify or
    ord(KeyProp_HasRevoker in setKeyProps) * spgpKeyPropFlag_HasRevoker or
    ord(KeyProp_HasADK in setKeyProps) * spgpKeyPropFlag_HasADK or
    ord(KeyProp_HasSubKey in setKeyProps) * spgpKeyPropFlag_HasSubKey or
    ord(KeyProp_IncludeUserIDs in setKeyProps) * spgpKeyPropFlag_IncludeUserIDs or
    ord(KeyProp_IncludeSignerIDs in setKeyProps) * spgpKeyPropFlag_IncludeSignerIDs or
    ord(KeyProp_IncludeGroupsList in setKeyProps) * spgpKeyPropFlag_IncludeGroupsList;
end;

function ShowError(const FOnFailure: TOnFailure; ErrorCode: Longint; ErrorStr: String): Longint;
begin
  Result:=ErrorCode;
  if PGPInitErrorCode=ieNone then begin
    if ErrorStr=EMPTY then begin
      SetLength(ErrorStr, 256);
      PGPGetErrorString(ErrorCode, 255, @ErrorStr[1]);
      SetLength(ErrorStr, StrLen(PChar(ErrorStr)));
    end;
  end
  else ErrorStr:=PGPInitError;
  if Assigned(FOnFailure) then
    FOnFailure(ErrorCode, ErrorStr)
  else Raise EFailException.Create(ErrorStr);
end;

function ShowHexError(const FOnFailure: TOnFailure; const IDStr: String): Longbool;
begin
  if not IsHexID(IDStr) then begin
    ShowError(FOnFailure, -1, HexFormError + '"' + IDStr + '"');
    Result:=true;
  end
  else Result:=false;
end;

function ShowPathStrError(const FOnFailure: TOnFailure; const PathStr: String): Longbool;
begin
  if (PathStr=EMPTY) or (Length(PathStr)>MAX_PATH) then begin
    ShowError(FOnFailure, -1, PathStrError + '"' + PathStr + '"');
    Result:=true;
  end
  else Result:=false;
end;


// TPGPGetKeyProps -------------------------------------------------------------

constructor TKeyRingProps.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FRingKeyOrdering:=UserID_Order;
  FPrimaryIDs:=TStringList.Create;
  FRingProps:=KeyProps_IDComplete + [KeyProp_Secret];
  FRingPropsList:=TKeyPropsList.Create(0, spgpKeyPropFlag_All);
end;

destructor TKeyRingProps.Destroy;
begin
  FRingPropsList.Free;
  FPrimaryIDs.Free;
  inherited Destroy;
end;

function TKeyRingProps.GetPrimaryIDs: Longint;
var
  KeyIndex	: Longint;
begin
  Result:=0;
  if (FPrimaryIDs<>nil) and (FRingPropsList<>nil) and (FRingPropsList.Count<>0) then begin
    FPrimaryIDs.Clear;
    with FRingPropsList do begin
      for KeyIndex:=0 to pred(Count) do begin
	FPrimaryIDs.Add(pKeyPropsRec(Objects[KeyIndex])^.kUserID);
	inc(Result);
      end;
    end;
    if Assigned(FComboBox) then FComboBox.Items.Assign(FPrimaryIDs);
    if Assigned(FListBox) then FListBox.Items.Assign(FPrimaryIDs);
  end;
end;

function TKeyRingProps.GetKeyFilter(AlgorithmFilter: TAlgorithmKeyFilter; BoolFilter: TBooleanKeyFilter): Longint;
begin
  Result:=0;
  case AlgorithmFilter of
    AlgorithmFilter_DHDSS: Result:=KeyFilterFlag_DHDSS;
    AlgorithmFilter_RSA: Result:=KeyFilterFlag_RSA;
    AlgorithmFilter_RSALegacy: Result:=KeyFilterFlag_V3;
  end;
  case BoolFilter of
    BoolFilter_CanEncrypt: Result:=Result or KeyFilterFlag_CanEncrypt;
    BoolFilter_CanDecrypt: Result:=Result or KeyFilterFlag_CanDecrypt;
    BoolFilter_CanSign: Result:=Result or KeyFilterFlag_CanSign;
    BoolFilter_CanVerify: Result:=Result or KeyFilterFlag_CanVerify;
  end;
end;

function TKeyRingProps.Update: Longint;
begin
  try
    FRingPropsList.Clear;
    FRingProps:=FRingProps + KeyProps_IDComplete + [KeyProp_Secret, KeyProp_IncludeGroupsList];
    Result:=FindKeyProps(ALL, FRingPropsList,
			 GetKeyPropsFlag(FRingProps),
			 GetKeyFilter(FRingAlgorithmFilter, FRingBoolFilter),
			 TPGPKeyOrdering(succ(FRingKeyOrdering)));
    if Result>=0 then
      Result:=GetPrimaryIDs
    else ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownKeyRingErr);
  end;
end;

constructor TPGPGetKeyProps.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
end;

destructor TPGPGetKeyProps.Destroy;
begin
  inherited Destroy;
end;

function TPGPGetKeyProps.DoGetKeyProps: Longint;
var
  KeyPropsList	: TKeyPropsList;
begin
  Result:=kPGPError_PublicKeyNotFound;
  try
    KeyPropsList:=nil;
    if Assigned(FOnGetKeyID) then FOnGetKeyID(FKeyID);
    if FKeyID<>EMPTY then begin
      Result:=FindKeyProps(FKeyID, KeyPropsList,
			   GetKeyPropsFlag(FKeyProps),
			   GetKeyFilter(FAlgorithmFilter, FBoolFilter),
			   TPGPKeyOrdering(succ(FKeyOrdering)));
      try
	if Result>=0 then begin
	  if Assigned(FOnGetKeyProps) then FOnGetKeyProps(KeyPropsList);
	end
	else ShowError(FOnFailure, Result, EMPTY);
      finally
	KeyPropsList.Free;
      end;
    end;
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownKeyPropsErr);
  end;
end;

function TPGPGetKeyProps.KeyIsOnRing: Longint;
var
  KeyPropsList	: TKeyPropsList; // dummy
begin
  Result:=kPGPError_PublicKeyNotFound;
  try
    KeyPropsList:=nil;
    if Assigned(FOnGetKeyID) then FOnGetKeyID(FKeyID);
    if FKeyID<>EMPTY then begin
      Result:=FindKeyProps(FKeyID, KeyPropsList,
			   spgpKeyPropFlag_None,
			   KeyFilterFlag_AllKeys,
			   Any_Ordering);
      if Result<0 then ShowError(FOnFailure, Result, EMPTY);
    end;
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownKeyOnRingErr);
  end;
end;

function TPGPGetKeyProps.KeyRingCount: Longint;
var
  KeyPropsList	: TKeyPropsList; // dummy
begin
  try
    KeyPropsList:=nil;
    Result:=FindKeyProps(ALL, KeyPropsList,
			 spgpKeyPropFlag_None,
			 KeyFilterFlag_AllKeys,
			 Any_Ordering);
    if Result<0 then ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownKeyRingCountErr);
  end;
end;

function TPGPGetKeyProps.GetKeyProp(KeyPropsList: TKeyPropsList; KeyIndex: Longint; KeyProp: TKeyProp): Variant;
begin
  Result:=0;
  if (KeyPropsList<>nil) and (KeyIndex>=0) and (KeyIndex<KeyPropsList.Count) then begin
    with pKeyPropsRec(KeyPropsList.Objects[KeyIndex])^ do begin
      case KeyProp of
	KeyProp_HexID: Result:=kHexID;
	KeyProp_UserID: Result:=kUserID;
	KeyProp_Fingerprint: Result:=kFingerprint;
	KeyProp_CreaTimeStr: Result:=kCreaTimeStr;
	KeyProp_ExpTimeStr: Result:=kExpTimeStr;
	KeyProp_Size: Result:=kSize;
	KeyProp_Algorithm: Result:=kAlgorithm;
	KeyProp_Trust: Result:=kTrust;
	KeyProp_Validity: Result:=kValidity;
	KeyProp_CreaTimeNum: Result:=kCreaTimeNum;
	KeyProp_ExpTimeNum: Result:=kExpTimeNum;
	KeyProp_Secret: Result:=kPrivate;
	KeyProp_ImplicitTrust: Result:=kImplicitTrust;
	KeyProp_Revoked: Result:=kRevoked;
	KeyProp_Disabled: Result:=kDisabled;
	KeyProp_Expired: Result:=kExpired;
	KeyProp_SecretShared: Result:=kSecShared;
	KeyProp_CanEncrypt: Result:=kCanEncrypt;
	KeyProp_CanDecrypt: Result:=kCanDecrypt;
	KeyProp_CanSign: Result:=kCanSign;
	KeyProp_CanVerify: Result:=kCanVerify;
	KeyProp_HasRevoker: Result:=kHasRevoker;
	KeyProp_HasADK: Result:=kHasADK;
	KeyProp_HasSubKey: Result:=kHasSubKey;
      else
	ShowError(FOnFailure, kPGPError_BadParams, EMPTY);
      end;
    end;
  end
  else ShowError(FOnFailure, kPGPError_ItemNotFound, EMPTY);
end;

function TPGPGetKeyProps.GetUserIDList(KeyPropsList: TKeyPropsList; KeyIndex: Longint): TStringList;
begin
  Result:=nil;
  if (KeyPropsList<>nil) and (KeyIndex>=0) and (KeyIndex<KeyPropsList.Count) then
    Result:=pKeyPropsRec(KeyPropsList.Objects[KeyIndex])^.kUserIDList
  else ShowError(FOnFailure, kPGPError_ItemNotFound, EMPTY);
end;

function TPGPGetKeyProps.GetSignerIDList(KeyPropsList: TKeyPropsList; KeyIndex: Longint): TStringList;
begin
  Result:=nil;
  if (KeyPropsList<>nil) and (KeyIndex>=0) and (KeyIndex<KeyPropsList.Count) then
    Result:=pKeyPropsRec(KeyPropsList.Objects[KeyIndex])^.kSignerIDList
  else ShowError(FOnFailure, kPGPError_ItemNotFound, EMPTY);
end;

function TPGPGetKeyProps.GetRevKeyIDList(KeyPropsList: TKeyPropsList; KeyIndex: Longint): TStringList;
begin
  Result:=nil;
  if (KeyPropsList<>nil) and (KeyIndex>=0) and (KeyIndex<KeyPropsList.Count) then
    Result:=pKeyPropsRec(KeyPropsList.Objects[KeyIndex])^.kRevKeyIDList
  else ShowError(FOnFailure, kPGPError_ItemNotFound, EMPTY);
end;

function TPGPGetKeyProps.GetADKeyIDList(KeyPropsList: TKeyPropsList; KeyIndex: Longint): TStringList;
begin
  Result:=nil;
  if (KeyPropsList<>nil) and (KeyIndex>=0) and (KeyIndex<KeyPropsList.Count) then
    Result:=pKeyPropsRec(KeyPropsList.Objects[KeyIndex])^.kADKeyIDList
  else ShowError(FOnFailure, kPGPError_ItemNotFound, EMPTY);
end;

function TPGPGetKeyProps.GetGroupHexIDs(KeyPropsList: TKeyPropsList; GroupIndex: Longint; var GroupName: String): String;
var
  TabPos	: Longint;
begin
  Result:=EMPTY;
  GroupName:=EMPTY;
  if (KeyPropsList<>nil) and (GroupIndex>=0) and (GroupIndex<KeyPropsList.GroupsList.Count) then begin
    Result:=KeyPropsList.GroupsList.Strings[GroupIndex];
    TabPos:=pos(TAB, Result);
    GroupName:=Copy(Result, 1, pred(TabPos));
    Delete(Result, 1, TabPos);
  end
  else ShowError(FOnFailure, kPGPError_ItemNotFound, EMPTY);
end;


// TPGPSetKeyProps -------------------------------------------------------------

constructor TPGPSetKeyProps.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FMinPassLen:=10;
  FMinPassQual:=100;
  if AOwner is TForm then FParentHandle:=TForm(AOwner).Handle;
end;

destructor TPGPSetKeyProps.Destroy;
begin
  inherited Destroy;
end;

function TPGPSetKeyProps.GetKeyHexID(FilterFlags: Longint): Longint;
var
  KeyPropsList	: TKeyPropsList;
  KeyPropsRec	: TKeyPropsRec;
begin
  Result:=0;
  KeyPropsList:=nil;
  try
    if (FKeyHexID=EMPTY) or (FindKeyProps(FKeyHexID,
					  KeyPropsList,
					  GetKeyPropsFlag(FKeyProps) or spgpKeyPropFlag_IDFlags,
					  FilterFlags,
					  Any_Ordering)<>1) then begin
      if (KeyPropsList<>nil) then KeyPropsList.Clear;
      Result:=SelectKeysDialog(FKeyDlgPrompt, KeyPropsList, true,
			       GetKeyPropsFlag(FKeyProps) or spgpKeyPropFlag_IDFlags,
			       FilterFlags, FParentHandle);
      if Result=0 then begin
	KeyPropsRec:=KeyPropsList.KeyProps[0];
	FKeyHexID:=KeyPropsList.Strings[0];
      end;
    end
    else begin
      KeyPropsRec:=KeyPropsList.KeyProps[0];
      FKeyHexID:=KeyPropsList.Strings[0];
    end;
    if Result=0 then begin
      if not ShowHexError(FOnFailure, FKeyHexID) then begin
	if Assigned(FOnKeySelected) and not FOnKeySelected(KeyPropsRec) then Result:=kPGPError_UserAbort;
      end
      else Result:=kPGPError_BadParams;
    end;
  finally
    KeyPropsList.Free;
  end;
end;

function TPGPSetKeyProps.DoKeyDisable: Longint;
begin
  try
    Result:=GetKeyHexID(KeyFilterFlag_Enabled);
    if Result=0 then Result:=KeyDisable(PChar(FKeyHexID));
    if Result<0 then ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownKeyDisableErr);
  end;
end;

function TPGPSetKeyProps.DoKeyEnable: Longint;
begin
  try
    Result:=GetKeyHexID(KeyFilterFlag_Disabled);
    if Result=0 then Result:=KeyEnable(PChar(FKeyHexID));
    if Result<0 then ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownKeyEnableErr);
  end;
end;

function TPGPSetKeyProps.DoKeyRemove: Longint;
begin
  try
    Result:=GetKeyHexID(KeyFilterFlag_AllKeys);
    if Result=0 then KeyRemove(PChar(FKeyHexID));
    if Result<0 then ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownKeyRemoveErr);
  end;
end;

function TPGPSetKeyProps.DoKeyRevoke: Longint;
var
  Passphrase	: PChar;
  Cancel	: Longbool;
begin
  try
    Result:=GetKeyHexID(KeyFilterFlag_CanDecrypt);
    if Result=0 then begin
      if Assigned(FOnGetPassphrase) then begin
	Passphrase:=PGPNewSecureData(PGPGetDefaultMemoryMgr, 256, kPGPMemoryMgrFlags_Clear);
	if Passphrase<>nil then begin
	  try
	    Cancel:=false;
	    Result:=kPGPError_UserAbort;
	    FOnGetPassphrase(Passphrase, Cancel);
	    if not Cancel then Result:=KeyRevoke(PChar(FKeyHexID), Passphrase);
	  finally
	    PGPFreeData(Passphrase);
	  end;
	end
	else Result:=kPGPError_OutOfMemory;
      end
      else Result:=KeyRevokeDialog(FKeyHexID, FPassDlgPrompt, FParentHandle);
    end;
    if Result<0 then ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownKeyRevokeErr);
  end;
end;

function TPGPSetKeyProps.DoKeyPassChange: Longint;
var
  OldPassphrase	: PChar;
  NewPassphrase	: PChar;
  Cancel	: Longbool;
begin
  try
    Result:=GetKeyHexID(KeyFilterFlag_CanSign);
    if Result=0 then begin
      if Assigned(FOnChangePassphrase) then begin
	OldPassphrase:=PGPNewSecureData(PGPGetDefaultMemoryMgr, 256, kPGPMemoryMgrFlags_Clear);
	if OldPassphrase<>nil then begin
	  try
	    NewPassphrase:=PGPNewSecureData(PGPGetDefaultMemoryMgr, 256, kPGPMemoryMgrFlags_Clear);
	    if NewPassphrase<>nil then begin
	      try
		Cancel:=false;
		Result:=kPGPError_UserAbort;
		repeat
		  FOnChangePassphrase(OldPassphrase, NewPassphrase, FMinPassLen, FMinPassQual, Cancel);
		until Cancel
		or (StrLen(NewPassphrase)>=FMinPassLen) and (PGPEstimatePassphraseQuality(NewPassphrase)>=FMinPassQual); 
		if not Cancel then Result:=ChangePassphrase(PChar(FKeyHexID), OldPassphrase, NewPassphrase);
	      finally
		PGPFreeData(NewPassphrase);
	      end;
	    end
	    else Result:=kPGPError_OutOfMemory;
	  finally
	    PGPFreeData(OldPassphrase);
	  end;
	end
	else Result:=kPGPError_OutOfMemory;
      end
      else begin
	Result:=KeyPassChangeDialog(FKeyHexID, FPassDlgOldPrompt, FPassDlgNewPrompt,
				    FMinPassLen, FMinPassQual, FParentHandle);
      end;
    end;
    if Result<0 then ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownKeyPassChangeErr);
  end;
end;


// TPGPPreferences -------------------------------------------------------------

constructor TPGPPreferences.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  if AOwner is TForm then FParentHandle:=TForm(AOwner).Handle;
end;

destructor TPGPPreferences.Destroy;
begin
  inherited Destroy;
end;

function TPGPPreferences.ShowPrefsDialog: Longint;
begin
  Result:=PreferencesDialog(ord(FPrefsPage), FParentHandle);
end;

function TPGPPreferences.GetFlags: Longint;
begin
  Result:=ord(Pref_PublicKeyring in FPGPPrefs) * PrefsFlag_PublicKeyring or
	  ord(Pref_PrivateKeyring in FPGPPrefs) * PrefsFlag_PrivateKeyring or
	  ord(Pref_RandomSeedFile in FPGPPrefs) * PrefsFlag_RandomSeedFile or
	  ord(Pref_GroupsFile in FPGPPrefs) * PrefsFlag_GroupsFile or
	  ord(Pref_DefaultKeyID in FPGPPrefs) * PrefsFlag_DefaultKeyID;
end;

function TPGPPreferences.PrefsError: Longbool;
begin
  with FPreferences do begin
    Result:=(Pref_PublicKeyring in FPGPPrefs) and ShowPathStrError(FOnFailure, PublicKeyring) or
	    (Pref_PrivateKeyring in FPGPPrefs) and ShowPathStrError(FOnFailure, PrivateKeyring) or
	    (Pref_RandomSeedFile in FPGPPrefs) and ShowPathStrError(FOnFailure, RandomSeedFile) or
	    (Pref_GroupsFile in FPGPPrefs) and ShowPathStrError(FOnFailure, GroupsFile) or
	    (Pref_DefaultKeyID in FPGPPrefs) and ShowHexError(FOnFailure, DefaultKeyHexID);
  end;
end;

function TPGPPreferences.GetAltPubKeyring: String;
begin
  Result:=FAltPubringFile;
end;

function TPGPPreferences.GetAltPrivKeyring: String;
begin
  Result:=FAltSecringFile;
end;

function TPGPPreferences.GetAltGroupsFile: String;
begin
  Result:=FAltGroupsFile;
end;

procedure TPGPPreferences.SetAltPubKeyring(const Value: String);
begin
  FAltPubringFile:=Value;
  KeyRings.PubringFile:=Value;
end;

procedure TPGPPreferences.SetAltPrivKeyring(const Value: String);
begin
  FAltSecringFile:=Value;
  KeyRings.SecringFile:=Value;
end;

procedure TPGPPreferences.SetAltGroupsFile(const Value: String);
begin
  FAltGroupsFile:=Value;
  KeyRings.GroupsFile:=Value;
end;

function TPGPPreferences.DoGetPreferences: Longint;
var PrefsFlag: Longint;
begin
  Result:=kPGPError_BadParams;
  try
    PrefsFlag:=GetFlags;
    if PrefsFlag<>0 then begin
      Result:=GetPreferences(FPreferences, PrefsFlag);
      if Result<0 then
	ShowError(FOnFailure, Result, EMPTY)
      else if Assigned(FOnGetPreferences) then FOnGetPreferences(FPreferences);
    end;
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownPrefsErr);
  end;
end;

function TPGPPreferences.DoSetPreferences: Longint;
var PrefsFlag: Longint;
begin
  Result:=kPGPError_BadParams;
  try
    if Assigned(FOnSetPreferences) then FOnSetPreferences(FPreferences);
    PrefsFlag:=GetFlags;
    if (PrefsFlag<>0) and not PrefsError then begin
      Result:=SetPreferences(FPreferences, PrefsFlag);
      if Result<0 then ShowError(FOnFailure, Result, EMPTY);
    end;
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownPrefsErr);
  end;
end;


// TPGPKeyServer ---------------------------------------------------------------

constructor TPGPKeyServer.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  if AOwner is TForm then FParentHandle:=TForm(AOwner).Handle;
end;

destructor TPGPKeyServer.Destroy;
begin
  inherited Destroy;
end;

function TPGPKeyServer.DoGetKeysFromServer(const KeyData: String): Longint;
var
  KeyPropsList	 : TKeyPropsList;
begin
  KeyPropsList:=nil;
  try
    Result:=GetKeyFromServerDialog(FKeyDlgPrompt, KeyData, KeyPropsList, GetKeyPropsFlag(FKeyProps), FParentHandle);
    try
      if Result=0 then begin
	if Assigned(FOnServerResults) then FOnServerResults(KeyPropsList);
      end
      else ShowError(FOnFailure, Result, Empty);
    finally
      KeyPropsList.Free;
    end;
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownServerErr);
  end;
end;

function TPGPKeyServer.DoSendKeysToServer: Longint;
var
  KeyPropsList	 : TKeyPropsList;
begin
  KeyPropsList:=nil;
  try
    Result:=SendKeyToServerDialog(FKeyDlgPrompt, KeyPropsList, GetKeyPropsFlag(FKeyProps), FParentHandle);
    try
      if Result=0 then begin
	if Assigned(FOnServerResults) then FOnServerResults(KeyPropsList);
      end
      else ShowError(FOnFailure, Result, Empty);
    finally
      KeyPropsList.Free;
    end;
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownServerErr);
  end;
end;

function TPGPKeyServer.DoGetDefaultServer: Longint;
var
  Entry		 : TStringList;
  Pref		 : pPGPPref;
  pKeyServerEntry: pPGPKeyServerEntry;
  ServerCount	 : PGPUInt32;
  FlagValue	 : PGPUInt32;
begin
  Pref:=nil;
  pKeyServerEntry:=nil;
  try
    if PGP7X then begin
      Result:=kPGPError_PrefNotFound;
      if PrefsFile<>nil then with PrefsFile do if LoadPrefs then begin
	try
	  Entry:=TStringList.Create;
	  if Entry<>nil then with Entry do begin
	    try
	      CommaText:=PrefsData.Values[KeyServers + '1'];
	      if (Text<>E) and (Count=8) then with FServerEntry do begin
		if Strings[0]<>E then ServerProtocol:=TServerType(StrToInt(Strings[0]));
		if Strings[3]<>E then ServerDNS:=Strings[3];
		if Strings[4]<>E then ServerPort:=StrToInt(Strings[4]);
		if Strings[7]<>E then begin
		  FlagValue:=StrToInt(Strings[7]);
		  if FlagValue and kKeyServerListed<>0 then Include(ServerFlags, KeyServerListed);
		  if FlagValue and kKeyServerIsRoot<>0 then Include(ServerFlags, KeyServerIsRoot);
		end;
	      end;
	    finally
	      Entry.Free;
	    end;
	    Result:=0;
	  end;
	except
	end;
	PrefsData.Clear;
      end;
    end
    else begin
      Result:=PGPclOpenClientPrefs(PGPGetDefaultMemoryMgr, Pref);
      if Result=0 then begin
	try
	  Result:=PGPGetKeyServerPrefs(Pref, pKeyServerEntry, ServerCount);
	  try
	    if Result=0 then begin
	      if ServerCount<>0 then begin
		with FServerEntry do begin
		  ServerProtocol:=TServerType(pKeyServerEntry^.Protocol);
		  ServerDNS:=pKeyServerEntry^.ServerDNS;
		  ServerPort:=pKeyServerEntry^.ServerPort;
		  if pKeyServerEntry^.Flags and kKeyServerListed<>0 then Include(ServerFlags, KeyServerListed);
		  if pKeyServerEntry^.Flags and kKeyServerIsRoot<>0 then Include(ServerFlags, KeyServerIsRoot);
		end;
		if Assigned(FOnGetDefaultServer) then FOnGetDefaultServer(FServerEntry);
	      end
	      else Result:=kPGPError_PrefNotFound;
	    end;
	  finally
	    PGPFreeData(pKeyServerEntry);
	  end;
	finally
	  PGPclCloseClientPrefs(Pref, false);
	end;
      end;
    end;
    if Result<0 then ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownServerErr);
  end;
end;

function TPGPKeyServer.DoSetDefaultServer: Longint;
var
  Entry		 : TStringList;
  Pref		 : pPGPPref;
  pKeyServerEntry: pPGPKeyServerEntry;
  ServerCount	 : PGPUInt32;
  FlagValue	 : PGPUint32;
begin
  Pref:=nil;
  pKeyServerEntry:=nil;
  try
    if PGP7X then begin
      Result:=kPGPError_PrefNotFound;
      if PrefsFile<>nil then with PrefsFile do if LoadPrefs then begin
	try
	  Entry:=TStringList.Create;
	  if Entry<>nil then with Entry do begin
	    try
	      CommaText:=PrefsData.Values[KeyServers + '1'];
	      if (Text<>E) and (Count=8) then with FServerEntry do begin
		FlagValue:=ord(KeyServerListed in ServerFlags) * kKeyServerListed or
			   ord(KeyServerIsRoot in ServerFlags) * kKeyServerIsRoot;
		Text:=IntToStr(ord(ServerProtocol)) + CM +
		      Strings[1] + CM +
		      QU + Strings[2] + QU + CM +
		      QU + ServerDNS + QU + CM +
		      IntToStr(ServerPort) + CM +
		      QU + Strings[5] + QU + CM +
		      Strings[6] + CM +
		      IntToStr(FlagValue);
	      end;
	      PrefsData.Values[KeyServers + '1']:=TrimRight(Text);
	    finally
	      Entry.Free;
	    end;
	    if SavePrefs then Result:=0;
	  end;
	except
	end;
	PrefsData.Clear;
      end;
    end
    else begin
      Result:=PGPclOpenClientPrefs(PGPGetDefaultMemoryMgr, Pref);
      if Result=0 then begin
	try
	  Result:=PGPGetKeyServerPrefs(Pref, pKeyServerEntry, ServerCount);
	  try
	    if Result=0 then begin
	      if ServerCount<>0 then begin
		if Assigned(FOnSetDefaultServer) then FOnSetDefaultServer(FServerEntry);
		with FServerEntry do begin
		  pKeyServerEntry^.StructSize:=SizeOf(TPGPKeyServerEntry);
		  if ServerProtocol<>KeyServerType_Invalid then
		    pKeyServerEntry^.Protocol:=PGPKeyServerProtocol(ServerProtocol)
		  else begin
		    Result:=kPGPError_BadParams;
		    Exit;
		  end;
		  if ServerDNS<>EMPTY then
		    StrPLCopy(pKeyServerEntry^.ServerDNS, ServerDNS, kMaxServerNameLength)
		  else begin
		    Result:=kPGPError_BadParams;
		    Exit;
		  end;
		  pKeyServerEntry^.ServerPort:=ServerPort;
		  pKeyServerEntry^.Flags:=ord(KeyServerListed in ServerFlags) * kKeyServerListed or
					  ord(KeyServerIsRoot in ServerFlags) * kKeyServerIsRoot;
		end;
		Result:=PGPSetKeyServerPrefs(Pref, pKeyServerEntry, ServerCount);
		if Result=0 then PGPclNotifyPrefsChanges(GetCurrentProcessID);
	      end
	      else Result:=kPGPError_PrefNotFound;
	    end;
	  finally
	    PGPFreeData(pKeyServerEntry);
	  end;
	finally
	  PGPclCloseClientPrefs(Pref, true);
	end;
      end;
    end;
    if Result<0 then ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownServerErr);
  end;
end;


// TPGPKeysGenerate ------------------------------------------------------------

constructor TPGPKeysGenerate.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  if AOwner is TForm then ParentHandle:=TForm(AOwner).Handle;
end;

function TPGPKeysGenerate.DHDSSKeyGenerate: Longint;
begin
  Result:=kPGPError_UnknownError;
  try
    Result:=inherited DHDSSKeyGenerate;
    if Result<>0 then ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else ShowError(FOnFailure, -1, UnknownKeyGenErr);
  end;
end;

function TPGPKeysGenerate.DHSubKeyGenerate: Longint;
begin
  Result:=kPGPError_UnknownError;
  try
    Result:=inherited DHSubKeyGenerate;
    if Result<>0 then ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else ShowError(FOnFailure, -1, UnknownKeyGenErr);
  end;
end;

function TPGPKeysGenerate.DSAKeyGenerate: Longint;
begin
  Result:=kPGPError_UnknownError;
  try
    Result:=inherited DSAKeyGenerate;
    if Result<>0 then ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else ShowError(FOnFailure, -1, UnknownKeyGenErr);
  end;
end;

function TPGPKeysGenerate.RSAKeyGenerate(Legacy: Longbool): Longint;
begin
  Result:=kPGPError_UnknownError;
  try
    Result:=inherited RSAKeyGenerate(Legacy);
    if Result<>0 then ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else ShowError(FOnFailure, -1, UnknownKeyGenErr);
  end;
end;


// TPGPKeyImport ---------------------------------------------------------------

constructor TPGPKeyImport.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  if AOwner is TForm then FParentHandle:=TForm(AOwner).Handle;
end;

destructor TPGPKeyImport.Destroy;
begin
  inherited Destroy;
end;

function TPGPKeyImport.DoKeyImport: Longint;
var
  KeyPropsList	: TKeyPropsList;
begin
  Result:=kPGPError_ItemNotFound;
  try
    KeyPropsList:=nil;
    if FKeyData<>EMPTY then begin
      FKeyProps:=FKeyProps + KeyProps_IDComplete;
      Result:=KeyImportDialog(FKeyDlgPrompt, FKeyData, KeyPropsList, false,
			      ord(Ignore_ByHexID in FIgnoreKnownKeys)*IgnoreFlag_ByHexID or
			      ord(Ignore_ByUserID in FIgnoreKnownKeys)*IgnoreFlag_ByUserID,
			      GetKeyPropsFlag(FKeyProps), FParentHandle);
      try
	if (Result=0) or ((Result=kPGPError_FilePermissions) and (KeyPropsList.Count>0)) then begin
	  if Assigned(FOnKeyImported) then FOnKeyImported(KeyPropsList, KeyPropsList.Count);
	end;
      finally
	KeyPropsList.Free;
      end;
    end;
    if Result<>0 then ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownKeyImportErr);
  end;
end;

function TPGPKeyImport.DoKeyImportFile: Longint;
var
  KeyPropsList	: TKeyPropsList;
begin
  Result:=kPGPError_FileNotFound;
  try
    KeyPropsList:=nil;
    if Assigned(FOnGetFileIn) then FOnGetFileIn(FFileIn);
    if FFileIn<>EMPTY then begin
      FKeyProps:=FKeyProps + KeyProps_IDComplete;
      Result:=KeyImportDialog(FKeyDlgPrompt, FFileIn, KeyPropsList, true,
			      ord(Ignore_ByHexID in FIgnoreKnownKeys)*IgnoreFlag_ByHexID or
			      ord(Ignore_ByUserID in FIgnoreKnownKeys)*IgnoreFlag_ByUserID,
			      GetKeyPropsFlag(FKeyProps), FParentHandle);
      try
	if (Result=0) or ((Result=kPGPError_FilePermissions) and (KeyPropsList.Count>0)) then begin
	  if Assigned(FOnKeyImported) then FOnKeyImported(KeyPropsList, KeyPropsList.Count);
	end;
      finally
	KeyPropsList.Free;
      end;
    end;
    if Result<>0 then ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownKeyImportErr);
  end;
end;


// TPGPKeyExport ---------------------------------------------------------------

constructor TPGPKeyExport.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FExportCompatible:=true;
  FKeyIDs:=TStringList.Create;
  if AOwner is TForm then FParentHandle:=TForm(AOwner).Handle;
end;

destructor TPGPKeyExport.Destroy;
begin
  FKeyIDs.Free;
  inherited Destroy;
end;

procedure TPGPKeyExport.SetVersionString(const Value: String);
begin
  if Value<>'' then
    StrPLCopy(MyVersion, Value, pred(SizeOf(TVersionString)))
  else if PGPGetSDKString(MyVersion)<>0 then MyVersion:='N/A';
end;

function TPGPKeyExport.GetVersionString: String;
begin
  Result:=MyVersion;
end;

procedure TPGPKeyExport.SetKeyIDs(const Value: TStrings);
begin
  FKeyIDs.Assign(Value);
end;

function TPGPKeyExport.DoKeyExport: Longint;
var
  KeyPropsList	: TKeyPropsList;
begin
  try
    FKeyData:=EMPTY;
    KeyPropsList:=nil;
    FKeyProps:=FKeyProps + KeyProps_IDComplete;
    Result:=KeyExportDialog(FKeyDlgPrompt, FKeyIDs, FKeyData,
			    KeyPropsList, false,
			    FExportCompatible, FExportPrivate,
			    GetKeyPropsFlag(FKeyProps), FParentHandle);
    try
      if Result=0 then begin
	if Assigned(FOnKeyExported) then FOnKeyExported(KeyPropsList, FKeyData, EMPTY);
      end
      else ShowError(FOnFailure, Result, EMPTY);
    finally
      KeyPropsList.Free;
    end;
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownKeyExportErr);
  end;
end;

function TPGPKeyExport.DoKeyExportFile: Longint;
var
  KeyPropsList	: TKeyPropsList;
begin
  Result:=kPGPError_FileNotFound;
  try
    KeyPropsList:=nil;
    if Assigned(FOnGetFileOut) then FOnGetFileOut(FFileOut);
    if FFileOut<>EMPTY then begin
      FKeyProps:=FKeyProps + KeyProps_IDComplete;
      Result:=KeyExportDialog(FKeyDlgPrompt, FKeyIDs, FFileOut,
			      KeyPropsList, true,
			      FExportCompatible, FExportPrivate,
			      GetKeyPropsFlag(FKeyProps), FParentHandle);
      try
	if Result=0 then begin
	  if Assigned(FOnKeyExported) then FOnKeyExported(KeyPropsList, EMPTY, FFileOut);
	end
	else ShowError(FOnFailure, Result, EMPTY);
      finally
	KeyPropsList.Free;
      end;
    end;
  except
    on EFailException do Raise;
    else Result:=ShowError(FOnFailure, -1, UnknownKeyExportErr);
  end;
end;


// TPGPEncode ------------------------------------------------------------------

constructor TPGPEncode.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  if AOwner is TForm then ParentHandle:=TForm(AOwner).Handle;
end;

function TPGPEncode.KeyEncryptBuffer(const DataBuffer: String; Sign: Longbool): Longint;
begin
  Result:=kPGPError_UnknownError;
  try
    Result:=inherited KeyEncryptBuffer(DataBuffer, Sign);
    if Result=0 then begin
      if Assigned(FOnEncoded) then FOnEncoded(OutputBuffer, OutputFileName);
    end
    else ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else ShowError(FOnFailure, -1, UnknownEncodeErr);
  end;
end;

function TPGPEncode.KeyEncryptFile(const FileName: String; Sign: Longbool): Longint;
begin
  Result:=kPGPError_UnknownError;
  try
    Result:=inherited KeyEncryptFile(FileName, Sign);
    if Result=0 then begin
      if Assigned(FOnEncoded) then FOnEncoded(OutputBuffer, OutputFileName);
    end
    else ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else ShowError(FOnFailure, -1, UnknownEncodeErr);
  end;
end;

function TPGPEncode.ConventionalEncryptBuffer(const DataBuffer: String): Longint;
begin
  Result:=kPGPError_UnknownError;
  try
    Result:=inherited ConventionalEncryptBuffer(DataBuffer);
    if Result=0 then begin
      if Assigned(FOnEncoded) then FOnEncoded(OutputBuffer, OutputFileName);
    end
    else ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else ShowError(FOnFailure, -1, UnknownEncodeErr);
  end;
end;

function TPGPEncode.ConventionalEncryptFile(const FileName: String): Longint;
begin
  Result:=kPGPError_UnknownError;
  try
    Result:=inherited ConventionalEncryptFile(FileName);
    if Result=0 then begin
      if Assigned(FOnEncoded) then FOnEncoded(OutputBuffer, OutputFileName);
    end
    else ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else ShowError(FOnFailure, -1, UnknownEncodeErr);
  end;
end;

function TPGPEncode.ClearSignBuffer(const DataBuffer: String): Longint;
begin
  Result:=kPGPError_UnknownError;
  try
    Result:=inherited ClearSignBuffer(DataBuffer);
    if Result=0 then begin
      if Assigned(FOnEncoded) then FOnEncoded(OutputBuffer, OutputFileName);
    end
    else ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else ShowError(FOnFailure, -1, UnknownEncodeErr);
  end;
end;

function TPGPEncode.ClearSignFile(const FileName: String): Longint;
begin
  Result:=kPGPError_UnknownError;
  try
    Result:=inherited ClearSignFile(FileName);
    if Result=0 then begin
      if Assigned(FOnEncoded) then FOnEncoded(OutputBuffer, OutputFileName);
    end
    else ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else ShowError(FOnFailure, -1, UnknownEncodeErr);
  end;
end;

function TPGPEncode.ArmorBuffer(const DataBuffer: String): Longint;
begin
  Result:=kPGPError_UnknownError;
  try
    Result:=inherited ArmorBuffer(DataBuffer);
    if Result=0 then begin
      if Assigned(FOnEncoded) then FOnEncoded(OutputBuffer, OutputFileName);
    end
    else ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else ShowError(FOnFailure, -1, UnknownEncodeErr);
  end;
end;

function TPGPEncode.ArmorFile(const FileName: String): Longint;
begin
  Result:=kPGPError_UnknownError;
  try
    Result:=inherited ArmorFile(FileName);
    if Result=0 then begin
      if Assigned(FOnEncoded) then FOnEncoded(OutputBuffer, OutputFileName);
    end
    else ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else ShowError(FOnFailure, -1, UnknownEncodeErr);
  end;
end;

function TPGPEncode.DetachedSignBuffer(const DataBuffer: String): Longint;
begin
  Result:=kPGPError_UnknownError;
  try
    Result:=inherited DetachedSignBuffer(DataBuffer);
    if Result=0 then begin
      if Assigned(FOnEncoded) then FOnEncoded(OutputBuffer, OutputFileName);
    end
    else ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else ShowError(FOnFailure, -1, UnknownEncodeErr);
  end;
end;

function TPGPEncode.DetachedSignFile(const FileName: String): Longint;
begin
  Result:=kPGPError_UnknownError;
  try
    Result:=inherited DetachedSignFile(FileName);
    if Result=0 then begin
      if Assigned(FOnEncoded) then FOnEncoded(OutputBuffer, OutputFileName);
    end
    else ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else ShowError(FOnFailure, -1, UnknownEncodeErr);
  end;
end;


// TPGPDecode ------------------------------------------------------------------

constructor TPGPDecode.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  if AOwner is TForm then ParentHandle:=TForm(AOwner).Handle;
end;

function TPGPDecode.DecodeBuffer(const DataBuffer: String): Longint;
begin
  Result:=kPGPError_UnknownError;
  try
    Result:=inherited DecodeBuffer(DataBuffer);
    if Result=0 then begin
      if Assigned(FOnDecoded) then FOnDecoded(OutputBuffer, OutputFileName, SigPropsRec, KeyPropsList);
    end
    else ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else ShowError(FOnFailure, -1, UnknownDecodeErr);
  end;
end;

function TPGPDecode.DecodeFile(const FileName: String): Longint;
begin
  Result:=kPGPError_UnknownError;
  try
    Result:=inherited DecodeFile(FileName);
    if Result=0 then begin
      if Assigned(FOnDecoded) then FOnDecoded(OutputBuffer, OutputFileName, SigPropsRec, KeyPropsList);
    end
    else ShowError(FOnFailure, Result, EMPTY);
  except
    on EFailException do Raise;
    else ShowError(FOnFailure, -1, UnknownDecodeErr);
  end;
end;


// Register --------------------------------------------------------------------

procedure Register;
begin
  RegisterComponents('PGP', [TPGPPreferences, TPGPKeyServer,
			     TPGPGetKeyProps, TPGPSetKeyProps,
			     TPGPKeysGenerate,
			     TPGPKeyImport, TPGPKeyExport,
			     TPGPEncode, TPGPDecode]);
end;

initialization

  PGPInitErrorCode:=pgpBase.PGPInitErrorCode;

// initialize notification messages --------------------------------------------

  if PGPInitErrorCode=ieNone then begin
    WM_PGP_ReloadPrefs:=WM_PGPReloadPrefs;
    WM_PGP_ReloadKeyring:=WM_PGPReloadKeyring;
    WM_PGP_ReloadKeyserverPrefs:=WM_PGPReloadKeyserverPrefs;
  end;

end.

