{$J+,Z4}
unit pgpSDKPrefs;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the "Borland Delphi Runtime Library PGPsdk" released 10 Apr }
{ 2000, available at http://www.oz.net/~srheller/dpgp/sdk/.                        }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpSDKPrefs.pas based on pgpSDKPrefs.h from the PGP sources }
{ which are Copyright (C) Network Associates Inc. and affiliated companies.        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ Comments modified                                                                }
{                                                                                  }
{**********************************************************************************}

interface

uses
  pgpPubTypes, pgpBase;

type
  PGPsdkPrefSelector = PGPEnumType;
const
  kPGPsdkPref_DefaultKeyID	= 3;
  kPGPsdkPref_PublicKeyring	= 5;
  kPGPsdkPref_PrivateKeyring	= 6;
  kPGPsdkPref_RandomSeedFile	= 7;
  kPGPsdkPref_GroupsFile	= 8;

var
{ use prefs stored in the prefs file }
  PGPsdkLoadPrefs: function(Context: pPGPContext; PrefSpec: pPGPFileSpec): PGPError; cdecl;

{ use prefs stored in the default prefs file }
  PGPsdkLoadDefaultPrefs: function(Context: pPGPContext): PGPError; cdecl;

{ save any changed preferences to disk }
  PGPsdkSavePrefs: function(Context: pPGPContext): PGPError; cdecl;

  PGPsdkPrefSetFileSpec: function(Context: pPGPContext; Selector: PGPsdkPrefSelector; FileSpec: pPGPFileSpec): PGPError; cdecl;

{ caller must de-allocate outRef with PGPFreeFileSpec }
  PGPsdkPrefGetFileSpec: function(Context: pPGPContext; Selector: PGPsdkPrefSelector; var FileSpec: pPGPFileSpec): PGPError; cdecl;

  PGPsdkPrefSetData: function(Context: pPGPContext; Selector: PGPsdkPrefSelector; pData: Pointer; Size: PGPSize): PGPError; cdecl;

{ caller must de-allocate dataOut with PGPFreeData }
  PGPsdkPrefGetData: function(Context: pPGPContext; Selector: PGPsdkPrefSelector; pData: Pointer; var Size: PGPSize): PGPError; cdecl;

implementation	// code modified by idw

uses
  Windows;

initialization

  if PGPInitErrorCode=ieNone then begin
    PGPsdkLoadPrefs:=GetProcAddress(hPGPsdkLib, 'PGPsdkLoadPrefs');
    PGPsdkLoadDefaultPrefs:=GetProcAddress(hPGPsdkLib, 'PGPsdkLoadDefaultPrefs');
    PGPsdkSavePrefs:=GetProcAddress(hPGPsdkLib, 'PGPsdkSavePrefs');
    PGPsdkPrefSetFileSpec:=GetProcAddress(hPGPsdkLib, 'PGPsdkPrefSetFileSpec');
    PGPsdkPrefGetFileSpec:=GetProcAddress(hPGPsdkLib, 'PGPsdkPrefGetFileSpec');
    PGPsdkPrefSetData:=GetProcAddress(hPGPsdkLib, 'PGPsdkPrefSetData');
    PGPsdkPrefGetData:=GetProcAddress(hPGPsdkLib, 'PGPsdkPrefGetData');
  end;

end.

