{$J+,Z4}
unit pgpBase;
{ $DEFINE SILENT_FAILURE}

// by removing the space preceding $DEFINE you may enable SILENT_FAILURE,
// which disables all initialization error messages and prevents your
// applications from being halted in case of a missing or incorrect
// PGP installation; this requires checking PGPInitErrorCode
// before using any PGP functionality, though

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the "Borland Delphi Runtime Library PGPsdk" released 10 Apr }
{ 2000, available at http://www.oz.net/~srheller/dpgp/sdk/.                        }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpBase.pas based on pgpBase.h from the PGP sources         }
{ which are Copyright (C) Network Associates Inc. and affiliated companies.        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{**********************************************************************************}

interface

const	// added by idw
  ErrorTitle	= 'PGP Components fatal error:';
  SDKError	= 'PGP Software Development Kit Core Library not found';
  SDKNLError	= 'PGP Software Development Kit Networking Library not found';
  SDKUIError	= 'PGP Software Development Kit User Interface Library not found';
  CLError	= 'PGP Client Library not found';
  SCError	= 'PGP Cryptographic Support Library not found';
  VersionError	= 'Wrong PGP version: 6.5.X or 7.X.X required';

type	// added by idw
  TPGPInitErrorCode = (ieNone, ieSDK, ieSDKNL, ieSDKUI, ieCL, ieSC, ieVersion);

const	// added by idw
  PGPInitErrorCode: TPGPInitErrorCode = ieNone;
  PGP7X: Longbool = false;
  PGPsdkLib: PChar = nil;
  PGPsdkNLLib: PChar = nil;
  PGPsdkUILib: PChar = nil;
  PGPclLib: PChar = nil;
  PGPscLib: PChar = nil;
  hPGPsdkLib: Longint = 0;
  hPGPsdkNLLib: Longint = 0;
  hPGPsdkUILib: Longint = 0;
  hPGPclLib: Longint = 0;
  hPGPscLib: Longint = 0;

type
  PGPBoolean	  = Byte;			// can be TRUE (1) or FALSE (0)
  PGPInt8	  = Char;
  PGPUInt8	  = Byte;
  PGPInt16	  = Smallint;
  PGPUInt16	  = Word;
  PGPInt32	  = Longint;
  PGPUInt32	  = Longint;			// changed from Cardinal to Longint by idw
  PGPByte	  = PGPUInt8;
  PGPError	  = PGPInt32;
  PGPEnumType	  = Longint;			// added by idw
  PGPUserValue	  = Pointer;
  PGPSize	  = PGPUInt32;
  PGPFlags	  = PGPUInt32;
  PGPFileOffset	  = PGPInt32;
  PGPTime	  = PGPUInt32;
  PGPTimeInterval = PGPUInt32;			// in milliseconds

  pPChar	  = ^PChar;			// for those weird char** variables

  TPGPVersion = Record
    MajorVersion: PGPUInt16;
    MinorVersion: PGPUInt16;
  end;

  TVersionString = Array[0..255] of Char;	// added by idw

const
  PGPFalse  = 0;
  PGPTrue   = 1;

const	// 7.X
  kPGPFlags_ForceLocalExecution	= $02;
  kPGPFlags_SuppressCacheThread	= $04;

var	// added by idw
  MyVersion: TVersionString;

var	// added by idw from pgpUtilities.h
  PGPsdkInit: function(Options: PGPFlags): PGPError; cdecl;		// Options is ignored prior to 7.X
  PGPsdkCleanup: function: PGPError; cdecl;

var
  // 6.5.X: PGPGetSDKVersion from pgpFeatures.h; 7.X: PGPGetPGPsdkVersion from pgpUtilities.h
  PGPGetSDKVersion: function(var Version: PGPUInt32): PGPUInt32; cdecl;	// 7.X returns version as result
  // 6.5.X: PGPGetSDKString from pgpFeatures.h; 7.X: PGPGetPGPsdkVersionString from pgpUtilities.h
  PGPGetSDKString: function(const TheString: TVersionString): PGPError; cdecl;

procedure ProcessMessages;	// added by idw
function PGP65X: Boolean;	// added by idw

implementation	// code added by idw

uses
  Windows,
  SysUtils;

procedure ProcessMessages;
var Msg: TMsg;
begin
  while PeekMessage(Msg, 0, 0, 0, PM_REMOVE) do begin
    TranslateMessage(Msg);
    DispatchMessage(Msg);
  end;
end;

function PGP65X: Boolean;
var Version: PGPUInt32;
begin // Version evaluation see pgpUtilities
  PGP7X:=(PGPGetSDKVersion(Version)>=$02000000);
  Result:=not PGP7X and (Version>=$03002000);
end;

function PGPInitError(ErrorCode: TPGPInitErrorCode): Longbool;
{$IFNDEF SILENT_FAILURE}
var ErrorMsg: PChar;
{$ENDIF}
begin
  PGPInitErrorCode:=ErrorCode;
  {$IFNDEF SILENT_FAILURE}
  ErrorMsg:=nil;
  case ErrorCode of
    ieSDK:	ErrorMsg:=SDKError;
    ieSDKNL:	ErrorMsg:=SDKNLError;
    ieSDKUI:	ErrorMsg:=SDKUIError;
    ieCL:	ErrorMsg:=CLError;
    ieSC:	ErrorMsg:=SCError;
    ieVersion:	ErrorMsg:=VersionError;
  end;
  MessageBox(0, ErrorMsg, ErrorTitle, MB_ICONERROR);
  Halt(ERROR_DLL_INIT_FAILED);
  {$ENDIF}
  Result:=true;
end;

initialization

  // Load Software Development Kit Core Library
  PGPsdkLib:='PGPSDK.dll';		// 5.X & 7.X
  hPGPsdkLib:=LoadLibrary(PGPsdkLib);
  if hPGPsdkLib=0 then begin
    PGPsdkLib:='PGP_SDK.dll';		// 6.X
    hPGPsdkLib:=LoadLibrary(PGPsdkLib);
  end;
  if (hPGPsdkLib=0) and PGPInitError(ieSDK) then Exit;

  // Load Software Development Kit Networking Library
  PGPsdkNLLib:='PGPsdkNL.dll';
  hPGPsdkNLLib:=LoadLibrary(PGPsdkNLLib);
  if (hPGPsdkNLLib=0) and PGPInitError(ieSDKNL) then Exit;

  // Load Software Development Kit User Interface Library
  PGPsdkUILib:='PGPsdkUI.dll';
  hPGPsdkUILib:=LoadLibrary(PGPsdkUILib);
  if (hPGPsdkUILib=0) and PGPInitError(ieSDKUI) then Exit;

  // Load Client Library
  PGPclLib:='PGPclientLib.dll';		// 7.X
  hPGPclLib:=LoadLibrary(PGPclLib);
  if hPGPclLib=0 then begin
    PGPclLib:='PGPcl.dll';		// 6.X
    hPGPclLib:=LoadLibrary(PGPclLib);
  end;
  if (hPGPclLib=0) and PGPInitError(ieCL) then Exit;

  // Load Cryptographic Support Library
  PGPscLib:='PGPsc.dll';
  hPGPscLib:=LoadLibrary(PGPscLib);
  if (hPGPscLib=0) and PGPInitError(ieSC) then Exit;

  // Check SDK Version
  PGPsdkInit:=GetProcAddress(hPGPsdkLib, 'PGPsdkInit');
  PGPsdkCleanup:=GetProcAddress(hPGPsdkLib, 'PGPsdkCleanup');
  PGPGetSDKVersion:=GetProcAddress(hPGPsdkLib, 'PGPGetSDKVersion');						// 5.X & 6.X
  if not Assigned(PGPGetSDKVersion) then PGPGetSDKVersion:=GetProcAddress(hPGPsdkLib, 'PGPGetPGPsdkVersion');	// 7.X
  PGPsdkInit(kPGPFlags_ForceLocalExecution);
  if not (PGP65X or PGP7X) and PGPInitError(ieVersion) then Exit;

  // Get SDK Version String
  if PGP7X then
    PGPGetSDKString:=GetProcAddress(hPGPsdkLib, 'PGPGetPGPsdkVersionString')
  else PGPGetSDKString:=GetProcAddress(hPGPsdkLib, 'PGPGetSDKString');
  if PGPGetSDKString(MyVersion)<>0 then MyVersion:='N/A';

finalization

  if Assigned(PGPsdkCleanup) then PGPsdkCleanup;

  if hPGPscLib<>0 then FreeLibrary(hPGPscLib);
  if hPGPclLib<>0 then FreeLibrary(hPGPclLib);
  if hPGPsdkUILib<>0 then FreeLibrary(hPGPsdkUILib);
  if hPGPsdkNLLib<>0 then FreeLibrary(hPGPsdkNLLib);
  if hPGPsdkLib<>0 then FreeLibrary(hPGPsdkLib);

end.

