{$J+,Z4}
unit pgpUI;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the "Borland Delphi Runtime Library PGPsdk" released 10 Apr }
{ 2000, available at http://www.oz.net/~srheller/dpgp/sdk/.                        }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpUserInterface.pas based on pgpUserInterface.h            }
{ from the PGP sources which are Copyright (C) Network Associates Inc.             }
{ and affiliated companies.                                                        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ Several declarations removed, all functions taking OptionLists modified          }
{ according to a suggestion by Steven R. Heller, for details see pgpOptionList.pas }
{                                                                                  }
{**********************************************************************************}

interface

uses
  pgpPubTypes, pgpBase;

type
  PGPAdditionalRecipientRequestEnforcement = PGPEnumType;
const
  kPGPARREnforcement_Invalid = 0;
  kPGPARREnforcement_None    = 1;
  kPGPARREnforcement_Warn    = 2;
  kPGPARREnforcement_Strict  = 3;

type
  PGPRecipientSpecType = PGPEnumType;
const
  kPGPRecipientSpecType_Invalid = 0;
  kPGPRecipientSpecType_Key     = 1;
  kPGPRecipientSpecType_UserID  = 2;
  kPGPRecipientSpecType_KeyID   = 3;

type	// PGP 7.X
  PGPRecipientSpecFlags = PGPFlags;
const	// PGP 7.X
  kPGPRecipientSpecFlags_Locked = 1;

type	// modified by idw
  pPGPRecipientSpec = ^PGPRecipientSpec;
  PGPRecipientSpec = Record			// initialize with FillChar(RecipientSpec, SizeOf(PGPRecipientSpec), 0)
    AType	: PGPRecipientSpecType;
    Locked	: PGPRecipientSpecFlags;	// PGP 7.X, compatible to 6.5.X
    Reserved32	: Array[0..2] of PGPUInt32;	// Must be zero in both PGP versions
    ID		: Record case Longint of	// PGP 7.X, not quite compatible to 6.5.X, but works
		    1 : (Key: pPGPKey);
		    2 : (UserIDStr: TUserID);
		    3 : (KeyID : TPGPKeyID7);
		  end;
  end;
  pPGPKeyServerSpec = ^PGPKeyServerSpec;
  PGPKeyServerSpec = Record			// PGP 6.5.X compatible, but too large for 7.X
    Server	: pPGPKeyServer;
    ServerName	: PChar;			// Optional in both versions
    ServerDomain: PChar;			// Optional in PGP 7.X only
    Reserved	: Array[0..3] of PGPUInt32;	// Must be zero in PGP 6.5.X
  end;

var	// added by idw from pgpUtilities.h
  PGPsdkUILibInit: function(Options: PGPFlags): PGPError; cdecl;	// Options is ignored prior to 7.X
  PGPsdkUILibCleanup: function: PGPError; cdecl;

var
  // PGP 6.5.X
  PGPRecipientDialog: function(Context: pPGPContext; AllKeys: pPGPKeySet; AlwaysDisplayDialog: PGPBoolean;
			       var RecipientKeys: pPGPKeySet; OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 7.X
  {PGPRecipientDialog: function(Context: pPGPContext; AllKeys: pPGPKeyDB; AlwaysDisplayDialog: PGPBoolean;
				var RecipientKeys: pPGPKeyDB; OptionList, LastOption: pPGPOptionList): PGPError; cdecl;}
  // both
  PGPPassphraseDialog: function(Context: pPGPContext; OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  // both
  PGPConfirmationPassphraseDialog: function(Context: pPGPContext; OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 6.5.X
  PGPKeyPassphraseDialog: function(Context: pPGPContext; TheKey: pPGPKey;
				   OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 7.X
  {PGPKeyPassphraseDialog: function(Context: pPGPContext; TheKey: pPGPKeyDBObj;
				    OptionList, LastOption: pPGPOptionList): PGPError; cdecl;}
  // PGP 6.5.X
  PGPSigningPassphraseDialog: function(Context: pPGPContext; AllKeys: pPGPKeySet; var SigningKey: pPGPKey;
				       OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 7.X
  {PGPSigningPassphraseDialog: function(Context: pPGPContext; AllKeys: pPGPKeyDB; var SigningKey: pPGPKeyDBObj;
					OptionList, LastOption: pPGPOptionList): PGPError; cdecl;}
  // PGP 6.5.X
  PGPDecryptionPassphraseDialog: function(Context: pPGPContext; RecipientKeys: pPGPKeySet; KeyIDCount: PGPUInt32;
					  const KeyIDList: pPGPKeyID7; var DecryptionKey: pPGPKey;
					  OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 7.X
  {PGPDecryptionPassphraseDialog: function(Context: pPGPContext; RecipientKeys: pPGPKeySet; KeyIDCount: PGPUInt32;
  					   const KeyIDList: pPGPKeyID; var DecryptionKey: pPGPKeyDBObj;
					   OptionList, LastOption: pPGPOptionList): PGPError; cdecl;}
  // both
  PGPConventionalEncryptionPassphraseDialog: function(Context: pPGPContext;
						      OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  // both
  PGPConventionalDecryptionPassphraseDialog: function(Context: pPGPContext;
  						      OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  // both
  PGPCollectRandomDataDialog: function(Context: pPGPContext; NeededEntropyBits: PGPUInt32;
				       OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  // both
  PGPEstimatePassphraseQuality: function(const Passphrase: PChar): PGPUInt32; cdecl;
  // PGP 6.5.X
  PGPSearchKeyServerDialog: function(Context: pPGPContext; ServerCount: PGPUInt32; const ServerList: pPGPKeyServerSpec;
				     tlsContext: pPGPtlsContext; SearchAllServers: PGPBoolean; var FoundKeys: pPGPKeySet;
				     OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  // PGP 7.X
  {PGPSearchKeyServerDialog: function(Context: pPGPContext; ServerCount: PGPUInt32; const ServerList: pPGPKeyServerSpec;
				      tlsContext: pPGPtlsContext; SearchAllServers: PGPBoolean; var FoundKeys: pPGPKeyDB;
				      OptionList, LastOption: pPGPOptionList): PGPError; cdecl;}
  // both
  PGPSendToKeyServerDialog: function(Context: pPGPContext; const Server: PGPKeyServerSpec;
				     tlsContext: pPGPtlsContext; KeysToSend: pPGPKeySet; var FailedKeys: pPGPKeySet;
				     OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  // options
  PGPOUIParentWindowHandle: function(Context: pPGPContext; ParentHandle: Longint): pPGPOptionList; cdecl;
  PGPOUIWindowTitle: function(Context: pPGPContext; Title: PChar): pPGPOptionList; cdecl;
  PGPOUIDialogPrompt: function(Context: pPGPContext; Prompt: PChar): pPGPOptionList; cdecl;
  PGPOUIDialogOptions: function(Context: pPGPContext; OptionList, LastOption: pPGPOptionList): pPGPOptionList; cdecl;
  PGPOUICheckbox: function(Context: pPGPContext; ItemID: PGPUInt32; const Title, Description: PChar;
			   InitialValue: PGPUInt32; var ResultValue: PGPUInt32;
			   LastOption: pPGPOptionList): pPGPOptionList; cdecl;
  PGPOUIOutputPassphrase: function(Context: pPGPContext; var Passphrase: PChar): pPGPOptionList; cdecl;
  PGPOUIMinimumPassphraseLength: function(Context: pPGPContext; MinimumPassphraseLength: PGPUInt32): pPGPOptionList; cdecl;
  PGPOUIMinimumPassphraseQuality: function(Context: pPGPContext; MinimumPassphraseQuality: PGPUInt32): pPGPOptionList; cdecl;
  PGPOUIShowPassphraseQuality: function(Context: pPGPContext; ShowPassphraseQuality: PGPBoolean): pPGPOptionList; cdecl;
  PGPOUIVerifyPassphrase: function(Context: pPGPContext; VerifyPassphrase: PGPBoolean): pPGPOptionList; cdecl;
  PGPOUIFindMatchingKey: function(Context: pPGPContext; FindMatchingKey: PGPBoolean): pPGPOptionList; cdecl;
  PGPOUIDefaultRecipients: function(Context: pPGPContext; NumRecipients: PGPUInt32;
				    const Recipients: pPGPRecipientSpec): pPGPOptionList; cdecl;
  PGPOUIDefaultKey: function(Context: pPGPContext; DefaultKey: pPGPKey): pPGPOptionList; cdecl;
  PGPOUIDisplayMarginalValidity: function(Context: pPGPContext; DisplayMarginalValidity: PGPBoolean): pPGPOptionList; cdecl;
  PGPOUIIgnoreMarginalValidity: function(Context: pPGPContext; IgnoreMarginalValidity: PGPBoolean): pPGPOptionList; cdecl;
  // both
  PGPOUIKeyServerSearchFilter: function(Context: pPGPContext; Filter: pPGPFilter): pPGPOptionList; cdecl;
  // PGP 6.5.X
  PGPOUIKeyServerSearchKey: function(Context: pPGPContext; Key: pPGPKey): pPGPOptionList; cdecl;
  // PGP 7.X
  {PGPOUIKeyServerSearchKey: function(Context: pPGPContext; Key: pPGPKeyDBObj): pPGPOptionList; cdecl;}
  // both
  PGPOUIKeyServerSearchKeySet: function(Context: pPGPContext; KeySet: pPGPKeySet): pPGPOptionList; cdecl;
  // both
  PGPOUIKeyServerSearchKeyIDList: function(Context: pPGPContext; KeyIDCount: PGPUInt32;
					   const KeyIDList: pPGPKeyID7): pPGPOptionList; cdecl;

implementation	// code modified by idw

uses
  Windows;

initialization

  PGPsdkUILibInit:=GetProcAddress(hPGPsdkUILib, 'PGPsdkUILibInit');
  PGPsdkUILibCleanup:=GetProcAddress(hPGPsdkUILib, 'PGPsdkUILibCleanup');
  PGPRecipientDialog:=GetProcAddress(hPGPsdkUILib, 'PGPRecipientDialog');
  PGPPassphraseDialog:=GetProcAddress(hPGPsdkUILib, 'PGPPassphraseDialog');
  PGPConfirmationPassphraseDialog:=GetProcAddress(hPGPsdkUILib, 'PGPConfirmationPassphraseDialog');
  PGPKeyPassphraseDialog:=GetProcAddress(hPGPsdkUILib, 'PGPKeyPassphraseDialog');
  PGPSigningPassphraseDialog:=GetProcAddress(hPGPsdkUILib, 'PGPSigningPassphraseDialog');
  PGPDecryptionPassphraseDialog:=GetProcAddress(hPGPsdkUILib, 'PGPDecryptionPassphraseDialog');
  PGPConventionalEncryptionPassphraseDialog:=GetProcAddress(hPGPsdkUILib, 'PGPConventionalEncryptionPassphraseDialog');
  PGPConventionalDecryptionPassphraseDialog:=GetProcAddress(hPGPsdkUILib, 'PGPConventionalDecryptionPassphraseDialog');
  PGPCollectRandomDataDialog:=GetProcAddress(hPGPsdkUILib, 'PGPCollectRandomDataDialog');
  PGPEstimatePassphraseQuality:=GetProcAddress(hPGPsdkUILib, 'PGPEstimatePassphraseQuality');
  PGPSearchKeyServerDialog:=GetProcAddress(hPGPsdkUILib, 'PGPSearchKeyServerDialog');
  PGPSendToKeyServerDialog:=GetProcAddress(hPGPsdkUILib, 'PGPSendToKeyServerDialog');
  PGPOUIParentWindowHandle:=GetProcAddress(hPGPsdkUILib, 'PGPOUIParentWindowHandle');
  PGPOUIWindowTitle:=GetProcAddress(hPGPsdkUILib, 'PGPOUIWindowTitle');
  PGPOUIDialogPrompt:=GetProcAddress(hPGPsdkUILib, 'PGPOUIDialogPrompt');
  PGPOUIDialogOptions:=GetProcAddress(hPGPsdkUILib, 'PGPOUIDialogOptions');
  PGPOUICheckbox:=GetProcAddress(hPGPsdkUILib, 'PGPOUICheckbox');
  PGPOUIOutputPassphrase:=GetProcAddress(hPGPsdkUILib, 'PGPOUIOutputPassphrase');
  PGPOUIMinimumPassphraseLength:=GetProcAddress(hPGPsdkUILib, 'PGPOUIMinimumPassphraseLength');
  PGPOUIMinimumPassphraseQuality:=GetProcAddress(hPGPsdkUILib, 'PGPOUIMinimumPassphraseQuality');
  PGPOUIShowPassphraseQuality:=GetProcAddress(hPGPsdkUILib, 'PGPOUIShowPassphraseQuality');
  PGPOUIVerifyPassphrase:=GetProcAddress(hPGPsdkUILib, 'PGPOUIVerifyPassphrase');
  PGPOUIFindMatchingKey:=GetProcAddress(hPGPsdkUILib, 'PGPOUIFindMatchingKey');
  PGPOUIDefaultRecipients:=GetProcAddress(hPGPsdkUILib, 'PGPOUIDefaultRecipients');
  PGPOUIDefaultKey:=GetProcAddress(hPGPsdkUILib, 'PGPOUIDefaultKey');
  PGPOUIDisplayMarginalValidity:=GetProcAddress(hPGPsdkUILib, 'PGPOUIDisplayMarginalValidity');
  PGPOUIIgnoreMarginalValidity:=GetProcAddress(hPGPsdkUILib, 'PGPOUIIgnoreMarginalValidity');
  PGPOUIKeyServerSearchFilter:=GetProcAddress(hPGPsdkUILib, 'PGPOUIKeyServerSearchFilter');
  PGPOUIKeyServerSearchKey:=GetProcAddress(hPGPsdkUILib, 'PGPOUIKeyServerSearchKey');
  PGPOUIKeyServerSearchKeySet:=GetProcAddress(hPGPsdkUILib, 'PGPOUIKeyServerSearchKeySet');
  PGPOUIKeyServerSearchKeyIDList:=GetProcAddress(hPGPsdkUILib, 'PGPOUIKeyServerSearchKeyIDList');

  PGPsdkUILibInit(kPGPFlags_ForceLocalExecution);

finalization

  if Assigned(PGPsdkUILibCleanup) then PGPsdkUILibCleanup;

end.

