{$J+,Z4}
unit pgpKeys;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the "Borland Delphi Runtime Library PGPsdk" released 10 Apr }
{ 2000, available at http://www.oz.net/~srheller/dpgp/sdk/.                        }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpKeys.pas based on pgpKeys.h from the PGP sources         }
{ which are Copyright (C) Network Associates Inc. and affiliated companies.        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ Lots of stuff removed (especially from PGP versions 5.5.X and 6.0.X);            }
{ all functions taking OptionLists modified according to a suggestion              }
{ by Steven R. Heller, for details see pgpOptionList.pas                           }
{                                                                                  }
{**********************************************************************************}

interface

uses
  pgpEvents,
  pgpPubTypes, pgpBase;

type
  { Key Ordering }
  PGPKeyOrdering = PGPEnumType;
const
  kPGPInvalidOrdering			= 00;
  kPGPAnyOrdering			= 01;
  kPGPUserIDOrdering			= 02;
  kPGPReverseUserIDOrdering		= 03;
  kPGPKeyIDOrdering			= 04;
  kPGPReverseKeyIDOrdering		= 05;
  kPGPValidityOrdering			= 06;
  kPGPReverseValidityOrdering		= 07;
  kPGPTrustOrdering			= 08;
  kPGPReverseTrustOrdering		= 09;
  kPGPEncryptKeySizeOrdering		= 10;
  kPGPReverseEncryptKeySizeOrdering	= 11;
  kPGPSigKeySizeOrdering		= 12;
  kPGPReverseSigKeySizeOrdering		= 13;
  kPGPCreationOrdering			= 14;
  kPGPReverseCreationOrdering		= 15;
  kPGPExpirationOrdering		= 16;
  kPGPReverseExpirationOrdering		= 17;

type
  { Key Properties }
  PGPKeyPropName = PGPEnumType;
const

  // String Properties
  kPGPKeyPropFingerprint		= 001;
  kPGPKeyPropPreferredAlgorithms	= 002;
  kPGPKeyPropThirdPartyRevocationKeyID	= 003;

  // Number Properties
  kPGPKeyPropAlgID			= 020;
  kPGPKeyPropBits			= 021;
  kPGPKeyPropTrust			= 022;
  kPGPKeyPropValidity			= 023;
  kPGPKeyPropLockingAlgID		= 024;
  kPGPKeyPropLockingBits		= 025;
  kPGPKeyPropFlags			= 026;

  // Time Properties
  kPGPKeyPropCreation			= 040;
  kPGPKeyPropExpiration			= 041;

  // PGPBoolean Properties
  kPGPKeyPropIsSecret			= 060;
  kPGPKeyPropIsAxiomatic		= 061;
  kPGPKeyPropIsRevoked			= 062;
  kPGPKeyPropIsDisabled			= 063;
  kPGPKeyPropIsNotCorrupt		= 064;
  kPGPKeyPropIsExpired			= 065;
  kPGPKeyPropNeedsPassphrase		= 066;
  kPGPKeyPropHasUnverifiedRevocation	= 067;
  kPGPKeyPropCanEncrypt			= 068;
  kPGPKeyPropCanDecrypt			= 069;
  kPGPKeyPropCanSign			= 070;
  kPGPKeyPropCanVerify			= 071;
  kPGPKeyPropIsEncryptionKey		= 072;
  kPGPKeyPropIsSigningKey		= 073;
  kPGPKeyPropIsSecretShared		= 074;
  kPGPKeyPropIsRevocable		= 075;
  kPGPKeyPropHasThirdPartyRevocation	= 076;

type
  { kPGPKeyPropFlags bits }
  PGPKeyPropFlags = PGPEnumType;
const
  kPGPKeyPropFlags_UsageSignUserIDs		= (1 shl 0);
  kPGPKeyPropFlags_UsageSignMessages		= (1 shl 1);
  kPGPKeyPropFlags_UsageEncryptCommunications	= (1 shl 2);
  kPGPKeyPropFlags_UsageEncryptStorage		= (1 shl 3);

  kPGPKeyPropFlags_PrivateSplit			= (1 shl 4);
  kPGPKeyPropFlags_PrivateShared		= (1 shl 7);

type
  { User ID Properties }
  PGPUserIDPropName = PGPEnumType;
const

  // String Properties
  kPGPUserIDPropName			= 080;
  kPGPUserIDPropAttributeData		= 081;

  // Number Properties
  kPGPUserIDPropValidity		= 100;
  kPGPUserIDPropConfidence		= 101;
  kPGPUserIDPropAttributeType		= 102;

  // PGPBoolean Properties
  kPGPUserIDPropIsAttribute		= 110;

type
  { Signature Properties }
  PGPSigPropName = PGPEnumType;
const

  // String Properties
  kPGPSigPropKeyID			= 120;
  kPGPSigPropX509Certificate		= 121;

  // Number Properties
  kPGPSigPropAlgID			= 140;
  kPGPSigPropTrustLevel			= 141;
  kPGPSigPropTrustValue			= 142;

  // Time Properties
  kPGPSigPropCreation			= 160;
  kPGPSigPropExpiration			= 161;

  // PGPBoolean Properties
  kPGPSigPropIsRevoked			= 180;
  kPGPSigPropIsNotCorrupt		= 181;
  kPGPSigPropIsTried			= 182;
  kPGPSigPropIsVerified			= 183;
  kPGPSigPropIsMySig			= 184;
  kPGPSigPropIsExportable		= 185;
  kPGPSigPropHasUnverifiedRevocation	= 186;
  kPGPSigPropIsExpired			= 187;
  kPGPSigPropIsX509			= 188;

type
  { PGPKeyRingOpenFlags }
  PGPKeyRingOpenFlags = PGPUInt32;
const
  kPGPKeyRingOpenFlags_Reserved		= (1 shl 0);
  kPGPKeyRingOpenFlags_Mutable		= (1 shl 1);
  kPGPKeyRingOpenFlags_Create		= (1 shl 2);

  // The following flags are only used by PGPOpenKeyRing
  kPGPKeyRingOpenFlags_Private		= (1 shl 8);
  kPGPKeyRingOpenFlags_Trusted		= (1 shl 9);

type
  { Used by Filtering functions to specify type of Match }
  PGPMatchCriterion = PGPEnumType;
const
  kPGPMatchDefault			= 1;
  kPGPMatchEqual			= 1; // val == supplied val
  kPGPMatchGreaterOrEqual		= 2; // val >= supplied val
  kPGPMatchLessOrEqual			= 3; // val <= supplied val
  kPGPMatchSubString			= 4; // val is in supplied val

const
  { This is the value of the Expiration time which means "never expires" }
  kPGPExpirationTime_Never		= 0;

const
  { Secret sharing header size }
  kPGPShareHeaderSize			= 4;

type
  PGPKeyIDStringType = PGPEnumType;
const
  kPGPKeyIDString_Abbreviated		= 2;
  kPGPKeyIDString_Full			= 3;

var
  { Key ring management }
  PGPOpenDefaultKeyRings: function(Context: pPGPContext;
		OpenFlags: PGPKeyRingOpenFlags;
		var KeySet: pPGPKeySet): PGPError; cdecl;
  PGPOpenKeyRingPair: function(Context: pPGPContext;
		OpenFlags: PGPKeyRingOpenFlags;
		PubFileSpec: pPGPFileSpec;
		SecFileSpec: pPGPFileSpec;
		var KeySet: pPGPKeySet): PGPError; cdecl;
  PGPOpenKeyRing: function(Context: pPGPContext;
		OpenFlags: PGPKeyRingOpenFlags;
		FileSpec: pPGPFileSpec;
		var KeySet: pPGPKeySet): PGPError; cdecl;
  PGPReloadKeyRings: function(KeySet: pPGPKeySet): PGPError; cdecl;
  PGPCheckKeyRingSigs: function(KeysToCheck: pPGPKeySet;
	KeysSigning: pPGPKeySet;
	CheckAll: PGPBoolean;
	EventHandler: TPGPEventhandlerProcPtr;
	EventHandlerData: PGPUserValue): PGPError; cdecl;
  PGPRevertKeyRingChanges: function(KeySet: pPGPKeySet): PGPError; cdecl;
  PGPCommitKeyRingChanges: function(KeySet: pPGPKeySet): PGPError; cdecl;
  { Keyset management }
  PGPNewKeySet: function(Context: pPGPContext;
		var KeySet: pPGPKeySet): PGPError; cdecl;
  PGPNewEmptyKeySet: function(OrigSet: pPGPKeySet;
		var NewSet: pPGPKeySet): PGPError; cdecl;
  PGPNewSingletonKeySet: function(Key: pPGPKey;
		var KeySet: pPGPKeySet): PGPError; cdecl;
  PGPUnionKeySets: function(Set1: pPGPKeySet;
		Set2: pPGPKeySet;
		var NewSet: pPGPKeySet): PGPError; cdecl;
  PGPFreeKeySet: function(KeySet: pPGPKeySet): PGPError; cdecl;
  PGPImportKeySet: function(Context: pPGPContext;
		var KeySet: pPGPKeyset;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  PGPExportKeySet: function(KeySet: pPGPKeySet;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  PGPAddKeys: function(KeysToAdd: pPGPKeySet;
		ASet: pPGPKeySet): PGPError; cdecl;
  PGPRemoveKeys: function(KeysToRemove: pPGPKeySet;
		ASet: pPGPKeySet): PGPError; cdecl;
  PGPPropagateTrust: function(KeySet: pPGPKeySet): PGPError; cdecl;
  PGPCountKeys: function(KeySet: pPGPKeySet;
		var NumKeys: PGPUInt32): PGPError; cdecl;
  PGPKeySetIsMember: function(Key: pPGPKey;
		KeySet: pPGPKeySet): PGPBoolean; cdecl;
  PGPKeySetIsMutable: function(KeySet: pPGPKeySet): PGPBoolean; cdecl;
  PGPKeySetNeedsCommit: function(KeySet: pPGPKeySet): PGPBoolean; cdecl;
  { Key filter functions }
  PGPNewKeyBooleanFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyCreationTimeFilter: function(Context: pPGPContext;
		CreationTime: PGPTime;
		Match: PGPMatchCriterion;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyExpirationTimeFilter: function(Context: pPGPContext;
		ExpirationTime: PGPTime;
		Match: PGPMatchCriterion;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyDisabledFilter: function(Context: pPGPContext;
		Disabled: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyNumberFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Value: PGPUInt32;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyTimeFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Value: PGPTime;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyPropertyBufferFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		var Buffer: Pointer;
		Length: PGPSize;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyRevokedFilter: function(Context: pPGPContext;
		Revoked: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyEncryptAlgorithmFilter: function(Context: pPGPContext;
		EncryptAlgorithm: PGPPublicKeyAlgorithm;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyEncryptKeySizeFilter: function(Context: pPGPContext;
		KeySize: PGPUInt32;
		Match: PGPMatchCriterion;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyFingerPrintFilter: function(Context: pPGPContext;
		FingerPrint: Pointer;
		FingerPrintLength: PGPSize;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeyIDFilter: function(Context: pPGPContext;
		var PGPKeyID: TPGPKeyID;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSubKeyBooleanFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSubKeyIDFilter: function(Context: pPGPContext;
		var SubPGPKeyID: TPGPKeyID;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSubKeyNumberFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Value: PGPUInt32;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSubKeyTimeFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Value: PGPTime;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSubKeyPropertyBufferFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		var Buffer: Pointer;
		Length: PGPSize;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeySigAlgorithmFilter: function(Context: pPGPContext;
		SigAlgorithm: PGPPublicKeyAlgorithm;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewKeySigKeySizeFilter: function(Context: pPGPContext;
		KeySize: PGPUInt32;
		Match: PGPMatchCriterion;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSigBooleanFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSigKeyIDFilter: function(Context: pPGPContext;
		var PGPKeyID: TPGPKeyID;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSigNumberFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Value: PGPUInt32;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSigTimeFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Value: PGPTime;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewSigPropertyBufferFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		var Buffer: Pointer;
		Length: PGPSize;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewUserIDBooleanFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewUserIDNameFilter: function(Context: pPGPContext;
		NameString: PChar;
		Match: PGPMatchCriterion;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewUserIDNumberFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		Value: PGPUInt32;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewUserIDStringBufferFilter: function(Context: pPGPContext;
		Prop: PGPKeyPropName;
		var Buffer: Pointer;
		Length: PGPSize;
		Match: PGPBoolean;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewUserIDStringFilter: function(Context: pPGPContext;
		UserIDString: PChar;
		Match: PGPMatchCriterion;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPNewUserIDEmailFilter: function(Context: pPGPContext;
		EmailString: PChar;
		Match: PGPMatchCriterion;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  // freeing OutFilter will call PGPFreeFilter on all Filters
  PGPNegateFilter: function(Filter: pPGPFilter;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPIntersectFilters: function(Filter1: pPGPFilter;
		Filter2: pPGPFilter;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPUnionFilters: function(Filter1: pPGPFilter;
		Filter2: pPGPFilter;
		var OutFilter: pPGPFilter): PGPError; cdecl;
  PGPFreeFilter: function(Filter: pPGPFilter): PGPError; cdecl;
  PGPFilterKeySet: function(OrigSet: pPGPKeySet;
		Filter: pPGPFilter;
		var ResultSet: pPGPKeySet): PGPError; cdecl;
  { Key iteration functions }
  PGPOrderKeySet: function(KeySet: pPGPKeySet;
		Order: PGPKeyOrdering;
		var KeyList: pPGPKeyList): PGPError; cdecl;
  PGPFreeKeyList: function(KeyList: pPGPKeyList): PGPError; cdecl;
  PGPNewKeyIter: function(KeyList: pPGPKeyList;
		var OutRef: pPGPKeyIter): PGPError; cdecl;
  PGPCopyKeyIter: function(OrigIter: pPGPKeyIter;
		var CopyIter: pPGPKeyIter): PGPError; cdecl;
  PGPFreeKeyIter: function(Iter: pPGPKeyIter): PGPError; cdecl;
  PGPKeyIterIndex: function(Iter: pPGPKeyIter): PGPInt32; cdecl;
  PGPKeyIterKey: function(Iter: pPGPKeyIter;
		var OutRef: pPGPKey): PGPError; cdecl;
  PGPKeyIterSubKey: function(Iter: pPGPKeyIter;
		var OutRef: pPGPSubKey): PGPError; cdecl;
  PGPKeyIterUserID: function(Iter: pPGPKeyIter;
		var OutRef: pPGPUserID): PGPError; cdecl;
  PGPKeyIterSig: function(Iter: pPGPKeyIter;
		var OutRef: pPGPSig): PGPError; cdecl;
  PGPKeyIterMove: function(Iter: pPGPKeyIter;
		RelOffset: PGPInt32;
		var OutRef: pPGPKey): PGPError; cdecl;
  PGPKeyIterSeek: function(Iter: pPGPKeyIter;
		Key: pPGPKey): PGPInt32; cdecl;
  PGPKeyIterNext: function(Iter: pPGPKeyIter;
		var OutRef: pPGPKey): PGPError; cdecl;
  PGPKeyIterNextSubKey: function(Iter: pPGPKeyIter;
		var OutRef: pPGPSubKey): PGPError; cdecl;
  PGPKeyIterNextUserID: function(Iter: pPGPKeyIter;
		var OutRef: pPGPUserID): PGPError; cdecl;
  PGPKeyIterNextUIDSig: function(Iter: pPGPKeyIter;
		var OutRef: pPGPSig): PGPError; cdecl;
  PGPKeyIterPrev: function(Iter: pPGPKeyIter;
		var OutRef: pPGPKey): PGPError; cdecl;
  PGPKeyIterPrevSubKey: function(Iter: pPGPKeyIter;
		var OutRef: pPGPSubKey): PGPError; cdecl;
  PGPKeyIterPrevUserID: function(Iter: pPGPKeyIter;
		var OutRef: pPGPUserID): PGPError; cdecl;
  PGPKeyIterPrevUIDSig: function(Iter: pPGPKeyIter;
		var OutRef: pPGPSig): PGPError; cdecl;
  PGPKeyIterRewind: function(Iter: pPGPKeyIter): PGPError; cdecl;
  PGPKeyIterRewindSubKey: function(Iter: pPGPKeyIter): PGPError; cdecl;
  PGPKeyIterRewindUserID: function(Iter: pPGPKeyIter): PGPError; cdecl;
  PGPKeyIterRewindUIDSig: function(Iter: pPGPKeyIter): PGPError; cdecl;
  { Key reference count functions }
  PGPIncKeySetRefCount: function(KeySet: pPGPKeySet): PGPError; cdecl;
  PGPIncFilterRefCount: function(Filter: pPGPFilter): PGPError; cdecl;
  PGPIncKeyListRefCount: function(KeyList: pPGPKeyList): PGPError; cdecl;
  { Key manipulation functions }
  PGPGenerateKey: function(Context: pPGPContext;
		var Key: pPGPKey;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  PGPChangePassphrase: function(Key: pPGPKey;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError; cdecl;
  PGPEnableKey: function(Key: pPGPKey): PGPError; cdecl;
  PGPDisableKey: function(Key: pPGPKey): PGPError; cdecl;
  PGPRevokeKey: function(Key: pPGPKey;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  PGPSetKeyAxiomatic: function(Key: pPGPKey;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  PGPUnsetKeyAxiomatic: function(Key: pPGPKey): PGPError; cdecl;
  PGPCompareKeys: function(A: pPGPKey;
		B: pPGPKey;
		Order: PGPKeyOrdering): PGPInt32; cdecl;
  PGPGenerateSubKey: function(Context: pPGPContext;
		var SubKey: pPGPSubKey;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  PGPRemoveSubKey: function(SubKey: pPGPSubKey): PGPError; cdecl;
  PGPChangeSubKeyPassphrase: function(SubKey: pPGPSubKey;
		OldPhrase: PChar;
		NewPhrase: PChar): PGPError; cdecl;
  PGPRevokeSubKey: function(SubKey: pPGPSubKey;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  PGPAddUserID: function(Key: pPGPKey;
		const UserID: PChar;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  PGPRemoveUserID: function(UserID: pPGPUserID): PGPError; cdecl;
  PGPSetPrimaryUserID: function(UserID: pPGPUserID): PGPError; cdecl;
  PGPCompareUserIDStrings: function(A: PChar;
		B: PChar): PGPInt32; cdecl;
  PGPSignUserID: function(UserID: pPGPUserID;
		CertifyingKey: pPGPKey;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  PGPRemoveSig: function(Cert: pPGPSig): PGPError; cdecl;
  PGPRevokeSig: function(Cert: pPGPSig;
		AllKeys: pPGPKeySet;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  PGPCountAdditionalRecipientRequests: function(BaseKey: pPGPKey;
		var NumARKeys: PGPUInt32): PGPError; cdecl;
  PGPGetIndexedAdditionalRecipientRequestKey: function(BaseKey: pPGPKey;
		AllKeys: pPGPKeySet;
		ARKeyIndex: PGPUInt32;
		var ARKey: pPGPKey;
		var ARKeyID: TPGPKeyID;
		var ARClass: PGPByte): PGPError; cdecl;
  PGPGetSigCertifierKey: function(Cert: pPGPSig;
		AllKeys: pPGPKeySet;
		var CertKey: pPGPKey): PGPError; cdecl;
  PGPCountRevocationKeys: function(BaseKey: pPGPKey;
		var NumRevKeys: PGPUInt32): PGPError; cdecl;
  PGPGetIndexedRevocationKey: function(BaseKey: pPGPKey;
		AllKeys: pPGPKeySet;
		RevKeyIndex: PGPUInt32;
		var RevKey: pPGPKey;
		var RevKeyID: TPGPKeyID): PGPError; cdecl;
  PGPPassphraseIsValid: function(Key: pPGPKey;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPBoolean; cdecl;
  { Get property functions }
  PGPGetHashAlgUsed: function(Key: pPGPKey;
		var HashAlg: PGPHashAlgorithm): PGPError; cdecl;
  PGPGetKeyBoolean: function(Key: pPGPKey;
		PropName: PGPKeyPropName;
		var Prop: PGPBoolean): PGPError; cdecl;
  PGPGetKeyNumber: function(Key: pPGPKey;
		PropName: PGPKeyPropName;
		var Prop: PGPInt32): PGPError; cdecl;
  PGPGetKeyPasskeyBuffer: function(Key: pPGPKey;
		 pPasskeyBuffer: Pointer;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError; cdecl;
  PGPGetKeyPropertyBuffer: function(Key: pPGPKey;
		PropName: PGPKeyPropName;
		BufferSize: PGPSize;
		pProp: Pointer;
		var FullSize: PGPSize): PGPError; cdecl;
  PGPGetKeyTime: function(Key: pPGPKey;
		PropName: PGPKeyPropName;
		var Prop: PGPTime): PGPError; cdecl;
  PGPGetSubKeyBoolean: function(SubKey: pPGPSubKey;
		PropName: PGPKeyPropName;
		var Prop: PGPBoolean): PGPError; cdecl;
  PGPGetSubKeyNumber: function(SubKey: pPGPSubKey;
		PropName: PGPKeyPropName;
		var Prop: PGPInt32): PGPError; cdecl;
  PGPGetSubKeyPasskeyBuffer: function(SubKey: pPGPSubKey;
		 pPasskeyBuffer: Pointer;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError; cdecl;
  PGPGetSubKeyPropertyBuffer: function(SubKey: pPGPSubKey;
		PropName: PGPKeyPropName;
		BufferSize: PGPSize;
		pProp: Pointer;
		var FullSize: PGPSize): PGPError; cdecl;
  PGPGetSubKeyTime: function(SubKey: pPGPSubKey;
		PropName: PGPKeyPropName;
		var Prop: PGPTime): PGPError; cdecl;
  PGPGetUserIDBoolean: function(UserID: pPGPUserID;
		PropName: PGPUserIDPropName;
		var Prop: PGPBoolean): PGPError; cdecl;
  PGPGetUserIDNumber: function(UserID: pPGPUserID;
		PropName: PGPUserIDPropName;
		var Prop: PGPInt32): PGPError; cdecl;
  PGPGetUserIDStringBuffer: function(UserID: pPGPUserID;
		PropName: PGPUserIDPropName;
		BufferSize: PGPSize;
		pData: Pointer;
		var FullSize: PGPSize): PGPError; cdecl;
  PGPGetSigBoolean: function(Cert: pPGPSig;
		PropName: PGPSigPropName;
		var Prop: PGPBoolean): PGPError; cdecl;
  PGPGetSigNumber: function(Cert: pPGPSig;
		PropName: PGPSigPropName;
		var Prop: PGPInt32): PGPError; cdecl;
  PGPGetSigPropertyBuffer: function(Cert: pPGPSig;
		PropName: PGPSigPropName;
		BufferSize: PGPSize;
		pData: Pointer;
		var FullSize: PGPSize): PGPError; cdecl;
  PGPGetSigTime: function(Cert: pPGPSig;
		PropName: PGPSigPropName;
		var Prop: PGPTime): PGPError; cdecl;
  PGPGetKeyEntropyNeeded: function(Context: pPGPContext;
		Options: pPGPOptionList;
		LastOption: pPGPOptionList): PGPError; cdecl;
  { Convenience property functions }
  PGPGetPrimaryUserID: function(Key: pPGPKey;
		var UserID: pPGPUserID): PGPError; cdecl;
  PGPGetPrimaryUserIDNameBuffer: function(Key: pPGPKey;
		BufferSize: PGPSize;
		pUserID: Pointer;
		var FullSize: PGPSize): PGPError; cdecl;
  PGPGetPrimaryUserIDValidity: function(Key: pPGPKey;
		var Validity: PGPValidity): PGPError; cdecl;
  { Default private key functions }
  PGPSetDefaultPrivateKey: function(Key: pPGPKey): PGPError; cdecl;
  PGPGetDefaultPrivateKey: function(Keyset: pPGPKeySet;
		var Key: pPGPKey): PGPError; cdecl;
  { User value functions }
  PGPSetKeyUserVal: function(Key: pPGPKey;
		UserValue: PGPUserValue): PGPError; cdecl;
  PGPSetSubKeyUserVal: function(SubKey: pPGPSubKey;
		UserValue: PGPUserValue): PGPError; cdecl;
  PGPSetSigUserVal: function(Cert: pPGPSig;
		UserValue: PGPUserValue): PGPError; cdecl;
  PGPSetUserIDUserVal: function(UserID: pPGPUserID;
		UserValue: PGPUserValue): PGPError; cdecl;
  PGPGetKeyUserVal: function(Key: pPGPKey;
		var UserValue: PGPUserValue): PGPError; cdecl;
  PGPGetSubKeyUserVal: function(SubKey: pPGPSubKey;
		var UserValue: PGPUserValue): PGPError; cdecl;
  PGPGetSigUserVal: function(Cert: pPGPSig;
		var UserValue: PGPUserValue): PGPError; cdecl;
  PGPGetUserIDUserVal: function(UserID: pPGPUserID;
		var UserValue: PGPUserValue): PGPError; cdecl;
  { Key ID functions }
  // must be in format output by PGPExportKeyID
  PGPImportKeyID: function(const KeyID: PChar;
		var PGPKeyID: TPGPKeyID): PGPError; cdecl;
  // outputs opaque string of bytes for storage of maximum size as KeyID
  PGPExportKeyID: function(const KeyID: PChar;
		var PGPKeyID: TPGPKeyID;
		var IDLength: PGPSize): PGPError; cdecl;
  PGPGetKeyIDString: function(var PGPKeyID: TPGPKeyID;
		AType: PGPKeyIDStringType;
		KeyID: TKeyID): PGPError; cdecl;
  PGPGetKeyIDFromString: function(KeyID: PChar;
		var PGPkeyID: TPGPKeyID): PGPError; cdecl;
  PGPGetKeyByKeyID: function(Keys: pPGPKeySet;
		const PGPKeyID: TPGPKeyID;
		PubKeyAlgorithm: PGPPublicKeyAlgorithm;
		var Key: pPGPKey): PGPError; cdecl;
  PGPGetKeyIDFromKey: function(Key: pPGPKey;
		var PGPKeyID: TPGPKeyID): PGPError; cdecl;
  PGPGetKeyIDFromSubKey: function(Key: pPGPSubKey;
		var PGPKeyID: TPGPKeyID): PGPError; cdecl;
  PGPGetKeyIDOfCertifier: function(Sig: pPGPSig;
		var PGPKeyID: TPGPKeyID): PGPError; cdecl;
  // returns 0 if equal, -1 if Key1 < Key2, 1 if Key1 > Key2
  PGPCompareKeyIDs: function(var Key: TPGPKeyID;
		var Key2: TPGPKeyID): PGPInt32; cdecl;
  { Context retrieval functions }
  PGPGetKeySetContext: function(KeySet: pPGPKeySet): pPGPContext; cdecl;
  PGPGetKeyListContext: function(KeyList: pPGPKeyList): pPGPContext; cdecl;
  PGPGetKeyIterContext: function(KeyIter: pPGPKeyIter): pPGPContext; cdecl;
  PGPGetKeyContext: function(Key: pPGPKey): pPGPContext; cdecl;
  PGPGetSubKeyContext: function(SubKey: pPGPSubKey): pPGPContext; cdecl;
  PGPGetUserIDContext: function(UserID: pPGPUserID): pPGPContext; cdecl;
  { Self signature options }
  PGPAddKeyOptions: function(Key: pPGPKey;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError; cdecl;
  PGPRemoveKeyOptions: function(Key: pPGPKey;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError; cdecl;
  PGPUpdateKeyOptions: function(Key: pPGPKey;
		 Options: pPGPOptionList;
		 LastOption: pPGPOptionList): PGPError; cdecl;

implementation	// code modified by idw

uses
  Windows;

initialization

  PGPOpenDefaultKeyRings:=GetProcAddress(hPGPsdkLib, 'PGPOpenDefaultKeyRings');
  PGPOpenKeyRingPair:=GetProcAddress(hPGPsdkLib, 'PGPOpenKeyRingPair');
  PGPOpenKeyRing:=GetProcAddress(hPGPsdkLib, 'PGPOpenKeyRing');
  PGPReloadKeyRings:=GetProcAddress(hPGPsdkLib, 'PGPReloadKeyRings');
  PGPCheckKeyRingSigs:=GetProcAddress(hPGPsdkLib, 'PGPCheckKeyRingSigs');
  PGPRevertKeyRingChanges:=GetProcAddress(hPGPsdkLib, 'PGPRevertKeyRingChanges');
  PGPCommitKeyRingChanges:=GetProcAddress(hPGPsdkLib, 'PGPCommitKeyRingChanges');
  PGPNewKeySet:=GetProcAddress(hPGPsdkLib, 'PGPNewKeySet');
  PGPNewEmptyKeySet:=GetProcAddress(hPGPsdkLib, 'PGPNewEmptyKeySet');
  PGPNewSingletonKeySet:=GetProcAddress(hPGPsdkLib, 'PGPNewSingletonKeySet');
  PGPUnionKeySets:=GetProcAddress(hPGPsdkLib, 'PGPUnionKeySets');
  PGPFreeKeySet:=GetProcAddress(hPGPsdkLib, 'PGPFreeKeySet');
  PGPImportKeySet:=GetProcAddress(hPGPsdkLib, 'PGPImportKeySet');
  PGPExportKeySet:=GetProcAddress(hPGPsdkLib, 'PGPExportKeySet');
  PGPAddKeys:=GetProcAddress(hPGPsdkLib, 'PGPAddKeys');
  PGPRemoveKeys:=GetProcAddress(hPGPsdkLib, 'PGPRemoveKeys');
  PGPPropagateTrust:=GetProcAddress(hPGPsdkLib, 'PGPPropagateTrust');
  PGPCountKeys:=GetProcAddress(hPGPsdkLib, 'PGPCountKeys');
  PGPKeySetIsMember:=GetProcAddress(hPGPsdkLib, 'PGPKeySetIsMember');
  PGPKeySetIsMutable:=GetProcAddress(hPGPsdkLib, 'PGPKeySetIsMutable');
  PGPKeySetNeedsCommit:=GetProcAddress(hPGPsdkLib, 'PGPKeySetNeedsCommit');
  PGPNewKeyBooleanFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyBooleanFilter');
  PGPNewKeyCreationTimeFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyCreationTimeFilter');
  PGPNewKeyExpirationTimeFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyExpirationTimeFilter');
  PGPNewKeyDisabledFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyDisabledFilter');
  PGPNewKeyNumberFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyNumberFilter');
  PGPNewKeyTimeFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyTimeFilter');
  PGPNewKeyPropertyBufferFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyPropertyBufferFilter');
  PGPNewKeyRevokedFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyRevokedFilter');
  PGPNewKeyEncryptAlgorithmFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyEncryptAlgorithmFilter');
  PGPNewKeyEncryptKeySizeFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyEncryptKeySizeFilter');
  PGPNewKeyFingerPrintFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyFingerPrintFilter');
  PGPNewKeyIDFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyIDFilter');
  PGPNewSubKeyBooleanFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSubKeyBooleanFilter');
  PGPNewSubKeyIDFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSubKeyIDFilter');
  PGPNewSubKeyNumberFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSubKeyNumberFilter');
  PGPNewSubKeyTimeFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSubKeyTimeFilter');
  PGPNewSubKeyPropertyBufferFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSubKeyPropertyBufferFilter');
  PGPNewKeySigAlgorithmFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeySigAlgorithmFilter');
  PGPNewKeySigKeySizeFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeySigKeySizeFilter');
  PGPNewSigBooleanFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSigBooleanFilter');
  PGPNewSigKeyIDFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSigKeyIDFilter');
  PGPNewSigNumberFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSigNumberFilter');
  PGPNewSigTimeFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSigTimeFilter');
  PGPNewSigPropertyBufferFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewSigPropertyBufferFilter');
  PGPNewUserIDBooleanFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewUserIDBooleanFilter');
  PGPNewUserIDNameFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewUserIDNameFilter');
  PGPNewUserIDNumberFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewUserIDNumberFilter');
  PGPNewUserIDStringBufferFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewUserIDStringBufferFilter');
  PGPNewUserIDStringFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewUserIDStringFilter');
  PGPNewUserIDEmailFilter:=GetProcAddress(hPGPsdkLib, 'PGPNewUserIDEmailFilter');
  PGPNegateFilter:=GetProcAddress(hPGPsdkLib, 'PGPNegateFilter');
  PGPIntersectFilters:=GetProcAddress(hPGPsdkLib, 'PGPIntersectFilters');
  PGPUnionFilters:=GetProcAddress(hPGPsdkLib, 'PGPUnionFilters');
  PGPFreeFilter:=GetProcAddress(hPGPsdkLib, 'PGPFreeFilter');
  PGPFilterKeySet:=GetProcAddress(hPGPsdkLib, 'PGPFilterKeySet');
  PGPOrderKeySet:=GetProcAddress(hPGPsdkLib, 'PGPOrderKeySet');
  PGPFreeKeyList:=GetProcAddress(hPGPsdkLib, 'PGPFreeKeyList');
  PGPNewKeyIter:=GetProcAddress(hPGPsdkLib, 'PGPNewKeyIter');
  PGPCopyKeyIter:=GetProcAddress(hPGPsdkLib, 'PGPCopyKeyIter');
  PGPFreeKeyIter:=GetProcAddress(hPGPsdkLib, 'PGPFreeKeyIter');
  PGPKeyIterIndex:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterIndex');
  PGPKeyIterKey:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterKey');
  PGPKeyIterSubKey:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterSubKey');
  PGPKeyIterUserID:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterUserID');
  PGPKeyIterSig:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterSig');
  PGPKeyIterMove:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterMove');
  PGPKeyIterSeek:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterSeek');
  PGPKeyIterNext:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterNext');
  PGPKeyIterNextSubKey:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterNextSubKey');
  PGPKeyIterNextUserID:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterNextUserID');
  PGPKeyIterNextUIDSig:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterNextUIDSig');
  PGPKeyIterPrev:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterPrev');
  PGPKeyIterPrevSubKey:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterPrevSubKey');
  PGPKeyIterPrevUserID:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterPrevUserID');
  PGPKeyIterPrevUIDSig:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterPrevUIDSig');
  PGPKeyIterRewind:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterRewind');
  PGPKeyIterRewindSubKey:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterRewindSubKey');
  PGPKeyIterRewindUserID:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterRewindUserID');
  PGPKeyIterRewindUIDSig:=GetProcAddress(hPGPsdkLib, 'PGPKeyIterRewindUIDSig');
  PGPIncKeySetRefCount:=GetProcAddress(hPGPsdkLib, 'PGPIncKeySetRefCount');
  PGPIncFilterRefCount:=GetProcAddress(hPGPsdkLib, 'PGPIncFilterRefCount');
  PGPIncKeyListRefCount:=GetProcAddress(hPGPsdkLib, 'PGPIncKeyListRefCount');
  PGPGenerateKey:=GetProcAddress(hPGPsdkLib, 'PGPGenerateKey');
  PGPChangePassphrase:=GetProcAddress(hPGPsdkLib, 'PGPChangePassphrase');
  PGPEnableKey:=GetProcAddress(hPGPsdkLib, 'PGPEnableKey');
  PGPDisableKey:=GetProcAddress(hPGPsdkLib, 'PGPDisableKey');
  PGPRevokeKey:=GetProcAddress(hPGPsdkLib, 'PGPRevokeKey');
  PGPSetKeyAxiomatic:=GetProcAddress(hPGPsdkLib, 'PGPSetKeyAxiomatic');
  PGPUnsetKeyAxiomatic:=GetProcAddress(hPGPsdkLib, 'PGPUnsetKeyAxiomatic');
  PGPCompareKeys:=GetProcAddress(hPGPsdkLib, 'PGPCompareKeys');
  PGPGenerateSubKey:=GetProcAddress(hPGPsdkLib, 'PGPGenerateSubKey');
  PGPRemoveSubKey:=GetProcAddress(hPGPsdkLib, 'PGPRemoveSubKey');
  PGPChangeSubKeyPassphrase:=GetProcAddress(hPGPsdkLib, 'PGPChangeSubKeyPassphrase');
  PGPRevokeSubKey:=GetProcAddress(hPGPsdkLib, 'PGPRevokeSubKey');
  PGPAddUserID:=GetProcAddress(hPGPsdkLib, 'PGPAddUserID');
  PGPRemoveUserID:=GetProcAddress(hPGPsdkLib, 'PGPRemoveUserID');
  PGPSetPrimaryUserID:=GetProcAddress(hPGPsdkLib, 'PGPSetPrimaryUserID');
  PGPCompareUserIDStrings:=GetProcAddress(hPGPsdkLib, 'PGPCompareUserIDStrings');
  PGPSignUserID:=GetProcAddress(hPGPsdkLib, 'PGPSignUserID');
  PGPRemoveSig:=GetProcAddress(hPGPsdkLib, 'PGPRemoveSig');
  PGPRevokeSig:=GetProcAddress(hPGPsdkLib, 'PGPRevokeSig');
  PGPCountAdditionalRecipientRequests:=GetProcAddress(hPGPsdkLib, 'PGPCountAdditionalRecipientRequests');
  PGPGetIndexedAdditionalRecipientRequestKey:=GetProcAddress(hPGPsdkLib, 'PGPGetIndexedAdditionalRecipientRequestKey');
  PGPGetSigCertifierKey:=GetProcAddress(hPGPsdkLib, 'PGPGetSigCertifierKey');
  PGPCountRevocationKeys:=GetProcAddress(hPGPsdkLib, 'PGPCountRevocationKeys');
  PGPGetIndexedRevocationKey:=GetProcAddress(hPGPsdkLib, 'PGPGetIndexedRevocationKey');
  PGPPassphraseIsValid:=GetProcAddress(hPGPsdkLib, 'PGPPassphraseIsValid');
  PGPGetHashAlgUsed:=GetProcAddress(hPGPsdkLib, 'PGPGetHashAlgUsed');
  PGPGetKeyBoolean:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyBoolean');
  PGPGetKeyNumber:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyNumber');
  PGPGetKeyPasskeyBuffer:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyPasskeyBuffer');
  PGPGetKeyPropertyBuffer:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyPropertyBuffer');
  PGPGetKeyTime:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyTime');
  PGPGetSubKeyBoolean:=GetProcAddress(hPGPsdkLib, 'PGPGetSubKeyBoolean');
  PGPGetSubKeyNumber:=GetProcAddress(hPGPsdkLib, 'PGPGetSubKeyNumber');
  PGPGetSubKeyPasskeyBuffer:=GetProcAddress(hPGPsdkLib, 'PGPGetSubKeyPasskeyBuffer');
  PGPGetSubKeyPropertyBuffer:=GetProcAddress(hPGPsdkLib, 'PGPGetSubKeyPropertyBuffer');
  PGPGetSubKeyTime:=GetProcAddress(hPGPsdkLib, 'PGPGetSubKeyTime');
  PGPGetUserIDBoolean:=GetProcAddress(hPGPsdkLib, 'PGPGetUserIDBoolean');
  PGPGetUserIDNumber:=GetProcAddress(hPGPsdkLib, 'PGPGetUserIDNumber');
  PGPGetUserIDStringBuffer:=GetProcAddress(hPGPsdkLib, 'PGPGetUserIDStringBuffer');
  PGPGetSigBoolean:=GetProcAddress(hPGPsdkLib, 'PGPGetSigBoolean');
  PGPGetSigNumber:=GetProcAddress(hPGPsdkLib, 'PGPGetSigNumber');
  PGPGetSigPropertyBuffer:=GetProcAddress(hPGPsdkLib, 'PGPGetSigPropertyBuffer');
  PGPGetSigTime:=GetProcAddress(hPGPsdkLib, 'PGPGetSigTime');
  PGPGetKeyEntropyNeeded:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyEntropyNeeded');
  PGPGetPrimaryUserID:=GetProcAddress(hPGPsdkLib, 'PGPGetPrimaryUserID');
  PGPGetPrimaryUserIDNameBuffer:=GetProcAddress(hPGPsdkLib, 'PGPGetPrimaryUserIDNameBuffer');
  PGPGetPrimaryUserIDValidity:=GetProcAddress(hPGPsdkLib, 'PGPGetPrimaryUserIDValidity');
  PGPSetDefaultPrivateKey:=GetProcAddress(hPGPsdkLib, 'PGPSetDefaultPrivateKey');
  PGPGetDefaultPrivateKey:=GetProcAddress(hPGPsdkLib, 'PGPGetDefaultPrivateKey');
  PGPSetKeyUserVal:=GetProcAddress(hPGPsdkLib, 'PGPSetKeyUserVal');
  PGPSetSubKeyUserVal:=GetProcAddress(hPGPsdkLib, 'PGPSetSubKeyUserVal');
  PGPSetSigUserVal:=GetProcAddress(hPGPsdkLib, 'PGPSetSigUserVal');
  PGPSetUserIDUserVal:=GetProcAddress(hPGPsdkLib, 'PGPSetUserIDUserVal');
  PGPGetKeyUserVal:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyUserVal');
  PGPGetSubKeyUserVal:=GetProcAddress(hPGPsdkLib, 'PGPGetSubKeyUserVal');
  PGPGetSigUserVal:=GetProcAddress(hPGPsdkLib, 'PGPGetSigUserVal');
  PGPGetUserIDUserVal:=GetProcAddress(hPGPsdkLib, 'PGPGetUserIDUserVal');
  PGPImportKeyID:=GetProcAddress(hPGPsdkLib, 'PGPImportKeyID');
  PGPExportKeyID:=GetProcAddress(hPGPsdkLib, 'PGPExportKeyID');
  PGPGetKeyIDString:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyIDString');
  PGPGetKeyIDFromString:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyIDFromString');
  PGPGetKeyByKeyID:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyByKeyID');
  PGPGetKeyIDFromKey:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyIDFromKey');
  PGPGetKeyIDFromSubKey:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyIDFromSubKey');
  PGPGetKeyIDOfCertifier:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyIDOfCertifier');
  PGPCompareKeyIDs:=GetProcAddress(hPGPsdkLib, 'PGPCompareKeyIDs');
  PGPGetKeySetContext:=GetProcAddress(hPGPsdkLib, 'PGPGetKeySetContext');
  PGPGetKeyListContext:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyListContext');
  PGPGetKeyIterContext:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyIterContext');
  PGPGetKeyContext:=GetProcAddress(hPGPsdkLib, 'PGPGetKeyContext');
  PGPGetSubKeyContext:=GetProcAddress(hPGPsdkLib, 'PGPGetSubKeyContext');
  PGPGetUserIDContext:=GetProcAddress(hPGPsdkLib, 'PGPGetUserIDContext');
  PGPAddKeyOptions:=GetProcAddress(hPGPsdkLib, 'PGPAddKeyOptions');
  PGPRemoveKeyOptions:=GetProcAddress(hPGPsdkLib, 'PGPRemoveKeyOptions');
  PGPUpdateKeyOptions:=GetProcAddress(hPGPsdkLib, 'PGPUpdateKeyOptions');

end.

