{$J+,Z4}
unit pgpCL;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the "Borland Delphi Runtime Library PGPsdk" released 10 Apr }
{ 2000, available at http://www.oz.net/~srheller/dpgp/sdk/.                        }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpClient.pas based on pgpCl.h from the PGP sources         }
{ which are Copyright (C) Network Associates Inc. and affiliated companies.        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ Lots of stuff removed (especially from PGP versions 5.5.X and 6.0.X)             }
{                                                                                  }
{**********************************************************************************}

interface

uses
  pgpTLS,
  pgpKeys,
  pgpEvents,
  pgpKeyServer,
  pgpMemoryMgr,
  pgpPubTypes, pgpBase;

const	// added by idw
  PGPclLib: PChar = nil;
  WM_PGPReloadPrefs: Longint = 0;
  WM_PGPReloadKeyring: Longint = 0;
  WM_PGPReloadKeyserverPrefs: Longint = 0;

var	// added by idw
  hPGPclLib: Longint;

//	_______________________________________________________
//
//	from pflPrefs		// added by idw

type
  PGPPrefIndex = PGPInt32;


//	_______________________________________________________
//
//	from pgpClientPrefs	// added by idw

const
  // (enum)
  kPGPPrefMacBinaryOff			= 1;
  kPGPPrefMacBinarySmart		= 2;
  kPGPPrefMacBinaryOn			= 3;

  // _PGPClientPrefsBool (enum)
  kPGPPrefBoolFirst			= 0;
  kPGPPrefEncryptToSelf			= 0;
  kPGPPrefWordWrapEnable		= 1;
  kPGPPrefDecryptCacheEnable		= 2;
  kPGPPrefSignCacheEnable		= 3;
  kPGPPrefMailEncryptPGPMIME		= 4;
  kPGPPrefMailSignPGPMIME		= 5;
  kPGPPrefFastKeyGen			= 6;
  kPGPPrefWarnOnMixRSAElGamal		= 7;
  kPGPPrefMailEncryptDefault		= 8;
  kPGPPrefMailSignDefault		= 9;
  kPGPPrefMarginalIsInvalid		= 10;
  kPGPPrefDisplayMarginalValidity	= 11;
  kPGPPrefFirstKeyGenerated		= 12;
  kPGPPrefWarnOnRSARecipAndNonRSASigner	= 13;
  kPGPPrefKeyServerSyncUnknownKeys	= 14;
  kPGPPrefKeyServerSyncOnAdd		= 15;
  kPGPPrefKeyServerSyncOnKeySign	= 16;
  kPGPPrefKeyServerSyncOnRevocation	= 17;
  kPGPPrefWarnOnReadOnlyKeyRings	= 18;
  kPGPPrefWarnOnWipe			= 19;
  kPGPPrefAutoDecrypt			= 20;
  kPGPPrefWarnOnADK			= 21;
  kPGPPrefKeyServerSyncOnVerify		= 22;	// 6.0
  kPGPPrefPGPkeysMacShowToolbar		= 23;	// 6.0
  kPGPPrefWarnOnMemLockFailure		= 24;	// 6.0
  kPGPPrefExportKeysCompatible		= 25;	// 6.0
  kPGPPrefAlwaysUseSecureViewer		= 26;	// 6.5
  kPGPPrefUseHexFingerprint		= 27;	// 6.5
  kPGPPrefDiskAutoUnmountOnTime		= 28;	// 7.0
  kPGPPrefDiskAutoUnmountOnSleep	= 29;	// 7.0
  kPGPPrefDiskNoSleepIfFailAU		= 30;	// 7.0
  kPGPPrefTrashIntegration		= 31;	// 6.5
  kPGPPrefBoolLast			= 31;

  // _PGPClientPrefsNumber (enum)
  kPGPPrefNumberFirst			= 200;
  kPGPPrefVersion			= 200;
  kPGPPrefWordWrapWidth			= 201;
  kPGPPrefDecryptCacheSeconds		= 202;
  kPGPPrefSignCacheSeconds		= 203;
  kPGPPrefDateOfLastSplashScreen	= 204;	// PGPTime
  kPGPPrefPreferredAlgorithm		= 205;
  kPGPPrefAllowedAlgorithms		= 206;	// OBSOLETE
  kPGPPrefMacBinaryDefault		= 207;
  kPGPPrefDateOfLastFreewareNotice	= 208;	// OBSOLETE
  kPGPPrefFileWipePasses		= 209;	// 6.0
  kPGPPrefDiskWipePasses		= 210;	// 6.0
  kPGPPrefLastSearchWindowSelection	= 211;	// 6.0
  kPGPPrefLastAllKeysUpdate		= 212;	// 6.5(moved from admin)
  kPGPPrefLastTrustedIntroducersUpdate	= 213;	// 6.5(moved from admin)
  kPGPPrefCAType			= 214;	// 6.5
  kPGPPrefCARootKeyAlg			= 215;	// 6.5
  kPGPPrefCAServerAuthKeyAlg		= 216;	// 6.5
  kPGPPrefCARevocationServerAuthKeyAlg	= 217;	// 6.5
  kPGPPrefNextAutoCRLUpdate		= 218;	// 6.5
  kPGPPrefDiskLastCreateSize		= 219;	// 7.0
  kPGPPrefDiskLastCreateScale		= 220;	// 7.0
  kPGPPrefDiskAutoUnmountTimeout	= 221;	// 7.0
  kPGPPrefNumberLast			= 221;

  // _PGPClientPrefsString (enum)
  kPGPPrefStringFirst			= 400;
  kPGPPrefOwnerName			= 400;
  kPGPPrefCompanyName			= 401;
  kPGPPrefLicenseNumber			= 402;
  kPGPPrefComment			= 403;
  kPGPPrefCAServerURL			= 405;	// 6.5
  kPGPPrefCARevocationServerURL		= 406;	// 6.5
  kPGPPrefDiskLastOpenDir		= 407;	// 7.0
  kPGPPrefDiskLastSaveDir		= 408;	// 7.0
  kPGPPrefStringLast			= 408;

  // _PGPClientPrefsByte (enum)

  kPGPPrefByteFirst			= 600;
  kPGPPrefPGPtoolsMacPrivateData	= 600;
  kPGPPrefPGPmenuMacAppSignatures	= 601;
  kPGPPrefPGPkeysMacMainWinPos		= 602;
  kPGPPrefPGPkeysMacColumnData		= 603;
  kPGPPrefKeyServerList			= 604;
  kPGPPrefPGPkeysWinMainWinPos		= 605;
  kPGPPrefPGPkeysWinColumnData		= 606;
  kPGPPrefPGPkeysWinGroupsData		= 607;
  kPGPPrefAllowedAlgorithmsList		= 608;	// 5.5.1
  kPGPPrefPGPdiskWin32PrivateData	= 609;	// 6.5
  kPGPPrefCARootKeyID			= 610;	// 6.5
  kPGPPrefCARootX509IASN		= 611;	// 6.5
  kPGPPrefCAServerAuthKeyID		= 612;	// 6.5
  kPGPPrefCARevocationServerAuthKeyID	= 613;	// 6.5
  kPGPPrefPGPdiskMacPrivateData		= 614;	// 6.5
  kPGPPrefHotKeyData			= 615;	// 6.5
  kPGPPrefByteLast			= 615;


//	_______________________________________________________
//
//	from pgpKeyServerPrefs	// added by idw

type
  PGPKeyServerEntryFlags = PGPEnumType;
const
  kKeyServerListed		= 1;
  kKeyServerIsRoot		= 2;

const
  kMaxServerNameLength		= 255;
type
  TKeyServer = Array[0..kMaxServerNameLength] of Char;

type
  pPGPKeyServerEntry = ^TPGPKeyServerEntry;
  TPGPKeyServerEntry = Record
    StructSize		: PGPSize;
    Protocol		: PGPKeyServerProtocol;
    Domain		: TKeyServer;
    ServerDNS		: TKeyServer;
    ServerPort		: PGPUInt16;
    AuthKeyIDString 	: TKeyID;
    AuthAlg		: PGPPublicKeyAlgorithm;
    Flags		: PGPUInt32;
    Reserved		: Array[0..63] of Char;
  end;

(*
	returns an array of PGPKeyServerEntry structures
	describing the keyservers in the default keyserver
	path and the number of structures in the array.
*)
var
  PGPGetKeyServerPrefs: function(Pref: pPGPPref;
				 var KeyServerList: pPGPKeyServerEntry;
				 var KeyServerCount: PGPUInt32): PGPError; cdecl;

(*
	given an array of PGPKeyServerEntry structures
	describing the keyservers in the default keyserver
	path it saves them off for later retrieval.
	All domains should be grouped contiguously in the array.
*)
var
  PGPSetKeyServerPrefs: function(Pref: pPGPPref;
				 KeyServerList: pPGPKeyServerEntry;
				 KeyServerCount: PGPUInt32): PGPError; cdecl;


//	_______________________________________________________
//
//	Library Initialization/Cleanup

//	Open library and initialize

var
  PGPclInitLibrary: function(Context: pPGPContext): PGPError; cdecl;

//	Close down DLL and purge passphrase buffers.

var
  PGPclCloseLibrary: function: PGPError; cdecl;


//	_______________________________________________________
//
//	Miscellaneous common dialogs and UI elements

//	Post PGP preferences property sheets.
//
//	This function posts the "PGP Preferences" property
//	sheet dialog boxes.  Appropriate calls are made into
//	the pgpkeydb library to set the preferences.
//
//	Entry parameters :
//		Context			- PGP library context
//		hWndParent		- handle of parent window
//		iStartsheet		- zero-based index of property sheet
//					  page to display initially.
//					  use the below-defined constants
//		keysetMain		- main keyset, if available.  If not
//					  available, NULL is OK.
//
//	This function returns kPGPError_UserAbort (if the user
//	presses the cancel button)

//	preferences pages (used for "iStartsheet")

const
  PGPCL_GENERALPREFS		= 0;
  PGPCL_KEYRINGPREFS		= 1;
  PGPCL_EMAILPREFS		= 2;
  PGPCL_HOTKEYPREFS		= 3;
  PGPCL_KEYSERVERPREFS		= 4;
  PGPCL_CAPREFS			= 5;
  PGPCL_ADVANCEDPREFS		= 6;

var
  PGPclPreferences: function(Context: pPGPContext; hWndParent: Longint; iStartsheet: Longint; KeySetMain: pPGPKeySet): PGPError; cdecl;


//	______________________________________________
//
//  The following functions are wrappers for
//  the pfl prefs routines. These are needed so
//  groupwise plugin can access prefs (Delphi)
//  using code in the PGPcl DLL			// activated by idw

var
  PGPclGetPrefBoolean: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; var Data: PGPBoolean): PGPError; cdecl;
  PGPclSetPrefBoolean: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; Data: PGPBoolean): PGPError; cdecl;
  PGPclGetPrefNumber: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; var Data: PGPUInt32): PGPError; cdecl;
  PGPclSetPrefNumber: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; Data: PGPUInt32): PGPError; cdecl;
  PGPclGetPrefStringAlloc: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; var Str: PChar): PGPError; cdecl;
  PGPclGetPrefStringBuffer: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; MaxSize: PGPSize; Str: PChar): PGPError; cdecl;
  PGPclSetPrefString: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex; Str: PChar): PGPError; cdecl;
  PGPclGetPrefData: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex;
			     var DataLength: PGPSize; var InBuffer: Pointer): PGPError; cdecl;
  PGPclSetPrefData: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex;
			     DataLength: PGPSize; OutBuffer: Pointer): PGPError; cdecl;
  PGPclRemovePref: function(PGPPref: pPGPPref; PrefIndex: PGPPrefIndex): PGPError; cdecl;

//	_______________________________________________________
//
//	Preference files convenience functions	// activated by idw

//	Open client preferences file and returns PrefRef to caller
//
//	Entry parameters :
//		memMgr			- memory manager to user for allocating fileref
//		pPrefRef		- pointer to buffer to receive PrefRef

var
  PGPclOpenClientPrefs: function(MemMgr: pPGPMemoryMgr; var PGPPref: pPGPPref): PGPError; cdecl;

//	Close, and optionally save changes to, open client preference file
//
//	Entry parameters :
//		PrefRef			- PrefRef of file to close
//		bSave			- TRUE => save changes before closing

var
  PGPclCloseClientPrefs: function(PGPPref: pPGPPref; bSave: Longbool): PGPError; cdecl;

//	Dispose PrefData
//
//	Entry parameters :
//		PrefRef			- PrefRef of file to close
//		dataBuffer		- pointer to previously retrieved data

var
  PGPclDisposePrefData: function(PGPPref: pPGPPref; DataBuffer: Pointer): PGPError; cdecl;

//	Broadcast message that indicates that the prefs
//	have been changed and that others should reload from
//	disk.
//
//	Entry parameters :
//		lParam		- 32 value which is passed along as the LPARAM
//				  of the broadcast message.  Current usage
//				  is to set this to your process ID or your
//				  window handle so that you can ignore
//				  your own messages, if you want.  Set to
//				  zero to ensure all recipients process message.

//	broadcast message used to inform others of prefs changes

const
  RELOADPREFSMSG = 'PGPM_RELOADPREFS';

var
  PGPclNotifyPrefsChanges: procedure(lParam: Longint); cdecl;

//	Broadcast message that indicates that the keyring
//	has been changed and that others should reload from
//	disk.
//
//	Entry parameters :
//		lParam		- 32 value which is passed along as the LPARAM
//				  of the broadcast message.  Current usage
//				  is to set this to your process ID or your
//				  window handle so that you can ignore
//				  your own messages, if you want.  Set to
//				  zero to ensure all recipients process message.

//	broadcast message used to inform others of keyring changes

const
  RELOADKEYRINGMSG = 'PGPM_RELOADKEYRING';

var
  PGPclNotifyKeyringChanges: procedure(lParam: Longint); cdecl;

//	Broadcast message that indicates that the keyserver prefs
//	have been changed and that others should reload from
//	disk.
//
//	Entry parameters :
//		lParam		- 32 value which is passed along as the LPARAM
//				  of the broadcast message.  Current usage
//				  is to set this to your process ID or your
//				  window handle so that you can ignore
//				  your own messages, if you want.  Set to
//				  zero to ensure all recipients process message.

//	broadcast message used to inform others of keyserver prefs changes

const
  RELOADKEYSERVERPREFSMSG = 'PGPM_RELOADKEYSERVERPREFS';

var
  PGPclNotifyKeyserverPrefsChanges: procedure(lParam: Longint); cdecl;


//	_______________________________________________________
//
//	Miscellaneous common dialogs and UI elements

var
  PGPclSelectKeys: function(Context: pPGPContext;
			    tlsContext: pPGPtlsContext;
			    hWndParent: Longint;
			    pszPrompt: PChar;
			    KeySetToDisplay: pPGPKeySet;
			    KeySetMain: pPGPKeySet;
			    var pKeySetSelected: pPGPKeySet): PGPError; cdecl;

//	display keyset and allow user to select keys
//	- extended calling parameters -- added option flags
//
//	Entry parameters :
//		hWndParent		- handle of parent window
//		pszPrompt		- prompt string
//		KeySetToDisplay		- keyset containing keys to show
//		KeySetMain		- backing keyset
//		uFlags			- option flags (see below)
//		pKeySetSelected		- buffer to receive keyset ref of selected keys
//
//
//	Returns kPGPError_NoErr if no error
//

// option flag bits

const	// added by idw
  PGPCL_SINGLESELECTION		= 1;

var	// added by idw
  PGPclSelectKeysEx: function(Context: pPGPContext;
			      tlsContext: pPGPtlsContext;
			      hWndParent: Longint;
			      pszPrompt: PChar;
			      KeySetToDisplay: pPGPKeySet;
			      KeySetMain: pPGPKeySet;
			      Flags: Longint;
			      var pKeySetSelected: pPGPKeySet): PGPError; cdecl;


//	_______________________________________________________
//
//	Keyserver convenience functions	// activated by idw

const
  PGPCL_SPECIFIEDSERVER		= 0;
  PGPCL_USERIDBASEDSERVER	= 1;	// determine server based on userid
  PGPCL_DEFAULTSERVER		= 2;	// use default keyserver
  PGPCL_ROOTSERVER		= 3;	// use root keyserver

//	Searches keyservers (as defined in prefs file) for the
//	specified userid string.
//
//	Entry parameters :
//		hwndParent		parent window
//		szUserID		string containing userid info
//		uServer			one of above-defined server constants
//		keysetMain		keyset to which tls key is added
//		pkeysetFound		buffer to receive PGPKeySetRef of found keys

var
  PGPclSearchServerForUserID: function(Context: pPGPContext;
				       tlsContext: pPGPtlsContext;
				       hwndParent: Longint;
				       szUserID: PChar;
				       uServer: Longint;
				       KeySetMain: pPGPKeySet;
				       var pKeySetFound: pPGPKeySet): PGPError; cdecl;


//	Searches default keyserver for the keyids in the list.
//
//	Entry parameters :
//		hwndParent		parent window
//		pkeyidList		array of PGPKeyID
//		NumKeyIDs		number of PGPKeyIDs in list
//		uServer			one of above-defined server constants
//		keysetMain		keyset to which tls key is added
//		pkeysetFound		buffer to receive PGPKeySetRef of found keys

var
  PGPclSearchServerForKeyIDs: function(Context: pPGPContext;
				       tlsContext: pPGPtlsContext;
				       hwndParent: Longint;
				       KeyIDList: pPGPKeyID;
				       NumKeyIDs: Longint;
				       uServer: Longint;
				       KeySetMain: pPGPKeySet;
				       var pKeySetFound: pPGPKeySet): PGPError; cdecl;


//	Searches default keyserver using the specified filter.
//
//	Entry parameters :
//		hwndParent		parent window
//		filter			filter to use for search
//		uServer			one of above-defined server constants
//		keysetMain		keyset to which tls key is added
//		pkeysetFound		buffer to receive : pPGPKeySet; of found keys

var
  PGPclSearchServerWithFilter: function(Context: pPGPContext;
					tlsContext: pPGPtlsContext;
					hwndParent: Longint;
					Filter: pPGPFilter;
					uServer: Longint;
					KeySetMain: pPGPKeySet;
					var pKeySetFound: pPGPKeySet): PGPError; cdecl;


//	Sends keys in keyset to the specified keyserver
//
//	Entry parameters :
//		hwndParent		parent window
//		szServerURL		server to send to
//		uServer			one of above-defined server constants
//					or zero to use pkeyserver
//		pkeyserver		server to send to (if uServer == 0)
//		keysetMain		keyset to which tls key is added and
//					which contains signing keys
//		keysetToSend		keyset with keys to send

var
  PGPclSendKeysToServer: function(Context: pPGPContext;
				  tlsContext: pPGPtlsContext;
				  hwndParent: Longint;
				  uServer: Longint;
				  var KeyServer: pPGPKeyServerEntry;
				  KeySetMain: pPGPKeySet;
				  KeySetToSend: pPGPKeySet): PGPError; cdecl;

implementation	// code modified by idw

uses
  Windows;

initialization

  PGPclLib:='PGPcl.dll';		// 6.X
  hPGPclLib:=LoadLibrary(PGPclLib);

  if hPGPclLib=0 then begin
    PGPclLib:='PGPclientLib.dll';	// 7.X
    hPGPclLib:=LoadLibrary(PGPclLib);
  end;

  if hPGPclLib=0 then begin
    ErrorMsg:='PGP Client Library not found';
    Halt(ERROR_DLL_INIT_FAILED);
  end;

  WM_PGPReloadPrefs:=RegisterWindowMessage(RELOADPREFSMSG);
  WM_PGPReloadKeyring:=RegisterWindowMessage(RELOADKEYRINGMSG);
  WM_PGPReloadKeyserverPrefs:=RegisterWindowMessage(RELOADKEYSERVERPREFSMSG);

  PGPclInitLibrary:=GetProcAddress(hPGPclLib, 'PGPclInitLibrary');					// _PGPclInitLibrary@8
  PGPclCloseLibrary:=GetProcAddress(hPGPclLib, 'PGPclCloseLibrary');					// _PGPclCloseLibrary@0
  PGPclPreferences:=GetProcAddress(hPGPclLib, 'PGPclPreferences');					// _PGPclPreferences@16
  PGPclGetPrefBoolean:=GetProcAddress(hPGPclLib, 'PGPclGetPrefBoolean');				// _PGPclGetPrefBoolean@12
  PGPclSetPrefBoolean:=GetProcAddress(hPGPclLib, 'PGPclSetPrefBoolean');				// _PGPclSetPrefBoolean@12
  PGPclGetPrefNumber:=GetProcAddress(hPGPclLib, 'PGPclGetPrefNumber');					// _PGPclGetPrefNumber@12
  PGPclSetPrefNumber:=GetProcAddress(hPGPclLib, 'PGPclSetPrefNumber');					// _PGPclSetPrefNumber@12
  PGPclGetPrefStringAlloc:=GetProcAddress(hPGPclLib, 'PGPclGetPrefStringAlloc');			// _PGPclGetPrefStringAlloc@12
  PGPclGetPrefStringBuffer:=GetProcAddress(hPGPclLib, 'PGPclGetPrefStringBuffer');			// _PGPclGetPrefStringBuffer@16
  PGPclSetPrefString:=GetProcAddress(hPGPclLib, 'PGPclSetPrefString');					// _PGPclSetPrefString@12
  PGPclGetPrefData:=GetProcAddress(hPGPclLib, 'PGPclGetPrefData');					// _PGPclGetPrefData@16
  PGPclSetPrefData:=GetProcAddress(hPGPclLib, 'PGPclSetPrefData');					// _PGPclSetPrefData@16
  PGPclRemovePref:=GetProcAddress(hPGPclLib, 'PGPclRemovePref');					// _PGPclRemovePref@8
  PGPclOpenClientPrefs:=GetProcAddress(hPGPclLib, 'PGPclOpenClientPrefs');				// ???
  PGPclCloseClientPrefs:=GetProcAddress(hPGPclLib, 'PGPclCloseClientPrefs');				// ???
  PGPclDisposePrefData:=GetProcAddress(hPGPclLib, 'PGPclDisposePrefData');				// ???
  PGPclNotifyPrefsChanges:=GetProcAddress(hPGPclLib, 'PGPclNotifyPrefsChanges');			// _PGPclNotifyPrefsChanges@4
  PGPclNotifyKeyringChanges:=GetProcAddress(hPGPclLib, 'PGPclNotifyKeyringChanges');			// _PGPclNotifyKeyringChanges@8
  PGPclNotifyKeyserverPrefsChanges:=GetProcAddress(hPGPclLib, 'PGPclNotifyKeyserverPrefsChanges');	// _PGPclNotifyKeyserverPrefsChanges@4
  PGPclSelectKeys:=GetProcAddress(hPGPclLib, 'PGPclSelectKeys');					// _PGPclSelectKeys@28
  PGPclSelectKeysEx:=GetProcAddress(hPGPclLib, 'PGPclSelectKeysEx');					// ???
  PGPclSearchServerForUserID:=GetProcAddress(hPGPclLib, 'PGPclSearchServerForUserID');			// _PGPclSearchServerForUserID@28
  PGPclSearchServerForKeyIDs:=GetProcAddress(hPGPclLib, 'PGPclSearchServerForKeyIDs');			// _PGPclSearchServerForKeyIDs@32
  PGPclSearchServerWithFilter:=GetProcAddress(hPGPclLib, 'PGPclSearchServerWithFilter');		// _PGPclSearchServerWithFilter@28
  PGPclSendKeysToServer:=GetProcAddress(hPGPclLib, 'PGPclSendKeysToServer');				// _PGPclSendKeysToServer@28
  PGPGetKeyServerPrefs:=GetProcAddress(hPGPclLib, 'PGPGetKeyServerPrefs');				// ???
  PGPSetKeyServerPrefs:=GetProcAddress(hPGPclLib, 'PGPSetKeyServerPrefs');				// ???

finalization

  if hPGPclLib<>0 then FreeLibrary(hPGPclLib);

end.

