{$J+,Z4}
unit pgpUI;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the "Borland Delphi Runtime Library PGPsdk" released 10 Apr }
{ 2000, available at http://www.oz.net/~srheller/dpgp/sdk/.                        }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpUserInterface.pas based on pgpUserInterface.h            }
{ from the PGP sources which are Copyright (C) Network Associates Inc.             }
{ and affiliated companies.                                                        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ Several declarations removed, all functions taking OptionLists modified          }
{ according to a suggestion by Steven R. Heller, for details see pgpOptionList.pas }
{                                                                                  }
{**********************************************************************************}

interface

uses
  pgpPubTypes, pgpBase;

const	// added by idw
  PGPsdkUILib: PChar = nil;

var	// added by idw
  hPGPsdkUILib: Longint;

type
  PGPAdditionalRecipientRequestEnforcement = PGPEnumType;
const
  kPGPARREnforcement_Invalid = 0;
  kPGPARREnforcement_None    = 1;
  kPGPARREnforcement_Warn    = 2;
  kPGPARREnforcement_Strict  = 3;

type
  PGPRecipientSpecType = PGPEnumType;
const
  kPGPRecipientSpecType_Invalid = 0;
  kPGPRecipientSpecType_Key     = 1;
  kPGPRecipientSpecType_UserID  = 2;
  kPGPRecipientSpecType_KeyID   = 3;

type	// modified by idw
  pPGPRecipientSpec = ^PGPRecipientSpec;
  PGPRecipientSpec = Record
    AType	: PGPRecipientSpecType;
    Locked	: PGPBoolean;
    Reserved8	: Array[0..2] of PGPBoolean;	// Must be zero
    Reserved32	: Array[0..2] of PGPUInt32;	// Must be zero
    ID		: Record case Longint of
		    1 : (Key: pPGPKey);
		    2 : (UserIDStr: TUserID);
		    3 : (ID: Record
			   KeyID : TPGPKeyID;
			   Algorithm : PGPPublicKeyAlgorithm;
			 end);
		  end;
  end;
  pPGPKeyServerSpec = ^PGPKeyServerSpec;
  PGPKeyServerSpec = Record
    Server	: pPGPKeyServer;
    ServerName	: PChar;			// Optional
    Reserved	: Array[0..4] of PGPUInt32;	// Must be zero
  end;

var
  PGPsdkUILibInit: function: PGPError; cdecl;
  PGPsdkUILibCleanup: function: PGPError cdecl;
  PGPRecipientDialog: function(Context: pPGPContext; AllKeys: pPGPKeySet; AlwaysDisplayDialog: PGPBoolean;
			       var RecipientKeys: pPGPKeySet; OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  PGPPassphraseDialog: function(Context: pPGPContext; OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  PGPConfirmationPassphraseDialog: function(Context: pPGPContext; OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  PGPKeyPassphraseDialog: function(Context: pPGPContext; TheKey: pPGPKey;
				   OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  PGPSigningPassphraseDialog: function(Context: pPGPContext; AllKeys: pPGPKeySet; var SigningKey: pPGPKey;
				       OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  PGPDecryptionPassphraseDialog: function(Context: pPGPContext; RecipientKeys: pPGPKeySet; KeyIDCount: PGPUInt32;
  					  const KeyIDList: pPGPKeyID; var DecryptionKey: pPGPKey;
					  OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  PGPConventionalEncryptionPassphraseDialog: function(Context: pPGPContext;
						      OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  PGPConventionalDecryptionPassphraseDialog: function(Context: pPGPContext;
  						      OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  PGPCollectRandomDataDialog: function(Context: pPGPContext; NeededEntropyBits: PGPUInt32;
				       OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  PGPEstimatePassphraseQuality: function(const Passphrase: PChar): PGPUInt32; cdecl;
  PGPSearchKeyServerDialog: function(Context: pPGPContext; ServerCount: PGPUInt32; const ServerList: pPGPKeyServerSpec;
				     tlsContext: pPGPtlsContext; SearchAllServers: PGPBoolean; var FoundKeys: pPGPKeySet;
				     OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  PGPSendToKeyServerDialog: function(Context: pPGPContext; const Server: PGPKeyServerSpec;
				     tlsContext: pPGPtlsContext; KeysToSend: pPGPKeySet; var FailedKeys: pPGPKeySet;
				     OptionList, LastOption: pPGPOptionList): PGPError; cdecl;
  PGPOUIParentWindowHandle: function(Context: pPGPContext; ParentHandle: Longint): pPGPOptionList; cdecl;
  PGPOUIWindowTitle: function(Context: pPGPContext; Title: PChar): pPGPOptionList; cdecl;
  PGPOUIDialogPrompt: function(Context: pPGPContext; Prompt: PChar): pPGPOptionList; cdecl;
  PGPOUIDialogOptions: function(Context: pPGPContext; OptionList, LastOption: pPGPOptionList): pPGPOptionList; cdecl;
  PGPOUICheckbox: function(Context: pPGPContext; ItemID: PGPUInt32; const Title, Description: PChar;
			   InitialValue: PGPUInt32; var ResultValue: PGPUInt32;
			   LastOption: pPGPOptionList): pPGPOptionList; cdecl;
  PGPOUIOutputPassphrase: function(Context: pPGPContext; var Passphrase: PChar): pPGPOptionList; cdecl;
  PGPOUIMinimumPassphraseLength: function(Context: pPGPContext; MinimumPassphraseLength: PGPUInt32): pPGPOptionList; cdecl;
  PGPOUIMinimumPassphraseQuality: function(Context: pPGPContext; MinimumPassphraseQuality: PGPUInt32): pPGPOptionList; cdecl;
  PGPOUIShowPassphraseQuality: function(Context: pPGPContext; ShowPassphraseQuality: PGPBoolean): pPGPOptionList; cdecl;
  PGPOUIVerifyPassphrase: function(Context: pPGPContext; VerifyPassphrase: PGPBoolean): pPGPOptionList; cdecl;
  PGPOUIFindMatchingKey: function(Context: pPGPContext; FindMatchingKey: PGPBoolean): pPGPOptionList; cdecl;
  PGPOUIDefaultRecipients: function(Context: pPGPContext; NumRecipients: PGPUInt32;
				    const Recipients: pPGPRecipientSpec): pPGPOptionList; cdecl;
  PGPOUIDefaultKey: function(Context: pPGPContext; DefaultKey: pPGPKey): pPGPOptionList; cdecl;
  PGPOUIDisplayMarginalValidity: function(Context: pPGPContext; DisplayMarginalValidity: PGPBoolean): pPGPOptionList; cdecl;
  PGPOUIIgnoreMarginalValidity: function(Context: pPGPContext; IgnoreMarginalValidity: PGPBoolean): pPGPOptionList; cdecl;
  PGPOUIKeyServerUpdateParams: function(Context: pPGPContext; NumKeyServers: PGPUInt32;
					const KeyServerList: PGPKeyServerSpec; tlsContext: pPGPtlsContext;
					SearchBeforeDisplay: PGPBoolean; var FoundKeys: pPGPKeySet;
					LastOption: pPGPOptionList): pPGPOptionList; cdecl;
  PGPOUIKeyServerSearchFilter: function(Context: pPGPContext; Filter: pPGPFilter): pPGPOptionList; cdecl;
  PGPOUIKeyServerSearchKey: function(Context: pPGPContext; Key: pPGPKey): pPGPOptionList; cdecl;
  PGPOUIKeyServerSearchKeySet: function(Context: pPGPContext; KeySet: pPGPKeySet): pPGPOptionList; cdecl;
  PGPOUIKeyServerSearchKeyIDList: function(Context: pPGPContext; KeyIDCount: PGPUInt32;
  					   const KeyIDList: pPGPKeyID): pPGPOptionList; cdecl;

implementation	// code modified by idw

uses
  Windows;

initialization

  PGPsdkUILib:='PGPsdkUI.dll';
  hPGPsdkUILib:=LoadLibrary(PGPsdkUILib);

  if hPGPsdkUILib=0 then begin
    ErrorMsg:='PGP Software Development Kit UI Library not found';
    Halt(ERROR_DLL_INIT_FAILED);
  end;

  PGPsdkUILibInit:=GetProcAddress(hPGPsdkUILib, 'PGPsdkUILibInit');
  PGPsdkUILibCleanup:=GetProcAddress(hPGPsdkUILib, 'PGPsdkUILibCleanup');
  PGPRecipientDialog:=GetProcAddress(hPGPsdkUILib, 'PGPRecipientDialog');
  PGPPassphraseDialog:=GetProcAddress(hPGPsdkUILib, 'PGPPassphraseDialog');
  PGPConfirmationPassphraseDialog:=GetProcAddress(hPGPsdkUILib, 'PGPConfirmationPassphraseDialog');
  PGPKeyPassphraseDialog:=GetProcAddress(hPGPsdkUILib, 'PGPKeyPassphraseDialog');
  PGPSigningPassphraseDialog:=GetProcAddress(hPGPsdkUILib, 'PGPSigningPassphraseDialog');
  PGPDecryptionPassphraseDialog:=GetProcAddress(hPGPsdkUILib, 'PGPDecryptionPassphraseDialog');
  PGPConventionalEncryptionPassphraseDialog:=GetProcAddress(hPGPsdkUILib, 'PGPConventionalEncryptionPassphraseDialog');
  PGPConventionalDecryptionPassphraseDialog:=GetProcAddress(hPGPsdkUILib, 'PGPConventionalDecryptionPassphraseDialog');
  PGPCollectRandomDataDialog:=GetProcAddress(hPGPsdkUILib, 'PGPCollectRandomDataDialog');
  PGPEstimatePassphraseQuality:=GetProcAddress(hPGPsdkUILib, 'PGPEstimatePassphraseQuality');
  PGPSearchKeyServerDialog:=GetProcAddress(hPGPsdkUILib, 'PGPSearchKeyServerDialog');
  PGPSendToKeyServerDialog:=GetProcAddress(hPGPsdkUILib, 'PGPSendToKeyServerDialog');
  PGPOUIParentWindowHandle:=GetProcAddress(hPGPsdkUILib, 'PGPOUIParentWindowHandle');
  PGPOUIWindowTitle:=GetProcAddress(hPGPsdkUILib, 'PGPOUIWindowTitle');
  PGPOUIDialogPrompt:=GetProcAddress(hPGPsdkUILib, 'PGPOUIDialogPrompt');
  PGPOUIDialogOptions:=GetProcAddress(hPGPsdkUILib, 'PGPOUIDialogOptions');
  PGPOUICheckbox:=GetProcAddress(hPGPsdkUILib, 'PGPOUICheckbox');
  PGPOUIOutputPassphrase:=GetProcAddress(hPGPsdkUILib, 'PGPOUIOutputPassphrase');
  PGPOUIMinimumPassphraseLength:=GetProcAddress(hPGPsdkUILib, 'PGPOUIMinimumPassphraseLength');
  PGPOUIMinimumPassphraseQuality:=GetProcAddress(hPGPsdkUILib, 'PGPOUIMinimumPassphraseQuality');
  PGPOUIShowPassphraseQuality:=GetProcAddress(hPGPsdkUILib, 'PGPOUIShowPassphraseQuality');
  PGPOUIVerifyPassphrase:=GetProcAddress(hPGPsdkUILib, 'PGPOUIVerifyPassphrase');
  PGPOUIFindMatchingKey:=GetProcAddress(hPGPsdkUILib, 'PGPOUIFindMatchingKey');
  PGPOUIDefaultRecipients:=GetProcAddress(hPGPsdkUILib, 'PGPOUIDefaultRecipients');
  PGPOUIDefaultKey:=GetProcAddress(hPGPsdkUILib, 'PGPOUIDefaultKey');
  PGPOUIDisplayMarginalValidity:=GetProcAddress(hPGPsdkUILib, 'PGPOUIDisplayMarginalValidity');
  PGPOUIIgnoreMarginalValidity:=GetProcAddress(hPGPsdkUILib, 'PGPOUIIgnoreMarginalValidity');
  PGPOUIKeyServerUpdateParams:=GetProcAddress(hPGPsdkUILib, 'PGPOUIKeyServerUpdateParams');
  PGPOUIKeyServerSearchFilter:=GetProcAddress(hPGPsdkUILib, 'PGPOUIKeyServerSearchFilter');
  PGPOUIKeyServerSearchKey:=GetProcAddress(hPGPsdkUILib, 'PGPOUIKeyServerSearchKey');
  PGPOUIKeyServerSearchKeySet:=GetProcAddress(hPGPsdkUILib, 'PGPOUIKeyServerSearchKeySet');
  PGPOUIKeyServerSearchKeyIDList:=GetProcAddress(hPGPsdkUILib, 'PGPOUIKeyServerSearchKeyIDList');

  PGPsdkUILibInit;

finalization

  if Assigned(PGPsdkUILibCleanup) then PGPsdkUILibCleanup;

  if hPGPsdkUILib<>0 then FreeLibrary(hPGPsdkUILib);

end.

