{$J+,Z4}
unit pgpSC;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the SPGP 2.5.6.0 sources,                                   }
{ available at http://www.oz.net/~srheller/spgp/.                                  }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpSC.pas based on pgpSC.h from the PGP sources             }
{ which are Copyright (C) Network Associates Inc. and affiliated companies.        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ Some comments removed, some declarations activated                               }
{                                                                                  }
{**********************************************************************************}

interface

uses
  pgpPubTypes, pgpBase;

const	// added by idw
  PGPscLib: PChar = nil;

var	// added by idw
  hPGPscLib: Longint;

type	// modified by idw
  pPGPsc = pPGPContext;
  pPGPtls = pPGPtlsContext;

type	// modified by idw
  TPath = Array[0..260] of Char;
  pFileList = ^TFileList;
  TFileList = Record
    Name: TPath;
    IsDirectory: Longbool;
    Next: pFileList;
  end;

// Library initialization routines
var InitPGPsc: function(Parent: Longint; var P: pPGPsc; var TLS: pPGPtls): Longbool; cdecl;
var UninitPGPsc: function(Parent: Longint; P: pPGPsc; TLS: pPGPtls): Longbool; cdecl;

// Clipboard routines
var EncryptClipboard: function(Parent: Longint;
    App			: PChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    Encrypt		: Longbool;
    Sign		: Longbool): Longbool; cdecl;
var DecryptClipboard: function(Parent: Longint;
    App			: PChar;
    P			: pPGPsc;
    TLS			: pPGPtls): Longbool; cdecl;
var AddKeyClipboard: function(Parent: Longint;
    P			: pPGPsc;
    TLS			: pPGPtls): Longbool; cdecl;
var ClipboardWipe: function(Parent: Longint; P: pPGPsc): Longbool; cdecl;

// Filelist routines
var EncryptFileList: function(Parent: Longint;
    App			: PChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    ListHead		: pFileList;
    Encrypt		: Longbool;
    Sign		: Longbool): Longbool; cdecl;
var DecryptFileList: function(Parent: Longint;
    App			: PChar;
    P			: pPGPsc;
    TLS			: pPGPtls;
    ListHead		: pFileList): Longbool; cdecl;
var AddKeyFileList: function(Parent: Longint;
    P			: pPGPsc;
    TLS			: pPGPtls;
    ListHead		: pFileList): Longbool; cdecl;
var WipeFileList: function(Parent: Longint;
    P			: pPGPsc;
    ListHead		: pFileList;
    DelFilePostWipe	: Longbool): Longbool; cdecl;

// Filelist utility functions (Note that UserCancel can be NULL)
var AddToFileList: function(var FileList: pFileList;
    FileName		: PChar;
    var UserCancel	: Longbool): Longbool; cdecl;
var FreeFileList: function(FileList: pFileList): Longbool; cdecl;

// Grabs preferences from pref file
var GetValidityDrawPrefs: function(P: pPGPsc; var InputBool: Longbool): Longbool; cdecl;
var GetMarginalInvalidPref: function(P: pPGPsc; var InputBool: Longbool): Longbool; cdecl;
var GetSecureViewerPref: function(P: pPGPsc): Longbool; cdecl;

// Use secure viewer and/or anti-tempest font
var TempestViewer: function(P: pPGPsc;
    Parent		: Longint;
    pInput		: PChar;
    InSize		: Longint;
    Warn		: Longbool): Cardinal; cdecl;

// Launches Keys/Tools
var DoLaunchNet: function(Parent: Longint): Longbool; cdecl;
var DoLaunchKeys: function(Parent: Longint): Longbool; cdecl;
var DoLaunchTools: function(Parent: Longint): Longbool; cdecl;
var DoLaunchDisk: function(Parent: Longint): Longbool; cdecl;

// Sends signature info to PGPlog
var SendPGPlogMsg: function(Parent: Longint; Msg: PChar): Longbool; cdecl;

// Returns path for PGPkeys
var PGPpath: procedure(var Path: TPath); cdecl;

implementation	// code modified by idw

uses
  Windows;

initialization

  PGPscLib:='PGPsc.dll';
  hPGPscLib:=LoadLibrary(PGPscLib);

  if hPGPscLib=0 then begin
    ErrorMsg:='PGP Cryptographic Support Library not found';
    Halt(ERROR_DLL_INIT_FAILED);
  end;

  InitPGPsc:=GetProcAddress(hPGPscLib, 'InitPGPsc');				// PGPscInit ???
  UninitPGPsc:=GetProcAddress(hPGPscLib, 'UninitPGPsc');			// PGPscDestroy ???
  EncryptClipboard:=GetProcAddress(hPGPscLib, 'EncryptClipboard');		// PGPscEncryptClipboard
  DecryptClipboard:=GetProcAddress(hPGPscLib, 'DecryptClipboard');		// PGPscDecryptClipboard
  AddKeyClipboard:=GetProcAddress(hPGPscLib, 'AddKeyClipboard');		// PGPscAddKeyClipboard
  ClipboardWipe:=GetProcAddress(hPGPscLib, 'ClipboardWipe');			// PGPscEraseClipboard
  EncryptFileList:=GetProcAddress(hPGPscLib, 'EncryptFileList');		// PGPscEncryptFileList
  DecryptFileList:=GetProcAddress(hPGPscLib, 'DecryptFileList');		// PGPscDecryptFileList
  AddKeyFileList:=GetProcAddress(hPGPscLib, 'AddKeyFileList');			// PGPscAddKeyFileList
  WipeFileList:=GetProcAddress(hPGPscLib, 'WipeFileList');			// PGPscWipeFileList
  AddToFileList:=GetProcAddress(hPGPscLib, 'AddToFileList');			// PGPscAddToFileList
  FreeFileList:=GetProcAddress(hPGPscLib, 'FreeFileList');			// PGPscFreeFileList
  GetValidityDrawPrefs:=GetProcAddress(hPGPscLib, 'GetValidityDrawPrefs');	// PGPscGetValidityDrawPrefs
  GetMarginalInvalidPref:=GetProcAddress(hPGPscLib, 'GetMarginalInvalidPref');	// PGPscGetMarginalInvalidPref
  GetSecureViewerPref:=GetProcAddress(hPGPscLib, 'GetSecureViewerPref');	// PGPscGetSecureViewerPref
  TempestViewer:=GetProcAddress(hPGPscLib, 'TempestViewer');			// PGPscTempestViewer
  DoLaunchNet:=GetProcAddress(hPGPscLib, 'DoLaunchNet');			// PGPscDoLaunchNet
  DoLaunchKeys:=GetProcAddress(hPGPscLib, 'DoLaunchKeys');			// PGPscDoLaunchKeys
  DoLaunchTools:=GetProcAddress(hPGPscLib, 'DoLaunchTools');			// PGPscDoLaunchTools
  DoLaunchDisk:=GetProcAddress(hPGPscLib, 'DoLaunchDisk');			// PGPscDoLaunchDisk
  SendPGPlogMsg:=GetProcAddress(hPGPscLib, 'SendPGPlogMsg');			// PGPscSendPGPlogMsg
  PGPpath:=GetProcAddress(hPGPscLib, 'PGPpath');				// PGPscPGPpath

end.

