{$J+,Z4}
unit pgpPubTypes;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the "Borland Delphi Runtime Library PGPsdk" released 10 Apr }
{ 2000, available at http://www.oz.net/~srheller/dpgp/sdk/.                        }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw"),            }
{ Graham Grieve from Kestral Computing <http://www.kestral.com.au/devtools/pgp/>   }
{                                                                                  }
{ The original file is pgpPubTypes.pas based on pgpPubTypes.h from the PGP sources }
{ which are Copyright (C) Network Associates Inc. and affiliated companies.        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{ PGPEnumType moved to pgpBase.pas, pPGPJob, pPGPPref, pPGPtls... types added,     }
{ kPGPMaxKeyIDStringSize, kPGPMaxExportedKeyIDSize, kPGPMaxFingerprintSize added,  }
{ kPGPHashAlgorithm_SHADouble removed                                              }
{                                                                                  }
{**********************************************************************************}

interface

uses
  pgpBase;

type
  { General data types used by PGPsdk }
  pPGPJob			= Pointer;
  pPGPPref			= Pointer;
  pPGPContext			= Pointer;
  pPGPFileSpec			= Pointer;
  pPGPOptionList		= Pointer;
  pPGPtlsContext		= Pointer;
  pPGPtlsConstContext		= Pointer;
  pPGPtlsSession		= Pointer;
  pPGPtlsConstSession		= Pointer;


type
  { Data types used by the key manipulation functions }
  pPGPKey			= Pointer;
  pPGPSubKey			= Pointer;
  pPGPUserID			= Pointer;
  pPGPSig			= Pointer;
  pPGPKeySet			= Pointer;
  pPGPKeyList			= Pointer;
  pPGPKeyIter			= Pointer;
  pPGPFilter			= Pointer;

type
  { Data types used by symmetric ciphers, cipher modes, hashing }
  pPGPHashContext		= Pointer;
  pPGPPublicKeyContext		= Pointer;
  pPGPPrivateKeyContext		= Pointer;
  pPGPSymmetricCipherContext	= Pointer;
  pPGPCBCContext		= Pointer;
  pPGPCFBContext		= Pointer;

type
  { Data type used by keyserver code }
  pPGPKeyServer			= Pointer;

type
  { Symmetric Ciphers }
  PGPCipherAlgorithm = PGPEnumType;
const
  kPGPCipherAlgorithm_None		= 0;
  kPGPCipherAlgorithm_IDEA		= 1;
  kPGPCipherAlgorithm_3DES		= 2;
  kPGPCipherAlgorithm_CAST5		= 3;

type
  { Hash algorithms }
  PGPHashAlgorithm = PGPEnumType;
const
  kPGPHashAlgorithm_Invalid		= 0;
  kPGPHashAlgorithm_MD5			= 1;
  kPGPHashAlgorithm_SHA			= 2;
  kPGPHashAlgorithm_RIPEMD160		= 3;

type
  { Public/Private key algorithms }
  PGPPublicKeyAlgorithm = PGPEnumType;
const
  kPGPPublicKeyAlgorithm_Invalid	= -1;
  kPGPPublicKeyAlgorithm_RSA		= $01;
  kPGPPublicKeyAlgorithm_RSAEncryptOnly	= $02;
  kPGPPublicKeyAlgorithm_RSASignOnly	= $03;
  kPGPPublicKeyAlgorithm_ElGamal	= $10; // DH
  kPGPPublicKeyAlgorithm_DSA		= $11; // DSS

  kPGPPublicKeyAlgorithm_First		= $01; // kPGPPublicKeyAlgorithm_RSA;
  kPGPPublicKeyAlgorithm_Last		= $11; // kPGPPublicKeyAlgorithm_DSA;

type
  { Trust values, used to set validity values }
  PGPTrust = PGPEnumType;
const
  kPGPKeyTrust_Mask 			= $7;

  kPGPKeyTrust_Undefined		= $0;
  kPGPKeyTrust_Unknown			= $1;
  kPGPKeyTrust_Never			= $2;
  kPGPKeyTrust_Marginal			= $5;
  kPGPKeyTrust_Complete			= $6;
  kPGPKeyTrust_Ultimate			= $7;

  kPGPNameTrust_Mask			= $3;

  kPGPNameTrust_Unknown			= $0;
  kPGPNameTrust_Untrusted		= $1;
  kPGPNameTrust_Marginal 		= $2;
  kPGPNameTrust_Complete 		= $3;

type
  { Validity levels, used for thresholds in options }
  PGPValidity = PGPEnumType;
const
  kPGPValidity_Unknown	= kPGPNameTrust_Unknown;
  kPGPValidity_Invalid	= kPGPNameTrust_Untrusted;
  kPGPValidity_Marginal	= kPGPNameTrust_Marginal;
  kPGPValidity_Complete	= kPGPNameTrust_Complete;

type
  { Line endings types }
  PGPLineEndType = PGPEnumType;
const
  kPGPLineEnd_Default			= 0;
  kPGPLineEnd_LF			= 1;
  kPGPLineEnd_CR			= 2;
  kPGPLineEnd_CRLF = kPGPLineEnd_LF or kPGPLineEnd_CR;

type
  { Local encoding types: Only one of Force or Auto should be used, the other values are modifiers }
  TPGPLocalEncodingFlags = PGPFlags;
const
  kPGPLocalEncoding_None		= $00;
  kPGPLocalEncoding_Force		= $01;
  kPGPLocalEncoding_Auto		= $02;
  kPGPLocalEncoding_NoMacBinCRCOkay	= $04;

const
  kPGPMaxUserIDSize			= 255;
  kPGPMaxKeyIDStringSize		= 127;
  kPGPMaxFingerprintSize		= 063;
  kPGPMaxExportedKeyIDSize		= 033;
  kPGPMimeSeparatorSize			= 080;
type	// added or modified by idw
  pUserID = ^TUserID;
  TUserID = Array[0..kPGPMaxUserIDSize] of Char;
  pKeyID = ^TKeyID;
  TKeyID = Array[0..kPGPMaxKeyIDStringSize] of Char;
  pPGPKeyID = ^TPGPKeyID;
  TPGPKeyID = Array[0..kPGPMaxExportedKeyIDSize] of PGPByte;
  pFingerprint = ^TFingerprint;
  TFingerprint = Array[0..kPGPMaxFingerprintSize] of Byte;
  pMimeSeparator = ^TMimeSeparator;
  TMimeSeparator = Array[0..kPGPMimeSeparatorSize] of Char;

implementation

end.

