{$J+,Z4}
unit pgpBase;

{**********************************************************************************}
{                                                                                  }
{ The contents of this file are subject to the Mozilla Public License Version 1.1  }
{ (the "License"); you may not use this file except in compliance with the         }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/.    }
{                                                                                  }
{ Software distributed under the License is distributed on an "AS IS" basis,       }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the }
{ specific language governing rights and limitations under the License.            }
{                                                                                  }
{ The Original Code is the "Borland Delphi Runtime Library PGPsdk" released 10 Apr }
{ 2000, available at http://www.oz.net/~srheller/dpgp/sdk/.                        }
{                                                                                  }
{ The Initial Developer of the Original Code is Steven R. Heller.                  }
{                                                                                  }
{ Portions created by Steven R. Heller are Copyright (C) 2000 Steven R. Heller.    }
{ All Rights Reserved.                                                             }
{                                                                                  }
{ Contributor(s): Michael in der Wiesche <idw.doc@t-online.de> ("idw").            }
{                                                                                  }
{ The original file is pgpBase.pas based on pgpBase.h from the PGP sources         }
{ which are Copyright (C) Network Associates Inc. and affiliated companies.        }
{                                                                                  }
{ Modifications by "idw" (other than stated in the code below):                    }
{                                                                                  }
{**********************************************************************************}

interface

const	// added by idw
  PGPsdk650 = $03002000;
  PGPsdk700 = $02000000;
  MyVersion: String = 'N/A';
  ErrorMsg: PChar = nil;
  PGPsdkLib: PChar = nil;
  MainExitProc: Pointer = nil;

var	// added by idw
  hPGPsdkLib: Longint;

type
  PGPBoolean	  = Byte;	// can be TRUE (1) or FALSE (0)
  PGPInt8	  = Char;
  PGPUInt8	  = Byte;
  PGPInt16	  = Smallint;
  PGPUInt16	  = Word;
  PGPInt32	  = Longint;
  PGPUInt32	  = Longint;	// changed from Cardinal to Longint by idw
  PGPByte	  = PGPUInt8;
  PGPError	  = PGPInt32;
  PGPEnumType	  = Longint;	// added by idw
  PGPUserValue	  = Pointer;
  PGPSize	  = PGPUInt32;
  PGPFlags	  = PGPUInt32;
  PGPFileOffset	  = PGPInt32;
  PGPTime	  = PGPUInt32;
  PGPTimeInterval = PGPUInt32;	// in milliseconds

  pPChar	  = ^PChar;	// for those weird char** variables

  TPGPVersion = Record
    MajorVersion: PGPUInt16;
    MinorVersion: PGPUInt16;
  end;

const
  PGPFalse  = 0;
  PGPTrue   = 1;

var	// added by idw
  PGPsdkInit: function: PGPError; cdecl;
  PGPsdkCleanup: function: PGPError; cdecl;
  PGPGetSDKVersion: function(var Version: PGPUInt32): PGPUInt32; cdecl;

procedure ProcessMessages;	// added by idw
function PGP65X: Boolean;	// added by idw

implementation	// code added by idw

uses
  Windows,
  SysUtils;

procedure ProcessMessages;
var Msg: TMsg;
begin
  while PeekMessage(Msg, 0, 0, 0, PM_REMOVE) do begin
    TranslateMessage(Msg);
    DispatchMessage(Msg);
  end;
end;

function PGP65X: Boolean;
var Version: PGPUInt32;
begin
  Result:=(PGPGetSDKVersion(Version)=0) and (Version>=PGPsdk650);
end;

procedure PGPExitProc; far;
begin
  ExitProc:=MainExitProc;
  if ExitCode=ERROR_DLL_INIT_FAILED then MessageBox(0, ErrorMsg, 'PGP Components fatal error:', MB_ICONERROR);
end;

initialization

  MainExitProc:=ExitProc;
  ExitProc:=@PGPExitProc;

  PGPsdkLib:='PGP_SDK.dll';		// 6.X
  hPGPsdkLib:=LoadLibrary(PGPsdkLib);

  if hPGPsdkLib=0 then begin
    PGPsdkLib:='PGPSDK.dll';		// 5.X & 7.X
    hPGPsdkLib:=LoadLibrary(PGPsdkLib);
  end;

  if hPGPsdkLib=0 then begin
    ErrorMsg:='PGP Software Development Kit Core Library not found';
    Halt(ERROR_DLL_INIT_FAILED);
  end;

  PGPsdkInit:=GetProcAddress(hPGPsdkLib, 'PGPsdkInit');
  PGPsdkCleanup:=GetProcAddress(hPGPsdkLib, 'PGPsdkCleanup');
  PGPGetSDKVersion:=GetProcAddress(hPGPsdkLib, 'PGPGetSDKVersion');						// 5.X & 6.X
  if not Assigned(PGPGetSDKVersion) then PGPGetSDKVersion:=GetProcAddress(hPGPsdkLib, 'PGPGetPGPsdkVersion');	// 7.X


  PGPsdkInit;

  if not PGP65X then begin
    ErrorMsg:='Wrong PGP version: 6.5.X required';
    Halt(ERROR_DLL_INIT_FAILED);
  end;

finalization

  if Assigned(PGPsdkCleanup) then PGPsdkCleanup;

  if hPGPsdkLib<>0 then FreeLibrary(hPGPsdkLib);

end.

