{$J+,Z4}
unit PrefFuncs;

{------------------------------------------------------------------------------}
{                                                                              }
{       This unit is based on Steve Heller's spgpPreferences.pas from his      }
{         SPGP sources available from http://www.oz.net/~srheller/spgp/        }
{                                                                              }
{                Portions created by Michael in der Wiesche are                }
{                 Copyright (C) 2001 by Michael in der Wiesche                 }
{                                                                              }
{------------------------------------------------------------------------------}

interface

uses
  Windows,
  SysUtils,
  KeyPropTypes,
  KeyFuncs,
  pgpKeys,
  pgpCL,
  pgpSDKPrefs,
  pgpMemoryMgr,
  pgpUtilities,
  pgpErrors, pgpPubTypes, pgpBase;

const
  PrefsFlag_Default		= $00;
  PrefsFlag_PublicKeyring	= $01;
  PrefsFlag_PrivateKeyring	= $02;
  PrefsFlag_RandomSeedFile	= $04;
  PrefsFlag_DefaultKeyID	= $08;
  PrefsFlag_GroupsFile		= $10;

type
  pPreferenceRec = ^TPreferenceRec;
  TPreferenceRec = Record
    PublicKeyring: String;
    PrivateKeyring: String;
    RandomSeedFile: String;
    GroupsFile: String;
    DefaultKeyHexID: String;
  end;

function GetPreferences(var Prefs: TPreferenceRec; Flags: Integer): Integer;
function SetPreferences(const Prefs: TPreferenceRec; Flags: Integer): Integer;

implementation

function GetPreferences(var Prefs: TPreferenceRec; Flags: Integer): Integer;
var
  Context	: pPGPContext;
  FileSpec	: pPGPFileSpec;
  FileOut	: PChar;
  KeyOut	: PChar;
  PGPKeyID	: TPGPKeyID;
  IDSize	: PGPSize;
  KeyID		: TKeyID;
 begin
  Context := nil;
  FileSpec:=nil;
  FillChar(Prefs, SizeOf(Prefs), 0);
  Result:=PGPNewContext(kPGPsdkAPIVersion, Context);
  if Result<>0 then Exit;
  try
    Result:=PGPsdkLoadDefaultPrefs(Context);
    if Result<>0 then Exit;

    // Pubring
    if Flags and PrefsFlag_PublicKeyring<>0 then
    begin
      Result:=PGPsdkPrefGetFileSpec(Context, kPGPsdkPref_PublicKeyring, FileSpec);
      try
	if Result=0 then begin
	  FileOut:=nil;
	  Result:=PGPGetFullPathFromFileSpec(FileSpec, FileOut);
	  try
	    Prefs.PublicKeyring:=FileOut;
	  finally
	    PGPFreeData(FileOut);
	  end;
	end;
      finally
	PGPFreeFileSpec(FileSpec);
      end;
    end;
    if Result<>0 then Exit;

    // Secring
    if Flags and PrefsFlag_PrivateKeyring<>0 then
    begin
      Result:=PGPsdkPrefGetFileSpec(Context, kPGPsdkPref_PrivateKeyring, FileSpec);
      try
	if Result=0 then begin
	  FileOut:=nil;
	  Result:=PGPGetFullPathFromFileSpec(FileSpec, FileOut);
	  try
	    Prefs.PrivateKeyring:=FileOut;
	  finally
	    PGPFreeData(FileOut);
	  end;
	end;
      finally
	PGPFreeFileSpec(FileSpec);
      end;
    end;
    if Result<>0 then Exit;

    // Randseed file
    if Flags and PrefsFlag_RandomSeedFile<>0 then
    begin
      Result:=PGPsdkPrefGetFileSpec(Context, kPGPsdkPref_RandomSeedFile, FileSpec);
      try
	if Result=0 then begin
	  FileOut:=nil;
	  Result:=PGPGetFullPathFromFileSpec(FileSpec, FileOut);
	  try
	    Prefs.RandomSeedFile:=FileOut;
	  finally
	    PGPFreeData(FileOut);
	  end;
	end;
      finally
	PGPFreeFileSpec(FileSpec);
      end;
    end;
    if Result<>0 then Exit;

    // Groups file
    if Flags and PrefsFlag_GroupsFile<>0 then
    begin
      Result:=PGPsdkPrefGetFileSpec(Context, kPGPsdkPref_GroupsFile, FileSpec);
      try
	if Result=0 then begin
	  FileOut:=nil;
	  Result:=PGPGetFullPathFromFileSpec(FileSpec, FileOut);
	  try
	    Prefs.GroupsFile:=FileOut;
	  finally
	    PGPFreeData(FileOut);
	  end;
	end;
      finally
	PGPFreeFileSpec(FileSpec);
      end;
    end;
    if Result<>0 then Exit;

    // Private key
    if Flags and PrefsFlag_DefaultKeyID<>0 then
    begin
      KeyOut:=nil;
      Result:=PGPsdkPrefGetData(Context, kPGPsdkPref_DefaultKeyID, @KeyOut, IDSize);
      if Result<>0 then Exit;
      try
	Result:=PGPImportKeyID(KeyOut, PGPKeyID);
      finally
	PGPFreeData(KeyOut);
      end;
      if Result<>0 then Exit;
      Result:=PGPGetKeyIDString(PGPKeyID, kPGPKeyIDString_Abbreviated, KeyID);
      if Result=0 then Prefs.DefaultKeyHexID:=KeyID;
    end;
  finally
    PGPFreeContext(Context);
  end;
end;

function SetPreferences(const Prefs: TPreferenceRec; Flags: Integer): Integer;
var
  Context	: pPGPContext;
  FileSpec	: pPGPFileSpec;
  KeyPropsList	: TKeyPropsList;
  MainKeySet	: pPGPKeySet;
  Key		: pPGPKey;
  KeyIn		: TPGPKeyID;
  PGPKeyID	: TPGPKeyID;
  IDSize	: PGPSize;
begin
  Context:=nil;
  FileSpec:=nil;
  Result:=PGPNewContext(kPGPsdkAPIVersion, Context);
  if Result<>0 then Exit;
  try
    Result:=PGPsdkLoadDefaultPrefs(Context);
    if Result<>0 then Exit;

    // Pubring
    if Flags and PrefsFlag_PublicKeyring<>0 then begin
      if not FileExists(Prefs.PublicKeyring) then begin
	Result:=kPGPError_FileNotFound;
	Exit;
      end;
      Result:=PGPNewFileSpecFromFullPath(Context, PChar(Prefs.PublicKeyring), FileSpec);
      try
	if Result=0 then Result:=PGPsdkPrefSetFileSpec(Context, kPGPsdkPref_PublicKeyring, FileSpec);
	if Result<>0 then Exit;
      finally
	PGPFreeFileSpec(FileSpec);
      end;
    end;

    // Secring
    if Flags and PrefsFlag_PrivateKeyring<>0 then begin
      if not FileExists(Prefs.PrivateKeyring) then begin
	Result:=kPGPError_FileNotFound;
	Exit;
      end;
      Result:=PGPNewFileSpecFromFullPath(Context, PChar(Prefs.PrivateKeyring), FileSpec);
      try
	if Result=0 then Result:=PGPsdkPrefSetFileSpec(Context, kPGPsdkPref_PrivateKeyring, FileSpec);
	if Result<>0 then Exit;
      finally
	PGPFreeFileSpec(FileSpec);
      end;
    end;

    // Randseed file
    if Flags and PrefsFlag_RandomSeedFile<>0 then begin
      if not FileExists(Prefs.RandomSeedFile) then begin
	Result:=kPGPError_FileNotFound;
	Exit;
      end;
      Result:=PGPNewFileSpecFromFullPath(Context, PChar(Prefs.RandomSeedFile), FileSpec);
      try
	if Result=0 then Result:=PGPsdkPrefSetFileSpec(Context, kPGPsdkPref_RandomSeedFile, FileSpec);
	if Result<>0 then Exit;
      finally
	PGPFreeFileSpec(FileSpec);
      end;
    end;

    // Groups file
    if Flags and PrefsFlag_GroupsFile<>0 then begin
      if not FileExists(Prefs.GroupsFile) then begin
	Result:=kPGPError_FileNotFound;
	Exit;
      end;
      Result:=PGPNewFileSpecFromFullPath(Context, PChar(Prefs.GroupsFile), FileSpec);
      try
	if Result=0 then Result:=PGPsdkPrefSetFileSpec(Context, kPGPsdkPref_GroupsFile, FileSpec);
	if Result<>0 then Exit;
      finally
	PGPFreeFileSpec(FileSpec);
      end;
    end;

    // Private key
    if Flags and PrefsFlag_DefaultKeyID<>0 then begin
      KeyPropsList:=nil;
      if FindKeyProps(Prefs.DefaultKeyHexID, KeyPropsList, 0, KeyFilterFlag_CanSign, Any_Ordering)=1 then begin
	Result:=PGPOpenDefaultKeyRings(Context, 0, MainKeySet);
	if Result<>0 then Exit;
	Result:=GetKeyByHexID(MainKeySet, Prefs.DefaultKeyHexID, Key);
	if Result<>0 then Exit;
	Result:=PGPGetKeyIDFromString(PChar(Prefs.DefaultKeyHexID), KeyIn);
	if Result<>0 then Exit;
	Result:=PGPExportKeyID(@KeyIn, PGPKeyID, IDSize);
	if Result<>0 then Exit;
	Result:=PGPsdkPrefSetData(Context, kPGPsdkPref_DefaultKeyID, @PGPKeyID, IDSize);
	if Result<>0 then Exit;
      end
      else Result:=kPGPError_SecretKeyNotFound;
      if Result<>0 then Exit;
    end;
    Result:=PGPsdkSavePrefs(Context);
    if Result=0 then begin
      PGPclNotifyKeyringChanges(GetCurrentProcessID);
      PGPclNotifyPrefsChanges(GetCurrentProcessID);
    end;
  finally
    PGPFreeContext(Context);
  end;
end;

end.

