////////////////////////////////////////////////////////////////////////////////
// PAGECONTROL98                                                              //
////////////////////////////////////////////////////////////////////////////////
// Enhanced PageControl for D2 & D3                                           //
// * Image List, Right & Left Tabs, ...                                       //
////////////////////////////////////////////////////////////////////////////////
// Version 1.80 Beta                                                          //
// Date de cration           : 10/03/1997                                    //
// Date dernire modification : 22/09/1997                                    //
////////////////////////////////////////////////////////////////////////////////
// Jean-Luc Mattei                                                            //
// jlucm@club-internet.fr  / jlucm@mygale.org                                 //
////////////////////////////////////////////////////////////////////////////////
//  REVISIONS :                                                               //
//                                                                            //
//  1.0 :                                                                     //
//        * Added .DCR                                                        //
//  1.1 : * CommCtrlEx.pas included (for D2)                                  //
//        * TNMCustomDraw Ok (for D2)                                         //
//  1.2 : * Added FlatButtons style (IE4 installed only)                      //
//  1.3 : * Added MeasureItem                                                 //
//        * Added Image drawing                                               //
//  1.4 : * CommCtrlEx Modified for D2 (thanks to Gerhard Volk)               //
//        * TDrawTabEvent, TMeasureTabEvent Pagre parameter changed from      //
//          TPageControl to TPageControl98 (thanks to Marcus Monnig)          //
//  1.5 : * CustomPageControl98 allows hidden properties                      //
//        * TTabSheet98 allows selecting imageindex for a page                //
//        * ENGLISH and FRANCAIS compiler directive for messages langage      //
//  1.60 : * Removed unused properties                                        //
//         * Some declaration modified for D2 compatibility                   //
//           (thanks to Gerhard Volk - again - for all the tests :-))         //
//         * Unified version number                                           //
//  1.70 : * See TabControl98 for changes                                     //
//         * Disabled Pages Painting (Roger Misteli)                          //
//         * Disabled Pages can't be selected now (Roger Misteli)             //
//         * TabSheet98 has a Color property now                              //
//  1.80 : * New DrawTab Painting method to avoid strange borders             //
//         * LockWindowUpdate removed to avoid entire screen flickering       //
//         * PageHint for each Page                                           //
//         * No more "PageIndex invalid" message when Position is left / right//
//         * Font can be choosen for each Tab (TabFont property)              //
//         * New Paint method for "colorized" Pages                           //
//         * TTabShhet SetImageIndex modified to correctly handle imageindex  //
//           when some pages are not visible (thanks to Fred Covely)          //
////////////////////////////////////////////////////////////////////////////////

{$define FRANCAIS}
//{$define ENGLISH}

unit PageControl98;

interface

{$R *.DCR}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Forms, Controls, Dialogs,
  CommCtrl, ComCtrls, TabControl98 {$ifdef VER100}, ComCtl98 {$else}, CommCtrlEx {$endif};

type

  TCustomPageControl98 = class;

  TTabSheet98 = class(TWinControl)
  private
    FPageControl: TCustomPageControl98;
    FTabVisible: Boolean;
    FTabShowing: Boolean;
    FImageIndex: Integer;
    FTabFont: TFont;
    procedure SetImageIndex(Value: Integer);
    function GetPageIndex: Integer;
    function GetTabIndex: Integer;
    procedure SetPageControl(APageControl: TCustomPageControl98);
    procedure SetPageIndex(Value: Integer);
    procedure SetTabShowing(Value: Boolean);
    procedure SetTabVisible(Value: Boolean);
    procedure UpdateTabShowing;
    function  GetColor: TColor;
    procedure SetColor(Value: TColor);
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
    Procedure setTabFont(Value: TFont);
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure ReadState(Reader: TReader); override;
    procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property PageControl: TCustomPageControl98 read FPageControl write SetPageControl;
    property TabIndex: Integer read GetTabIndex;
  published
    property Color: TColor read GetColor write SetColor;
    property Caption;
    property Enabled;
    property Font;
    property TabFont: TFont read FTabFont write SetTabFont;
    property Hint;
    property Height stored False;
    property ImageIndex: Integer read FImageIndex write SetImageIndex;
    property Left stored False;
    property PageIndex: Integer read GetPageIndex write SetPageIndex stored False;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabVisible: Boolean read FTabVisible write SetTabVisible default True;
    property Top stored False;
    property Visible stored False;
    property Width stored False;
    property OnDragDrop;
    property OnDragOver;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

  TCustomPageControl98 = class(TCustomTabControl98)
  private
    FPages: TList;
    FActivePage: TTabSheet98;
    FLastOne: TTabSheet98;
    procedure ChangeActivePage(Page: TTabSheet98);
    procedure DeleteTab(Page: TTabSheet98);
    function GetPage(Index: Integer): TTabSheet98;
    function GetPageCount: Integer;
    procedure InsertPage(Page: TTabSheet98);
    procedure InsertTab(Page: TTabSheet98);
    procedure MoveTab(CurIndex, NewIndex: Integer);
    procedure RemovePage(Page: TTabSheet98);
    procedure SetActivePage(Page: TTabSheet98);
    procedure UpdateTab(Page: TTabSheet98);
    procedure UpdateActivePage;
    procedure CMDesignHitTest(var Message: TCMDesignHitTest); message CM_DESIGNHITTEST;
    procedure CMDialogKey(var Message: TCMDialogKey); message CM_DIALOGKEY;
    procedure CNNotify(var Message: TWMNotify); message CN_NOTIFY;
    procedure WMNotify(var Message: TWMNotify); message WM_NOTIFY;
  protected
    procedure SetTabPosition (Value: TTabPosition); override;
    procedure Change; override;
    procedure GetChildren(Proc: TGetChildProc {$ifdef VER100}; Root: TComponent {$endif}); override;
    procedure SetChildOrder(Child: TComponent; Order: Integer); override;
    procedure ShowControl(AControl: TControl); override;
    procedure AssociateImages; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function FindNextPage(CurPage: TTabSheet98;
      GoForward, CheckTabVisible: Boolean): TTabSheet98;
    procedure SelectNextPage(GoForward: Boolean);
    property PageCount: Integer read GetPageCount;
    property Pages[Index: Integer]: TTabSheet98 read GetPage;
    property ActivePage: TTabSheet98 read FActivePage write SetActivePage;
  end;

  TPageControl98 = class(TCustomPageControl98)
  published
    property Color;
    property DefaultDrawing;
    property DrawStyle;
    property Images;
    property MultiSelect;
    property TabPosition;
    {$ifndef VER100}
    property TabType;
    {$endif}
    property TabStyle;
    property TabJustification;
    property OnDrawTab;
    property OnMeasureTab;
    property OnGetTabColor;

    property ActivePage;
    property Align;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property HotTrack;
    property MultiLine;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    {$ifdef VER100}
    property ScrollOpposite;
    {$endif}
    property ShowHint;
    property TabHeight;
    property TabOrder;
    property TabStop;
    property TabWidth;
    property Visible;
    property OnChange;
    property OnChanging;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
  end;

procedure Register;

implementation

Uses DsgnIntf, TypInfo;

const

  {$ifdef ENGLISH}
  SPage98IndexError = 'Sheet index Error';
  StrAddPage = 'New Sheet';
  StrNextPage = 'Next Sheet';
  StrPrevPage = 'Prev Sheet';
  {$endif}

  {$ifdef FRANCAIS}
  SPage98IndexError = 'Index de page incorect';
  StrAddPage = 'Nouvelle page';
  StrNextPage = 'Page suivante';
  StrPrevPage = 'Page prcdente';
  {$endif}

type

  { TActivePage98Property }
  TActivePage98Property = class(TComponentProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TActivePage98Property.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList];
end;

procedure TActivePage98Property.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Component: TComponent;
begin
  for I := 0 to Designer.Form.ComponentCount - 1 do
  begin
    Component := Designer.Form.Components[I];
    if (Component.Name <> '') and (Component is TTabSheet98) and
      (TTabSheet98(Component).PageControl = GetComponent(0)) then
      Proc(Component.Name);
  end;
end;

{ TPageControl98Editor }

type
  TPageControl98Editor = class(TDefaultEditor)
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

procedure TPageControl98Editor.ExecuteVerb(Index: Integer);
var
  PageControl: TCustomPageControl98;
  Page: TTabSheet98;
  Designer: TFormDesigner;
begin
  if Component is TTabSheet98 then
    PageControl := TTabSheet98(Component).PageControl else
    PageControl := TPageControl98(Component);
  if PageControl <> nil then
  begin
    Designer := Self.Designer;
    if Index = 0 then
    begin
      Page := TTabSheet98.Create(Designer.Form);
      try
        Page.Name := Designer.UniqueName(TTabSheet98.ClassName);
        Page.Parent := PageControl;
        Page.PageControl := PageControl;
      except
        Page.Free;
        raise;
      end;
      PageControl.ActivePage := Page;
      Designer.SelectComponent(Page);
      Designer.Modified;
    end else
    begin
      Page := PageControl.FindNextPage(PageControl.ActivePage,
        Index = 1, False);
      if (Page <> nil) and (Page <> PageControl.ActivePage) then
      begin
        PageControl.ActivePage := Page;
        if Component is TTabSheet98 then Designer.SelectComponent(Page);
        Designer.Modified;
      end;
    end;
  end;
end;

function TPageControl98Editor.GetVerb(Index: Integer): string;
begin
  case Index of
    0 : Result:= StrAddPage;
    1 : Result:= StrNextPage;
    2 : Result:= StrPrevPage;
  end;
end;

function TPageControl98Editor.GetVerbCount: Integer;
begin
  Result := 3;
end;

procedure Register;
begin
  RegisterComponents('Exemples', [TPageControl98]);
  RegisterClasses([TTabSheet98]);
  RegisterComponentEditor(TPageControl98, TPageControl98Editor);
  RegisterComponentEditor(TTabSheet98, TPageControl98Editor);
  RegisterPropertyEditor(TypeInfo(TTabSheet98), TPageControl98, 'ActivePage', TActivePage98Property);
end;

{ TTabSheet98 }

constructor TTabSheet98.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Align := alClient;
  ControlStyle := ControlStyle + [csAcceptsControls, csNoDesignVisible, csOpaque] - [csFramed];
  Visible := False;
  FTabVisible := True;
  FImageIndex:= -1;
  FTabFont:= TFont.Create;
  FTabFont.Name:= 'Arial';
end;

procedure TTabSheet98.SetTabFont(Value: TFont);
begin
  FTabFont.Assign(Value);
end;

procedure TTabSheet98.SetImageIndex(Value: Integer);
begin
if ( PageControl is TCustomPageControl98 ) then begin
FImageIndex:= Value;
with ( PageControl as TCustomPageControl98 ) do begin
if ( PageIndex >= 0 ) and ( PageIndex < PageCount ) then
         // Modifi par Fred Covely - Gestion des images correcte avec pages invisibles
Image[Self.TabIndex]:= FImageIndex;
end;
   end
end;

destructor TTabSheet98.Destroy;
begin
  if FPageControl <> nil then FPageControl.RemovePage(Self);
  inherited Destroy;
end;

function TTabSheet98.GetPageIndex: Integer;
begin
  if FPageControl <> nil then
    Result := FPageControl.FPages.IndexOf(Self) else
    Result := -1;
end;

function TTabSheet98.GetTabIndex: Integer;
var
  I: Integer;
begin
  Result := 0;
  if not FTabShowing then Dec(Result) else
    for I := 0 to PageIndex - 1 do
      if TTabSheet98(FPageControl.FPages[I]).FTabShowing then
        Inc(Result);
end;

procedure TTabSheet98.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params.WindowClass do
    style := style and not (CS_HREDRAW or CS_VREDRAW);
end;

procedure TTabSheet98.ReadState(Reader: TReader);
begin
  inherited ReadState(Reader);
  if Reader.Parent is TCustomPageControl98 then
    PageControl := TCustomPageControl98(Reader.Parent);
end;

procedure TTabSheet98.WMPaint(var Message: TWMPaint);
var
  R: TRect;
  Dc: HDC;
begin
  R:= BoundsRect;
  Dc:= GetWindowDC(FPageControl.Handle);
  case FPageControl.TabPosition of
    tpTop    : InflateRect(R, 2, 2);
    tpBottom : begin
                 OffsetRect(R, 0, -2);
                 InflateRect(R, 2, 2);
               end;
    tpLeft   : begin
                 OffsetRect(R, 0, -2);
                 InflateRect(R, 0, 2);
                 R.Right:= R.Right + 2;
                 R.Bottom:= R.Bottom + 2;
               end;
    tpRight  : begin
                 OffsetRect(R, 0, -2);
                 InflateRect(R, 2, 2);
                 R.Right:= R.Right - 2;
                 R.Bottom:= R.Bottom + 2;
               end;
  end;
  FillRect(Dc, R, Brush.Handle);
  ReleaseDC(FPageControl.Handle, Dc);
  inherited;
end;

procedure TTabSheet98.SetPageControl(APageControl: TCustomPageControl98);
begin
  if FPageControl <> APageControl then
  begin
    if FPageControl <> nil then FPageControl.RemovePage(Self);
    Parent := APageControl;
    if APageControl <> nil then APageControl.InsertPage(Self);
  end;
end;

procedure TTabSheet98.SetPageIndex(Value: Integer);
var
  I, MaxPageIndex: Integer;
begin
  if FPageControl <> nil then
  begin
    MaxPageIndex := FPageControl.FPages.Count - 1;
    if Value > MaxPageIndex then
      raise EListError.CreateFmt(SPage98IndexError, [Value, MaxPageIndex]);
    I := TabIndex;
    FPageControl.FPages.Move(PageIndex, Value);
    if I >= 0 then FPageControl.MoveTab(I, TabIndex);
  end;
end;

procedure TTabSheet98.SetTabShowing(Value: Boolean);
begin
  if FTabShowing <> Value then
    if Value then
    begin
      FTabShowing := True;
      FPageControl.InsertTab(Self);
    end else
    begin
      FPageControl.DeleteTab(Self);
      FTabShowing := False;
    end;
end;

procedure TTabSheet98.SetTabVisible(Value: Boolean);
begin
  if FTabVisible <> Value then
  begin
    FTabVisible := Value;
    UpdateTabShowing;
  end;
end;

procedure TTabSheet98.UpdateTabShowing;
begin
  SetTabShowing((FPageControl <> nil) and FTabVisible);
end;

procedure TTabSheet98.CMTextChanged(var Message: TMessage);
begin
  if FTabShowing then FPageControl.UpdateTab(Self);
end;

function TTabSheet98.GetColor: TColor;
begin
  Result:= Brush.Color;
end;

procedure TTabSheet98.SetColor(Value: TColor);
begin
  Brush.Color:= Value;
  Invalidate;
end;

{ TCustomPageControl98 }

constructor TCustomPageControl98.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := [csDoubleClicks];
  FPages := TList.Create;
end;

destructor TCustomPageControl98.Destroy;
var
  I: Integer;
begin
  for I := 0 to FPages.Count - 1 do TTabSheet98(FPages[I]).FPageControl := nil;
  FPages.Free;
  inherited Destroy;
end;

procedure TCustomPageControl98.Change;
var
  Form: {$ifdef VER100} TCustomForm {$else} TForm {$endif};
begin
  UpdateActivePage;
  if csDesigning in ComponentState then
  begin
    Form := GetParentForm(Self);
    if (Form <> nil) and (Form.Designer <> nil) then Form.Designer.Modified;
  end;
  inherited Change;
end;

procedure TCustomPageControl98.ChangeActivePage(Page: TTabSheet98);
var
  ParentForm: {$ifdef VER100} TCustomForm {$else} TForm {$endif};
begin
  if FActivePage <> Page then
  begin
    ParentForm := GetParentForm(Self);
    if (ParentForm <> nil) and (FActivePage <> nil) and
      FActivePage.ContainsControl(ParentForm.ActiveControl) then
      ParentForm.ActiveControl := FActivePage;
    if Page <> nil then
    begin
      Page.BringToFront;
      Page.Visible := True;
      if (ParentForm <> nil) and (FActivePage <> nil) and
        (ParentForm.ActiveControl = FActivePage) then
        if Page.CanFocus then
          ParentForm.ActiveControl := Page else
          ParentForm.ActiveControl := Self;
    end;
    if FActivePage <> nil then FActivePage.Visible := False;
    FActivePage := Page;
    if (ParentForm <> nil) and (FActivePage <> nil) and
      (ParentForm.ActiveControl = FActivePage) then
      FActivePage.SelectFirst;
  end;
end;

procedure TCustomPageControl98.DeleteTab(Page: TTabSheet98);
begin
  Tabs.Delete(Page.TabIndex);
  UpdateActivePage;
end;

function TCustomPageControl98.FindNextPage(CurPage: TTabSheet98;
  GoForward, CheckTabVisible: Boolean): TTabSheet98;
var
  I, StartIndex: Integer;
begin
  if FPages.Count <> 0 then
  begin
    StartIndex := FPages.IndexOf(CurPage);
    if StartIndex = -1 then
      if GoForward then StartIndex := FPages.Count - 1 else StartIndex := 0;
    I := StartIndex;
    repeat
      if GoForward then
      begin
        Inc(I);
        if I = FPages.Count then I := 0;
      end else
      begin
        if I = 0 then I := FPages.Count;
        Dec(I);
      end;
      Result := FPages[I];
      if not CheckTabVisible or Result.TabVisible then Exit;
    until I = StartIndex;
  end;
  Result := nil;
end;

procedure TCustomPageControl98.GetChildren(Proc: TGetChildProc {$ifdef VER100}; Root: TComponent {$endif});
var
  I: Integer;
begin
  for I := 0 to FPages.Count - 1 do Proc(TComponent(FPages[I]));
end;

function TCustomPageControl98.GetPage(Index: Integer): TTabSheet98;
begin
  Result := FPages[Index];
end;

function TCustomPageControl98.GetPageCount: Integer;
begin
  Result := FPages.Count;
end;

procedure TCustomPageControl98.InsertPage(Page: TTabSheet98);
begin
  FPages.Add(Page);
  Page.FPageControl := Self;
  Page.UpdateTabShowing;
end;

procedure TCustomPageControl98.InsertTab(Page: TTabSheet98);
begin
  Tabs.InsertObject(Page.TabIndex, Page.Caption, Page);
  UpdateActivePage;
end;

procedure TCustomPageControl98.MoveTab(CurIndex, NewIndex: Integer);
begin
  Tabs.Move(CurIndex, NewIndex);
end;

procedure TCustomPageControl98.RemovePage(Page: TTabSheet98);
begin
  if FActivePage = Page then SetActivePage(nil);
  Page.SetTabShowing(False);
  Page.FPageControl := nil;
  FPages.Remove(Page);
end;

procedure TCustomPageControl98.SelectNextPage(GoForward: Boolean);
var
  Page: TTabSheet98;
begin
  Page := FindNextPage(ActivePage, GoForward, True);
  if (Page <> nil) and (Page <> ActivePage) and CanChange then
  begin
    TabIndex := Page.TabIndex;
    Change;
  end;
end;

procedure TCustomPageControl98.SetActivePage(Page: TTabSheet98);
begin
  if (Page <> nil) and (Page.PageControl <> Self) then Exit;
  ChangeActivePage(Page);
  if Page <> nil then TabIndex := Page.TabIndex else TabIndex := -1;
end;

procedure TCustomPageControl98.SetChildOrder(Child: TComponent; Order: Integer);
begin
  TTabSheet98(Child).PageIndex := Order;
end;

procedure TCustomPageControl98.ShowControl(AControl: TControl);
begin
  if (AControl is TTabSheet98) and (TTabSheet98(AControl).PageControl = Self) then
    SetActivePage(TTabSheet98(AControl));
  inherited ShowControl(AControl);
end;

procedure TCustomPageControl98.UpdateTab(Page: TTabSheet98);
begin
  Tabs[Page.TabIndex] := Page.Caption;
end;

procedure TCustomPageControl98.UpdateActivePage;
begin
  if TabIndex >= 0 then SetActivePage(TTabSheet98(Tabs.Objects[TabIndex]));
end;

procedure TCustomPageControl98.CMDesignHitTest(var Message: TCMDesignHitTest);
var
  HitIndex: Integer;
  HitTestInfo: TTCHitTestInfo;
begin
  HitTestInfo.pt := SmallPointToPoint(Message.Pos);
  HitIndex := SendMessage(Handle, TCM_HITTEST, 0, Longint(@HitTestInfo));
  if (HitIndex >= 0) and (HitIndex <> TabIndex) then Message.Result := 1;
end;

procedure TCustomPageControl98.CMDialogKey(var Message: TCMDialogKey);
begin
  if (Message.CharCode = VK_TAB) and (GetKeyState(VK_CONTROL) < 0) then
  begin
    SelectNextPage(GetKeyState(VK_SHIFT) >= 0);
    Message.Result := 1;
  end else
    inherited;
end;

procedure TCustomPageControl98.AssociateImages;
Var
  i: Integer;
begin
  for i:= 0 to PageCount - 1 do begin
    if ( Pages[i].ImageIndex < Images.Count ) then
      Image[i]:= Pages[i].ImageIndex;
  end;
end;

procedure TCustomPageControl98.SetTabPosition (Value: TTabPosition);
Var Keep: Integer;
begin
  if HandleAllocated and ( Value <> TabPosition ) and ( ( Value = tpLeft ) or ( Value = tpRight )) then begin
    inherited SetTabPosition(Value);
    (*Keep:= ActivePage.PageIndex;
    if ( ( Keep + 1 ) < PageCount ) then
      ActivePage:= Pages[Keep+1]
    else
      if ( ( Keep - 1 ) >= 0 ) then
        ActivePage:= Pages[Keep-1];
    ActivePage:= Pages[Keep];*)
  end
  else
    inherited SetTabPosition(Value);
end;

procedure TCustomPageControl98.WMNotify(var Message: TWMNotify);
var
  HitIndex: Integer;
  HitTestInfo: TTCHitTestInfo;
begin
  with Message.NMHdr^ do
    case code of
      TTN_NEEDTEXT:
        with Message do begin
          Windows.GetCursorPos(HitTestInfo.pt);
          HitTestInfo.pt:= ScreenToClient(HitTestInfo.pt);
          HitIndex:= SendMessage(Handle, TCM_HITTEST, 0, Longint(@HitTestInfo));
          if (HitIndex <> -1) and (Pages[HitIndex].Hint <> '') then
            strPCopy(PToolTipText(NMHdr)^.lpszText,Pages[HitIndex].Hint)
          else
            strPCopy(PToolTipText(NMHdr)^.lpszText,Hint);
          PToolTipText(NMHdr)^.hInst := 0;
          SetWindowPos(NMHdr^.hwndFrom, HWND_TOP, 0, 0, 0, 0, SWP_NOACTIVATE or
          SWP_NOSIZE or SWP_NOMOVE);
          Result := 1;
        end;
      NM_HOVER :
        begin
          MessageBeep(MB_Ok);
        end;
    end;
end;

procedure TCustomPageControl98.CNNotify(var Message: TWMNotify);
Var
  Pt: TPoint;
begin
  with Message.NMHdr^ do
    case code of
      TCN_SELCHANGE:   begin
                         Change;
                         if not ActivePage.Enabled then
                           ActivePage:=FLastOne;
                         //LockWindowUpdate(0);
                       end;
      TCN_SELCHANGING: begin
                         Message.Result := 1;
                         if CanChange then
                           Message.Result := 0;
                         FLastOne:=ActivePage;
                         //LockWindowUpdate(Handle);
                       end;
      NM_HOVER :
        begin
          MessageBeep(MB_Ok);
        end;
    end;
end;

end.
