unit PCVURLLabel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ShellApi,Classe;

type
  TPCVLabelURL = class(TLabel)
  private
    FOverColor : TColor;
    FOverUnderline : Boolean;
    TmpColor : TColor;
    TmpUnderLine : Boolean;
    FUrl : String;
    FExecURL:Boolean;
    Tmp,xMask : TBitmap;
    FFont:TFont;
    ReCaption:Boolean;
    FCaption:TCaption;
    procedure SetOverColor(value : TColor);
    procedure SetOverUnderline(value : Boolean);
  protected
    procedure DoMouseEnter(var Message:TMessage); message cm_MouseEnter;
    procedure DoMouseLeave(var Message:TMessage); message cm_MouseLeave;
    procedure Click;override;
  public
    constructor Create(AOwner:TComponent);override;
  published
    property ColorOver : TColor read FOverColor
                                write SetOverColor;
    property UnderlineOver : Boolean read FOverUnderline
                                     write SetOverUnderLine;

    property URL : String read FURL write FURL;
    property ExecURL:Boolean read FExecURL write FExecURL default TRUE;
  end;

const
     crHandCur = 10;

{$R Cursors.res}

implementation

constructor TPCVLabelURL.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);
  FOverColor:=clRed;
  FOverUnderline:=True;
  ExecURL:=True;
  AutoSize:=True;
  Font.Color:=clBlue;
  Font.Name:='Arial';
  Font.Size:=10;
  Font.Style:=[fsBold];

  Caption:='PCV Homepage';
  FUrl := 'http://www.pcv.go.ro';

  Screen.Cursors[crHandCur]:=LoadCursor(HInstance,'PCVHand');
  Cursor:=crHandCur;
  TmpColor:=Font.Color;
end;

procedure TPCVLabelURL.DoMouseEnter(var Message:TMessage);
begin            
  TmpColor:=Font.Color;
  Font.Color:=FOverColor;
  if not (fsUnderline in Font.Style) and FOverUnderline then
   Font.Style:=Font.Style + [fsUnderline];
end;

procedure TPCVLabelURL.DoMouseLeave(var Message:TMessage);
begin
  Font.Color:=TmpColor;
  if FOverUnderline then
   Font.Style:=Font.Style - [fsUnderline];
end;

procedure TPCVLabelURL.Click;
var Link,S1,S2 : String;
begin
  Link:=FURL+#0;
  S1:=''+#0;
  S2:=''+#0;
  if FExecURL then
     ShellExecute(Application.Handle,nil,@Link[1],@S1[1],@S2[1],SW_Show);
  Inherited Click;
end;

procedure TPCVLabelURL.SetOverColor(value : TColor);
begin
  FOverColor:=value;
  Paint;
end;

procedure TPCVLabelURL.SetOverUnderline(value : Boolean);
begin
  FOverUnderLine := value;
  if fsUnderLine in Font.Style then
     Font.Style:=Font.Style-[fsUnderline];
{  Paint;}
end;

end.
