unit PCVSliderPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs,ExtCtrls,Classe;

type
  TDirections = (DownToUp,UpToDown);
  TSlideAllignment = (saLeft,saCenter,saRight);
  T3DStyle = (Lowered,Normal,Raised);
  TPCVSliderPanel = class(TGraphicControl)
  private
     FTextStyle:T3DStyle;
     FHighLightColor : TColor;
     
     FColor : TColor;
     FDirection : TDirections;
     xMask,Tmp : TBitmap;
     SliderFont : TFont;
     FInterval : LongInt;
     FStep : LongInt;
     FActive : Boolean;
     PosY : LongInt;
     isTransp,FTransparent : Boolean;
     SliderTimer : TTimer;
     RR : TRect;
     FLines : TStrings;
     FTextAlign : TSlideAllignment;
     TmpRect : TRect;
     procedure SetDirection(value : TDirections);
     procedure SetSliderColor(value : TColor);
     procedure SetSliderInterval(value : LongInt);
     procedure SetSliderStep(value : LongInt);
     procedure SetSliderActive(value : Boolean);
     procedure SetSliderTransparent(value : Boolean);
     procedure StartSlider(sender : TObject);
     procedure SetTextAlign(value : TSlideAllignment);
     procedure SetHighLightColor(value : TColor);
     procedure SetTextStyle(value : T3DStyle);
     procedure Draw3DText(Canvas : TCanvas;x,y,pos:LongInt);
     procedure SetLines(value : TStrings);
     procedure DrawSliderPanel;
     procedure SetXMask;
  protected
     procedure Paint;override;
     procedure RePaint;override;
  public
    constructor Create(AOwner:TComponent);override;
    destructor Destroy;override;
  published
    property Direction : TDirections read FDirection write SetDirection;
    property Color : TColor read FColor write SetSliderColor;
    property Active : Boolean read FActive write SetSliderActive;
    property Interval : LongInt read FInterval  write SetSliderInterval;
    property Step : LongInt read FStep write SetSliderStep;
    property Transparent : Boolean read FTransparent write SetSliderTransparent;
    property Lines : TStrings read FLines write SetLines;
    property TextAlign : TSlideAllignment read FTextAlign write SetTextAlign;
    property TextStyle : T3DStyle read FTextStyle write SetTextStyle;
    property HighlightColor : TColor read FHighLightColor write SetHighLightColor;
    property Font;
  end;

implementation

constructor TPCVSliderPanel.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);
  Canvas.Font:=Font;
  Width:=150;
  Height:=70;

  Tmp:=TBitmap.Create;
  xMask:=TBitmap.Create;

  FLines:=TStringList.Create;
  FLines.Add('PCV');
  FLines.Add('Slider');
  FLines.Add('Panel');

  FActive:=FALSE;
  FInterval:=50;
  FStep := 2;
  FColor:=clBtnFace;
  FTransparent:=FALSE;
  PosY:=0;
  FDirection:=DownToUp;
  FTextAlign:=saCenter;

  FTextStyle:=Raised;
  FHighlightColor:=clWhite;

  SliderTimer:=TTimer.Create(Self);
  SliderTimer.Interval:=FInterval;
  SliderTimer.Enabled:=False;
  SliderTimer.OnTimer:=StartSlider;

end;

procedure TPCVSliderPanel.RePaint;
begin
  isTransp:=FTransparent;
  inherited RePaint;
end;

procedure TPCVSliderPanel.Paint;
begin
  DrawSliderPanel;
end;

procedure TPCVSliderPanel.DrawSliderPanel;
var R,R2:TRect;
    TmpMask,FStore : TBitMap;
    i : Integer;
    Col:TColor;
begin
  if FLines.Count <0 then Exit;
  R:=ClientRect;
  R2:=ClientRect;
  Canvas.Font:=Font;

  With Tmp.Canvas do
     begin
       Font.Assign(Self.Canvas.Font);
       Col:=Font.Color;
       Brush.Color:=FColor;
       Tmp.Width:=R2.Right - R2.Left;
       Tmp.Height:=R2.Bottom - R2.Top;
       R:=Rect(0,0,Tmp.Width,Tmp.Height);
       FillRect(R);
       Brush.Style:=bsClear;
       for i:=0 to FLines.Count - 1  do
       begin
          Case FTextStyle of
              Lowered : begin
                          Font.Color:=FHighLightColor;
                          Draw3DText(Tmp.Canvas,1,PosY+1,i);
                          Font.Color:=Col;
                        end;
                        
              Raised  : begin
                          Font.Color:=FHighLightColor;
                          Draw3DText(Tmp.Canvas,-1,PosY-1,i);
                          Font.Color:=Col;
                        end;
            end;
          Draw3DText(Tmp.Canvas,0,PosY,i);
        end; {for}
     end; {with}

   if FTransparent then
      begin
          with TmpMask do
            begin
              TmpMask:=TBitmap.Create;
              Monochrome:=TRUE;
              Width:=Tmp.Width;
              Height:=Tmp.Height;
              with Canvas do
                 begin
                   Font.Assign(Self.Canvas.Font);
                   Font.Color:=clBlack;
                   Brush.Color:=clWhite;
                   FillRect(R);
                   Brush.Style:=bsClear;
                   for i:=0 to FLines.Count - 1  do
                      begin
                        Case FTextStyle of
                          Lowered : Draw3DText(TmpMask.Canvas,1,PosY+1,i);
                          Raised  : Draw3DText(TmpMask.Canvas,-1,PosY-1,i);
                         end;
                        Draw3DText(TmpMask.Canvas,0,PosY,i);
                       end; {for}
                 end;
            end;

        Self.Canvas.Brush.Style:=bsClear;
        Self.Canvas.FillRect(R2);
        if isTransp then
           SetXMask;
           
        with FStore do
          begin
            FStore:=TBitmap.Create;
            Width:=Tmp.Width;
            Height:=Tmp.Height;
            with Canvas do
              begin
                Draw(0,0,xMask);

                CopyMode:=cmSrcInvert;
                Draw(0,0,Tmp);

                CopyMode:=cmSrcAnd;
                Draw(0,0,TmpMask);

                CopyMode:=cmSrcInvert;
                Draw(0,0,Tmp);
              end;
          end;
          Self.Canvas.Draw(R2.Left,R2.Top,fStore);
          fStore.Free;
          TmpMask.Free;
      end
         else Canvas.Draw(R2.Left,R2.Top,Tmp);
  Self.Canvas.Brush.Style:=bsSolid;
end;

// Start the slider
procedure TPCVSliderPanel.StartSlider;
var R:TRect;
begin
  if FActive then
    begin
      R:=ClientRect;
      if FDirection = DownToUp then
         begin
           Dec(PosY,FStep);
           if PosY<=-(Canvas.TextHeight('A')*(FLines.Count+1)) then
                 PosY:=R.Bottom - R.Top;
           isTransp:=FALSE;      
           DrawSliderPanel;
         end;

     if FDirection = UpToDown then
         begin
           Inc(PosY,FStep);
           if PosY>=(R.Bottom - R.Top) then
                PosY:=-(Canvas.TextHeight('A')*(FLines.Count+1));
           isTransp:=FALSE;
           DrawSliderPanel;
         end;
    end;
end;

// Set direction of Slider
procedure TPCVSliderPanel.SetDirection(value : TDirections);
begin
  FDirection:=value;
end;

// Set the Slider BackGround Color
procedure TPCVSliderPanel.SetSliderColor(value : TColor);
begin
  FColor:=value;
  RePaint;
end;

// Set the Slider Timer Interval
procedure TPCVSliderPanel.SetSliderInterval(value : LongInt);
begin
  SliderTimer.Interval:=value;
  FInterval:=value;
end;

// Set the step of the slider
procedure TPCVSliderPanel.SetSliderStep(value : LongInt);
begin
  FStep:=value;
end;

// Set the slider Active
procedure TPCVSliderPanel.SetSliderActive(value : Boolean);
begin
  SliderTimer.Enabled:=value;
  FActive:=value;
end;

// Set the transparency
procedure TPCVSliderPanel.SetSliderTransparent(value : Boolean);
begin
  if FTransparent <> Value then
       begin
         FTransparent:=value;
         RePaint;
       end;
end;

procedure TPCVSliderPanel.SetTextAlign(value : TSlideAllignment);
begin
  if FTextAlign <> value then
     begin
       FTextAlign:=value;
       RePaint;
     end;
end;

procedure TPCVSliderPanel.SetLines(Value : TStrings);
begin
  FLines.Assign(Value);
  RePaint;
end;

procedure TPCVSliderPanel.SetHighLightColor(value : TColor);
begin
  if FHighLightColor <> value then
      begin
        FHighLightColor:=value;
        if FTextStyle <> Normal then
              RePaint;
      end;
end;

procedure TPCVSliderPanel.SetTextStyle(value : T3DStyle);
begin
  if FTextStyle <> value then
      begin
        FTextStyle:=value;
        RePaint;
      end;
end;

procedure TPCVSliderPanel.Draw3DText(Canvas : TCanvas;x,y,pos:LongInt);
var XPos,YPos:LongInt;
begin
  with Canvas do
    begin
      if FTextAlign=saLeft then
         begin
           XPos:=1;
           YPos:=Y+(Pos*TextHeight(FLines[Pos]))+2;
         end;

      if FTextAlign=saRight then
         begin
           XPos:=Tmp.Width-TextWidth(FLines[Pos]);
           YPos:=Y+(pos*TextHeight(FLines[Pos]))+2;;
         end;

      if FTextAlign=saCenter then
         begin
           XPos:=Tmp.Width div 2 -(TextWidth(FLines[Pos]) div 2);
           YPos:=Y+(pos*TextHeight(FLines[Pos]))+2;
         end;
      TextOut(XPos+X,YPos,FLines[Pos]);
    end;
end;

procedure TPCVSliderPanel.SetXMask;
var R:TRect;
begin
  With xMask.Canvas do
     begin
       xMask.Width:=Tmp.Width;
       xMask.Height:=Tmp.Height;
       Font.Assign(Self.Canvas.Font);
       R:=Rect(0,0,Tmp.Width,Tmp.Height);
       CopyRect(R,Self.Canvas,ClientRect);
     end;
end;

destructor TPCVSliderPanel.Destroy;
begin
  SliderTimer.Free;
  Tmp.Free;
  xMask.Free;
  FLines.Free;
  inherited Destroy;
end;

end.
