unit PCVShadowButton;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs,Classe,ExtCtrls,ShellAPI;

type
  TPCVButtonStyle = (bsEllipse,bsRectangle,bsRoundRect);
  TPCVShadowButton = class(TGraphicControl)
  private
     FUrl : String;
     FExecURL : Boolean;
     FCaption:TCaption;
     FFrameColor : TColor;
     FBkColor : TColor;
     FColorOver : TColor;
     FShadowColor : TColor;
     FShadowOffset : Longint;
     FTmpColor : TColor;
     FStyle : TPCVButtonStyle;
     Tmp,xMask : TBitmap;
     Pos : Integer;
     Transp : Boolean;
     procedure SetStyle(value : TPCVButtonStyle);
     procedure SetFrameColor(value : TColor);
     procedure SetShadowColor(value : TColor);
     procedure SetColorOver(value : TColor);
     procedure SetShadowOffset(value : Longint);
     procedure SetBkColor(value: TColor);
     procedure SetCaption(value : TCaption);
     procedure DrawOnCanvas(Dest : TCanvas);
     procedure DoMouseEnter(var Msg : TMessage); message cm_MouseEnter;
     procedure DoMouseLeave(var Msg : TMessage); message cm_MouseLeave;
     procedure MouseDown(Button: TMouseButton;
                         Shift: TShiftState; X, Y: Integer);override;
     procedure MouseUp(Button: TMouseButton;
                       Shift: TShiftState; X, Y: Integer);override;
     procedure SetXMask;
     procedure DrawButton;
  protected
     procedure Paint;override;
     procedure Click;override;
  public
     constructor Create(AOwner : TComponent);override;
     destructor Destroy;override;
  published
     property Caption : TCaption read FCaption write SetCaption;
     property Style : TPCVButtonStyle read FStyle write SetStyle;
     property FrameColor : TColor read FFrameColor write SetFrameColor;
     property BkColor : TColor read FBkColor write SetBkColor;
     property ShadowColor : TColor read FShadowColor write SetShadowColor;
     property ShadowOffset : Longint read FShadowOffset write setShadowOffset;
     property ColorOver : TColor read FColorOver write SetColorOver;
     property URL : String read FUrl write FURL;
     property ClickExecURL : Boolean read FExecURL write FExecURL;
     property Font;

     property OnClick;
     property OnDblClick;
     property OnDragDrop;
     property OnDragOver;
     property OnEndDrag;
     property OnStartDrag;
     property OnMouseMove;
     property OnMouseDown;
     property OnMouseUp;
  end;


implementation

constructor TPCVShadowButton.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  FFrameColor:=clBlack;
  FBkColor:=clYellow;
  FShadowColor:=clGray;
  FColorOver:=clBlack;
  FShadowOffset:=5;
  FStyle:=bsRoundRect;
  FCaption:='PCV  Shadow Button';
  FExecURL:=FALSE;
  URL:='http://www.pcv.go.ro';
  Pos:=0;
  Width:=160;
  Height:=40;

  Tmp:=TBitmap.Create;
  xMask:=TBitmap.Create;
end;

destructor TPCVShadowButton.Destroy;
begin
  inherited Destroy;
end;

procedure TPCVShadowButton.DrawButton;
var R:TRect;
    TmpMask,FStore : TBitmap;
    xx,yy:integer;
    Col,Col1,Col2,Col3 : TColor;
begin
  Canvas.Font:=Font;

  with Tmp.Canvas do
    begin
      Font.Assign(Self.Canvas.Font);
      Pen.Color:=FFrameColor;
      Tmp.Width:=ClientRect.Right - ClientRect.Left;
      Tmp.Height:=ClientRect.Bottom - ClientRect.Top;
      R:=Rect(0,0,Tmp.Width,Tmp.Height);
      DrawOnCanvas(Tmp.Canvas);
      //================================
      xx:=(Pos-1)+(Tmp.Width - FShadowOffset) div 2 - (TextWidth(FCaption) div 2);
      yy:=(Pos-1)+(Tmp.Height - FShadowOffset) div 2 - (TextHeight(FCaption) div 2);
      Font.Color:=FTmpColor;
      TextOut(xx,yy,FCaption);
    end;
          with TmpMask do
            begin
              TmpMask:=TBitmap.Create;
              Monochrome:=TRUE;
              Width:=Tmp.Width;
              Height:=Tmp.Height;
              with Canvas do
                 begin
                   Font.Assign(Self.Canvas.Font);
                   Font.Color:=clBlack;
                   Brush.Color:=clWhite;
                   FillRect(R);
                   
                   Col1:=FFrameColor;
                   Col2:=FBkColor;
                   Col3:=FShadowColor;
                   FBkColor:=clBlack;
                   FFrameColor:=clBlack;
                   FShadowColor:=clBlack;

                   DrawOnCanvas(TmpMask.Canvas);

                   FBkColor:=Col2;
                   FFrameColor:=Col1;
                   FShadowColor:=Col3;

                   Font.Color:=clBlack;
                   TextOut(xx,yy,FCaption);
                   Brush.Style:=bsClear;
                 end;
            end;

        Self.Canvas.Brush.Style:=bsClear;
        Self.Canvas.FillRect(ClientRect);
        
        if Transp then
           SetXMask;

        with FStore do
          begin
            FStore:=TBitmap.Create;
            Width:=Tmp.Width;
            Height:=Tmp.Height;
            with Canvas do
              begin
                Draw(0,0,xMask);

                CopyMode:=cmSrcInvert;
                Draw(0,0,Tmp);

                CopyMode:=cmSrcAnd;
                Draw(0,0,TmpMask);

                CopyMode:=cmSrcInvert;
                Draw(0,0,Tmp);
              end;
          end;
Self.Canvas.Draw(ClientRect.Left,ClientRect.Top,fStore);
fStore.Free;
TmpMask.Free;
Self.Canvas.Brush.Style:=bsSolid;

end;

procedure TPCVShadowButton.Paint;
begin
  Transp:=TRUE;
  FTmpColor:=Font.Color;
  DrawButton;
  Transp:=FALSE;
end;

procedure TPCVShadowButton.SetStyle(value : TPCVButtonStyle);
begin
  if FStyle <> value then
      begin
        FStyle:=value;
        RePaint;
      end;
end;

procedure TPCVShadowButton.SetFrameColor(value : TColor);
begin
  if FFrameColor <> value then
     begin
       FFrameColor:=value;
       RePaint;
     end;
end;

procedure TPCVShadowButton.SetShadowColor(value : TColor);
begin
  if FShadowColor <> value then
     begin
       FShadowColor:=value;
       RePaint;
     end;
end;

procedure TPCVShadowButton.SetColorOver(value : TColor);
begin
  FColorOver:=value;
end;

procedure TPCVShadowButton.SetShadowOffset(value : Longint);
begin
  if FShadowOffset <> value then
       begin
         FShadowOffset:=value;
         RePaint;
       end;
end;

procedure TPCVShadowButton.SetCaption(value : TCaption);
begin
  if FCaption <> value then
     begin
       FCaption:=value;
       RePaint;
     end;
end;

procedure TPCVShadowButton.DrawOnCanvas(Dest : TCanvas);
begin
 with Dest do
 begin
      case FStyle of
         bsEllipse : begin
                       if Pos =0 then
                           begin
                             Brush.Color:=FShadowColor;
                             Pen.Style:=psClear;
                             Ellipse(FShadowOffset,FShadowOffset,
                                     Tmp.Width,Tmp.Height);
                           end;
                       Brush.Color:=FBkColor;
                       Pen.Style:=psSolid;
                       Ellipse(Pos,Pos,Tmp.Width-FShadowOffset,
                               Tmp.Height - FShadowOffset);
                     end;
         bsRectangle : begin
                         if Pos = 0 then
                              begin
                                Brush.Color:=FShadowColor;
                                Pen.Style:=psClear;
                                Rectangle(FShadowOffset,FShadowOffset,
                                          Tmp.Width,Tmp.Height);
                              end;            
                         Brush.Color:=FBkColor;
                         Pen.Style:=psSolid;
                         Rectangle(Pos,Pos,Tmp.Width-FShadowOffset,
                                 Tmp.Height - FShadowOffset);
                       end;

         bsRoundRect : begin
                         if Pos = 0 then
                             begin
                               Brush.Color:=FShadowColor;
                               Pen.Style:=psClear;
                               RoundRect(FShadowOffset,FShadowOffset,
                                 Tmp.Width,Tmp.Height,20,20);
                             end;    
                         Brush.Color:=FBkColor;
                         Pen.Style:=psSolid;
                         RoundRect(Pos,Pos,Tmp.Width-FShadowOffset,
                                 Tmp.Height - FShadowOffset,20,20);
                       end;
             end;          
 end;                      
end;

// Save the back image
procedure TPCVShadowButton.SetXMask;
var R:TRect;
begin
  With xMask.Canvas do
    begin
      xMask.Width:=Tmp.Width;
      xMask.Height:=Tmp.Height;
      R:=Rect(0,0,Tmp.Width,Tmp.Height);
      Font.Assign(Self.Canvas.Font);
      CopyRect(R,Self.Canvas,ClientRect);
    end;
end;

procedure TPCVShadowButton.SetBkColor(value: TColor);
begin
  if FBkColor <> value then
      begin
        FBkColor:=value;
        RePaint;
      end;
end;

procedure TPCVShadowButton.DoMouseEnter(var Msg : TMessage);
var Col : TColor;
begin
  if not Enabled then Exit;
  Transp:=FALSE;
  Col:=FTmpColor;
  FTmpColor:=FColorOver;
  DrawButton;
  FTmpColor:=Col;
end;

procedure TPCVShadowButton.DoMouseLeave(var Msg : TMessage);
begin
  if not Enabled then Exit;
  Transp:=FALSE;
  DrawButton;
end;

procedure TPCVShadowButton.MouseDown(Button: TMouseButton;
                                     Shift: TShiftState; X, Y: Integer);
var TmpOffset,TmpPos : LongInt;
    Col : TColor;                                 
begin
  if not Enabled then Exit;
  Transp:=FALSE;
  TmpPos:=Pos;
  Pos:=FShadowOffset;
  TmpOffset:=FShadowOffset;
  FShadowOffset:=0;
  DrawButton;
  FShadowOffset:=TmpOffset;
  Pos:=TmpPos;
end;

procedure TPCVShadowButton.MouseUp(Button: TMouseButton;
                                   Shift: TShiftState; X, Y: Integer);
begin
  if not Enabled then Exit;
  Transp:=FALSE;
  DrawButton;
end;

procedure TPCVShadowButton.Click;
var Link,S1,S2 : String;
begin
  Inherited Click;
  if FExecURL then
     begin
       Link:=FURL+#0;
       S1:=''+#0;
       S2:=''+#0;
       ShellExecute(Application.Handle,nil,@Link[1],@S1[1],@S2[1],SW_Show);
     end;  
end;

end.
