unit PCVSlide;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs,ExtCtrls,Classe;

type
  TDirections = (sdRightToLeft,sdLeftToRight);
  T3DStyle = (Lowered,Normal,Raised,Shadow);
  TPCVAlign = (TopAlign,CenterAlign,BottomAlign);
  TPCVSlider = class(TGraphicControl)
  private
     FTextStyle : T3DStyle;
     FShadowColor : TColor;
     FHighLightColor : TColor;
     FXShadowOffset : Byte;
     FYShadowOffset : Byte;
     FColor : TColor;
     FText : TCaption;
     FDirection : TDirections;
     xMask,Tmp : TBitmap;
     SliderFont : TFont;
     FInterval : LongInt;
     FStep : LongInt;
     FActive : Boolean;
     PosX,PosY : LongInt;
     isTransp,FTransparent : Boolean;
     SliderTimer : TTimer;
     RR : TRect;
     FVAlign : TPCVAlign;
     procedure SetDirection(value : TDirections);
     procedure SetSliderText(value : TCaption);
     procedure SetSliderColor(value : TColor);
     procedure SetSliderInterval(value : LongInt);
     procedure SetSliderActive(value : Boolean);
     procedure SetSliderTransparent(value : Boolean);
     procedure StartSlider(sender : TObject);
     procedure SetHighlightColor(value : TColor);
     procedure SetShadowColor(value : TColor);
     procedure SetXShadowOffset(value : Byte);
     procedure SetYShadowOffset(value : Byte);
     procedure SetTextStyle(value : T3DStyle);
     procedure SetVAlign(value : TPCVAlign);
     procedure DrawSlider;
     procedure SetXMask;
  protected
     procedure Paint;override;
     procedure RePaint;override;
  public
    constructor Create(AOwner:TComponent);override;
    destructor Destroy;override;
  published
    property Direction : TDirections read FDirection write SetDirection;
    property Text : TCaption read FText write SetSliderText;
    property Color : TColor read FColor write SetSliderColor;
    property Active : Boolean read FActive write SetSliderActive;
    property Interval : LongInt read FInterval  write SetSliderInterval;
    property Step : LongInt read FStep write FStep;
    property Transparent : Boolean read FTransparent write SetSliderTransparent;
    property TextStyle : T3DStyle read FTExtStyle write SetTextStyle;
    property ShadowColor : TColor read FShadowColor write SetShadowColor;
    property HighLightColor : TColor read FHighlightColor write SetHighlightColor;
    property XShadowOffset : Byte read FXShadowOffset write SetXShadowOffset;
    property YShadowOffset : Byte read FYShadowOffset write SetYShadowOffset;
    property VAlign : TPCVAlign read FVAlign write SetVAlign;

    property Font;
  end;

implementation

constructor TPCVSlider.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);
  FText:='PCV Slider';
  Canvas.Font:=Font;
  Width:=100;
  Height:=15;

  Tmp:=TBitmap.Create;
  xMask:=TBitmap.Create;

  FActive:=FALSE;
  FInterval:=30;
  
  PosX:=2;
  PosY:=1;

  FStep := 2;
  FColor:=clBtnFace;
  FTransparent:=FALSE;
  FDirection:=sdRightToLeft;
  FVAlign:=CenterAlign;

  FTextStyle:=Raised;
  FHighLightColor:=clWhite;
  FShadowColor:=clGray;
  FXShadowOffset:=2;
  FYShadowOffset:=2;

  SliderTimer:=TTimer.Create(Self);
  SliderTimer.Interval:=FInterval;
  SliderTimer.Enabled:=False;
  SliderTimer.OnTimer:=StartSlider;
end;

procedure TPCVSlider.RePaint;
begin
  isTransp:=FTransparent;
  inherited RePaint;
end;

procedure TPCVSlider.Paint;
var isActive : Boolean;
begin
  DrawSlider;
end;

procedure TPCVSlider.DrawSlider;
var R,R2:TRect;
    TmpMask,FStore : TBitMap;
    Col : TColor;
begin
  R:=ClientRect;
  R2:=ClientRect;
  Canvas.Font:=Font;

  case FVAlign of
     TopAlign : PosY:=1;
     CenterAlign : PosY:=((R2.Bottom - R2.Top) div 2) - (Canvas.TextHeight(FText) div 2);
     BottomAlign : PosY:=(R2.Bottom - R2.Top) - (Canvas.TextHeight(FText)) -1;
  end;

  With Tmp.Canvas do
     begin
       Font.Assign(Self.Canvas.Font);
       Col:=Font.Color;
       Brush.Color:=FColor;
       Tmp.Width:=R2.Right - R2.Left;
       Tmp.Height:=R2.Bottom - R2.Top;
       R:=Rect(0,0,Tmp.Width,Tmp.Height);
       FillRect(R);
       Brush.Style:=bsClear;
       case FTextStyle of
            Lowered : begin
                        Font.Color:=FHighLightColor;
                        TextOut(PosX+1,PosY+1,FText);
                        Font.Color:=Col;
                      end;
            Raised :  begin
                        Font.Color:=FHighLightColor;
                        TextOut(PosX-1,PosY-1,FText);
                        Font.Color:=Col;
                      end;
            Shadow :  begin
                        Font.Color:=FShadowColor;
                        TextOut(PosX+FXShadowOffset,PosY+FYShadowOffset,FText);
                        Font.Color:=Col;
                      end;
        end;
       TextOut(PosX,PosY,FText);
     end;

   if FTransparent then
      begin
          with TmpMask do
            begin
              TmpMask:=TBitmap.Create;
              Monochrome:=TRUE;
              Width:=Tmp.Width;
              Height:=Tmp.Height;
              with Canvas do
                 begin
                   Font.Assign(Self.Canvas.Font);
                   Font.Color:=clBlack;
                   Brush.Color:=clWhite;
                   FillRect(R);
                   Brush.Style:=bsClear;
                   case FTextStyle of
                       Lowered : TextOut(PosX+1,PosY+1,FText);
                       Raised :  TextOut(PosX-1,PosY-1,FText);
                       Shadow :  TextOut(PosX+FXShadowOffset,PosY+FYShadowOffset,FText);
                    end;
                   TextOut(PosX,PosY,FText);
                 end;
            end;

        Self.Canvas.Brush.Style:=bsClear;
        Self.Canvas.FillRect(R2);

        if isTransp then
          SetXMask;
               
        with FStore do
          begin
            FStore:=TBitmap.Create;
            Width:=Tmp.Width;
            Height:=Tmp.Height;
            with Canvas do
              begin
                Draw(0,0,xMask);

                CopyMode:=cmSrcInvert;
                Draw(0,0,Tmp);

                CopyMode:=cmSrcAnd;
                Draw(0,0,TmpMask);

                CopyMode:=cmSrcInvert;
                Draw(0,0,Tmp);
              end;
          end;
          Self.Canvas.Draw(R2.Left,R2.Top,fStore);
          fStore.Free;
          TmpMask.Free;
      end
         else Canvas.Draw(R2.Left,R2.Top,Tmp);
  Self.Canvas.Brush.Style:=bsSolid;
end;


// Start the slider
procedure TPCVSlider.StartSlider;
var R:TRect;
begin
  if FActive then
    begin
      R:=ClientRect;
      if FDirection = sdRightToLeft then
         begin
           Dec(PosX,FStep);
           if PosX<=-Canvas.TextWidth(FText) then
                 PosX:=R.Right-R.Left;
           isTransp:=FALSE;      
           DrawSlider;
         end;

     if FDirection = sdLeftToRight then
         begin
           Inc(PosX,FStep);
           if PosX>=(R.Right - R.Left) then
                PosX:=-Canvas.TextWidth(FText);
           isTransp:=FALSE;      
           DrawSlider;
         end;
    end;
end;

// Set direction of Slider
procedure TPCVSlider.SetDirection(value : TDirections);
begin
  FDirection:=value;
end;

// Set the caption of the slider
procedure TPCVSlider.SetSliderText(value : TCaption);
begin
  if FText <> value then
     begin
       FText:=value;
       RePaint;
     end;  
end;

// Set the Slider BackGround Color 
procedure TPCVSlider.SetSliderColor(value : TColor);
begin
  FColor:=value;
  RePaint;
end;

// Set the Slider Timer Interval
procedure TPCVSlider.SetSliderInterval(value : LongInt);
begin
  SliderTimer.Interval:=value;
  FInterval:=value;
end;

// Set the slider Active
procedure TPCVSlider.SetSliderActive(value : Boolean);
begin
  SliderTimer.Enabled:=value;
  FActive:=value;
end;

// Set the transparency
procedure TPCVSlider.SetSliderTransparent(value : Boolean);
begin
  if FTransparent<> Value then
       begin
         FTransparent:=value;
         RePaint;
       end;
end;

// Save the back image
procedure TPCVSlider.SetXMask;
var R:TRect;
begin
  With xMask.Canvas do
    begin
      xMask.Width:=Tmp.Width;
      xMask.Height:=Tmp.Height;
      R:=Rect(0,0,Tmp.Width,Tmp.Height);
      Font.Assign(Self.Canvas.Font);
      CopyRect(R,Self.Canvas,ClientRect);
    end;
end;

procedure TPCVSlider.SetHighlightColor(value : TColor);
begin
  if FHighLightColor <> value then
     begin
       FHighLightColor:=value;
       RePaint;
     end;
end;

procedure TPCVSlider.SetShadowColor(value : TColor);
begin
  if FShadowColor <> value then
     begin
       FShadowColor:=value;
       RePaint;
     end;
end;

procedure TPCVSlider.SetXShadowOffset(value : Byte);
begin
  if FXShadowOffset <> value then
     begin
       FXShadowOffset:=value;
       RePaint;
     end;
end;

procedure TPCVSlider.SetYShadowOffset(value : Byte);
begin
  if FYShadowOffset<> value then
     begin
       FYShadowOffset:=value;
       RePaint;
     end;
end;

procedure TPCVSlider.SetTextStyle(value : T3DStyle);
begin
  if FTextStyle <> value then
     begin
       FTextStyle:=value;
       RePaint;
     end;
end;

procedure TPCVSlider.SetVAlign(value : TPCVAlign);
begin
   if FVAlign <> value then
       begin
         FVAlign:=value;
         RePaint;
       end;
end;

destructor TPCVSlider.Destroy;
begin
  SliderTimer.Free;
  Tmp.Free;
  xMask.Free;
  inherited Destroy;
end;

end.
