unit PCVOverButton;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  PCVButtonStyleOver = (boFrame,boOnlyCaption);
  TPCVOverButton = class(TGraphicControl)
  private
     FCaption:TCaption;
     FFrameColorOver:TColor;
     FCaptionOverColor : TColor;
     FButtonStyle : PCVButtonStyleOver;
     FUrl : String;
     FExecURL : Boolean;
     FVAlign : TPCVVAlign;
     FHAlign : TPCVHAlign;
     x,y:Integer;

     procedure SetFrameColorOver(value:TColor);
     procedure SetCaptionOverColor(value : TColor);
     procedure SetCaption(value : TCaption);
     procedure SetButtonStyle(value :SetButtonStyle : PCVButtonStyleOver);
     procedure SetHAlign(value : TPCVHAlign);
     procedure SetVAlign(value : TPCVVAlign);
  protected
    procedure DoMouseEnter(var Message:TMessage); message cm_MouseEnter;
    procedure DoMouseLeave(var Message:TMessage); message cm_MouseLeave;
    procedure Click;override;
  public
     constructor Create(AOwner : TComponent);override;
     procedure Paint;override;
  published
     property Caption : TCaption read FCaption write SetCaption default 'PCV Over Button';
     property CaptionColorOver : TColor write FCaptionOverColor write SetCaptionOverColor default clRed;
     property FrameColor : TColor read FFrameColor write SetFrameColor default clRed;
     property ButtonStyle : PCVButtonStyleOver read FButtonStyle write SetButtonStyle default boFrame;
     property ExecURL : Boolean read FExecURL write FExecURL default FALSE;
     property URL : String read FURL write FURL;
     property VAlign : TPCVVAlign read FVAlign write SetVAlign default vaCenter;
     property HAlign : TPCVHAlign read FHAlign write SetHAlign default haCenter;

     property Font;
     property OnClick;
     property OnDblClick;
     property OnDragDrop;
     property OnDragOver;
     property OnEndDrag;
     property OnStartDrag;
     property OnMouseMove;
     property OnMouseDown;
     property OnMouseUp;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('PCV', [TPCVOverButton]);
end;

constructor TPCVOverButton.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);
  Width:=140;
  Height:=20;
  Tmp:=TBitmap.Create;
  xMask:=TBitmap.Create;
  x:=0;
  y:=0;
end;

procedure TPCVOverButton.Paint;
var x,y,i:integer;
    Store,TmpMask : TBitmap;
begin
  Canvas.Font.Assign(Font);

  With Tmp.Canvas do
     begin
       Font.Assign(Self.Canvas.Font);
       Tmp.Width:=ClientRect.Right - ClientRect.Left;
       Tmp.Height:=ClientRect.Bottom - ClientRect.Top;
       case FHAlign of
             haLeft : x:=3;
             haCenter : x:= (Tmp.Width div 2) -(TextWidth(FCaption) div 2);
             haRight : x:= Tmp.Width - TextWidth(FCaption);
          end;
          
       case FHAlign of
             vaTop : y:=3;
             vaCenter : y:=(Tmp.Height div 2) -(TextHeight(FCaption) div 2);
             vaBottom : y:=Tmp.Height - TextHeight(FCaption);
          end;
          TextOut(x,y,FCaption);
     end;

          with TmpMask do
            begin
              TmpMask:=TBitmap.Create;
              Monochrome:=TRUE;
              Width:=Tmp.Width;
              Height:=Tmp.Height;
              with Canvas do
                 begin
                   Font.Assign(Self.Canvas.Font);
                   Font.Color:=clBlack;
                   Brush.Color:=clWhite;
                   FillRect(R);
                   if isOver then
                     begin
                       FFrameUPColor:=clBlack;
                       FFrameDOWNColor:=clBlack;
                     end;  

                   MoveTo(0,0);
                   LineTo(Tmp.Width,0);
                   LineTo(0,Tmp.Height);
                   MoveTo(Tmp.Width,Tmp.Height);
                   LineTo(Tmp.Width,0);
                   LineTo(0,Tmp.Height);
                   
                   FBkColor:=Col2;
                   FFrameColor:=Col1;
                   FShadowColor:=Col3;

                   Font.Color:=clBlack;
                   TextOut(xx,yy,FCaption);
                   Brush.Style:=bsClear;
                 end;
            end;

        Self.Canvas.Brush.Style:=bsClear;
        Self.Canvas.FillRect(ClientRect);
        
        if Transp then
           SetXMask;

        with FStore do
          begin
            FStore:=TBitmap.Create;
            Width:=Tmp.Width;
            Height:=Tmp.Height;
            with Canvas do
              begin
                Draw(0,0,xMask);

                CopyMode:=cmSrcInvert;
                Draw(0,0,Tmp);

                CopyMode:=cmSrcAnd;
                Draw(0,0,TmpMask);

                CopyMode:=cmSrcInvert;
                Draw(0,0,Tmp);
              end;
          end;
Self.Canvas.Draw(ClientRect.Left,ClientRect.Top,fStore);
fStore.Free;
TmpMask.Free;
Self.Canvas.Brush.Style:=bsSolid;

end;

procedure TPCVOverButton.SetFrameColorOver(value:TColor);
begin
  if FFrameColor <> value then
     begin
       FFrameColor:=value;
       Paint;
     end;      
end;

procedure TPCVOverButton.SetCaptionOverColor(value : TColor);
begin
  if FCaptionOverColor <> value then
    begin
      FCaptionOverColor:=value;
      Paint;
end;

procedure TPCVOverButton.SetCaption(value : TCaption);
begin
  if FCaption <> value then
    begin
      FCaption:=value;
      RePaint;
    end;  
end;

procedure TPCVOverButton.SetButtonStyle(value :SetButtonStyle : PCVButtonStyleOver);
begin
  if FButtonStyle<>value then
     begin
       FButtonStyle:=value;
       Paint;
     end;  
end;

procedure TPCVOverButton.SetHAlign(value : TPCVHAlign);
begin
  if FHAlign <> value then
       begin
         FHAlign:=value;
         RePaint;
       end;
end;

procedure TPCVOverButton.SetVAlign(value : TPCVVAlign);
begin
  if FVAlign <> value then
       begin
         FVAlign:=value;
         RePaint;
       end;
end;

procedure TPCVOverButton.DoMouseEnter(var Message:TMessage);
begin
end;

procedure TPCVOverButton.DoMouseLeave(var Message:TMessage);
begin
end;

procedure TPCVOverButton.Click;
var Link,S1,S2 : String;
begin
  Inherited Click;
  if Not ExecURL then
      Exit;
  Link:=URL+#0;
  S1:=''+#0;
  S2:=''+#0;
  ShellExecute(Application.Handle,nil,@Link[1],@S1[1],@S2[1],SW_Show);
end;

end.
