//===========================================
//          PCV Library Component
//       (c) 2002 Paraschiv Cristian
//            pcv3000@yahoo.com
//              www.pcv.go.ro
//===========================================

unit PCVFocusButton;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs,ShellApi,Classe;

type
  TPCVFocusButton = class(TGraphicControl)
  private
    FBkColor : TColor;
    FBkColorOver : TColor;
    FBkColorDown : TColor;
    FFrameColor : TColor;
    FFrameColorOver : TColor;
    FFrameColorDown : TColor;
    FCaptionColor : TColor;
    FCaptionColorOver : TColor;
    FCaptionColorDown : TColor;
    FOffsetDown : LongInt;
    FCaption : TCaption;
    FUrl : String;
    Tmp : TBitmap;
    isDown : Boolean;
    procedure SetUrl(Value : String);
    procedure SetBkColor(value : TColor);
    procedure SetBkColorOver(value : TColor);
    procedure SetBkColorDown(value : TColor);
    procedure SetFrameColor(value : TColor);
    procedure SetFrameColorOver(value : TColor);
    procedure SetFrameColorDown(value : TColor);
    procedure SetCaptionColorOver(value : TColor);
    procedure SetCaptionColorDown(value : TColor);
    procedure SetCaption(value : TCaption);
    procedure SetOffsetDown(value : LongInt);
  protected
    procedure Paint;override;
    procedure DoMouseLeave(var Msg : TMessage); message CM_MouseLeave;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer);override;
    procedure DoFontChanged(var Msg : TMessage); message cm_FontChanged;
    procedure MouseDown(Button: TMouseButton;
                        Shift: TShiftState; X, Y: Integer);override;
    procedure MouseUp(Button: TMouseButton;
                      Shift: TShiftState; X, Y: Integer);override;
  public
    constructor Create(AOwner : TComponent);override;
    destructor Destroy;override;
    procedure Click;override;
  published
    property Align;
    property BackColor : TColor read FBkColor write SetBkColor;
    property BackColorOver : TColor read FBkColorOver write SetBkColorOver;
    property BackColorDown : TColor read FBkColorDown write SetBkColorDown;
    property FrameColor : TColor read FFrameColor write SetframeColor;
    property FrameColorOver : TColor read FFrameColorOver write SetFrameColorOver;
    property FrameColorDown : TColor read FFrameColorDown write SetFrameColorDown;
    property CaptionColorOver : TColor read FCaptionColorOver write SetCaptionColorOver;
    property CaptionColorDown : TColor read FCaptionColorDown write SetCaptionColorDown;
    property Caption : TCaption read FCaption write SetCaption;
    property Offset : LongInt read FOffsetDown write SetOffsetDown;
    property URL : String read FURL write SetURL;
    property Visible;
    property Anchors;
    property Font;
    property Enabled;

    property OnClick;
    property OnMouseMove;
    property OnMouseUp;
    property OnMouseDown;
  end;

implementation

constructor TPCVFocusButton.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);

  Tmp:=TBitmap.Create;
  
  Canvas.Font:=Font;
  FFrameColor:=clGray;
  FFrameColorOver:=clWhite;
  FCaptionColorOver:=clYellow;
  FCaptionColorDown:=clAqua;
  FBkColorDown := clTeal;
  FBkColor:=clBtnFace;
  FBkColorOver:=clTeal;
  FCaptionColor:=Canvas.Font.Color;
  FFrameColorDown := clWhite;
  FCaption:='PCV';
  FOffsetDown:=2;
  isDown:=False;
  Width:=150;
  Height:=30;           
end;

procedure TPCVFocusButton.Paint;
var R,R2:TRect;
    x,y:LongInt;
begin
  R:=ClientRect;
  R2:=R;
  with Tmp.Canvas do
      begin
        Tmp.Width:=R2.Right - R2.Left;
        Tmp.Height:=R2.Bottom - R2.Top;
        Font.Assign(Self.Canvas.Font);
        X:=Tmp.Width div 2 -(TextWidth(FCaption) div 2);
        Y:=Tmp.Height div 2 - (TextHeight(FCaption) div 2);
        Brush.Style:=bsSolid;
        Brush.Color:=FBkColor;
        Pen.Style:=psSolid;
        Pen.Color:=FFrameColor;
        Rectangle(0,0,Tmp.Width,Tmp.Height);
        Brush.Style:=bsClear;
        TextOut(x,y,FCaption);
        Brush.Style:=bsSolid;
      end;
  Self.Canvas.Draw(R2.Left,R2.Top,Tmp);
end;

procedure TPCVFocusButton.SetUrl(Value : String);
begin
  FUrl:=Value;
end;

procedure TPCVFocusButton.SetBkColor(value : TColor);
begin
  if FBkColor <> Value then
     begin
       FBkColor:=Value;
       RePaint;
     end;  
end;

procedure TPCVFocusButton.SetBkColorOver(value : TColor);
begin
  if FBkColorOver <> Value then
      begin
        FBkColorOver:=Value;
        RePaint;
      end;
end;

procedure TPCVFocusButton.SetFrameColor(value : TColor);
begin
  if FFrameColor <> value then
      begin
        FFrameColor:=value;
        RePaint;
      end;
end;

procedure TPCVFocusButton.SetFrameColorOver(value : TColor);
begin
  if FFrameColorOver<> Value then
       begin
         FFRameColorOver:=Value;
         RePaint;
       end;
end;

procedure TPCVFocusButton.SetFrameColorDown(value : TColor);
begin
  if FFrameColorDown <> Value then
       begin
         FFrameColorDown:=value;
         RePaint;
       end;
end;

procedure TPCVFocusButton.SetCaptionColorOver(value : TColor);
begin
  if FCaptionColorOver <> value then
      begin
        FCaptionColorOver:=value;
        RePaint;
      end;
end;

procedure TPCVFocusButton.SetBkColorDown(value : TColor);
begin
  if FBkColorDown <> Value then
      begin
        FBkColorDown:=value;
        RePaint;
      end;
end;

procedure TPCVFocusButton.SetCaptionColorDown(value : TColor);
begin
  if FCaptionColorDown <> value then
     begin
       FCaptionColorDown:=value;
       RePaint;
     end;
end;

procedure TPCVFocusButton.SetCaption(value : TCaption);
begin
  if FCaption <> value then
     begin
       FCaption:=value;
       RePaint;
     end;
end;

procedure TPCVFocusButton.SetOffsetDown(value : LongInt);
begin
  if FOffsetDown <> value then
      begin
        FOffsetDown:=value;
        RePaint;
      end;
end;

procedure TPCVFocusButton.MouseMove(Shift: TShiftState; X, Y: Integer);
var R,R2:TRect;
    xx,yy : LongInt;
    BackUpColor : TColor;
begin
  if isDown then Exit;
  
  R:=ClientRect;
  R2:=R;
  with Tmp.Canvas do
      begin
        Tmp.Width:=R2.Right - R2.Left;
        Tmp.Height:=R2.Bottom - R2.Top;
        Font.Assign(Self.Canvas.Font);
        BackUpColor:=Font.Color;
        Font.Color:=FCaptionColorOver;
        XX:=Tmp.Width div 2 -(TextWidth(FCaption) div 2);
        YY:=Tmp.Height div 2 - (TextHeight(FCaption) div 2);
        Brush.Style:=bsSolid;
        Brush.Color:=FBkColorOver;
        Pen.Style:=psSolid;
        Pen.Color:=FFrameColorOver;
        Rectangle(0,0,Tmp.Width,Tmp.Height);
        Brush.Style:=bsClear;
        TextOut(xx,yy,FCaption);
        Brush.Style:=bsSolid;
        Font.Color:=BackUpColor;
      end;
  Self.Canvas.Draw(R2.Left,R2.Top,Tmp);
end;

procedure TPCVFocusButton.DoMouseLeave(var Msg: TMessage);
begin
  isDown:=FALSE;
  RePaint;
end;

procedure TPCVFocusButton.MouseDown(Button: TMouseButton;
                        Shift: TShiftState; X, Y: Integer);
var R,R2:TRect;
    xx,yy : LongInt;
    BackUpColor : TColor;
begin
  if (Button <> mbLeft) or (isDown) then Exit;
  isDown:=TRUE;
  R:=ClientRect;
  R2:=R;
  with Tmp.Canvas do
      begin
        Tmp.Width:=R2.Right - R2.Left;
        Tmp.Height:=R2.Bottom - R2.Top;
        Font.Assign(Self.Canvas.Font);
        BackUpColor:=Font.Color;
        Font.Color:=FCaptionColorDown;
        XX:=Tmp.Width div 2 -(TextWidth(FCaption) div 2);
        YY:=Tmp.Height div 2 - (TextHeight(FCaption) div 2);
        Brush.Style:=bsSolid;
        Brush.Color:=FBkColorDown;
        Pen.Style:=psSolid;
        Pen.Color:=FFrameColorDown;
        Rectangle(0,0,Tmp.Width,Tmp.Height);
        Brush.Style:=bsClear;
        TextOut(xx+FOffsetDown,yy+FOffsetDown,FCaption);
        Brush.Style:=bsSolid;
        Font.Color:=BackUpColor;
      end;
  Self.Canvas.Draw(R2.Left,R2.Top,Tmp);
end;

procedure TPCVFocusButton.MouseUp(Button: TMouseButton;
                        Shift: TShiftState; X, Y: Integer);
begin
  isDown:=FALSE;
  RePaint;
end;

procedure TPCVFocusButton.DoFontChanged(var Msg : TMessage);
begin
  Tmp.Canvas.Font:=Font;
  Canvas.Font:=Font;
  RePaint;
end;

procedure TPCVFocusButton.Click;
var Link,S1,S2: String;
begin
  Inherited Click;
  isDown:=FALSE;
  if FUrl = '' then Exit;
  Link:=FURL+#0;
  S1:=''+#0;
  S2:=''+#0;
  ShellExecute(Application.Handle,nil,@Link[1],@S1[1],@S2[1],SW_Show);
end;

destructor TPCVFocusButton.Destroy;
begin
  inherited Destroy;
end;

end.
