unit PCVFadeLabel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type
  TPCVValign = (vaTop,vaCenter,vaBottom);
  TPCVHAlign = (haLeft,haCenter,haRight);
  TPCVFadeLabel = class(TGraphicControl)
  private
    FTRansparent: Boolean;
    FStep: Integer;
    FColor : TColor;
    FAnimationDelay: Integer;
    FCaption: TCaption;
    FColorEnd: TColor;
    FOnMouseLeave: TNotifyEvent;
    FHAlign: TPCVHAlign;
    FVAlign: TPCVVAlign;
    Timer : TTimer;
    FTmpStep : Integer;
    CurrentColor : TColor;
    xMask,Tmp : TBitmap;
    PosX,PosY : Integer;
    FStart: Boolean;
    procedure SetAnimationDelay(const Value: Integer);
    procedure SetCaption(const Value: TCaption);
    procedure SetColorEnd(const Value: TColor);
    procedure SetHAlign(const Value: TPCVHAlign);
    procedure SetTransparent(const Value: Boolean);
    procedure SetVAlign(const Value: TPCVVAlign);
    procedure Animate(Sender : TObject);
    function  ERGB(r, g, b: integer;limit : boolean;ColorFrom,ColorTo : TColor): TColor;
    procedure SetColor(const Value: TColor);
    procedure MouseLeave(var Msg: TMessage);
    procedure SetStart(const Value: Boolean);
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
  published
    property Anchors;
    property Align;
    property Enabled;
    property Font;
    property ShowHint;
    property Hint;

    property Start : Boolean read FStart write SetStart;
    property Color : TColor read FColor write SetColor;
    property Step : Integer read FStep write FStep;
    property Transparent : Boolean read FTRansparent write SetTransparent;
    property Caption : TCaption read FCaption write SetCaption;
    property VAlign : TPCVVAlign read FVAlign write SetVAlign;
    property HAlign : TPCVHAlign read FHAlign write SetHAlign;
    property AnimationDelay : Integer read FAnimationDelay write SetAnimationDelay;
    property DestColor : TColor read FColorEnd write SetColorEnd;

    property onMouseLeave : TNotifyEvent read FOnMouseLeave write FOnMouseLeave;
    property onClick;
    property onMouseDown;
    property onMouseMove;
    property onMouseUp;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('PCV', [TPCVFadeLabel]);
end;

{ TPCVFadeLabel }

procedure TPCVFadeLabel.Animate(Sender: TObject);
begin
    CurrentColor:=ERGB(GetRValue(CurrentColor)+FTmpStep,
                       GetGValue(CurrentColor)+FTmpStep,
                       GetBValue(CurrentColor)+FTmpStep,
                       True,Font.Color,DestColor);
    Paint;
end;

constructor TPCVFadeLabel.Create(AOwner: TComponent);
begin
  inherited;
  Width:=150;
  Height:=30;
  FTransparent:=False;
  Timer:=TTimer.Create(self);
  Timer.Enabled:=False;
  Timer.onTimer:=Animate;
  FStep:=2;
  Font.Color:=clBlack;
  FColorEnd:=clWhite;
  FAnimationDelay:=10;
  VAlign:=vaCenter;
  HAlign:=haCenter;
  CurrentColor:=Font.Color;
  Color:=clBtnFace;
  FTmpStep:=FStep;

  Tmp:=TBitmap.Create;
  xMask:=TBitmap.Create;
end;

destructor TPCVFadeLabel.Destroy;
begin
  Timer.Free;
  inherited;
end;

function TPCVFadeLabel.ERGB(r, g, b: integer; limit: boolean;
  ColorFrom, ColorTo: TColor): TColor;
begin
  if not Limit then begin
     if r <= 0 then r:=0;
     if g <= 0 then g:=0;
     if b <= 0 then b:=0;

     if r >= 255 then r:=255;
     if g >= 255 then g:=255;
     if b >= 255 then b:=255;
  end;

  if Limit then begin
     if R <= GetRValue(ColorFrom) then  R:=GetRValue(ColorFrom);
     if G <= GetGValue(ColorFrom) then  G:=GetGValue(ColorFrom);
     if B <= GetBValue(ColorFrom) then  B:=GetBValue(ColorFrom);

     if R >= GetRValue(ColorTo)   then  R:=GetRValue(ColorTo);
     if G >= GetGValue(ColorTo)   then  G:=GetGValue(ColorTo);
     if B >= GetBValue(ColorTo)   then  B:=GetBValue(ColorTo);
  end;

  Result:=RGB(R,G,B);

  if (Result <= ColorFrom) or (Result >= ColorTo) then
     FTmpStep:=-FTmpStep;
end;

procedure TPCVFadeLabel.MouseLeave(var Msg: TMessage);
begin
  if Assigned(FonMouseLeave) then
     FOnMouseLeave(Self);
end;

procedure TPCVFadeLabel.Paint;
var R,R2,R3:TRect;
    TmpMask,FStore : TBitMap;
begin
  if not Assigned(Canvas) then Exit;
  R:=ClientRect;
  R2:=ClientRect;
  Canvas.Font:=Font;

  With Tmp.Canvas do
     begin
       Font.Assign(Self.Canvas.Font);
       Tmp.Width:=R2.Right - R2.Left;
       Tmp.Height:=R2.Bottom - R2.Top;
       case FVAlign of
          vaTop : PosY:=1;
          vaCenter : PosY:=(Tmp.Height div 2) - (TextHeight(FCaption) div 2);
          vaBottom : PosY:=Tmp.Height - TextHeight(FCaption);
        end;

       case FHAlign of
          haLeft : PosX:=1;
          haCenter : PosX:=(Tmp.Width div 2) - (TextWidth(FCaption) div 2);
          haRight : PosX:=Tmp.Width - TextWidth(FCaption);
        end;

       Font.Color:=CurrentColor;
       Brush.Color:=Color;
       R:=Rect(0,0,Tmp.Width,Tmp.Height);
       FillRect(R);
       Brush.Style:=bsClear;
       TextOut(PosX,PosY,FCaption);
     end;

   if FTransparent then
      begin
          with TmpMask do
            begin
              TmpMask:=TBitmap.Create;
              Monochrome:=TRUE;
              Width:=Tmp.Width;
              Height:=Tmp.Height;
              with Canvas do
                 begin
                   Font.Assign(Self.Canvas.Font);
                   Font.Color:=clBlack;
                   Brush.Color:=clWhite;
                   FillRect(R);
                   Brush.Style:=bsClear;
                   TextOut(PosX,PosY,FCaption);
                 end;
            end;

        Self.Canvas.Brush.Style:=bsClear;
        Self.Canvas.FillRect(R2);

         With xMask.Canvas do begin
              xMask.Width:=Tmp.Width;
              xMask.Height:=Tmp.Height;
              Font.Assign(Self.Canvas.Font);
              CopyRect(Rect(0,0,Tmp.Width,Tmp.Height),Self.Canvas,ClientRect);
        end;

        with FStore do
          begin
            FStore:=TBitmap.Create;
            Width:=Tmp.Width;
            Height:=Tmp.Height;
            with Canvas do
              begin
                Draw(0,0,xMask);

                CopyMode:=cmSrcInvert;
                Draw(0,0,Tmp);

                CopyMode:=cmSrcAnd;
                Draw(0,0,TmpMask);

                CopyMode:=cmSrcInvert;
                Draw(0,0,Tmp);
              end;
          end;
          Self.Canvas.Draw(R2.Left,R2.Top,fStore);
          fStore.Free;
          TmpMask.Free;
      end else Canvas.Draw(R2.Left,R2.Top,Tmp);
end;

procedure TPCVFadeLabel.SetAnimationDelay(const Value: Integer);
begin
  FAnimationDelay := Value;
  Timer.Interval:=FAnimationDelay;
end;

procedure TPCVFadeLabel.SetCaption(const Value: TCaption);
begin
  if FCaption <> value then begin
     FCaption := Value;
     Repaint;
  end;
end;

procedure TPCVFadeLabel.SetColor(const Value: TColor);
begin
  FColor := Value;
  Repaint;
end;

procedure TPCVFadeLabel.SetColorEnd(const Value: TColor);
begin
  FColorEnd := Value;
end;

procedure TPCVFadeLabel.SetHAlign(const Value: TPCVHAlign);
begin
  FHAlign := Value;
  Repaint;
end;

procedure TPCVFadeLabel.SetStart(const Value: Boolean);
begin
  FStart := Value;
  CurrentColor:=Font.Color;
  Timer.Enabled:=Value;
end;

procedure TPCVFadeLabel.SetTransparent(const Value: Boolean);
begin
  if FTransparent <> value then begin
     FTransparent := Value;
     Repaint;
  end;
end;

procedure TPCVFadeLabel.SetVAlign(const Value: TPCVVAlign);
begin
  FVAlign := Value;
  Repaint;
end;

end.

