unit PCVFadeButton;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs,extctrls;

type
  TPCVFadeButton = class(TGraphicControl)
  private
    FCaption : TCaption;
    FShowBorder: boolean;
    FFadeOnOver: Boolean;
    FDestColor: TColor;
    FCaptionOverColor: TColor;
    FBorderColor: TColor;
    FBorderDestColor : TColor;
    FOnMouseLeave: TNotifyEvent;
    CurrentBorderColor,CurrentColor : TColor;
    Timer : TTimer;
    FTmpStep,FStep: Integer;
    FColor: TColor;
    TmpColor : TColor;
    FBorderHeight: Integer;
    FFadeOnLeave: Boolean;
    FSpeed: Integer;
    procedure SetBorderColor(const Value: TColor);
    procedure SetCaption(const Value: TCaption);
    procedure SetCaptionOverColor(const Value: TColor);
    procedure SetShowBorder(const Value: boolean);
    procedure MouseLeave(var Msg : TMessage); message cm_MouseLeave;
    procedure Animate(Sender : TObject);
    function  ERGB(r, g, b: integer;limit,border : boolean;ColorFrom,ColorTo : TColor): TColor;
    procedure SetColor(const Value: TColor);
    procedure SetBorderHeight(const Value: Integer);
    procedure SetStep(const Value: Integer);
    procedure SetSpeed(const Value: Integer);
  protected
    procedure Paint; override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
  public
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
  published
    property Align;
    property Anchors;
    property Font;
    property Enabled;
    property ShowHint;
    property Hint;

    property Color : TColor read FColor write SetColor;
    property FadeOnLeave : Boolean read FFadeOnLeave write FFadeOnLeave;
    property Caption : TCaption read FCaption write SetCaption;
    property Step : Integer read FStep write SetStep;
    property BorderColor : TColor read FBorderColor write SetBorderColor;
    property BorderDestColor : TColor read FBorderDestColor write FBorderDestColor;
    property DestColor : TColor read FDestColor write FDestColor;
    property ShowBorder : boolean read FShowBorder write SetShowBorder;
    property CaptionOverColor : TColor read FCaptionOverColor write SetCaptionOverColor;
    property FadeOnOver : Boolean read FFadeOnOver write FFadeOnOver;
    property BorderHeight : Integer read FBorderHeight write SetBorderHeight;
    property Speed : Integer read FSpeed write SetSpeed;

    property onMouseLeave : TNotifyEvent read FOnMouseLeave write FOnMouseLeave;
    property onMouseDown;
    property onMouseUp;
    property onMouseMove;
    property OnClick;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('PCV', [TPCVFadeButton]);
end;

{ TPCVFadeButton }

procedure TPCVFadeButton.Animate(Sender: TObject);
begin
    CurrentColor:=ERGB(GetRValue(CurrentColor)+FTmpStep,
                       GetGValue(CurrentColor)+FTmpStep,
                       GetBValue(CurrentColor)+FTmpStep,
                       True,False,Color,DestColor);
    CurrentBorderColor:=ERGB(GetRValue(CurrentBorderColor)+FTmpStep,
                             GetGValue(CurrentBorderColor)+FTmpStep,
                             GetBValue(CurrentBorderColor)+FTmpStep,
                             True,True,BorderColor,BorderDestColor);
    Paint;
end;

constructor TPCVFadeButton.Create(AOwner: TComponent);
begin
  inherited;
  FBorderColor:=clSilver;
  BorderDestColor:=clWhite;
  Color:=clGreen;
  FDestColor:=clLime;
  FFadeOnOver:=True;
  FShowBorder:=True;
  FCaptionOverColor := clLime;
  FFadeOnLeave:=True;
  Font.Color:=clWhite;
  CurrentColor:=Color;
  CurrentBorderColor:=FBorderColor;
  Width:=150;
  Height:=30;
  FBorderHeight:=1;
  Timer:=TTimer.Create(Self);
  Timer.Enabled:=False;
  Timer.OnTimer:=Animate;
  FStep:=2;
  Speed:=10;
end;

destructor TPCVFadeButton.Destroy;
begin
  Timer.Free;
  inherited;
end;

function TPCVFadeButton.ERGB(r, g, b: integer;limit,border : boolean;ColorFrom,ColorTo : TColor): TColor;
begin
  if not Limit then begin
     if r <= 0 then r:=0;
     if g <= 0 then g:=0;
     if b <= 0 then b:=0;

     if r >= 255 then r:=255;
     if g >= 255 then g:=255;
     if b >= 255 then b:=255;
  end;

  if Limit then begin
     if R <= GetRValue(ColorFrom) then  R:=GetRValue(ColorFrom);
     if G <= GetGValue(ColorFrom) then  G:=GetGValue(ColorFrom);
     if B <= GetBValue(ColorFrom) then  B:=GetBValue(ColorFrom);

     if R >= GetRValue(ColorTo)   then  R:=GetRValue(ColorTo);
     if G >= GetGValue(ColorTo)   then  G:=GetGValue(ColorTo);
     if B >= GetBValue(ColorTo)   then  B:=GetBValue(ColorTo);
  end;

  Result:=RGB(R,G,B);

  if Border then Exit;
  if (Result <= ColorFrom) or (Result >= ColorTo) then
     Timer.Enabled:=False;
end;

procedure TPCVFadeButton.MouseLeave(var Msg: TMessage);
begin
  if FFadeOnLeave then begin
    // CurrentColor:=DestColor;
     FTmpStep:=-FStep;
     Timer.Enabled:=True;
     Font.Color:=TmpColor;
  end else begin
             Timer.Enabled:=False;
             CurrentBorderColor:=BorderColor;
             CurrentColor:=Color;
             Font.Color:=TmpColor;
             Paint;
           end;
  if Assigned(FonMouseLeave) then
     FOnMouseLeave(Self);
end;

procedure TPCVFadeButton.MouseMove(Shift: TShiftState; X, Y: Integer);
begin
  inherited;
   if Font.Color <> CaptionOverColor then begin
      TmpColor:=Font.Color;
      Font.Color:=CaptionOverColor;
   end;

  if not Timer.Enabled and FFadeOnOver then begin
     FTmpStep:=FStep;
     Timer.Enabled:=True;
  end;
  
  if not FFadeOnOver then
     begin
       CurrentBorderColor:=BorderDestColor;
       CurrentColor:=DestColor;
       Paint;
     end; 
end;

procedure TPCVFadeButton.Paint;
var TmpMask : TBitmap;
begin
  if not Assigned(Canvas) then Exit;
  TmpMask:=TBitmap.Create;
  TmpMask.Width:=Width;
  TmpMask.Height:=Height;
  with TmpMask.Canvas do begin
      Brush.Style:=bsSolid;
      Brush.Color:=CurrentColor;
      if FShowBorder then Pen.Style:=psSolid
                     else Pen.Style:=psClear;
      Pen.Color:=CurrentBorderColor;
      Pen.Width:=FBorderHeight;
      Rectangle(0,0,Width,Height);
      Font.Assign(Self.Font);
      TextOut(Width div 2 - (TextWidth(FCaption) div 2),Height div 2 - (TextHeight(FCaption) div 2),FCaption);
  end;
  Canvas.Draw(0,0,TmpMask);
  TmpMask.Free;
end;

procedure TPCVFadeButton.SetBorderColor(const Value: TColor);
begin
  if FBorderColor <> Value then begin
     FBorderColor := Value;
     CurrentBorderColor:=value;
     Paint;
  end;
end;

procedure TPCVFadeButton.SetBorderHeight(const Value: Integer);
begin
  FBorderHeight := Value;
  Paint;
end;

procedure TPCVFadeButton.SetCaption(const Value: TCaption);
begin
  if FCaption <> value then begin
     FCaption := Value;
     Paint;
  end;
end;

procedure TPCVFadeButton.SetCaptionOverColor(const Value: TColor);
begin
  FCaptionOverColor := Value;
end;

procedure TPCVFadeButton.SetColor(const Value: TColor);
begin
  FColor := Value;
  CurrentColor:=Value;
  Paint;
end;

procedure TPCVFadeButton.SetShowBorder(const Value: boolean);
begin
  if FShowBorder <> value then begin
     FShowBorder := Value;
     Paint;
  end;
end;

procedure TPCVFadeButton.SetSpeed(const Value: Integer);
begin
  FSpeed := Value;
  Timer.Interval:=Speed;
end;

procedure TPCVFadeButton.SetStep(const Value: Integer);
begin
  FStep := Value;
end;

end.
