unit PCV3DLabel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs,Classe;

type
  TPCV3DLabel = class(TGraphicControl)
  private
    Tmp : TBitmap;
    FTransparent : Boolean;
    FAutoSize : Boolean;
    FColor : TColor;
    FCaption : TCaption;
    FShadowColor : TColor;
    FShadowOffset : Integer;
    FHighlightColor : TColor;
    FVAlign : TPCVVAlign;
    FHAlign : TPCVHAlign;
    FStyle : TPCV3DStyle;
    procedure SetStyle(value : TPCV3DStyle);
    procedure SetCaption(value : TCAption);
    procedure SetVAlign(value : TPCVVAlign);
    procedure SetHAlign(value : TPCVHAlign);
    procedure SetShadowColor(value : TColor);
    procedure SetHighlightColor(value : TColor);
    procedure SetTransparent(value : Boolean);
    procedure SetShadowOffset(value : Integer);
    procedure SetColor(value : TColor);
    procedure SetAutoSize(value : Boolean);
  protected
    procedure Paint;override;
  public
    constructor Create(AOwner: TComponent);override;
  published
    property HighlightColor : TColor read FHighlightColor write SetHighlightColor;
    property ShadowColor: TColor read FShadowColor write SetShadowColor;
    property ShadowOffset:Integer read FShadowOffset write SetShadowOffset;
    property Caption : TCaption read FCaption write SetCaption;
    property Transparent : Boolean read FTransparent write SetTransparent;
    property VAlign : TPCVVAlign read FValign write SetVAlign;
    property HAlign : TPCVHAlign read FHAlign write SetHAlign;
    property Style : TPCV3DStyle read FStyle write SetStyle;
    property Color : TColor read FColor write SetColor;
    property AutoSize : Boolean read FAutoSize write SetAutoSize default TRUE;
    property Font;

    property OnClick;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;
  
implementation

constructor TPCV3DLabel.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  FAutoSize:=TRUE;
  FCaption:='PCV 3D Label';
  FTransparent:=FALSE;
  FColor:=clBtnFace;
  FVAlign:=vaTop;
  FHAlign:=haLeft;
  FStyle:=plsRaised;
  FShadowColor:=clGray;
  FHighlightColor:=clWhite;
  FShadowOffset:=2;
end;

procedure TPCV3DLabel.Paint;
var R,R2:TRect;
    PosX,PosY:Longint;
    Col : TColor;
begin
  R:=ClientRect;
  Canvas.Font.Assign(Font);
  if FAutoSize then
     begin
       Width:=Canvas.TextWidth(FCaption)+4;
       Height:=Canvas.TextHeight(FCaption)+4;
     end; // if
      
  with Canvas do
  begin
    if not Transparent then
        begin
          Brush.Color:=FColor;
          Brush.Style:=bsSolid;
          FillRect(ClientRect);
        end;
    Brush.Style:=bsClear; 
    Col:=Font.Color;
    case FVAlign of
      vaTop : PosY:=0;
      vaCenter : PosY:=R.Top+(R.Bottom - R.Top div 2) - (TextHeight(FCaption) div 2);
      vaBottom : PosY:=R.Bottom - TextHeight(FCaption);
    end;  // case 1

    case FHAlign of
      haLeft : PosX:=0;
      haCenter : PosX:=R.Left+(R.Right - R.Left div 2) - (TextWidth(FCaption) div 2);
      haRight : PosX:=R.Right - TextWidth(FCaption);
    end; // case 2

    case FStyle of
       plsLowered : begin
                      Font.Color:=FHighlightColor;
                      TextOut(PosX+1,PosY+1,FCaption);
                    end;
       plsRaised : begin
                     Font.Color:=FHighlightColor;
                     TextOut(PosX-1,PosY-1,FCaption);
                   end;
       plsShadowed : begin
                       Font.Color:=FShadowColor;
                       TextOut(PosX+FShadowOffset,PosY+FShadowOffset,FCaption);
                     end;
    end; // case 3
   Font.Color:=Col;
   TextOut(PosX,PosY,FCaption);
  end; // canvas
end;

procedure TPCV3DLabel.SetStyle(value : TPCV3DStyle);
begin
  if FStyle <> value then
     begin
       FStyle:=value;
       Invalidate;
     end;
end;

procedure TPCV3DLabel.SetCaption(value : TCaption);
begin
  if FCaption <> value then
     begin
       FCaption:=value;
       Invalidate;
     end;
end;

procedure TPCV3DLabel.SetVAlign(value : TPCVVAlign);
begin
  if FVAlign <> value then
     begin
       FVAlign:=value;
       Invalidate;
     end;
end;

procedure TPCV3DLabel.SetHAlign(value : TPCVHAlign);
begin
  if FHAlign <> value then
     begin
       FHAlign:=value;
       Invalidate;
     end;
end;

procedure TPCV3DLabel.SetShadowColor(value : TColor);
begin
  if FShadowColor <> value then
     begin
       FShadowColor:=value;
       Invalidate;
     end;
end;

procedure TPCV3DLabel.SetHighlightColor(value : TColor);
begin
  if FHighlightColor <> value then
      begin
        FHighlightColor:=value;
        Invalidate;
      end;
end;

procedure TPCV3DLabel.SetTransparent(value : Boolean);
begin
  if FTransparent <> value then
     begin
       FTransparent:=value;
       Invalidate;
     end;
end;

procedure TPCV3DLabel.SetShadowOffset(value : Integer);
begin
  if FShadowOffset <> value then
     begin
       FShadowOffset:=value;
       Invalidate;
     end;
end;

procedure TPCV3DLabel.SetColor(value : TColor);
begin
  if FColor <> value then
     begin
       FColor:=value;
       Invalidate;
     end;
end;

procedure TPCV3DLabel.SetAutoSize(value : Boolean);
begin
  if FAutosize <> value then
     begin
       FAutoSize:=value;
       Invalidate;
     end;
end;

end.
