unit TagRecChgDlg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type
	TTaggedRecChanges = class(TForm)
    rgChangeScope: TRadioGroup;
    btnOK: TBitBtn;
    btnCancel: TBitBtn;
    procedure btnOKClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
	private
		{ Private declarations }
		FTaggedRecs: Boolean;
		FChangeType: ANSIString;
	public
		{ Public declarations }
		property TaggedRecs: Boolean read FTaggedRecs write FTaggedRecs;
		property ChangeType: String read FChangeType write FChangeType;
	end;

var
	TaggedRecChanges: TTaggedRecChanges;

implementation

{$R *.DFM}

procedure TTaggedRecChanges.btnOKClick(Sender: TObject);
begin
	FTaggedRecs := (rgChangeScope.ItemIndex = 1);
end;

procedure TTaggedRecChanges.FormActivate(Sender: TObject);
begin
	Caption := FChangeType + ' Records';
	rgChangeScope.Caption := 'Do you wish to ' + FChangeType + ':';
	rgChangeScope.ItemIndex := 0;
end;

end.
