unit RenTable;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TRenameTable = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    edtNewName: TEdit;
    btnOK: TBitBtn;
    btnCancel: TBitBtn;
    edtOldName: TEdit;
    procedure FormShow(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
  private
		{ Private declarations }
		FTableChoice: String;
	public
		{ Public declarations }
		property TableChoice: String read FTableChoice write FTableChoice;
	end;

var
	RenameTable: TRenameTable;

implementation

uses
	PhnMain;

{$R *.DFM}

procedure TRenameTable.FormShow(Sender: TObject);
begin
	edtOldName.Text := TableChoice;
	edtNewName.Text := '';
end;

procedure TRenameTable.btnOKClick(Sender: TObject);
begin

	if (edtOldName.Text <> edtNewName.Text) then
	begin
		PhoneBookDB.TableDefs[MainTablePrefix + FTableChoice].Properties['Name'].Value := MainTablePrefix + edtNewName.Text;
		PhoneBookDB.TableDefs[NumbersTablePrefix + FTableChoice].Properties['Name'].Value := NumbersTablePrefix + edtNewName.Text;
		TableNameList[TableNameList.IndexOf( edtOldName.Text )] := edtNewName.Text;
		TableNameListStatic[TableNameListStatic.IndexOf( edtOldName.Text )] := edtNewName.Text;
		ShowMessage( 'Phone Book "' + edtOldName.Text + '" has been renamed to "' + edtNewName.Text + '".' );
	end;

end;

end.
