unit PhoneGrid;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, Menus;

type
  TPhoneBookTable = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    Close1: TMenuItem;
    N3: TMenuItem;
    Save1: TMenuItem;
    SaveAs1: TMenuItem;
    N2: TMenuItem;
    Print1: TMenuItem;
    PrintSetup1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Edit1: TMenuItem;
    Undo1: TMenuItem;
    N5: TMenuItem;
    MarkRecord1: TMenuItem;
    AddRecord1: TMenuItem;
    DeleteRecord1: TMenuItem;
    CopyRecord1: TMenuItem;
    MoveRecord1: TMenuItem;
    N4: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    View1: TMenuItem;
    mnuViewForm: TMenuItem;
    Table1: TMenuItem;
    DBGrid1: TDBGrid;
    procedure mnuViewFormClick(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    FPhoneForm: TForm;
    procedure SetPhoneForm( Value: TForm );
  public
    { Public declarations }
    property frmPhoneForm: TForm read FPhoneForm write SetPhoneForm;
  end;

var
  PhoneBookTable: TPhoneBookTable;

implementation

uses Phnbook;

var
  iWidth: smallint;
  iHeight: smallint;

procedure TPhoneBookTable.SetPhoneForm( Value: TForm );
begin
	FPhoneForm := Value;
end;

{$R *.DFM}

procedure TPhoneBookTable.mnuViewFormClick(Sender: TObject);
begin
	{self.Hide;}
  iWidth := self.Width;
  iHeight := self.Height;
  {self.Width := 0;
  self.Height := 0;}
  self.WindowState := wsMinimized;
  self.frmPhoneForm.SetFocus;
  self.frmPhoneForm.WindowState := wsNormal;
end;

procedure TPhoneBookTable.Close1Click(Sender: TObject);
begin
	frmPhoneForm.Close; {This will close both windows.}
end;

procedure TPhoneBookTable.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
	Action := caFree;
end;

procedure TPhoneBookTable.FormCreate(Sender: TObject);
begin
	iHeight := self.Height;
  iWidth := self.Width;
end;

procedure TPhoneBookTable.FormActivate(Sender: TObject);
begin
  self.WindowState := wsNormal;
	self.Height := iHeight;
  self.Width := iWidth;
end;

{procedure TPhoneBookTable.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
	frmPhoneForm.Close;
end;}

end.
