unit PhnSearch;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, Buttons, ExtCtrls;

type
	TPhoneSearch = class(TForm)
		edtSearch: TEdit;
		Label1: TLabel;
		btnOK: TBitBtn;
		btnCancel: TBitBtn;
		rgSort: TRadioGroup;
		procedure btnCancelClick(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure rgSortClick(Sender: TObject);
		procedure edtSearchKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	PhoneSearch: TPhoneSearch;
	OldBookMark: Variant;

const
	LastName_IndexPos		= 0;
	FirstName_IndexPos	= 1;
	Company_IndexPos		= 2;

implementation

uses Phnmain;

{$R *.DFM}

procedure TPhoneSearch.btnCancelClick(Sender: TObject);
begin
	with CurrPhoneBook do
	begin
		PhoneBase.BookMark := VarAsType( OldBookMark, varOleStr );
		GetPhoneInfo;
	end;
end;

procedure TPhoneSearch.FormShow(Sender: TObject);
begin

	with CurrPhoneBook do
	begin

		if LastNameIndex.Checked then
		begin
			rgSort.ItemIndex := LastName_IndexPos;
		end
		else
		begin

		if FirstNameIndex.Checked then
		begin
			rgSort.ItemIndex := FirstName_IndexPos;
		end
		else
		begin
			rgSort.ItemIndex := Company_IndexPos;
		end;

		end;

		OldBookMark := PhoneBase.BookMark;
		edtSearch.Text := '';
	end;

end;

procedure TPhoneSearch.rgSortClick(Sender: TObject);
begin

	with CurrPhoneBook do
	begin
		Case rgSort.ItemIndex of
			LastName_IndexPos:	LastNameIndexClick( Sender );
			FirstName_IndexPos:	FirstNameIndexClick( Sender );
			Company_IndexPos:		CompanyIndexClick( Sender );
		end;
	end;

end;

procedure TPhoneSearch.edtSearchKeyUp(Sender: TObject; var Key: Word;
	Shift: TShiftState);
begin
	with CurrPhoneBook do
	begin
		PhoneBase.Seek( '>=', edtSearch.Text );

		if (not VarAsType( PhoneBase.NoMatch, varBoolean )) then
			GetPhoneInfo;

	end;
end;

end.
